<?php
    /**
     * download
     *
     * @package Wojo Framework
     * @author wojoscripts.com
     * @copyright 2023
     * @version 5.50: download.php, v1.00 11/18/2023 12:22 PM Gewa Exp $
     *
     */
    
    const _WOJO = true;
    require_once('init.php');
    set_time_limit(0);
    
    if (ini_get('zlib.output_compression')) {
        ini_set('zlib.output_compression', 'Off');
    }

    //free downloads
    if (isset($_GET['free'])) {
        $token = Validator::sanitize($_GET['token'], 'alphanumeric', 32);
        $id = Utility::decode($_GET['free']);
        
        if ($item = Database::Go()->select(Product::mTable, array('price'))->where('id', $id ? : 0, '=')->where('active', 1, '=')->first()->run()) {
            if ($item->price > 0) {
                Url::redirect(SITEURL . '/?msg=6');
                exit;
            }
            
            if (App::Core()->allow_free == 'no'
                and !App::Auth()->logged_in) {
                Url::redirect(Url::currentUrl() . '?msg=' . urlencode(Language::$word->FM_ERROR9));
                exit;
            }
            
            if ($row = Database::Go()->select(Product::fTable, array('alias', 'name'))->where('token', $token, '=')->first()->run()) {
                if (!File::exists(App::Core()->file_dir . $row->name)) {
                    Url::redirect(Url::currentUrl() . '?msg=' . urlencode(Language::$word->FM_ERROR5));
                    exit;
                }
                File::download(App::Core()->file_dir . $row->name, $row->name);
            } else {
                Url::redirect(Url::currentUrl() . '?msg=' . urlencode(str_replace('[IP]', Url::getIP(), Language::$word->FM_ERROR10)));
                exit;
            }
            
        } else {
            Url::redirect(Url::currentUrl() . '?msg=' . urlencode(Language::$word->FM_ERROR7));
        }
    //membership downloads
    } elseif (isset($_GET['member']) and isset($_GET['token']) and App::Auth()->logged_in) {
        $token = Validator::sanitize($_GET['token'], 'alphanumeric', 32);
        $id = Utility::decode($_GET['member']);
        $downloads = false;
        
        if ($item = Database::Go()->select(Product::mTable, array('membership_id'))->where('id', $id ? : 0, '=')->where('active', 1, '=')->first()->run()) {
            if (!Content::is_valid($item->membership_id)) {
                Url::redirect(Url::currentUrl() . '?msg=' . urlencode(Language::$word->FM_ERROR11));
                exit;
            }
            
            $mem = Database::Go()->select(Membership::mTable, array('downloads'))->where('id', App::Auth()->membership_id, '=')->first()->run();
            if ($mem->downloads > 0) {
                $downloads = true;
                $usr = Database::Go()->select(User::mTable, array('downloads'))->where('id', App::Auth()->uid, '=')->first()->run();
                if (Validator::compareNumbers($usr->downloads, $mem->downloads, 'gte')) {
                    Url::redirect(Url::currentUrl() . '?msg=' . urlencode(str_replace('[X]', $mem->downloads, Language::$word->FM_ERROR12)));
                    exit;
                }
            }
            
            if ($row = Database::Go()->select(Product::fTable, array('alias', 'name'))->where('token', $token, '=')->first()->run()) {
                if (!File::exists(App::Core()->file_dir . $row->name)) {
                    Url::redirect(Url::currentUrl() . '?msg=' . urlencode(Language::$word->FM_ERROR5));
                    exit;
                }
                if ($downloads) {
                    //update download counter
                    Database::Go()->rawQuery('UPDATE `' . User::mTable . '` SET downloads = downloads + 1 WHERE id = ?', array(App::Auth()->uid))->run();
                }
                File::download(App::Core()->file_dir . $row->name, $row->name);
                
            } else {
                Url::redirect(Url::currentUrl() . '?msg=' . urlencode(str_replace('[IP]', Url::getIP(), Language::$word->FM_ERROR10)));
                exit;
            }
        } else {
            Url::redirect(Url::currentUrl() . '?msg=' . urlencode(Language::$word->FM_ERROR7));
        }
        
    //paid downloads
    } elseif (isset($_GET['paid']) and isset($_GET['token']) and App::Auth()->logged_in) {
        $token = Validator::sanitize($_GET['token'], 'alphanumeric', 32);
        $id = Validator::sanitize($_GET['paid'], 'int', 11);
        
        $sql = '
        SELECT COUNT(t.qty) AS counter, t.id, t.status, t.downloads, t.file_date, p.expiry, p.expiry_type
          FROM `' . Product::xTable . '` AS t
          LEFT JOIN `' . Product::mTable . '` AS p ON t.product_id = p.id
          WHERE t.id = ?
          AND t.user_id = ?
          AND t.status = ?
          AND p.active = ?
          GROUP BY t.id
        ';
        
        if ($row = Database::Go()->rawQuery($sql, array($id, App::Auth()->uid, 1, 1))->first()->run()) {
            if ($row->expiry != 0 && $row->status == 1) {
                if ($row->expiry_type == 'days') {
                    
                    $expiry = ($row->expiry * $row->counter);
                    $current_time = time();
                    $expiry_time = $row->file_date + ($expiry * 24 * 60 * 60);
                    $elapsed_time = $current_time - $row->file_date;
                    if ($current_time > $expiry_time) {
                        $expired = true;
                    }
                } else {
                    if ($row->downloads >= ($row->expiry * $row->counter)) {
                        $expired = true;
                    }
                }
            }
            if (isset($expired)) {
                Url::redirect(Url::currentUrl() . '?msg=' . urlencode(Language::$word->FM_ERROR1));
                exit;
            }
            
            $file_row = Database::Go()->select(Product::fTable, array('alias', 'name'))->where('token', $token, '=')->first()->run();
            if (!File::exists(App::Core()->file_dir . $file_row->name)) {
                Url::redirect(Url::currentUrl() . '?msg=' . urlencode(Language::$word->FM_ERROR5));
                exit;
            }
            //update download counter
            Database::Go()->rawQuery('UPDATE `' . Product::xTable . '` SET downloads = downloads + 1 WHERE id = ?', array($row->id))->run();
            
            File::download(App::Core()->file_dir . $file_row->name, $file_row->name);
        } else {
            Url::redirect(Url::currentUrl() . '?msg=' . urlencode(str_replace('[IP]', Url::getIP(), Language::$word->FM_ERROR10)));
        }
    } else {
        Url::redirect(Url::currentUrl() . '?msg=' . urlencode(Language::$word->FM_ERROR7));
    }