<?php
    /**
     * ipn
     *
     * @package Wojo Framework
     * @author wojoscripts.com
     * @copyright 2023
     * @version 5.50 ipn.php, v1.00 10/18/2023 6:25 PM Gewa Exp $
     *
     */
    
    use Mollie\Api\Exceptions\ApiException;
    use Mollie\Api\MollieApiClient;
    
    const _WOJO = true;
    require_once('../../../init.php');
    
    if (!App::Auth()->is_User()) {
        exit;
    }
    
    ini_set('log_errors', true);
    ini_set('error_log', dirname(__file__) . '/ipn_errors.log');
    
    if (Validator::get('order_id')) {
        require_once BASEPATH . 'gateways/ideal/vendor/autoload.php';
        
        $apikey = Database::Go()->select(Admin::gTable, array('extra'))->where('name', 'ideal', '=')->first()->run();
        $mollie = new MollieApiClient;
        
        try {
            $mollie->setApiKey($apikey->extra);
            
            $o = Validator::sanitize($_GET['order_id'], 'string');
            $c = Database::Go()->select(Product::cxTable)->where('order_id', $o, '=')->first()->run();
            
            if ($c) {
                $cart = Product::getCartContentIpn();
                $totals = Product::getCartTotal();
                $payment = $mollie->payments->get($cart->cart_id);
                
                if ($payment->isPaid()) {
                    $amount = Utility::numberParse($totals->grand);
                    $txn_id = $payment->metadata->order_id;
                    $items = array();
                    
                    // insert payment record
                    foreach ($cart as $k => $item) {
                        $key = Database::Go()->select(Product::cdTable, array('cdkey'))->where('product_id', $item->id, '=')->one()->run();
                        $data = array(
                            'user_id' => App::Auth()->uid,
                            'product_id' => $item->id,
                            'txn_id' => $txn_id,
                            'tax' => Utility::numberParse($item->totaltax),
                            'amount' => Validator::sanitize($item->total, 'float'),
                            'total' => Validator::sanitize($item->totaltax + $item->total, 'float'),
                            'coupon' => $item->coupon,
                            'cdkey' => ($key) ? : '',
                            'pp' => $apikey->displayname,
                            'ip' => Url::getIP(),
                            'file_date' => time(),
                            'currency' => $apikey->extra2,
                            'status' => 1,
                        );
                        
                        $items[$k]['title'] = $item->title;
                        $items[$k]['qty'] = 1;
                        $items[$k]['price'] = $item->total;
                        $items[$k]['cdkey'] = $data['cdkey'];
                        $cdkey[] = $data['cdkey'];
                        
                        Database::Go()->insert(Product::xTable, $data)->run();
                        if ($key) {
                            Database::Go()->delete(Product::cdTable)->where('cdkey', $data['cdkey'], '=')->run();
                        }
                    }
                    
                    // invoice table
                    $xdata = array(
                        'invoice_id' => substr(time(), 5),
                        'transaction_id' => $txn_id,
                        'user_id' => App::Auth()->uid,
                        'items' => json_encode($items),
                        'coupon' => $totals->discount,
                        'tax' => $totals->tax,
                        'subtotal' => $totals->subtotal,
                        'grand' => $amount,
                        'currency' => 'EUR',
                    );
                    Database::Go()->insert(Product::ivTable, $xdata)->run();
                    
                    $json['type'] = 'success';
                    $json['title'] = Language::$word->SUCCESS;
                    $json['message'] = Language::$word->STR_POK;
                    
                    /* == Notify Administrator == */
                    $mailer = Mailer::sendMail();
                    $tpl = Database::Go()->select(Content::eTable, array('body', 'subject'))->where('typeid', 'payComplete', '=')->first()->run();
                    $core = App::Core();
                    $body = str_replace(array(
                        '[LOGO]',
                        '[CEMAIL]',
                        '[COMPANY]',
                        '[SITE_NAME]',
                        '[DATE]',
                        '[SITEURL]',
                        '[NAME]',
                        '[TYPE]',
                        '[ITEMNAME]',
                        '[CDKEY]',
                        '[PRICE]',
                        '[STATUS]',
                        '[PP]',
                        '[IP]',
                        '[FB]',
                        '[TW]'
                    ), array(
                        $core->plogo,
                        $core->site_email,
                        $core->company,
                        $core->site_name,
                        date('Y'),
                        SITEURL,
                        App::Auth()->name,
                        Language::$word->PRD_PRODUCT,
                        implode(', ', array_column($cart, 'title')),
                        implode(', ', array_column($items, 'cdkey')),
                        $amount,
                        'Completed',
                        'iDeal',
                        Url::getIP(),
                        $core->social->facebook,
                        $core->social->twitter
                    ), $tpl->body);
                    
                    $mailer->Subject = $tpl->subject;
                    $mailer->Body = $body;
                    
                    try {
                        $mailer->setFrom($core->site_email, $core->company);
                        $mailer->addAddress($core->site_email, $core->company);
                        $mailer->isHTML();
                        $mailer->send();
                    } catch (\PHPMailer\PHPMailer\Exception) {
                    }
                    
                    /* == Notify User == */
                    $umailer = Mailer::sendMail();
                    $tpl2 = Database::Go()->select(Content::eTable, array('body', 'subject'))->where('typeid', 'payCompleteUser', '=')->first()->run();
                    $ubody = str_replace(array(
                        '[LOGO]',
                        '[CEMAIL]',
                        '[COMPANY]',
                        '[SITE_NAME]',
                        '[DATE]',
                        '[SITEURL]',
                        '[NAME]',
                        '[TYPE]',
                        '[ITEMNAME]',
                        '[CDKEY]',
                        '[PRICE]',
                        '[TAX]',
                        '[PP]',
                        '[FB]',
                        '[TW]'
                    ), array(
                        $core->plogo,
                        $core->site_email,
                        $core->company,
                        $core->site_name,
                        date('Y'),
                        SITEURL,
                        App::Auth()->name,
                        Language::$word->PRD_PRODUCT,
                        implode(', ', array_column($items, 'title')),
                        Language::$word->PRD_CDKEYS . ': ' . implode(', ', array_column($items, 'cdkey')),
                        $amount,
                        $totals->tax,
                        'iDeal',
                        Url::getIP(),
                        $core->social->facebook,
                        $core->social->twitter
                    ), $tpl2->body);
                    
                    $umailer->Subject = $tpl2->subject;
                    $umailer->Body = $ubody;
                    
                    try {
                        $umailer->setFrom($core->site_email, $core->company);
                        $umailer->addAddress(App::Auth()->email, App::Auth()->name);
                        $umailer->isHTML();
                        $umailer->send();
                    } catch (\PHPMailer\PHPMailer\Exception) {
                    }
                    
                    // empty cart
                    Database::Go()->delete(Product::cxTable)->where('user_id', App::Auth()->sesid, '=')->run();
                } else {
                    $json['type'] = 'error';
                    $json['title'] = Language::$word->ERROR;
                    $json['message'] = Language::$word->STR_ERR1;
                }
            } else {
                $json['type'] = 'error';
                $json['title'] = Language::$word->ERROR;
                $json['message'] = Language::$word->STR_ERR1;
            }
        } catch (ApiException $e) {
            $json['type'] = 'error';
            $json['title'] = Language::$word->ERROR;
            $json['message'] = 'API call failed: ' . htmlspecialchars($e->getMessage());
            print json_encode($json);
        }
    } else {
        $json['type'] = 'error';
        $json['title'] = Language::$word->ERROR;
        $json['message'] = Language::$word->STR_ERR1;
        print json_encode($json);
    }