<?php
    /**
     * ipn
     *
     * @package Wojo Framework
     * @author wojoscripts.com
     * @copyright 2023
     * @version 5.50: form.tpl.php, v1.00 11/25/2023 3:54 PM Gewa Exp $
     *
     */
    
    const _WOJO = true;
    require_once '../../../init.php';
    
    if (!App::Auth()->is_User()) {
        exit;
    }
    
    ini_set('log_errors', true);
    ini_set('error_log', dirname(__file__) . '/ipn_errors.log');
    
    if (isset($_POST['processPaystackPayment'])) {
        $validate = Validator::run($_POST);
        $validate->set('payment_method', 'Invalid Payment Methods')->required()->string();
        $safe = $validate->safe();
        
        if (!$cart = Product::getCartContentIpn()) {
            Message::$msgs['cart'] = Language::$word->STR_ERR;
        }
        
        if (count(Message::$msgs) === 0) {
            $pp = Database::Go()->select(Core::gTable)->where('name', 'paystack', '=')->first()->run();
            
            $totals = Product::getCartTotal();
            $tax = Content::calculateTax();
            $amount = Utility::numberParse($totals->grand);
            $items = array();
            $cdkey = array();
            
            $curl = curl_init();
            curl_setopt_array($curl, array(
                CURLOPT_URL => 'https://api.paystack.co/transaction/verify/' . $safe->payment_method,
                CURLOPT_RETURNTRANSFER => true,
                CURLOPT_ENCODING => '',
                CURLOPT_MAXREDIRS => 10,
                CURLOPT_TIMEOUT => 30,
                CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                CURLOPT_CUSTOMREQUEST => 'GET',
                CURLOPT_HTTPHEADER => array(
                    'Authorization: Bearer ' . $pp->extra,
                    'Cache-Control: no-cache',
                ),
            ));
            
            $response = curl_exec($curl);
            $error = curl_error($curl);
            curl_close($curl);
            
            if ($error) {
                $json['type'] = 'error';
                $json['title'] = 'ERROR';
                $json['message'] = 'cURL Error #:' . $error;
                print json_encode($json);
                exit;
            } else {
                $result = json_decode($response);
                if ($result->data->status == 'success') {
                    $txn_id = $result->data->reference;
                    
                    // insert payment record
                    foreach ($cart as $k => $item) {
                        $key = Database::Go()->select(Product::cdTable, array('cdkey'))->where('product_id', $item->id, '=')->one()->run();
                        $data = array(
                            'user_id' => App::Auth()->uid,
                            'product_id' => $item->id,
                            'txn_id' => $txn_id,
                            'tax' => Utility::numberParse($item->totaltax),
                            'amount' => Validator::sanitize($item->total, 'float'),
                            'total' => Validator::sanitize($item->totaltax + $item->total, 'float'),
                            'coupon' => $item->coupon,
                            'cdkey' => ($key) ? : '',
                            'pp' => $pp->displayname,
                            'ip' => Url::getIP(),
                            'file_date' => time(),
                            'currency' => $pp->extra2,
                            'status' => 1,
                        );
                        
                        $items[$k]['title'] = $item->title;
                        $items[$k]['qty'] = 1;
                        $items[$k]['price'] = $item->total;
                        $items[$k]['cdkey'] = $data['cdkey'];
                        $cdkey[] = $data['cdkey'];
                        
                        Database::Go()->insert(Product::xTable, $data)->run();
                        if ($key) {
                            Database::Go()->delete(Product::cdTable)->where('cdkey', $data['cdkey'], '=')->run();
                        }
                    }
                    
                    // invoice table
                    $xdata = array(
                        'invoice_id' => substr(time(), 5),
                        'transaction_id' => $txn_id,
                        'user_id' => App::Auth()->uid,
                        'items' => json_encode($items),
                        'coupon' => $totals->discount,
                        'tax' => $totals->tax,
                        'subtotal' => $totals->subtotal,
                        'grand' => $amount,
                        'currency' => 'EUR',
                    );
                    Database::Go()->insert(Product::ivTable, $xdata)->run();
                    
                    $json['type'] = 'success';
                    $json['title'] = Language::$word->SUCCESS;
                    $json['message'] = Language::$word->STR_POK;
                } else {
                    $json['type'] = 'error';
                    $json['title'] = 'ERROR';
                    $json['message'] = $result->data->gateway_response;
                }
                print json_encode($json);
                
                /* == Notify Administrator == */
                $mailer = Mailer::sendMail();
                $tpl = Database::Go()->select(Content::eTable, array('body', 'subject'))->where('typeid', 'payComplete', '=')->first()->run();
                $core = App::Core();
                $body = str_replace(array(
                    '[LOGO]',
                    '[CEMAIL]',
                    '[COMPANY]',
                    '[SITE_NAME]',
                    '[DATE]',
                    '[SITEURL]',
                    '[NAME]',
                    '[TYPE]',
                    '[ITEMNAME]',
                    '[CDKEY]',
                    '[PRICE]',
                    '[STATUS]',
                    '[PP]',
                    '[IP]',
                    '[FB]',
                    '[TW]'
                ), array(
                    $core->plogo,
                    $core->site_email,
                    $core->company,
                    $core->site_name,
                    date('Y'),
                    SITEURL,
                    App::Auth()->name,
                    Language::$word->PRD_PRODUCT,
                    implode(', ', array_column($cart, 'title')),
                    implode(', ', array_column($items, 'cdkey')),
                    $amount,
                    'Completed',
                    $pp->displayname,
                    Url::getIP(),
                    $core->social->facebook,
                    $core->social->twitter
                ), $tpl->body);
                
                $mailer->Subject = $tpl->subject;
                $mailer->Body = $body;
            }
        } else {
            Message::msgSingleStatus();
        }
    }