<?php
    /**
     * ipn
     *
     * @package Wojo Framework
     * @author wojoscripts.com
     * @copyright 2023
     * @version 5.50 ipn.php, v1.00 10/18/2023 6:25 PM Gewa Exp $
     *
     */
    
    use Razorpay\Api\Api;
    use Razorpay\Api\Errors\SignatureVerificationError;
    
    const _WOJO = true;
    require_once '../../../init.php';
    
    if (!App::Auth()->is_User()) {
        exit;
    }
    
    require(BASEPATH . '/gateways/razorpay/lib/Razorpay.php');
    
    if (isset($_POST['razorpay_payment_id'])) {
        $validate = Validator::run($_POST);
        $validate
            ->set('razorpay_signature', 'Invalid Signature')->required()->string()
            ->set('razorpay_payment_id', 'Invalid Payment ID')->required()->string();
        $safe = $validate->safe();
        
        if (!$cart = Product::getCartContentIpn()) {
            Message::$msgs['cart'] = Language::$word->STR_ERR;
        }
        
        if (count(Message::$msgs) === 0) {
            $apikey = Database::Go()->select(Admin::gTable, array('extra'))->where('name', 'razorpay', '=')->first()->run();
            $api = new Api($apikey->extra, $apikey->extra3);
            
            $totals = Product::getCartTotal();
            $amount = Utility::numberParse($totals->grand);
            $items = array();
            $cdkey = array();
            
            try {
                $attributes = array(
                    'razorpay_order_id' => $totals->order_id,
                    'razorpay_payment_id' => $_POST['razorpay_payment_id'],
                    'razorpay_signature' => $_POST['razorpay_signature']
                );
                
                $api->utility->verifyPaymentSignature($attributes);
                
                // insert payment record
                foreach ($cart as $k => $item) {
                    $key = Database::Go()->select(Product::cdTable, array('cdkey'))->where('product_id', $item->id, '=')->one()->run();
                    $data = array(
                        'user_id' => App::Auth()->uid,
                        'product_id' => $item->id,
                        'txn_id' => $safe->razorpay_payment_id,
                        'tax' => Utility::numberParse($item->totaltax),
                        'amount' => Validator::sanitize($item->total, 'float'),
                        'total' => Validator::sanitize($item->totaltax + $item->total, 'float'),
                        'coupon' => $item->coupon,
                        'cdkey' => ($key) ? : '',
                        'pp' => $apikey->displayname,
                        'ip' => Url::getIP(),
                        'file_date' => time(),
                        'currency' => $apikey->extra2,
                        'status' => 1,
                    );
                    
                    $items[$k]['title'] = $item->title;
                    $items[$k]['qty'] = 1;
                    $items[$k]['price'] = $item->total;
                    $items[$k]['cdkey'] = $data['cdkey'];
                    $cdkey[] = $data['cdkey'];
                    
                    Database::Go()->insert(Product::xTable, $data)->run();
                    if ($key) {
                        Database::Go()->delete(Product::cdTable)->where('cdkey', $data['cdkey'], '=')->run();
                    }
                }
                
                // invoice table
                $xdata = array(
                    'invoice_id' => substr(time(), 5),
                    'transaction_id' => $safe->razorpay_payment_id,
                    'user_id' => App::Auth()->uid,
                    'items' => json_encode($items),
                    'coupon' => $totals->discount,
                    'tax' => $totals->tax,
                    'subtotal' => $totals->subtotal,
                    'grand' => $amount,
                    'currency' => strtoupper($apikey->extra2),
                );
                Database::Go()->insert(Product::ivTable, $xdata)->run();
                
                $json['type'] = 'success';
                $json['title'] = Language::$word->SUCCESS;
                $json['message'] = Language::$word->STR_POK;
                print json_encode($json);
                
                /* == Notify Administrator == */
                $mailer = Mailer::sendMail();
                $tpl = Database::Go()->select(Content::eTable, array('body', 'subject'))->where('typeid', 'payComplete', '=')->first()->run();
                $core = App::Core();
                $body = str_replace(array(
                    '[LOGO]',
                    '[CEMAIL]',
                    '[COMPANY]',
                    '[SITE_NAME]',
                    '[DATE]',
                    '[SITEURL]',
                    '[NAME]',
                    '[TYPE]',
                    '[ITEMNAME]',
                    '[CDKEY]',
                    '[PRICE]',
                    '[STATUS]',
                    '[PP]',
                    '[IP]',
                    '[FB]',
                    '[TW]'
                ), array(
                    $core->plogo,
                    $core->site_email,
                    $core->company,
                    $core->site_name,
                    date('Y'),
                    SITEURL,
                    App::Auth()->name,
                    Language::$word->PRD_PRODUCT,
                    implode(', ', array_column($cart, 'title')),
                    implode(', ', array_column($items, 'cdkey')),
                    $amount,
                    'Completed',
                    $apikey->displayname,
                    Url::getIP(),
                    $core->social->facebook,
                    $core->social->twitter
                ), $tpl->body);
                
                $mailer->Subject = $tpl->subject;
                $mailer->Body = $body;
                
                try {
                    $mailer->setFrom($core->site_email, $core->company);
                    $mailer->addAddress($core->site_email, $core->company);
                    $mailer->isHTML();
                    $mailer->send();
                } catch (\PHPMailer\PHPMailer\Exception) {
                }
                
                // empty cart
                Database::Go()->delete(Product::cxTable)->where('user_id', App::Auth()->sesid, '=')->run();
            } catch (SignatureVerificationError $e) {
                $json['type'] = 'error';
                $json['title'] = Language::$word->ERROR;
                $json['message'] = $e->getMessage();
                print json_encode($json);
            }
        } else {
            Message::msgSingleStatus();
        }
    }