<?php
    /**
     * ipn
     *
     * @package Wojo Framework
     * @author wojoscripts.com
     * @copyright 2023
     * @version 5.50: ipn.php, v1.00 7/18/2023 6:01 PM Gewa Exp $
     *
     */
    
    use Stripe\Customer;
    use Stripe\Exception\CardException;
    use Stripe\Stripe;
    
    const _WOJO = true;
    require_once '../../init.php';
    
    if (!App::Auth()->is_User()) {
        exit;
    }
    
    ini_set('log_errors', true);
    ini_set('error_log', dirname(__file__) . '/ipn_errors.log');
    
    if (isset($_POST['processStripePayment'])) {
        $validate = Validator::run($_POST);
        $validate->set('payment_method', 'Invalid Payment Methods')->required()->string();
        $safe = $validate->safe();
        
        if (!$cart = Membership::getCart(App::Auth()->uid)) {
            Message::$msgs['cart'] = Language::$word->STR_ERR;
        }
        
        if (count(Message::$msgs) === 0) {
            require_once BASEPATH . '/gateways/stripe/vendor/autoload.php';
            $pp = Database::Go()->select(Core::gTable)->where('name', 'stripe', '=')->first()->run();
            $core = App::Core();
            $auth = App::Auth();
            
            Stripe::setApiKey($pp->extra);
            try {
                //Create a client
                $client = Customer::create(array(
                    'name' => $auth->name,
                    'payment_method' => $safe->payment_method,
                ));
                
                // insert payment record
                $row = Database::Go()->select(Membership::mTable)->where('id', $cart->membership_id, '=')->first()->run();
                $data = array(
                    'txn_id' => time(),
                    'membership_id' => $row->id,
                    'user_id' => $auth->uid,
                    'amount' => $cart->total,
                    'coupon' => $cart->coupon,
                    'total' => $cart->totalprice,
                    'tax' => $cart->totaltax,
                    'currency' => $pp->extra2,
                    'ip' => Url::getIP(),
                    'pp' => $pp->displayname,
                    'status' => 1,
                );
                
                $last_id = Database::Go()->insert(Product::xTable, $data)->run();
                
                //insert user membership
                $u_data = array(
                    'transaction_id' => $last_id,
                    'user_id' => $auth->uid,
                    'membership_id' => $row->id,
                    'expire' => Membership::calculateDays($row->id),
                    'recurring' => $row->recurring,
                    'active' => 1,
                );
                
                //update user record
                $x_data = array(
                    'stripe_cus' => $client['id'],
                    'membership_id' => $row->id,
                    'mem_expire' => $u_data['expire'],
                );
                
                Database::Go()->insert(Membership::mhTable, $u_data)->run();
                Database::Go()->update(User::mTable, $x_data)->where('id', $auth->uid, '=')->run();
                
                //insert cron record
                if ($row->recurring) {
                    $cdata = array(
                        'user_id' => $auth->uid,
                        'membership_id' => $row->id,
                        'amount' => $cart->totalprice,
                        'stripe_customer' => $client['id'],
                        'stripe_pm' => $safe->payment_method,
                        'renewal' => $u_data['expire'],
                    );
                    Database::Go()->insert(Core::cjTable, $cdata)->run();
                }
                
                Database::Go()->delete(Product::cxTable)->where('user_m_id', $auth->uid, '=')->run();
                
                //update membership status
                Auth::$udata->membership_id = Session::set('membership_id', $row->id);
                Auth::$udata->mem_expire = Session::set('mem_expire', $x_data['mem_expire']);
                
                $jn['type'] = 'success';
                $jn['title'] = Language::$word->SUCCESS;
                $jn['message'] = Language::$word->STR_POK;
                print json_encode($jn);
                
                /* == Notify Administrator == */
                $mailer = Mailer::sendMail();
                $tpl = Database::Go()->select(Content::eTable, array('body', 'subject'))->where('typeid', 'payComplete', '=')->first()->run();
                $core = App::Core();
                $body = str_replace(array(
                    '[LOGO]',
                    '[CEMAIL]',
                    '[COMPANY]',
                    '[SITE_NAME]',
                    '[DATE]',
                    '[SITEURL]',
                    '[NAME]',
                    '[ITEMNAME]',
                    '[PRICE]',
                    '[STATUS]',
                    '[PP]',
                    '[IP]',
                    '[FB]',
                    '[TW]'
                ), array(
                    $core->plogo,
                    $core->site_email,
                    $core->company,
                    $core->site_name,
                    date('Y'),
                    SITEURL,
                    $auth->fname . ' ' . $auth->lname,
                    $row->title,
                    $cart->totalprice,
                    'Completed',
                    $pp->displayname,
                    Url::getIP(),
                    $core->social->facebook,
                    $core->social->twitter
                ), $tpl->body);
                
                $mailer->Subject = $tpl->subject;
                $mailer->Body = $body;
                try {
                    $mailer->setFrom($core->site_email, $core->company);
                    $mailer->addAddress($core->site_email, $core->company);
                    $mailer->isHTML();
                    $mailer->send();
                } catch (\PHPMailer\PHPMailer\Exception) {
                }
                
            } catch (CardException $e) {
                $body = $e->getJsonBody();
                $err = $body['error'];
                $json['type'] = 'error';
                Message::$msgs['msg'] = 'Message is: ' . $err['message'] . "\n";
                Message::msgSingleStatus();
            }
        } else {
            Message::msgSingleStatus();
        }
    }