<?php
    /**
     * index
     *
     * @package Wojo Framework
     * @author wojoscripts.com
     * @copyright 2023
     * @version 5.50: index.php, v1.00 7/20/2023 4:41 PM Gewa Exp $
     *
     */
    const _WOJO = true;
    
    include('init.php');
    $router = new Router();
    $tpl = App::View(BASEPATH . 'view/');
    $core = App::Core();
    
    //admin routes
    $router->mount('/admin', function () use ($router, $tpl) {
        //admin login
        $router->match('GET|POST', 'login', function () use ($tpl) {
            if (App::Auth()->is_Admin()) {
                Url::redirect(SITEURL . '/admin/');
                exit;
            }
            
            $tpl->template = 'admin/login';
            $tpl->title = Language::$word->LOGIN;
        });
        
        //admin index
        $router->get('/', 'Admin@index');
        
        //admin menus
        $router->mount('/menus', function () use ($router, $tpl) {
            $router->get('/', 'Content@menuIndex');
            $router->get('/edit/(\d+)', 'Content@menuEdit');
        });
        
        //admin categories
        $router->mount('/categories', function () use ($router, $tpl) {
            $router->get('/', 'Content@categoryIndex');
            $router->get('/edit/(\d+)', 'Content@categoryEdit');
        });
        
        //admin pages
        $router->mount('/pages', function () use ($router, $tpl) {
            $router->get('/', 'Content@pageIndex');
            $router->get('/edit/(\d+)', 'Content@pageEdit');
            $router->get('/new', 'Content@pageNew');
        });
        
        //admin f.a.q.
        $router->mount('/faq', function () use ($router, $tpl) {
            $router->get('/', 'Content@faqIndex');
            $router->get('/edit/(\d+)', 'Content@faqEdit');
            $router->get('/new', 'Content@faqNew');
        });
        
        //admin users
        $router->mount('/users', function () use ($router, $tpl) {
            $router->match('GET|POST', '/', 'User@index');
            $router->match('GET|POST', '/grid', 'User@index');
            $router->get('/history/(\d+)', 'User@history');
            $router->get('/edit/(\d+)', 'User@edit');
            $router->get('/new', 'User@new');
        });
        
        //admin countries
        $router->mount('/countries', function () use ($router, $tpl) {
            $router->get('/', 'Content@countryIndex');
            $router->get('/edit/(\d+)', 'Content@countryEdit');
        });
        
        //admin coupons
        $router->mount('/coupons', function () use ($router, $tpl) {
            $router->get('/', 'Content@couponIndex');
            $router->get('/edit/(\d+)', 'Content@couponEdit');
            $router->get('/new', 'Content@couponNew');
        });
        
        //admin custom fields
        $router->mount('/fields', function () use ($router, $tpl) {
            $router->get('/', 'Content@fieldIndex');
            $router->get('/edit/(\d+)', 'Content@fieldEdit');
            $router->get('/new', 'Content@fieldNew');
        });
        
        //admin account
        $router->mount('/account', function () use ($router, $tpl) {
            $router->get('/', 'Admin@account');
            $router->get('/password', 'Admin@password');
        });
        
        //admin gateways
        $router->mount('/gateways', function () use ($router, $tpl) {
            $router->get('/', 'Admin@gatewayIndex');
            $router->get('/edit/(\d+)', 'Admin@gatewayEdit');
        });
        
        //admin email templates
        $router->mount('/templates', function () use ($router, $tpl) {
            $router->get('/', 'Content@templateIndex');
            $router->get('/edit/(\d+)', 'Content@templateEdit');
        });
        
        //admin news
        $router->mount('/news', function () use ($router, $tpl) {
            $router->get('/', 'Content@newsIndex');
            $router->get('/edit/(\d+)', 'Content@newsEdit');
            $router->get('/new', 'Content@newsNew');
        });
        
        //admin permissions
        $router->mount('/roles', function () use ($router, $tpl) {
            $router->get('/', 'Admin@role');
            $router->get('/edit/(\d+)', 'Admin@roleEdit');
        });
        
        //admin products
        $router->mount('/products', function () use ($router, $tpl) {
            $router->match('GET|POST', '/', 'Product@index');
            $router->match('GET|POST', '/grid', 'Product@index');
            $router->get('/edit/(\d+)', 'Product@edit');
            $router->get('/new', 'Product@new');
            $router->get('/history/(\d+)', 'Product@history');
        });
        
        //admin memberships
        $router->mount('/memberships', function () use ($router, $tpl) {
            $router->match('GET', '/', 'Membership@index');
            $router->get('/history/(\d+)', 'Membership@history');
            $router->get('/edit/(\d+)', 'Membership@edit');
            $router->get('/new', 'Membership@new');
        });
        
        //admin transactions
        $router->mount('/transactions', function () use ($router, $tpl) {
            $router->match('GET|POST', '/', 'Admin@transactionIndex');
            $router->get('/new', 'Admin@transactionNew');
        });
        
        //admin maintenance
        $router->get('/utilities', 'Admin@maintenanceIndex');
        
        //admin backup
        $router->get('/backup', 'Admin@backupIndex');
        
        //admin newsletter
        $router->get('/mailer', 'Admin@mailerIndex');
        
        //admin system
        $router->get('/system', 'Admin@systemIndex');
        
        //admin trash
        $router->get('/trash', 'Admin@trashIndex');
        
        //admin language manager
        $router->get('/language', 'Language@index');
        
        //admin comments
        $router->mount('/comments', function () use ($router, $tpl) {
            $router->match('GET', '/', 'Comment@index');
            $router->get('/edit', 'Comment@settings');
        });
        
        //admin files
        $router->match('GET|POST', '/files', 'File@index');
        
        //admin configuration
        $router->get('/configuration', 'Core@index');
        
        //admin blog
        $router->mount('/blog', function () use ($router, $tpl) {
            $router->match('GET|POST', '/', '/view/admin/blog/@Blog@adminIndex');
            $router->get('/edit/(\d+)', '/view/admin/blog/@Blog@edit');
            $router->get('/new', '/view/admin/blog/@Blog@new');
            $router->get('/categories', '/view/admin/blog/@Blog@categoryNew');
            $router->get('/category/(\d+)', '/view/admin/blog/@Blog@categoryEdit');
            $router->get('/settings', '/view/admin/blog/@Blog@settings');
        });
        
        //logout
        $router->before('GET', '/logout', function () {
            if (App::Auth()->logged_in) {
                App::Auth()->logout();
            }
            Url::redirect(SITEURL . '/admin/');
        });
        
    });
    
    /* front end routes */
    //home
    $router->match('GET|POST', '/', 'Front@index');
    $router->match('GET|POST', '/login', 'Front@login');
    $router->match('GET|POST', '/register', 'Front@register');
    $router->match('GET|POST', '/password/([a-z0-9_-]+)', 'Front@password');
    
    //front pages
    $router->match('GET|POST', '/content/([a-z0-9_-]+)', 'Front@page');
    
    //wishlist
    $router->match('GET|POST', '/wishlist', 'Front@wishlist');
    
    //compare
    $router->match('GET|POST', '/compare', 'Front@compare');
    
    //category
    $router->match('GET|POST', '/category/([a-z0-9_-]+)', 'Content@categoryRender');
    
    //product
    $router->match('GET|POST', '/product/([a-z0-9_-]+)', 'Product@render');
    
    //cart
    $router->match('GET|POST', '/cart', 'Product@cart');
    
    //search
    $router->match('GET|POST', '/search', 'Front@search');
    
    //news
    $router->match('GET|POST', '/news', 'Front@news');
    
    //account activation
    $router->get('/activation', 'Front@activation');
    
    //payment activation
    $router->match('GET|POST', '/validate', 'Front@validate');
    
    //front blog
    $router->mount('/blog', function () use ($router, $tpl) {
        $router->match('GET|POST', '/', '/view/admin/blog/@Blog@frontIndex');
        $router->get('/category/([a-z0-9_-]+)', '/view/admin/blog/@Blog@frontCategory');
        $router->get('/([a-z0-9_-]+)', '/view/admin/blog/@Blog@render');
    });
    
    //dashboard
    $router->mount('/dashboard', function () use ($router, $tpl) {
        $router->match('GET|POST', '/', 'Front@dashboard');
        $router->get('/memberships', 'Front@membership');
        $router->get('/history', 'Front@history');
        $router->get('/profile', 'Front@profile');
        $router->get('/view/([a-zA-Z0-9]+)', 'Front@view');
    });
    
    //logout
    $router->get('/logout', function () {
        App::Auth()->logout();
        Url::redirect(SITEURL . '/');
    });
    
    //404
    $router->set404(function () use ($core, $router) {
        $tpl = App::View(BASEPATH . 'view/');
        $tpl->dir = $router->segments[0] == 'admin' ? 'admin/' : 'front/themes/' . $core->theme . '/';
        $tpl->segments = $router->segments;
        $tpl->data = null;
        $tpl->title = Language::$word->META_ERROR;
        $tpl->keywords = null;
        $tpl->description = null;
        $tpl->core = $core;
        $tpl->auth = App::Auth();
        $tpl->db = App::Database();
        $tpl->crumbs = [array(0 => Language::$word->HOME, 1 => ''), Language::$word->META_ERROR2];

        if ($router->segments[0] != 'admin') {
            $tpl->menus = Content::getMenus();
            $tpl->categories = App::Content()->renderCategories(App::Content()->categoryTree());
            $tpl->counter = Product::cartCounter();
        }
        $tpl->template = $router->segments[0] == 'admin' ? 'admin/404' : 'front/themes/' . $core->theme . '/404';
        echo $tpl->render();
    });
    
    // Maintenance mode
    if ($core->offline) {
        if (false === str_contains($_SERVER['REQUEST_URI'], 'login/') && false === str_contains($_SERVER['REQUEST_URI'], 'admin/') && false === App::Auth()->is_Admin()) {
            Url::redirect(SITEURL . '/maintenance.php');
            exit;
        }
    }
    
    // Run router
    $router->run(function () use ($tpl, $core, $router) {
        $tpl->segments = $router->segments;
        $tpl->core = $core;
        $tpl->auth = App::Auth();
        if ($router->segments[0] != 'admin') {
            $tpl->menus = Content::getMenus();
            $tpl->categories = App::Content()->renderCategories(App::Content()->categoryTree());
            $tpl->counter = Product::cartCounter();
        }
        Content::$segments = $router->segments;
        echo $tpl->render();
    });