<?php
    /**
     * Core Class
     *
     * @package Wojo Framework
     * @author wojoscripts.com
     * @copyright 2023
     * @version 5.50: Core.php, v1.00 7/22/2023 9:39 AM Gewa Exp $
     *
     */
    if (!defined('_WOJO')) {
        die('Direct access to this location is not allowed.');
    }
    
    class Core
    {
        
        const sTable = 'settings';
        const txTable = 'trash';
        const gTable = 'gateways';
        const cjTable = 'cronjobs';
        
        public static string $language;
        
        public string $site_name;
        public string $company;
        public string $site_dir;
        public string $site_email;
        public string $logo;
        public string $plogo;
        public string $short_date;
        public string $long_date;
        public string $calendar_date;
        public string $time_format;
        public string $dtz;
        public string $locale;
        public string $lang;
        public int $weekstart;
        public string $theme;
        public string $color;
        public int $perpage;
        public int $ploader;
        public int $offline;
        public string $offline_msg;
        public string $offline_d;
        public string $offline_t;
        public int $eucookie;
        public string $backup;
        public string $currency;
        public string $file_dir;
        public int $featured;
        public int $cperpage;
        public string $home_layout;
        public int $avatar_w;
        public int $avatar_h;
        public int $thumb_h;
        public int $thumb_w;
        public int $enable_tax;
        public float $tax_rate;
        public int $reg_verify;
        public int $auto_verify;
        public int $notify_admin;
        public string $allow_free;
        public int $enable_comments;
        public string $mailer;
        public string $smtp_host;
        public string $smtp_user;
        public string $smtp_pass;
        public int $smtp_port;
        public string $sendmail;
        public int $is_ssl;
        public stdClass $social;
        public stdClass $page_slugs;
        public string $analytics;
        public int $flood;
        public int $attempt;
        public int $logging;
        public string $inv_info;
        public string $inv_note;
        public string $wojov;
        public string $wojon;
        
        /**
         *
         */
        public function __construct()
        {
            $this->settings();
            ($this->dtz) ? ini_set('date.timezone', $this->dtz) : date_default_timezone_set('UTC');
            Locale::setDefault($this->locale);
        }
        
        /**
         * index
         *
         * @return void
         */
        public function index(): void
        {
            $tpl = App::View(BASEPATH . 'view/');
            $tpl->dir = 'admin/';
            $tpl->title = Language::$word->META_SETTINGS;
            $tpl->caption = Language::$word->META_M_SETTINGS;
            $tpl->subtitle = Language::$word->CONF_INFO;
            
            $tpl->data = $this;
            $tpl->countries = Database::Go()->select(Content::cnTable)->orderBy('sorting', 'DESC')->run();
            
            $colors = File::findFiles(THEMEBASE . '/css/colors/', array('fileTypes' => array('css'), 'level' => 1));
            $values = array_map(function ($e) {
                return ucfirst(substr($e, 1, -4));
            }, $colors);
            
            $tpl->colors = array_combine($colors, $values);
            
            $tpl->template = 'admin/configuration';
        }
        
        /**
         * processConfig
         *
         * @return void
         */
        public function processConfig(): void
        {
            $validate = Validator::run($_POST);
            $validate
                ->set('site_name', Language::$word->CONF_SITE)->required()->string()->min_len(2)->max_len(80)
                ->set('company', Language::$word->CONF_COMPANY)->required()->string()->min_len(2)->max_len(80)
                ->set('site_email', Language::$word->CONF_EMAIL)->required()->email()
                ->set('theme', Language::$word->CONF_THEME)->required()->string();
            
            $validate
                ->set('color', Language::$word->CONF_THEME_COLOR)->required()->string()
                ->set('perpage', Language::$word->CONF_PERPAGE)->required()->numeric()
                ->set('thumb_w', Language::$word->CONF_TH_WH)->required()->numeric()
                ->set('thumb_h', Language::$word->CONF_TH_WH)->required()->numeric()
                ->set('avatar_w', Language::$word->CONF_AV_WH)->required()->numeric()
                ->set('avatar_h', Language::$word->CONF_AV_WH)->required()->numeric()
                ->set('long_date', Language::$word->CONF_LONGDATE)->required()->string()
                ->set('short_date', Language::$word->CONF_SHORTDATE)->required()->string();
            
            $validate
                ->set('time_format', Language::$word->CONF_TIMEFORMAT)->required()->string()
                ->set('dtz', Language::$word->CONF_DTZ)->required()->string()
                ->set('locale', Language::$word->CONF_LOCALES)->required()->string()
                ->set('weekstart', Language::$word->CONF_WEEKSTART)->required()->numeric()
                ->set('lang', Language::$word->CONF_LANG)->required()->string()->exact_len(2)
                ->set('ploader', Language::$word->CONF_PLOADER)->required()->numeric()
                ->set('file_dir', Language::$word->CONF_FILEDIR)->required()->path()
                ->set('featured', Language::$word->CONF_FEATURED)->required()->numeric();
            
            $validate
                ->set('cperpage', Language::$word->CONF_CPERPAGE)->required()->numeric()
                ->set('home_layout', Language::$word->CONF_HLAYOUT)->required()->numeric()
                ->set('eucookie', Language::$word->CONF_EUCOOKIE)->required()->numeric()
                ->set('offline', Language::$word->CONF_OFFLINE_M)->required()->numeric()
                ->set('offline_d_submit', Language::$word->CONF_OFFLINE_DT)->required()->date()
                ->set('offline_t', Language::$word->CONF_OFFLINE_DT)->required()->date()
                ->set('currency', Language::$word->CONF_CURRENCY)->required()->string()->min_len(3)->max_len(6);
            
            $validate
                ->set('enable_tax', Language::$word->CONF_ETAX)->required()->numeric()
                ->set('tax_rate', Language::$word->CONF_ETAX_RATE)->required()->float()
                ->set('reg_verify', Language::$word->CONF_REGVERIFY)->required()->numeric()
                ->set('auto_verify', Language::$word->CONF_AUTOVERIFY)->required()->numeric()
                ->set('notify_admin', Language::$word->CONF_NOTIFY_ADMIN)->required()->numeric()
                ->set('allow_free', Language::$word->CONF_FREEDOWN)->required()->string()
                ->set('flood', Language::$word->CONF_LOGIN_TIME)->required()->numeric()->min_len(1)->max_len(3)
                ->set('attempt', Language::$word->CONF_LOGIN_ATTEMPT)->required()->numeric()
                ->set('logging', Language::$word->CONF_LOG_ON)->required()->numeric()
                ->set('enable_comments', Language::$word->CONF_COMMENTS)->required()->numeric()
                ->set('mailer', Language::$word->CONF_MAILER)->required()->string()
                ->set('is_ssl', Language::$word->CONF_SMTP_SSL)->required()->numeric();
            
            $validate
                ->set('analytics', Language::$word->CONF_GA)->string()
                ->set('inv_info', Language::$word->CONF_INVDATA)->text('basic')
                ->set('inv_note', Language::$word->CONF_INVNOTE)->text('basic')
                ->set('offline_msg', Language::$word->CONF_OFFLINE_MS)->text('basic')
                ->set('twitter', Language::$word->CONF_TWID)->string()
                ->set('facebook', Language::$word->CONF_FBID)->string()
                ->set('site_dir', Language::$word->CONF_DIR)->string()
                ->set('sendmail', Language::$word->CONF_SMAILPATH)->path();
            
            $validate
                ->set('smtp_host', Language::$word->CONF_SMTP_HOST)->string()
                ->set('smtp_user', Language::$word->CONF_SMTP_USER)->string()
                ->set('smtp_pass', Language::$word->CONF_SMTP_PASS)->string()
                ->set('smtp_port', Language::$word->CONF_SMTP_PORT)->numeric();
            
            switch ($_POST['mailer']) {
                case 'SMTP':
                    $validate
                        ->set('smtp_host', Language::$word->CONF_SMTP_HOST)->required()->string()
                        ->set('smtp_user', Language::$word->CONF_SMTP_USER)->required()->string()
                        ->set('smtp_pass', Language::$word->CONF_SMTP_PASS)->required()->string()
                        ->set('smtp_port', Language::$word->CONF_SMTP_PORT)->required()->numeric();
                    break;
                
                case 'SMAIL':
                    $validate->set('sendmail', Language::$word->CONF_SMAILPATH)->required()->string();
                    break;
            }
            
            $safe = $validate->safe();
            
            $logo = File::upload('logo', 3145728, 'png,jpg,svg');
            $plogo = File::upload('plogo', 3145728, 'png,jpg,svg');
            
            if (count(Message::$msgs) === 0) {
                $smedia['facebook'] = $safe->facebook;
                $smedia['twitter'] = $safe->twitter;
                
                $data = array(
                    'site_name' => $safe->site_name,
                    'company' => $safe->company,
                    'site_email' => $safe->site_email,
                    'site_dir' => $safe->site_dir,
                    'theme' => $safe->theme,
                    'color' => $safe->color,
                    'perpage' => $safe->perpage,
                    'thumb_w' => $safe->thumb_w,
                    'thumb_h' => $safe->thumb_h,
                    'avatar_w' => $safe->avatar_w,
                    'avatar_h' => $safe->avatar_h,
                    'long_date' => $safe->long_date,
                    'short_date' => $safe->short_date,
                    'time_format' => $safe->time_format,
                    'weekstart' => $safe->weekstart,
                    'file_dir' => $safe->file_dir,
                    'lang' => $safe->lang,
                    'dtz' => $safe->dtz,
                    'locale' => $safe->locale,
                    'ploader' => $safe->ploader,
                    'featured' => $safe->featured,
                    'cperpage' => $safe->cperpage,
                    'home_layout' => $safe->home_layout,
                    'eucookie' => $safe->eucookie,
                    'offline' => $safe->offline,
                    'offline_msg' => $safe->offline_msg,
                    'offline_d' => Database::toDate($safe->offline_d_submit),
                    'offline_t' => $safe->offline_t,
                    'currency' => $safe->currency,
                    'enable_tax' => $safe->enable_tax,
                    'tax_rate' => $safe->tax_rate,
                    'reg_verify' => $safe->reg_verify,
                    'auto_verify' => $safe->auto_verify,
                    'notify_admin' => $safe->notify_admin,
                    'allow_free' => $safe->allow_free,
                    'enable_comments' => $safe->enable_comments,
                    'flood' => ($safe->flood * 60),
                    'attempt' => $safe->attempt,
                    'logging' => $safe->logging,
                    'analytics' => $safe->analytics,
                    'mailer' => $safe->mailer,
                    'sendmail' => $safe->sendmail,
                    'smtp_host' => $safe->smtp_host,
                    'smtp_user' => $safe->smtp_user,
                    'smtp_pass' => $safe->smtp_pass,
                    'smtp_port' => $safe->smtp_port,
                    'is_ssl' => $safe->is_ssl,
                    'inv_info' => $safe->inv_info,
                    'inv_note' => $safe->inv_note,
                    'social_media' => json_encode($smedia),
                );
                
                if (array_key_exists('logo', $_FILES)) {
                    File::deleteFile(UPLOADS . $this->logo);
                    $result = File::process($logo, UPLOADS . '/', false, 'logo', false);
                    $data['logo'] = $result['fname'];
                }
                
                if (array_key_exists('plogo', $_FILES)) {
                    File::deleteFile(UPLOADS . $this->logo);
                    $result = File::process($plogo, UPLOADS . '/', false, 'print_logo', false);
                    $data['plogo'] = $result['fname'];
                }
                
                if (Validator::post('dellogo')) {
                    $data['logo'] = 'NULL';
                }
                if (Validator::post('dellogop')) {
                    $data['plogo'] = 'NULL';
                }
                
                Database::Go()->update(self::sTable, $data)->where('id', 1, '=')->run();
                Message::msgReply(Database::Go()->affected(), 'success', Language::$word->CONF_UPDATE_OK);
            } else {
                Message::msgSingleStatus();
            }
        }
        
        /**
         * settings
         *
         * @return void
         */
        protected function settings(): void
        {
            $row = Database::Go()->select(self::sTable)->where('id', 1, '=')->first()->run();
            
            $this->site_name = $row->site_name;
            $this->company = $row->company;
            $this->site_dir = $row->site_dir;
            $this->site_email = $row->site_email;
            $this->logo = $row->logo;
            $this->plogo = $row->plogo;
            $this->short_date = $row->short_date;
            $this->calendar_date = $row->calendar_date;
            $this->long_date = $row->long_date;
            $this->time_format = $row->time_format;
            $this->dtz = $row->dtz;
            $this->locale = $row->locale;
            $this->lang = $row->lang;
            $this->weekstart = $row->weekstart;
            $this->theme = $row->theme;
            $this->color = $row->color;
            $this->perpage = $row->perpage;
            $this->ploader = $row->ploader;
            
            $this->offline = $row->offline;
            $this->offline_msg = $row->offline_msg;
            $this->offline_d = $row->offline_d;
            $this->offline_t = $row->offline_t;
            $this->eucookie = $row->eucookie;
            $this->backup = $row->backup;
            $this->currency = $row->currency;
            $this->file_dir = $row->file_dir;
            $this->featured = $row->featured;
            $this->cperpage = $row->cperpage;
            $this->home_layout = $row->home_layout;
            
            $this->avatar_w = $row->avatar_w;
            $this->avatar_h = $row->avatar_h;
            $this->thumb_h = $row->thumb_h;
            $this->thumb_w = $row->thumb_w;
            
            $this->enable_tax = $row->enable_tax;
            $this->tax_rate = $row->tax_rate;
            
            $this->reg_verify = $row->reg_verify;
            $this->auto_verify = $row->auto_verify;
            $this->notify_admin = $row->notify_admin;
            $this->allow_free = $row->allow_free;
            $this->enable_comments = $row->enable_comments;
            
            $this->mailer = $row->mailer;
            $this->smtp_host = $row->smtp_host;
            $this->smtp_user = $row->smtp_user;
            $this->smtp_pass = $row->smtp_pass;
            $this->smtp_port = $row->smtp_port;
            $this->sendmail = $row->sendmail;
            $this->is_ssl = $row->is_ssl;
            
            $this->social = json_decode($row->social_media);
            $this->page_slugs = json_decode($row->page_slugs);
            $this->analytics = $row->analytics;
            
            $this->flood = $row->flood;
            $this->attempt = $row->attempt;
            $this->logging = $row->logging;
            
            $this->inv_info = $row->inv_info;
            $this->inv_note = $row->inv_note;
            
            $this->wojov = $row->wojov;
            $this->wojon = $row->wojon;
        }
        
        /**
         * colors
         *
         * @return string
         */
        public static function colors(): string
        {
            if (isset($_COOKIE['COLOR_DDP'])) {
                $file = Validator::sanitize($_COOKIE['COLOR_DDP'], 'string', 12);
                
                if (file_exists(THEMEBASE . '/css/colors/' . $file)) {
                    $html = '<link id="styler" href="' . THEMEURL . '/css/colors/' . $file . '" rel="stylesheet" type="text/css">';
                } else {
                    $html = '<link id="styler" href="' . THEMEURL . '/css/_default.css" rel="stylesheet" type="text/css">';
                }
            } else {
                if (App::Core()->color == '_default.css') {
                    $html = '<link id="styler" href="' . THEMEURL . '/css/_default.css" rel="stylesheet" type="text/css">';
                } else {
                    $html = '<link id="styler" href="' . THEMEURL . '/css/colors/_' . strtolower(App::Core()->color) . '.css" rel="stylesheet" type="text/css">';
                }
            }
            return $html;
        }
    }