<?php
    /**
     * Maintenance
     *
     * @package Wojo Framework
     * @author wojoscripts.com
     * @copyright 2023
     * @version $Id: maintenance.tpl.php, v1.00 2023-08-10 10:12:05 gewa Exp $
     */
    const _WOJO = true;
    include('init.php');
    
    if (!App::Core()->offline)
        Url::redirect(SITEURL);
    
    $d = explode('-', App::Core()->offline_d);
    $t = explode(':', App::Core()->offline_t);
?>
<!doctype html>
<html lang="en">
<head>
   <meta charset="utf-8">
   <title><?php echo App::Core()->company; ?></title>
   <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1">
   <meta name="apple-mobile-web-app-capable" content="yes">
   <link rel="shortcut icon" href="<?php echo SITEURL; ?>/assets/favicon.ico" type="image/x-icon">
   <link
      href="<?php echo THEMEURL . '/cache/' . Cache::cssCache(array('base.css', 'transition.css', 'dropdown.css', 'image.css', 'label.css', 'message.css', 'list.css', 'table.css', 'tooltip.css', 'form.css', 'input.css', 'icon.css', 'button.css', 'card.css', 'modal.css', 'progress.css', 'utility.css',  'style.css'), THEMEBASE); ?>"
      rel="stylesheet" type="text/css">
   <script src="<?php echo SITEURL; ?>/assets/jquery.js"></script>
</head>
<body>
<header id="mheader">
   <a href="<?php echo SITEURL; ?>/" class="logo">
       <?php echo (App::Core()->logo) ? '<img src="' . SITEURL . '/uploads/' . App::Core()->logo . '" alt="' . App::Core()->company . '">' : App::Core()->company; ?></a>
</header>
<main id="mmain">
   <div class="wojo-grid">
      <div class="row gutters justify-center">
         <div class="columns screen-60 tablet-60 mobile-100 phone-100">
            <h4>
                <?php echo Language::$word->CONF_OFFLINE_M; ?>
            </h4>
             <?php echo Url::out_url(App::Core()->offline_msg); ?>
            <div id="mdashboard" class="row gutters">
               <div class="columns auto phone-50">
                  <div class="dash weeks_dash">
                     <div class="digit first">
                        <div style="display:none" class="top">1</div>
                        <div style="display:block" class="bottom">0</div>
                     </div>
                     <div class="digit last">
                        <div style="display:none" class="top">3</div>
                        <div style="display:block" class="bottom">0</div>
                     </div>
                     <span class="dash_title"><?php echo Language::$word->_WEEKS; ?></span>
                  </div>
               </div>
               <div class="columns auto phone-50">
                  <div class="dash days_dash">
                     <div class="digit first">
                        <div style="display:none" class="top">0</div>
                        <div style="display:block" class="bottom">0</div>
                     </div>
                     <div class="digit last">
                        <div style="display:none" class="top">0</div>
                        <div style="display:block" class="bottom">0</div>
                     </div>
                     <span class="dash_title"><?php echo Language::$word->_DAYS; ?></span>
                  </div>
               </div>
               <div class="columns auto phone-50">
                  <div class="dash hours_dash">
                     <div class="digit first">
                        <div style="display:none" class="top">2</div>
                        <div style="display:block" class="bottom">0</div>
                     </div>
                     <div class="digit last">
                        <div style="display:none" class="top">3</div>
                        <div style="display:block" class="bottom">0</div>
                     </div>
                     <span class="dash_title"><?php echo Language::$word->_HOURS; ?></span>
                  </div>
               </div>
               <div class="columns auto phone-50">
                  <div class="dash minutes_dash">
                     <div class="digit first">
                        <div style="display:none" class="top">2</div>
                        <div style="display:block" class="bottom">0</div>
                     </div>
                     <div class="digit last">
                        <div style="display:none" class="top">9</div>
                        <div style="display:block" class="bottom">0</div>
                     </div>
                     <span class="dash_title"><?php echo Language::$word->_MINUTES; ?></span>
                  </div>
               </div>
            </div>
         </div>
      </div>
   </div>
</main>
<div id="mfooter">Copyright &copy;<?php echo date('Y') . ' ' . App::Core()->company; ?> Powered by DDP v.<?php echo App::Core()->wojov; ?></div>
<script src="<?php echo SITEURL; ?>/assets/countdown.js"></script>
<script>
   $(document).ready(function () {
      $('#mdashboard').countDown({
         targetDate: {
            'day': <?php echo $d[2];?> ,
            'month': <?php echo $d[1];?> ,
            'year': <?php echo $d[0];?> ,
            'hour': <?php echo $t[0];?> ,
            'min': <?php echo $t[1];?> ,
            'sec': 0
         }
      });

      $('.logo img').each(function () {
         const $img = $(this);
         const imgID = $img.attr('id');
         const imgClass = $img.attr('class');
         const imgURL = $img.attr('src');

         $.get(imgURL, function (data) {
            let $svg = $(data).find('svg');
            if (typeof imgID !== 'undefined') {
               $svg = $svg.attr('id', imgID);
            }
            if (typeof imgClass !== 'undefined') {
               $svg = $svg.attr('class', imgClass + ' replaced-svg');
            }
            $svg = $svg.removeAttr('xmlns:a');
            $img.replaceWith($svg);
         }, 'xml');

      });
   });
</script>
</body>
</html>