-- ================================================================
--
-- @version $Id: structure.sql 2020-07-01 12:12:05 gewa $
-- @package Digital Downloads Pro
-- @copyright 2020. wojoscripts.com
--
-- ================================================================
-- Database Content
-- ================================================================
--
-- Table structure for table `activity`
--

DROP TABLE IF EXISTS `activity`;
CREATE TABLE IF NOT EXISTS `activity` (
  `id` int(11) UNSIGNED NOT NULL AUTO_INCREMENT,
  `user_id` int(11) UNSIGNED NOT NULL DEFAULT '0',
  `username` varchar(80) DEFAULT NULL,
  `ip` varbinary(16) DEFAULT NULL,
  `failed` tinyint(1) UNSIGNED NOT NULL DEFAULT '0',
  `failed_last` int(11) UNSIGNED NOT NULL DEFAULT '0',
  `type` varchar(20) DEFAULT NULL,
  `message` varchar(150) DEFAULT NULL,
  `importance` tinyint(1) UNSIGNED NOT NULL DEFAULT '0' COMMENT '1 yes, 0 =no',
  `created` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `idx_user` (`user_id`)
  ) ENGINE = MyISAM DEFAULT CHARSET = utf8mb4;

--
-- Table structure for table `blog`
--

DROP TABLE IF EXISTS `blog`;
CREATE TABLE IF NOT EXISTS `blog` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `category_id` int(11) unsigned NOT NULL DEFAULT '0',
  `user_id` int(11) unsigned NOT NULL DEFAULT '0',
  `title` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `slug` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `body` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `thumb` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `hits` int(6) unsigned DEFAULT '0',
  `show_sharing` tinyint(1) unsigned NOT NULL DEFAULT '1',
  `show_created` tinyint(1) unsigned NOT NULL DEFAULT '1',
  `keywords` varchar(200) DEFAULT NULL,
  `description` text,
  `created` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `active` tinyint(1) unsigned NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  KEY `idx_catid` (`category_id`)
  ) ENGINE = MyISAM DEFAULT CHARSET = utf8mb4;

--
-- Table structure for table `blog_categories`
--

DROP TABLE IF EXISTS `blog_categories`;
CREATE TABLE IF NOT EXISTS `blog_categories` (
  `id` int(6) unsigned NOT NULL AUTO_INCREMENT,
  `parent_id` int(6) unsigned NOT NULL DEFAULT '0',
  `name` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `slug` varchar(100) NOT NULL,
  `icon` varchar(100) DEFAULT NULL,
  `perpage` tinyint(3) unsigned NOT NULL DEFAULT '10',
  `keywords` varchar(200) DEFAULT NULL,
  `description` text,
  `sorting` int(6) unsigned NOT NULL DEFAULT '0',
  `active` tinyint(1) unsigned NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  KEY `order_num` (`sorting`),
  KEY `parent_id` (`parent_id`)
  ) ENGINE = MyISAM DEFAULT CHARSET = utf8mb4;

--
-- Table structure for table `cart`
--

DROP TABLE IF EXISTS `cart`;
CREATE TABLE IF NOT EXISTS `cart` (
  `id` int(11) UNSIGNED NOT NULL AUTO_INCREMENT,
  `user_id` varchar(48) NOT NULL DEFAULT '0',
  `user_m_id` int(11) UNSIGNED NOT NULL DEFAULT '0',
  `product_id` int(11) UNSIGNED NOT NULL DEFAULT '0',
  `membership_id` int(11) UNSIGNED NOT NULL DEFAULT '0',
  `tax` decimal(13, 2) UNSIGNED NOT NULL DEFAULT '0.00',
  `totaltax` decimal(13, 2) UNSIGNED NOT NULL DEFAULT '0.00',
  `coupon` decimal(13, 2) UNSIGNED NOT NULL DEFAULT '0.00',
  `total` decimal(13, 2) UNSIGNED NOT NULL DEFAULT '0.00',
  `originalprice` decimal(13, 2) UNSIGNED NOT NULL DEFAULT '0.00',
  `totalprice` decimal(13, 2) UNSIGNED NOT NULL DEFAULT '0.00',
  `cart_id` varchar(100) DEFAULT NULL,
  `order_id` varchar(100) DEFAULT NULL,
  `created` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `idx_membership` (`membership_id`),
  KEY `idx_product` (`product_id`)
  ) ENGINE = MyISAM DEFAULT CHARSET = utf8mb4;

--
-- Table structure for table `categories`
--

DROP TABLE IF EXISTS `categories`;
CREATE TABLE IF NOT EXISTS `categories` (
  `id` int(6) UNSIGNED NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `parent_id` int(6) UNSIGNED NOT NULL DEFAULT '0',
  `slug` varchar(100) NOT NULL,
  `body` varchar(100) DEFAULT NULL,
  `keywords` varchar(250) DEFAULT NULL,
  `description` varchar(250) DEFAULT NULL,
  `sorting` tinyint(11) UNSIGNED NOT NULL DEFAULT '0',
  `active` tinyint(1) UNSIGNED NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `idx_parent` (`parent_id`)
  ) ENGINE = MyISAM DEFAULT CHARSET = utf8mb4;

--
-- Dumping data for table `categories`
--

INSERT INTO `categories`
VALUES (1, 'Software', 0, 'software', 'Looking for licensed software for your computer or network? ', '', '', 2, 1);
INSERT INTO `categories`
VALUES (2, 'E-Books', 0, 'ebooks', NULL, NULL, NULL, 6, 1);
INSERT INTO `categories`
VALUES (3, 'Music and Video', 0, 'music-and-video', NULL, NULL, NULL, 7, 1);
INSERT INTO `categories`
VALUES (4, 'Office and Productivity', 0, 'office-and-productivity', NULL, NULL, NULL, 8, 1);
INSERT INTO `categories`
VALUES (5, 'Antivirus and Security', 1, 'antivirus-and-security', NULL, '', '', 3, 1);
INSERT INTO `categories`
VALUES (6, 'Bussines and Accounting', 1, 'bussines-and-accounting', NULL, '', '', 4, 1);
INSERT INTO `categories`
VALUES (7, 'Customer Support', 1, 'customer-support', NULL, NULL, NULL, 5, 1);
INSERT INTO `categories`
VALUES (8, 'PC Games', 0, 'pc-games', '', '', '', 1, 1);
INSERT INTO `categories`
VALUES (9, 'VIP Access', 0, 'vip-access', '', '', '', 9, 1);

--
-- Table structure for table `categories_related`
--

DROP TABLE IF EXISTS `categories_related`;
CREATE TABLE IF NOT EXISTS `categories_related` (
  `id` int(11) UNSIGNED NOT NULL AUTO_INCREMENT,
  `product_id` int(11) UNSIGNED NOT NULL DEFAULT '0',
  `category_id` int(11) UNSIGNED NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `idx_product` (`product_id`),
  KEY `idx_category` (`category_id`)
  ) ENGINE = MyISAM AUTO_INCREMENT = 81 DEFAULT CHARSET = utf8mb4;

--
-- Dumping data for table `categories_related`
--

INSERT INTO `categories_related`
VALUES (38, 1, 4);
INSERT INTO `categories_related`
VALUES (37, 1, 1);
INSERT INTO `categories_related`
VALUES (40, 2, 1);
INSERT INTO `categories_related`
VALUES (46, 3, 5);
INSERT INTO `categories_related`
VALUES (45, 3, 1);
INSERT INTO `categories_related`
VALUES (47, 4, 1);
INSERT INTO `categories_related`
VALUES (48, 4, 6);
INSERT INTO `categories_related`
VALUES (49, 5, 1);
INSERT INTO `categories_related`
VALUES (50, 6, 1);
INSERT INTO `categories_related`
VALUES (51, 7, 1);
INSERT INTO `categories_related`
VALUES (52, 7, 3);
INSERT INTO `categories_related`
VALUES (80, 8, 5);
INSERT INTO `categories_related`
VALUES (79, 8, 1);
INSERT INTO `categories_related`
VALUES (55, 9, 1);
INSERT INTO `categories_related`
VALUES (56, 9, 4);
INSERT INTO `categories_related`
VALUES (57, 10, 1);
INSERT INTO `categories_related`
VALUES (58, 10, 3);
INSERT INTO `categories_related`
VALUES (74, 11, 8);
INSERT INTO `categories_related`
VALUES (71, 12, 8);
INSERT INTO `categories_related`
VALUES (76, 13, 8);
INSERT INTO `categories_related`
VALUES (67, 14, 2);
INSERT INTO `categories_related`
VALUES (66, 15, 2);
INSERT INTO `categories_related`
VALUES (65, 16, 2);
INSERT INTO `categories_related`
VALUES (68, 17, 9);

--
-- Table structure for table `cdkeys`
--

DROP TABLE IF EXISTS `cdkeys`;
CREATE TABLE IF NOT EXISTS `cdkeys` (
  `product_id` int(11) UNSIGNED NOT NULL DEFAULT '0',
  `cdkey` varchar(60) NOT NULL DEFAULT '0',
  PRIMARY KEY (`cdkey`),
  KEY `idx_product` (`product_id`)
  ) ENGINE = MyISAM DEFAULT CHARSET = utf8mb4;

--
-- Table structure for table `comments`
--

DROP TABLE IF EXISTS `comments`;
CREATE TABLE IF NOT EXISTS `comments` (
  `id` int(11) UNSIGNED NOT NULL AUTO_INCREMENT,
  `parent_id` int(11) UNSIGNED NOT NULL DEFAULT '0',
  `product_id` int(11) UNSIGNED NOT NULL DEFAULT '0',
  `username` varchar(24) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `user_id` int(11) UNSIGNED NOT NULL DEFAULT '0',
  `email` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `body` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `www` varchar(220) DEFAULT NULL,
  `vote_up` int(11) UNSIGNED NOT NULL DEFAULT '0',
  `vote_down` int(11) NOT NULL DEFAULT '0',
  `rating` int(11) UNSIGNED NOT NULL DEFAULT '0',
  `ip` varchar(16) DEFAULT NULL,
  `created` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `active` tinyint(1) UNSIGNED NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `parent` (`parent_id`)
  ) ENGINE = MyISAM DEFAULT CHARSET = utf8mb4;

--
-- Table structure for table `countries`
--

DROP TABLE IF EXISTS `countries`;
CREATE TABLE IF NOT EXISTS `countries` (
  `id` smallint(6) UNSIGNED NOT NULL AUTO_INCREMENT,
  `abbr` varchar(2) NOT NULL,
  `name` varchar(70) NOT NULL,
  `active` tinyint(1) UNSIGNED NOT NULL DEFAULT '1',
  `home` tinyint(1) UNSIGNED NOT NULL DEFAULT '0',
  `vat` decimal(13, 2) UNSIGNED NOT NULL DEFAULT '0.00',
  `sorting` smallint(6) UNSIGNED NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `abbrv` (`abbr`)
  ) ENGINE = MyISAM DEFAULT CHARSET = utf8mb4;

--
-- Dumping data for table `countries`
--

INSERT INTO `countries`
VALUES (1, 'AF', 'Afghanistan', 1, 0, '0.00', 0);
INSERT INTO `countries`
VALUES (2, 'AL', 'Albania', 1, 0, '0.00', 0);
INSERT INTO `countries`
VALUES (3, 'DZ', 'Algeria', 1, 0, '0.00', 0);
INSERT INTO `countries`
VALUES (4, 'AS', 'American Samoa', 1, 0, '0.00', 0);
INSERT INTO `countries`
VALUES (5, 'AD', 'Andorra', 1, 0, '0.00', 0);
INSERT INTO `countries`
VALUES (6, 'AO', 'Angola', 1, 0, '0.00', 0);
INSERT INTO `countries`
VALUES (7, 'AI', 'Anguilla', 1, 0, '0.00', 0);
INSERT INTO `countries`
VALUES (8, 'AQ', 'Antarctica', 1, 0, '0.00', 0);
INSERT INTO `countries`
VALUES (9, 'AG', 'Antigua and Barbuda', 1, 0, '0.00', 0);
INSERT INTO `countries`
VALUES (10, 'AR', 'Argentina', 1, 0, '0.00', 0);
INSERT INTO `countries`
VALUES (11, 'AM', 'Armenia', 1, 0, '0.00', 0);
INSERT INTO `countries`
VALUES (12, 'AW', 'Aruba', 1, 0, '0.00', 0);
INSERT INTO `countries`
VALUES (13, 'AU', 'Australia', 1, 0, '0.00', 0);
INSERT INTO `countries`
VALUES (14, 'AT', 'Austria', 1, 0, '0.00', 0);
INSERT INTO `countries`
VALUES (15, 'AZ', 'Azerbaijan', 1, 0, '0.00', 0);
INSERT INTO `countries`
VALUES (16, 'BS', 'Bahamas', 1, 0, '0.00', 0);
INSERT INTO `countries`
VALUES (17, 'BH', 'Bahrain', 1, 0, '0.00', 0);
INSERT INTO `countries`
VALUES (18, 'BD', 'Bangladesh', 1, 0, '0.00', 0);
INSERT INTO `countries`
VALUES (19, 'BB', 'Barbados', 1, 0, '0.00', 0);
INSERT INTO `countries`
VALUES (20, 'BY', 'Belarus', 1, 0, '0.00', 0);
INSERT INTO `countries`
VALUES (21, 'BE', 'Belgium', 1, 0, '0.00', 0);
INSERT INTO `countries`
VALUES (22, 'BZ', 'Belize', 1, 0, '0.00', 0);
INSERT INTO `countries`
VALUES (23, 'BJ', 'Benin', 1, 0, '0.00', 0);
INSERT INTO `countries`
VALUES (24, 'BM', 'Bermuda', 1, 0, '0.00', 0);
INSERT INTO `countries`
VALUES (25, 'BT', 'Bhutan', 1, 0, '0.00', 0);
INSERT INTO `countries`
VALUES (26, 'BO', 'Bolivia', 1, 0, '0.00', 0);
INSERT INTO `countries`
VALUES (27, 'BA', 'Bosnia and Herzegowina', 1, 0, '0.00', 0);
INSERT INTO `countries`
VALUES (28, 'BW', 'Botswana', 1, 0, '0.00', 0);
INSERT INTO `countries`
VALUES (29, 'BV', 'Bouvet Island', 1, 0, '0.00', 0);
INSERT INTO `countries`
VALUES (30, 'BR', 'Brazil', 1, 0, '0.00', 0);
INSERT INTO `countries`
VALUES (31, 'IO', 'British Indian Ocean Territory', 1, 0, '0.00', 0);
INSERT INTO `countries`
VALUES (32, 'VG', 'British Virgin Islands', 1, 0, '0.00', 0);
INSERT INTO `countries`
VALUES (33, 'BN', 'Brunei Darussalam', 1, 0, '0.00', 0);
INSERT INTO `countries`
VALUES (34, 'BG', 'Bulgaria', 1, 0, '0.00', 0);
INSERT INTO `countries`
VALUES (35, 'BF', 'Burkina Faso', 1, 0, '0.00', 0);
INSERT INTO `countries`
VALUES (36, 'BI', 'Burundi', 1, 0, '0.00', 0);
INSERT INTO `countries`
VALUES (37, 'KH', 'Cambodia', 1, 0, '0.00', 0);
INSERT INTO `countries`
VALUES (38, 'CM', 'Cameroon', 1, 0, '0.00', 0);
INSERT INTO `countries`
VALUES (39, 'CA', 'Canada', 1, 1, '13.00', 1000);
INSERT INTO `countries`
VALUES (40, 'CV', 'Cape Verde', 1, 0, '0.00', 0);
INSERT INTO `countries`
VALUES (41, 'KY', 'Cayman Islands', 1, 0, '0.00', 0);
INSERT INTO `countries`
VALUES (42, 'CF', 'Central African Republic', 1, 0, '0.00', 0);
INSERT INTO `countries`
VALUES (43, 'TD', 'Chad', 1, 0, '0.00', 0);
INSERT INTO `countries`
VALUES (44, 'CL', 'Chile', 1, 0, '0.00', 0);
INSERT INTO `countries`
VALUES (45, 'CN', 'China', 1, 0, '0.00', 0);
INSERT INTO `countries`
VALUES (46, 'CX', 'Christmas Island', 1, 0, '0.00', 0);
INSERT INTO `countries`
VALUES (47, 'CC', 'Cocos (Keeling) Islands', 1, 0, '0.00', 0);
INSERT INTO `countries`
VALUES (48, 'CO', 'Colombia', 1, 0, '0.00', 0);
INSERT INTO `countries`
VALUES (49, 'KM', 'Comoros', 1, 0, '0.00', 0);
INSERT INTO `countries`
VALUES (50, 'CG', 'Congo', 1, 0, '0.00', 0);
INSERT INTO `countries`
VALUES (51, 'CK', 'Cook Islands', 1, 0, '0.00', 0);
INSERT INTO `countries`
VALUES (52, 'CR', 'Costa Rica', 1, 0, '0.00', 0);
INSERT INTO `countries`
VALUES (53, 'CI', 'Cote D''ivoire', 1, 0, '0.00', 0);
INSERT INTO `countries`
VALUES (54, 'HR', 'Croatia', 1, 0, '0.00', 0);
INSERT INTO `countries`
VALUES (55, 'CU', 'Cuba', 1, 0, '0.00', 0);
INSERT INTO `countries`
VALUES (56, 'CY', 'Cyprus', 1, 0, '0.00', 0);
INSERT INTO `countries`
VALUES (57, 'CZ', 'Czech Republic', 1, 0, '0.00', 0);
INSERT INTO `countries`
VALUES (58, 'DK', 'Denmark', 1, 0, '0.00', 0);
INSERT INTO `countries`
VALUES (59, 'DJ', 'Djibouti', 1, 0, '0.00', 0);
INSERT INTO `countries`
VALUES (60, 'DM', 'Dominica', 1, 0, '0.00', 0);
INSERT INTO `countries`
VALUES (61, 'DO', 'Dominican Republic', 1, 0, '0.00', 0);
INSERT INTO `countries`
VALUES (62, 'TP', 'East Timor', 1, 0, '0.00', 0);
INSERT INTO `countries`
VALUES (63, 'EC', 'Ecuador', 1, 0, '0.00', 0);
INSERT INTO `countries`
VALUES (64, 'EG', 'Egypt', 1, 0, '0.00', 0);
INSERT INTO `countries`
VALUES (65, 'SV', 'El Salvador', 1, 0, '0.00', 0);
INSERT INTO `countries`
VALUES (66, 'GQ', 'Equatorial Guinea', 1, 0, '0.00', 0);
INSERT INTO `countries`
VALUES (67, 'ER', 'Eritrea', 1, 0, '0.00', 0);
INSERT INTO `countries`
VALUES (68, 'EE', 'Estonia', 1, 0, '0.00', 0);
INSERT INTO `countries`
VALUES (69, 'ET', 'Ethiopia', 1, 0, '0.00', 0);
INSERT INTO `countries`
VALUES (70, 'FK', 'Falkland Islands (Malvinas)', 1, 0, '0.00', 0);
INSERT INTO `countries`
VALUES (71, 'FO', 'Faroe Islands', 1, 0, '0.00', 0);
INSERT INTO `countries`
VALUES (72, 'FJ', 'Fiji', 1, 0, '0.00', 0);
INSERT INTO `countries`
VALUES (73, 'FI', 'Finland', 1, 0, '0.00', 0);
INSERT INTO `countries`
VALUES (74, 'FR', 'France', 1, 0, '0.00', 0);
INSERT INTO `countries`
VALUES (75, 'GF', 'French Guiana', 1, 0, '0.00', 0);
INSERT INTO `countries`
VALUES (76, 'PF', 'French Polynesia', 1, 0, '0.00', 0);
INSERT INTO `countries`
VALUES (77, 'TF', 'French Southern Territories', 1, 0, '0.00', 0);
INSERT INTO `countries`
VALUES (78, 'GA', 'Gabon', 1, 0, '0.00', 0);
INSERT INTO `countries`
VALUES (79, 'GM', 'Gambia', 1, 0, '0.00', 0);
INSERT INTO `countries`
VALUES (80, 'GE', 'Georgia', 1, 0, '0.00', 0);
INSERT INTO `countries`
VALUES (81, 'DE', 'Germany', 1, 0, '0.00', 0);
INSERT INTO `countries`
VALUES (82, 'GH', 'Ghana', 1, 0, '0.00', 0);
INSERT INTO `countries`
VALUES (83, 'GI', 'Gibraltar', 1, 0, '0.00', 0);
INSERT INTO `countries`
VALUES (84, 'GR', 'Greece', 1, 0, '0.00', 0);
INSERT INTO `countries`
VALUES (85, 'GL', 'Greenland', 1, 0, '0.00', 0);
INSERT INTO `countries`
VALUES (86, 'GD', 'Grenada', 1, 0, '0.00', 0);
INSERT INTO `countries`
VALUES (87, 'GP', 'Guadeloupe', 1, 0, '0.00', 0);
INSERT INTO `countries`
VALUES (88, 'GU', 'Guam', 1, 0, '0.00', 0);
INSERT INTO `countries`
VALUES (89, 'GT', 'Guatemala', 1, 0, '0.00', 0);
INSERT INTO `countries`
VALUES (90, 'GN', 'Guinea', 1, 0, '0.00', 0);
INSERT INTO `countries`
VALUES (91, 'GW', 'Guinea-Bissau', 1, 0, '0.00', 0);
INSERT INTO `countries`
VALUES (92, 'GY', 'Guyana', 1, 0, '0.00', 0);
INSERT INTO `countries`
VALUES (93, 'HT', 'Haiti', 1, 0, '0.00', 0);
INSERT INTO `countries`
VALUES (94, 'HM', 'Heard and McDonald Islands', 1, 0, '0.00', 0);
INSERT INTO `countries`
VALUES (95, 'HN', 'Honduras', 1, 0, '0.00', 0);
INSERT INTO `countries`
VALUES (96, 'HK', 'Hong Kong', 1, 0, '0.00', 0);
INSERT INTO `countries`
VALUES (97, 'HU', 'Hungary', 1, 0, '0.00', 0);
INSERT INTO `countries`
VALUES (98, 'IS', 'Iceland', 1, 0, '0.00', 0);
INSERT INTO `countries`
VALUES (99, 'IN', 'India', 1, 0, '0.00', 0);
INSERT INTO `countries`
VALUES (100, 'ID', 'Indonesia', 1, 0, '0.00', 0);
INSERT INTO `countries`
VALUES (101, 'IQ', 'Iraq', 1, 0, '0.00', 0);
INSERT INTO `countries`
VALUES (102, 'IE', 'Ireland', 1, 0, '0.00', 0);
INSERT INTO `countries`
VALUES (103, 'IR', 'Islamic Republic of Iran', 1, 0, '0.00', 0);
INSERT INTO `countries`
VALUES (104, 'IL', 'Israel', 1, 0, '0.00', 0);
INSERT INTO `countries`
VALUES (105, 'IT', 'Italy', 1, 0, '0.00', 0);
INSERT INTO `countries`
VALUES (106, 'JM', 'Jamaica', 1, 0, '0.00', 0);
INSERT INTO `countries`
VALUES (107, 'JP', 'Japan', 1, 0, '0.00', 0);
INSERT INTO `countries`
VALUES (108, 'JO', 'Jordan', 1, 0, '0.00', 0);
INSERT INTO `countries`
VALUES (109, 'KZ', 'Kazakhstan', 1, 0, '0.00', 0);
INSERT INTO `countries`
VALUES (110, 'KE', 'Kenya', 1, 0, '0.00', 0);
INSERT INTO `countries`
VALUES (111, 'KI', 'Kiribati', 1, 0, '0.00', 0);
INSERT INTO `countries`
VALUES (112, 'KP', 'Korea, Dem. Peoples Rep of', 1, 0, '0.00', 0);
INSERT INTO `countries`
VALUES (113, 'KR', 'Korea, Republic of', 1, 0, '0.00', 0);
INSERT INTO `countries`
VALUES (114, 'KW', 'Kuwait', 1, 0, '0.00', 0);
INSERT INTO `countries`
VALUES (115, 'KG', 'Kyrgyzstan', 1, 0, '0.00', 0);
INSERT INTO `countries`
VALUES (116, 'LA', 'Laos', 1, 0, '0.00', 0);
INSERT INTO `countries`
VALUES (117, 'LV', 'Latvia', 1, 0, '0.00', 0);
INSERT INTO `countries`
VALUES (118, 'LB', 'Lebanon', 1, 0, '0.00', 0);
INSERT INTO `countries`
VALUES (119, 'LS', 'Lesotho', 1, 0, '0.00', 0);
INSERT INTO `countries`
VALUES (120, 'LR', 'Liberia', 1, 0, '0.00', 0);
INSERT INTO `countries`
VALUES (121, 'LY', 'Libyan Arab Jamahiriya', 1, 0, '0.00', 0);
INSERT INTO `countries`
VALUES (122, 'LI', 'Liechtenstein', 1, 0, '0.00', 0);
INSERT INTO `countries`
VALUES (123, 'LT', 'Lithuania', 1, 0, '0.00', 0);
INSERT INTO `countries`
VALUES (124, 'LU', 'Luxembourg', 1, 0, '0.00', 0);
INSERT INTO `countries`
VALUES (125, 'MO', 'Macau', 1, 0, '0.00', 0);
INSERT INTO `countries`
VALUES (126, 'MK', 'Macedonia', 1, 0, '0.00', 0);
INSERT INTO `countries`
VALUES (127, 'MG', 'Madagascar', 1, 0, '0.00', 0);
INSERT INTO `countries`
VALUES (128, 'MW', 'Malawi', 1, 0, '0.00', 0);
INSERT INTO `countries`
VALUES (129, 'MY', 'Malaysia', 1, 0, '0.00', 0);
INSERT INTO `countries`
VALUES (130, 'MV', 'Maldives', 1, 0, '0.00', 0);
INSERT INTO `countries`
VALUES (131, 'ML', 'Mali', 1, 0, '0.00', 0);
INSERT INTO `countries`
VALUES (132, 'MT', 'Malta', 1, 0, '0.00', 0);
INSERT INTO `countries`
VALUES (133, 'MH', 'Marshall Islands', 1, 0, '0.00', 0);
INSERT INTO `countries`
VALUES (134, 'MQ', 'Martinique', 1, 0, '0.00', 0);
INSERT INTO `countries`
VALUES (135, 'MR', 'Mauritania', 1, 0, '0.00', 0);
INSERT INTO `countries`
VALUES (136, 'MU', 'Mauritius', 1, 0, '0.00', 0);
INSERT INTO `countries`
VALUES (137, 'YT', 'Mayotte', 1, 0, '0.00', 0);
INSERT INTO `countries`
VALUES (138, 'MX', 'Mexico', 1, 0, '0.00', 0);
INSERT INTO `countries`
VALUES (139, 'FM', 'Micronesia', 1, 0, '0.00', 0);
INSERT INTO `countries`
VALUES (140, 'MD', 'Moldova, Republic of', 1, 0, '0.00', 0);
INSERT INTO `countries`
VALUES (141, 'MC', 'Monaco', 1, 0, '0.00', 0);
INSERT INTO `countries`
VALUES (142, 'MN', 'Mongolia', 1, 0, '0.00', 0);
INSERT INTO `countries`
VALUES (143, 'MS', 'Montserrat', 1, 0, '0.00', 0);
INSERT INTO `countries`
VALUES (144, 'MA', 'Morocco', 1, 0, '0.00', 0);
INSERT INTO `countries`
VALUES (145, 'MZ', 'Mozambique', 1, 0, '0.00', 0);
INSERT INTO `countries`
VALUES (146, 'MM', 'Myanmar', 1, 0, '0.00', 0);
INSERT INTO `countries`
VALUES (147, 'NA', 'Namibia', 1, 0, '0.00', 0);
INSERT INTO `countries`
VALUES (148, 'NR', 'Nauru', 1, 0, '0.00', 0);
INSERT INTO `countries`
VALUES (149, 'NP', 'Nepal', 1, 0, '0.00', 0);
INSERT INTO `countries`
VALUES (150, 'NL', 'Netherlands', 1, 0, '0.00', 0);
INSERT INTO `countries`
VALUES (151, 'AN', 'Netherlands Antilles', 1, 0, '0.00', 0);
INSERT INTO `countries`
VALUES (152, 'NC', 'New Caledonia', 1, 0, '0.00', 0);
INSERT INTO `countries`
VALUES (153, 'NZ', 'New Zealand', 1, 0, '0.00', 0);
INSERT INTO `countries`
VALUES (154, 'NI', 'Nicaragua', 1, 0, '0.00', 0);
INSERT INTO `countries`
VALUES (155, 'NE', 'Niger', 1, 0, '0.00', 0);
INSERT INTO `countries`
VALUES (156, 'NG', 'Nigeria', 1, 0, '0.00', 0);
INSERT INTO `countries`
VALUES (157, 'NU', 'Niue', 1, 0, '0.00', 0);
INSERT INTO `countries`
VALUES (158, 'NF', 'Norfolk Island', 1, 0, '0.00', 0);
INSERT INTO `countries`
VALUES (159, 'MP', 'Northern Mariana Islands', 1, 0, '0.00', 0);
INSERT INTO `countries`
VALUES (160, 'NO', 'Norway', 1, 0, '0.00', 0);
INSERT INTO `countries`
VALUES (161, 'OM', 'Oman', 1, 0, '0.00', 0);
INSERT INTO `countries`
VALUES (162, 'PK', 'Pakistan', 1, 0, '0.00', 0);
INSERT INTO `countries`
VALUES (163, 'PW', 'Palau', 1, 0, '0.00', 0);
INSERT INTO `countries`
VALUES (164, 'PA', 'Panama', 1, 0, '0.00', 0);
INSERT INTO `countries`
VALUES (165, 'PG', 'Papua New Guinea', 1, 0, '0.00', 0);
INSERT INTO `countries`
VALUES (166, 'PY', 'Paraguay', 1, 0, '0.00', 0);
INSERT INTO `countries`
VALUES (167, 'PE', 'Peru', 1, 0, '0.00', 0);
INSERT INTO `countries`
VALUES (168, 'PH', 'Philippines', 1, 0, '0.00', 0);
INSERT INTO `countries`
VALUES (169, 'PN', 'Pitcairn', 1, 0, '0.00', 0);
INSERT INTO `countries`
VALUES (170, 'PL', 'Poland', 1, 0, '0.00', 0);
INSERT INTO `countries`
VALUES (171, 'PT', 'Portugal', 1, 0, '0.00', 0);
INSERT INTO `countries`
VALUES (172, 'PR', 'Puerto Rico', 1, 0, '0.00', 0);
INSERT INTO `countries`
VALUES (173, 'QA', 'Qatar', 1, 0, '0.00', 0);
INSERT INTO `countries`
VALUES (174, 'RE', 'Reunion', 1, 0, '0.00', 0);
INSERT INTO `countries`
VALUES (175, 'RO', 'Romania', 1, 0, '0.00', 0);
INSERT INTO `countries`
VALUES (176, 'RU', 'Russian Federation', 1, 0, '0.00', 0);
INSERT INTO `countries`
VALUES (177, 'RW', 'Rwanda', 1, 0, '0.00', 0);
INSERT INTO `countries`
VALUES (178, 'LC', 'Saint Lucia', 1, 0, '0.00', 0);
INSERT INTO `countries`
VALUES (179, 'WS', 'Samoa', 1, 0, '0.00', 0);
INSERT INTO `countries`
VALUES (180, 'SM', 'San Marino', 1, 0, '0.00', 0);
INSERT INTO `countries`
VALUES (181, 'ST', 'Sao Tome and Principe', 1, 0, '0.00', 0);
INSERT INTO `countries`
VALUES (182, 'SA', 'Saudi Arabia', 1, 0, '0.00', 0);
INSERT INTO `countries`
VALUES (183, 'SN', 'Senegal', 1, 0, '0.00', 0);
INSERT INTO `countries`
VALUES (184, 'RS', 'Serbia', 1, 0, '0.00', 0);
INSERT INTO `countries`
VALUES (185, 'SC', 'Seychelles', 1, 0, '0.00', 0);
INSERT INTO `countries`
VALUES (186, 'SL', 'Sierra Leone', 1, 0, '0.00', 0);
INSERT INTO `countries`
VALUES (187, 'SG', 'Singapore', 1, 0, '0.00', 0);
INSERT INTO `countries`
VALUES (188, 'SK', 'Slovakia', 1, 0, '0.00', 0);
INSERT INTO `countries`
VALUES (189, 'SI', 'Slovenia', 1, 0, '0.00', 0);
INSERT INTO `countries`
VALUES (190, 'SB', 'Solomon Islands', 1, 0, '0.00', 0);
INSERT INTO `countries`
VALUES (191, 'SO', 'Somalia', 1, 0, '0.00', 0);
INSERT INTO `countries`
VALUES (192, 'ZA', 'South Africa', 1, 0, '0.00', 0);
INSERT INTO `countries`
VALUES (193, 'ES', 'Spain', 1, 0, '0.00', 0);
INSERT INTO `countries`
VALUES (194, 'LK', 'Sri Lanka', 1, 0, '0.00', 0);
INSERT INTO `countries`
VALUES (195, 'SH', 'St. Helena', 1, 0, '0.00', 0);
INSERT INTO `countries`
VALUES (196, 'KN', 'St. Kitts and Nevis', 1, 0, '0.00', 0);
INSERT INTO `countries`
VALUES (197, 'PM', 'St. Pierre and Miquelon', 1, 0, '0.00', 0);
INSERT INTO `countries`
VALUES (198, 'VC', 'St. Vincent and the Grenadines', 1, 0, '0.00', 0);
INSERT INTO `countries`
VALUES (199, 'SD', 'Sudan', 1, 0, '0.00', 0);
INSERT INTO `countries`
VALUES (200, 'SR', 'Suriname', 1, 0, '0.00', 0);
INSERT INTO `countries`
VALUES (201, 'SJ', 'Svalbard and Jan Mayen Islands', 1, 0, '0.00', 0);
INSERT INTO `countries`
VALUES (202, 'SZ', 'Swaziland', 1, 0, '0.00', 0);
INSERT INTO `countries`
VALUES (203, 'SE', 'Sweden', 1, 0, '0.00', 0);
INSERT INTO `countries`
VALUES (204, 'CH', 'Switzerland', 1, 0, '0.00', 0);
INSERT INTO `countries`
VALUES (205, 'SY', 'Syrian Arab Republic', 1, 0, '0.00', 0);
INSERT INTO `countries`
VALUES (206, 'TW', 'Taiwan', 1, 0, '0.00', 0);
INSERT INTO `countries`
VALUES (207, 'TJ', 'Tajikistan', 1, 0, '0.00', 0);
INSERT INTO `countries`
VALUES (208, 'TZ', 'Tanzania, United Republic of', 1, 0, '0.00', 0);
INSERT INTO `countries`
VALUES (209, 'TH', 'Thailand', 1, 0, '0.00', 0);
INSERT INTO `countries`
VALUES (210, 'TG', 'Togo', 1, 0, '0.00', 0);
INSERT INTO `countries`
VALUES (211, 'TK', 'Tokelau', 1, 0, '0.00', 0);
INSERT INTO `countries`
VALUES (212, 'TO', 'Tonga', 1, 0, '0.00', 0);
INSERT INTO `countries`
VALUES (213, 'TT', 'Trinidad and Tobago', 1, 0, '0.00', 0);
INSERT INTO `countries`
VALUES (214, 'TN', 'Tunisia', 1, 0, '0.00', 0);
INSERT INTO `countries`
VALUES (215, 'TR', 'Turkey', 1, 0, '0.00', 0);
INSERT INTO `countries`
VALUES (216, 'TM', 'Turkmenistan', 1, 0, '0.00', 0);
INSERT INTO `countries`
VALUES (217, 'TC', 'Turks and Caicos Islands', 1, 0, '0.00', 0);
INSERT INTO `countries`
VALUES (218, 'TV', 'Tuvalu', 1, 0, '0.00', 0);
INSERT INTO `countries`
VALUES (219, 'UG', 'Uganda', 1, 0, '0.00', 0);
INSERT INTO `countries`
VALUES (220, 'UA', 'Ukraine', 1, 0, '0.00', 0);
INSERT INTO `countries`
VALUES (221, 'AE', 'United Arab Emirates', 1, 0, '0.00', 0);
INSERT INTO `countries`
VALUES (222, 'GB', 'United Kingdom (GB)', 1, 0, '23.50', 999);
INSERT INTO `countries`
VALUES (224, 'US', 'United States', 1, 0, '7.50', 998);
INSERT INTO `countries`
VALUES (225, 'VI', 'United States Virgin Islands', 1, 0, '0.00', 0);
INSERT INTO `countries`
VALUES (226, 'UY', 'Uruguay', 1, 0, '0.00', 0);
INSERT INTO `countries`
VALUES (227, 'UZ', 'Uzbekistan', 1, 0, '0.00', 0);
INSERT INTO `countries`
VALUES (228, 'VU', 'Vanuatu', 1, 0, '0.00', 0);
INSERT INTO `countries`
VALUES (229, 'VA', 'Vatican City State', 1, 0, '0.00', 0);
INSERT INTO `countries`
VALUES (230, 'VE', 'Venezuela', 1, 0, '0.00', 0);
INSERT INTO `countries`
VALUES (231, 'VN', 'Vietnam', 1, 0, '0.00', 0);
INSERT INTO `countries`
VALUES (232, 'WF', 'Wallis And Futuna Islands', 1, 0, '0.00', 0);
INSERT INTO `countries`
VALUES (233, 'EH', 'Western Sahara', 1, 0, '0.00', 0);
INSERT INTO `countries`
VALUES (234, 'YE', 'Yemen', 1, 0, '0.00', 0);
INSERT INTO `countries`
VALUES (235, 'ZR', 'Zaire', 1, 0, '0.00', 0);
INSERT INTO `countries`
VALUES (236, 'ZM', 'Zambia', 1, 0, '0.00', 0);
INSERT INTO `countries`
VALUES (237, 'ZW', 'Zimbabwe', 1, 0, '0.00', 0);

--
-- Table structure for table `coupons`
--

DROP TABLE IF EXISTS `coupons`;
CREATE TABLE IF NOT EXISTS `coupons` (
  `id` int(1) UNSIGNED NOT NULL AUTO_INCREMENT,
  `title` varchar(100) NOT NULL,
  `code` varchar(30) NOT NULL,
  `discount` smallint(2) UNSIGNED NOT NULL DEFAULT '0',
  `type` varchar(1) NOT NULL DEFAULT 'p',
  `minval` decimal(12, 2) UNSIGNED NOT NULL DEFAULT '0.00',
  `validuntil` date DEFAULT NULL,
  `created` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `active` tinyint(1) UNSIGNED NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
  ) ENGINE = MyISAM DEFAULT CHARSET = utf8mb4;

--
-- Table structure for table `cronjobs`
--

DROP TABLE IF EXISTS `cronjobs`;
CREATE TABLE IF NOT EXISTS `cronjobs` (
  `id` int(11) UNSIGNED NOT NULL AUTO_INCREMENT,
  `user_id` int(11) UNSIGNED NOT NULL DEFAULT '0',
  `membership_id` int(11) UNSIGNED NOT NULL DEFAULT '0',
  `stripe_customer` varchar(60) NOT NULL,
  `stripe_pm` varchar(80) NOT NULL,
  `amount` decimal(10, 2) UNSIGNED NOT NULL DEFAULT '0.00',
  `created` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `renewal` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_user_id` (`user_id`),
  KEY `idx_membership_id` (`membership_id`)
  ) ENGINE = MyISAM DEFAULT CHARSET = utf8mb4;

--
-- Table structure for table `custom_fields`
--

DROP TABLE IF EXISTS `custom_fields`;
CREATE TABLE IF NOT EXISTS `custom_fields` (
  `id` int(6) UNSIGNED NOT NULL AUTO_INCREMENT,
  `title` varchar(60) NOT NULL,
  `tooltip` varchar(100) DEFAULT NULL,
  `name` varchar(20) NOT NULL,
  `required` tinyint(1) UNSIGNED NOT NULL DEFAULT '0',
  `section` varchar(30) DEFAULT NULL,
  `sorting` int(4) UNSIGNED NOT NULL DEFAULT '0',
  `active` tinyint(1) UNSIGNED NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
  ) ENGINE = MyISAM DEFAULT CHARSET = utf8mb4;

--
-- Table structure for table `custom_fields_data`
--

DROP TABLE IF EXISTS `custom_fields_data`;
CREATE TABLE IF NOT EXISTS `custom_fields_data` (
  `id` int(11) UNSIGNED NOT NULL AUTO_INCREMENT,
  `user_id` int(11) UNSIGNED NOT NULL DEFAULT '0',
  `product_id` int(11) UNSIGNED NOT NULL DEFAULT '0',
  `field_id` int(11) UNSIGNED NOT NULL DEFAULT '0',
  `field_name` varchar(40) DEFAULT NULL,
  `field_value` varchar(100) DEFAULT NULL,
  `section` varchar(30) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_user` (`user_id`),
  KEY `idx_field` (`field_id`)
  ) ENGINE = MyISAM DEFAULT CHARSET = utf8mb4;

--
-- Table structure for table `email_templates`
--

DROP TABLE IF EXISTS `email_templates`;
CREATE TABLE IF NOT EXISTS `email_templates` (
  `id` int(5) UNSIGNED NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `subject` varchar(150) NOT NULL,
  `help` tinytext,
  `body` text NOT NULL,
  `type` enum ('news','mailer') DEFAULT 'mailer',
  `typeid` varchar(30) DEFAULT NULL,
  PRIMARY KEY (`id`)
  ) ENGINE = MyISAM DEFAULT CHARSET = utf8mb4;

--
-- Dumping data for table `email_templates`
--

INSERT INTO `email_templates`
VALUES (1, 'Registration Email', 'Please verify your email', 'This template is used to send Registration Verification Email, when Configuration->Registration Verification is set to YES', '<div id=\"#kt_app_body_content\" style=\"background-color:#D5D9E2; font-family:Arial,Helvetica,sans-serif; line-height: 1.5; min-height: 100%; font-weight: normal; font-size: 15px; color: #2F3044; margin:0; padding:0; width:100%;\">\r\n  <div style=\"background-color:#ffffff; padding: 45px 0 34px 0; border-radius: 24px; margin:40px auto; max-width: 600px;\">\r\n    <table style=\"border-collapse:collapse\" width=\"100%\" height=\"auto\" cellspacing=\"0\" cellpadding=\"0\" border=\"0\" align=\"center\">\r\n      <tbody>\r\n        <tr>\r\n          <td style=\"text-align:center; padding-bottom: 10px\" valign=\"center\" align=\"center\"><div style=\"text-align:center; margin:0 15px 34px 15px\">\r\n              <div style=\"margin-bottom: 10px\">\r\n                <a href=\"[SITEURL]\" rel=\"noopener\" target=\"_blank\">\r\n                <img alt=\"Logo\" src=\"[SITEURL]/uploads/[LOGO]\" style=\"height: 32px\" data-image=\"e036b6jq8u1u\">\r\n                </a>\r\n              </div>\r\n              <div style=\"margin-bottom: 15px\">\r\n                <img alt=\"image\" src=\"[SITEURL]/assets/email/email_welcome.svg\" style=\"width:170px\" data-image=\"4q0ezesrmapj\">\r\n              </div>\r\n              <div style=\"font-size: 14px; font-weight: 500; margin-bottom: 27px; font-family:Arial,Helvetica,sans-serif;\">\r\n                <p style=\"margin-bottom:9px; color:#181C32; font-size: 22px; font-weight:700\">Hey [NAME], thanks for signing up!</p>\r\n                <p style=\"background: #EFF8FF; border-radius: 12px; padding:14px\">The administrator of this site has requested all new accounts to be activated by the users who created them thus your account is currently inactive. To activate your account, please visit the link below.</p>\r\n                <p style=\"margin-bottom:2px; color:#7E8299\">Here are your login details. Please keep them in a safe place</p>\r\n                <p style=\"margin-bottom:2px; color:#7E8299\">Username: [USERNAME] </p>\r\n                <p style=\"margin-bottom:2px; color:#7E8299\">Password: [PASSWORD] </p>\r\n              </div>\r\n              <a href=\"[LINK]\" target=\"_blank\" style=\"background-color:#2196F3; border-radius:6px;display:inline-block; padding:11px 19px; color: #FFFFFF; font-size: 14px; font-weight:500;\">Activate your account</a>\r\n            </div></td>\r\n        </tr>\r\n        <tr>\r\n          <td style=\"font-size: 13px; text-align:center; padding: 0 10px 10px 10px; font-weight: 500; color: #A1A5B7; font-family:Arial,Helvetica,sans-serif\" valign=\"center\" align=\"center\"><p style=\"color:#181C32; font-size: 16px; font-weight: 600; margin-bottom:9px\">Stay in touch</p>\r\n<p style=\"margin-bottom:4px\">You may reach us at\r\n              <a href=\"[SITEURL]\" rel=\"noopener\" target=\"_blank\" style=\"font-weight: 600\"> [SITE_NAME]</a>\r\n            </p>\r\n<p>We serve Mon-Fri, 9AM-18AM</p></td>\r\n        </tr>\r\n        <tr>\r\n          <td style=\"text-align:center; padding-bottom: 20px;\" valign=\"center\" align=\"center\"><a href=\"mailto:[CEMAIL]\" style=\"margin-right:10px\"><img alt=\"Logo\" src=\"[SITEURL]/assets/email/icon-email.svg\" style=\"width:24px\" data-image=\"3f06iim5p7u3\"></a>\r\n<a href=\"https://facebook.com/[FB]\" style=\"margin-right:10px\"><img alt=\"Logo\" src=\"[SITEURL]/assets/email/icon-facebook.svg\" style=\"width:24px\" data-image=\"ger80dm1r3v7\"></a>\r\n<a href=\"https://twitter.com/[TW]\"><img alt=\"Logo\" src=\"[SITEURL]/assets/email/icon-twitter.svg\" style=\"width:24px\" data-image=\"5zmro5phptef\"></a></td>\r\n        </tr>\r\n        <tr>\r\n          <td style=\"font-size: 13px; padding:0 15px; text-align:center; font-weight: 500; color: #A1A5B7;font-family:Arial,Helvetica,sans-serif\" valign=\"center\" align=\"center\"><p> The information above is gathered from the user input. © Copyright [DATE] [COMPANY]. All rights reserved.</p></td>\r\n        </tr>\r\n      </tbody>\r\n    </table>\r\n  </div>\r\n</div>', 'mailer', 'regMail');
INSERT INTO `email_templates`
VALUES (2, 'Welcome Mail From Admin', 'You have been registered', 'This template is used to send welcome email, when user is added by administrator', '<div id=\"#kt_app_body_content\" style=\"background-color:#D5D9E2; font-family:Arial,Helvetica,sans-serif; line-height: 1.5; min-height: 100%; font-weight: normal; font-size: 15px; color: #2F3044; margin:0; padding:0; width:100%;\">\r\n  <div style=\"background-color:#ffffff; padding: 45px 0 34px 0; border-radius: 24px; margin:40px auto; max-width: 600px;\">\r\n    <table style=\"border-collapse:collapse\" width=\"100%\" height=\"auto\" cellspacing=\"0\" cellpadding=\"0\" border=\"0\" align=\"center\">\r\n      <tbody>\r\n        <tr>\r\n          <td style=\"text-align:center; padding-bottom: 10px\" valign=\"center\" align=\"center\"><div style=\"text-align:center; margin:0 15px 34px 15px\">\r\n              <div style=\"margin-bottom: 10px\">\r\n                <a href=\"[SITEURL]\" rel=\"noopener\" target=\"_blank\">\r\n                <img alt=\"Logo\" src=\"[SITEURL]/uploads/[LOGO]\" style=\"height: 32px\" data-image=\"nx5t5w9hxjjw\">\r\n                </a>\r\n              </div>\r\n              <div style=\"margin-bottom: 15px\">\r\n                <img alt=\"image\" src=\"[SITEURL]/assets/email/email_welcome.svg\" style=\"width:170px\" data-image=\"tdillwcpct3m\">\r\n              </div>\r\n              <div style=\"font-size: 14px; font-weight: 500; margin-bottom: 27px; font-family:Arial,Helvetica,sans-serif;\">\r\n                <p style=\"margin-bottom:9px; color:#181C32; font-size: 22px; font-weight:700\">Hey [NAME]</p>\r\n                <p style=\"margin-bottom:2px; color:#7E8299\">You\'re now a member of [SITE_NAME].</p>\r\n                <p style=\"margin-bottom:2px; color:#7E8299\">Here are your login details. Please keep them in a safe place</p>\r\n                <p style=\"margin-bottom:2px; color:#7E8299\">Username: [USERNAME] </p>\r\n                <p style=\"margin-bottom:2px; color:#7E8299\">Password: [PASSWORD] </p>\r\n              </div>\r\n              <a href=\"[LINK]\" target=\"_blank\" style=\"background-color:#2196F3; border-radius:6px;display:inline-block; padding:11px 19px; color: #FFFFFF; font-size: 14px; font-weight:500;\"> Go to login</a>\r\n            </div></td>\r\n        </tr>\r\n        <tr>\r\n          <td style=\"font-size: 13px; text-align:center; padding: 0 10px 10px 10px; font-weight: 500; color: #A1A5B7; font-family:Arial,Helvetica,sans-serif\" valign=\"center\" align=\"center\"><p style=\"color:#181C32; font-size: 16px; font-weight: 600; margin-bottom:9px\">Stay in touch</p>\r\n<p style=\"margin-bottom:4px\">You may reach us at\r\n              <a href=\"[SITEURL]\" rel=\"noopener\" target=\"_blank\" style=\"font-weight: 600\"> [SITE_NAME]</a>\r\n            </p>\r\n<p>We serve Mon-Fri, 9AM-18AM</p></td>\r\n        </tr>\r\n        <tr>\r\n          <td style=\"text-align:center; padding-bottom: 20px;\" valign=\"center\" align=\"center\"><a href=\"mailto:[CEMAIL]\" style=\"margin-right:10px\"><img alt=\"Logo\" src=\"[SITEURL]/assets/email/icon-email.svg\" style=\"width:24px\" data-image=\"nhnhstrwuw40\"></a>\r\n<a href=\"https://facebook.com/[FB]\" style=\"margin-right:10px\"><img alt=\"Logo\" src=\"[SITEURL]/assets/email/icon-facebook.svg\" style=\"width:24px\" data-image=\"imaq57xdbyr5\"></a>\r\n<a href=\"https://twitter.com/[TW]\"><img alt=\"Logo\" src=\"[SITEURL]/assets/email/icon-twitter.svg\" style=\"width:24px\" data-image=\"icgjxbn8ed8f\"></a></td>\r\n        </tr>\r\n        <tr>\r\n          <td style=\"font-size: 13px; padding:0 15px; text-align:center; font-weight: 500; color: #A1A5B7;font-family:Arial,Helvetica,sans-serif\" valign=\"center\" align=\"center\"><p> The information above is gathered from the user input. © Copyright [DATE] [COMPANY]. All rights reserved.</p></td>\r\n        </tr>\r\n      </tbody>\r\n    </table>\r\n  </div>\r\n</div>', 'mailer', 'regMailAdmin');
INSERT INTO `email_templates`
VALUES (3, 'Default Newsletter', 'Newsletter', 'This is a default newsletter template', '<div id=\"#kt_app_body_content\" style=\"background-color:#D5D9E2; font-family:Arial,Helvetica,sans-serif; line-height: 1.5; min-height: 100%; font-weight: normal; font-size: 15px; color: #2F3044; margin:0; padding:0; width:100%;\">\r\n  <div style=\"background-color:#ffffff; padding: 45px 0 34px 0; border-radius: 24px; margin:40px auto; max-width: 600px;\">\r\n    <table style=\"border-collapse:collapse\" width=\"100%\" height=\"auto\" cellspacing=\"0\" cellpadding=\"0\" border=\"0\" align=\"center\">\r\n      <tbody>\r\n        <tr>\r\n          <td style=\"text-align:center; padding-bottom: 10px\" valign=\"center\" align=\"center\"><div style=\"text-align:center; margin:0 15px 34px 15px\">\r\n              <div style=\"margin-bottom: 10px\">\r\n                <a href=\"[SITEURL]\" rel=\"noopener\" target=\"_blank\">\r\n                <img alt=\"Logo\" src=\"[SITEURL]/uploads/[LOGO]\" style=\"height: 32px\" data-image=\"t3awwxkkek38\">\r\n                </a>\r\n              </div>\r\n              <div style=\"margin-bottom: 15px\">\r\n                <img alt=\"image\" src=\"[SITEURL]/assets/email/email_envelope.svg\" style=\"width:170px\" data-image=\"y21lpynr8eyi\">\r\n              </div>\r\n              <div style=\"font-size: 14px; font-weight: 500; margin-bottom: 27px; font-family:Arial,Helvetica,sans-serif;\">\r\n                <p style=\"margin-bottom:9px; color:#181C32; font-size: 22px; font-weight:700\">Hey [NAME]!</p>\r\n                <p style=\"margin-bottom:2px; color:#7E8299\">[ATTACHMENT] </p>\r\n              </div>\r\n              <div style=\"font-size: 14px; font-weight: 500; margin-bottom: 27px; font-family:Arial,Helvetica,sans-serif;text-align:left;\">Newsletter content goes here...  </div>\r\n            </div></td>\r\n        </tr>\r\n        <tr>\r\n          <td style=\"font-size: 13px; text-align:center; padding: 0 10px 10px 10px; font-weight: 500; color: #A1A5B7; font-family:Arial,Helvetica,sans-serif\" valign=\"center\" align=\"center\"><p style=\"color:#181C32; font-size: 16px; font-weight: 600; margin-bottom:9px\">Stay in touch</p>\r\n<p style=\"margin-bottom:4px\">You may reach us at\r\n              <a href=\"[SITEURL]\" rel=\"noopener\" target=\"_blank\" style=\"font-weight: 600\"> [SITE_NAME]</a>\r\n            </p>\r\n<p>We serve Mon-Fri, 9AM-18AM</p></td>\r\n        </tr>\r\n        <tr>\r\n          <td style=\"text-align:center; padding-bottom: 20px;\" valign=\"center\" align=\"center\"><a href=\"mailto:[CEMAIL]\" style=\"margin-right:10px\"><img alt=\"Logo\" src=\"[SITEURL]/assets/email/icon-email.svg\" style=\"width:24px\" data-image=\"o4y1qq9ya3u9\"></a>\r\n<a href=\"https://facebook.com/[FB]\" style=\"margin-right:10px\"><img alt=\"Logo\" src=\"[SITEURL]/assets/email/icon-facebook.svg\" style=\"width:24px\" data-image=\"5vic7v3epyz7\"></a>\r\n<a href=\"https://twitter.com/[TW]\"><img alt=\"Logo\" src=\"[SITEURL]/assets/email/icon-twitter.svg\" style=\"width:24px\" data-image=\"v4leysp717al\"></a></td>\r\n        </tr>\r\n        <tr>\r\n          <td style=\"font-size: 13px; padding:0 15px; text-align:center; font-weight: 500; color: #A1A5B7;font-family:Arial,Helvetica,sans-serif\" valign=\"center\" align=\"center\"><p> The information above is gathered from the user input. © Copyright [DATE] [COMPANY]. All rights reserved.</p></td>\r\n        </tr>\r\n      </tbody>\r\n    </table>\r\n  </div>\r\n</div>', 'mailer', 'newsletter');
INSERT INTO `email_templates`
VALUES (4, 'Single Email', 'Single User Email', 'This template is used to email single user', '<div id=\"#kt_app_body_content\" style=\"background-color:#D5D9E2; font-family:Arial,Helvetica,sans-serif; line-height: 1.5; min-height: 100%; font-weight: normal; font-size: 15px; color: #2F3044; margin:0; padding:0; width:100%;\">\r\n  <div style=\"background-color:#ffffff; padding: 45px 0 34px 0; border-radius: 24px; margin:40px auto; max-width: 600px;\">\r\n    <table style=\"border-collapse:collapse\" width=\"100%\" height=\"auto\" cellspacing=\"0\" cellpadding=\"0\" border=\"0\" align=\"center\">\r\n      <tbody>\r\n        <tr>\r\n          <td style=\"text-align:center; padding-bottom: 10px\" valign=\"center\" align=\"center\"><div style=\"text-align:center; margin:0 15px 34px 15px\">\r\n              <div style=\"margin-bottom: 10px\">\r\n                <a href=\"[SITEURL]\" rel=\"noopener\" target=\"_blank\">\r\n                <img alt=\"Logo\" src=\"[SITEURL]/uploads/[LOGO]\" style=\"height: 32px\" data-image=\"1nga2mnv0u9a\">\r\n                </a>\r\n              </div>\r\n              <div style=\"margin-bottom: 15px\">\r\n                <img alt=\"image\" src=\"[SITEURL]/assets/email/email_welcome.svg\" style=\"width:170px\" data-image=\"yz7ot90jjgsr\">\r\n              </div>\r\n              <div style=\"font-size: 14px; font-weight: 500; margin-bottom: 27px; font-family:Arial,Helvetica,sans-serif;\">\r\n                <p style=\"margin-bottom:9px; color:#181C32; font-size: 22px; font-weight:700\">Hey [NAME]</p>\r\n              </div>\r\n              <div style=\"font-size: 14px; font-weight: 500; margin-bottom: 27px; font-family:Arial,Helvetica,sans-serif;\"> Your message goes here... </div>\r\n            </div></td>\r\n        </tr>\r\n        <tr>\r\n          <td style=\"font-size: 13px; text-align:center; padding: 0 10px 10px 10px; font-weight: 500; color: #A1A5B7; font-family:Arial,Helvetica,sans-serif\" valign=\"center\" align=\"center\"><p style=\"color:#181C32; font-size: 16px; font-weight: 600; margin-bottom:9px\">Stay in touch</p>\r\n<p style=\"margin-bottom:4px\">You may reach us at\r\n              <a href=\"[SITEURL]\" rel=\"noopener\" target=\"_blank\" style=\"font-weight: 600\"> [SITE_NAME]</a>\r\n            </p>\r\n<p>We serve Mon-Fri, 9AM-18AM</p></td>\r\n        </tr>\r\n        <tr>\r\n          <td style=\"text-align:center; padding-bottom: 20px;\" valign=\"center\" align=\"center\"><a href=\"mailto:[CEMAIL]\" style=\"margin-right:10px\"><img alt=\"Logo\" src=\"[SITEURL]/assets/email/icon-email.svg\" style=\"width:24px\" data-image=\"o9qwfphwdsqc\"></a>\r\n<a href=\"https://facebook.com/[FB]\" style=\"margin-right:10px\"><img alt=\"Logo\" src=\"[SITEURL]/assets/email/icon-facebook.svg\" style=\"width:24px\" data-image=\"9rwzrav4kwxv\"></a>\r\n<a href=\"https://twitter.com/[TW]\"><img alt=\"Logo\" src=\"[SITEURL]/assets/email/icon-twitter.svg\" style=\"width:24px\" data-image=\"8s5vfq2ueb93\"></a></td>\r\n        </tr>\r\n        <tr>\r\n          <td style=\"font-size: 13px; padding:0 15px; text-align:center; font-weight: 500; color: #A1A5B7;font-family:Arial,Helvetica,sans-serif\" valign=\"center\" align=\"center\"><p> The information above is gathered from the user input. © Copyright [DATE] [COMPANY]. All rights reserved.</p></td>\r\n        </tr>\r\n      </tbody>\r\n    </table>\r\n  </div>\r\n</div>', 'mailer', 'singleMail');
INSERT INTO `email_templates`
VALUES (5, 'Forgot Password Admin', 'Password Reset', 'This template is used for retrieving lost admin password', '<div id=\"#kt_app_body_content\" style=\"background-color:#D5D9E2; font-family:Arial,Helvetica,sans-serif; line-height: 1.5; min-height: 100%; font-weight: normal; font-size: 15px; color: #2F3044; margin:0; padding:0; width:100%;\">\r\n  <div style=\"background-color:#ffffff; padding: 45px 0 34px 0; border-radius: 24px; margin:40px auto; max-width: 600px;\">\r\n    <table style=\"border-collapse:collapse\" width=\"100%\" height=\"auto\" cellspacing=\"0\" cellpadding=\"0\" border=\"0\" align=\"center\">\r\n      <tbody>\r\n        <tr>\r\n          <td style=\"text-align:center; padding-bottom: 10px\" valign=\"center\" align=\"center\"><div style=\"text-align:center; margin:0 15px 34px 15px\">\r\n              <div style=\"margin-bottom: 10px\">\r\n                <a href=\"[SITEURL]\" rel=\"noopener\" target=\"_blank\">\r\n                <img alt=\"Logo\" src=\"[SITEURL]/uploads/[LOGO]\" style=\"height: 32px\" data-image=\"k1zba5ll6zwg\">\r\n                </a>\r\n              </div>\r\n              <div style=\"margin-bottom: 15px\">\r\n                <img alt=\"image\" src=\"[SITEURL]/assets/email/email_password.svg\" style=\"width:170px\" data-image=\"w7w4byt2ycsc\">\r\n              </div>\r\n              <div style=\"font-size: 14px; font-weight: 500; margin-bottom: 27px; font-family:Arial,Helvetica,sans-serif;\">\r\n                <p style=\"margin-bottom:9px; color:#181C32; font-size: 22px; font-weight:700\">Hey [NAME]!</p>\r\n                <p style=\"margin-bottom:2px; color:#7E8299\">it seems that you or someone requested a new password for you. </p>\r\n				  <p style=\"margin-bottom:2px; color:#7E8299\">We have generated a new password, as requested. </p>\r\n              </div>\r\n              <a href=\"[LINK]\" target=\"_blank\" style=\"background-color:#2196F3; border-radius:6px;display:inline-block; padding:11px 19px; color: #FFFFFF; font-size: 14px; font-weight:500;\"> Go to password reset page</a>\r\n            </div></td>\r\n        </tr>\r\n        <tr>\r\n          <td style=\"font-size: 13px; text-align:center; padding: 0 10px 10px 10px; font-weight: 500; color: #A1A5B7; font-family:Arial,Helvetica,sans-serif\" valign=\"center\" align=\"center\"><p style=\"color:#181C32; font-size: 16px; font-weight: 600; margin-bottom:9px\">Stay in touch</p>\r\n<p style=\"margin-bottom:4px\">You may reach us at\r\n              <a href=\"[SITEURL]\" rel=\"noopener\" target=\"_blank\" style=\"font-weight: 600\"> [SITE_NAME]</a>\r\n            </p>\r\n<p>We serve Mon-Fri, 9AM-18AM</p></td>\r\n        </tr>\r\n        <tr>\r\n          <td style=\"text-align:center; padding-bottom: 20px;\" valign=\"center\" align=\"center\"><a href=\"mailto:[CEMAIL]\" style=\"margin-right:10px\"><img alt=\"Logo\" src=\"[SITEURL]/assets/email/icon-email.svg\" style=\"width:24px\" data-image=\"nbt21yllo1i5\"></a>\r\n<a href=\"https://facebook.com/[FB]\" style=\"margin-right:10px\"><img alt=\"Logo\" src=\"[SITEURL]/assets/email/icon-facebook.svg\" style=\"width:24px\" data-image=\"t5dq2gjz0vm2\"></a>\r\n<a href=\"https://twitter.com/[TW]\"><img alt=\"Logo\" src=\"[SITEURL]/assets/email/icon-twitter.svg\" style=\"width:24px\" data-image=\"od5705rjhb5w\"></a></td>\r\n        </tr>\r\n        <tr>\r\n          <td style=\"font-size: 13px; padding:0 15px; text-align:center; font-weight: 500; color: #A1A5B7;font-family:Arial,Helvetica,sans-serif\" valign=\"center\" align=\"center\"><p> The information above is gathered from the user input. © Copyright [DATE] [COMPANY]. All rights reserved.</p></td>\r\n        </tr>\r\n      </tbody>\r\n    </table>\r\n  </div>\r\n</div>', 'mailer', 'adminPassReset');
INSERT INTO `email_templates`
VALUES (6, 'Forgot Password User', 'Password Reset', 'This template is used for retrieving lost user password', '<div id=\"#kt_app_body_content\" style=\"background-color:#D5D9E2; font-family:Arial,Helvetica,sans-serif; line-height: 1.5; min-height: 100%; font-weight: normal; font-size: 15px; color: #2F3044; margin:0; padding:0; width:100%;\">\r\n  <div style=\"background-color:#ffffff; padding: 45px 0 34px 0; border-radius: 24px; margin:40px auto; max-width: 600px;\">\r\n    <table style=\"border-collapse:collapse\" width=\"100%\" height=\"auto\" cellspacing=\"0\" cellpadding=\"0\" border=\"0\" align=\"center\">\r\n      <tbody>\r\n        <tr>\r\n          <td style=\"text-align:center; padding-bottom: 10px\" valign=\"center\" align=\"center\"><div style=\"text-align:center; margin:0 15px 34px 15px\">\r\n              <div style=\"margin-bottom: 10px\">\r\n                <a href=\"[SITEURL]\" rel=\"noopener\" target=\"_blank\">\r\n                <img alt=\"Logo\" src=\"[SITEURL]/uploads/[LOGO]\" style=\"height: 32px\" data-image=\"cuabtjclmfqw\">\r\n                </a>\r\n              </div>\r\n              <div style=\"margin-bottom: 15px\">\r\n                <img alt=\"image\" src=\"[SITEURL]/assets/email/email_password.svg\" style=\"width:170px\" data-image=\"th79hxnb3ati\">\r\n              </div>\r\n              <div style=\"font-size: 14px; font-weight: 500; margin-bottom: 27px; font-family:Arial,Helvetica,sans-serif;\">\r\n                <p style=\"margin-bottom:9px; color:#181C32; font-size: 22px; font-weight:700\">Hey [NAME]!</p>\r\n                <p style=\"margin-bottom:2px; color:#7E8299\">it seems that you or someone requested a new password for you. </p>\r\n				  <p style=\"margin-bottom:2px; color:#7E8299\">We have generated a new password, as requested. </p>\r\n              </div>\r\n              <a href=\"[LINK]\" target=\"_blank\" style=\"background-color:#2196F3; border-radius:6px;display:inline-block; padding:11px 19px; color: #FFFFFF; font-size: 14px; font-weight:500;\"> Go to password reset page</a>\r\n            </div></td>\r\n        </tr>\r\n        <tr>\r\n          <td style=\"font-size: 13px; text-align:center; padding: 0 10px 10px 10px; font-weight: 500; color: #A1A5B7; font-family:Arial,Helvetica,sans-serif\" valign=\"center\" align=\"center\"><p style=\"color:#181C32; font-size: 16px; font-weight: 600; margin-bottom:9px\">Stay in touch</p>\r\n<p style=\"margin-bottom:4px\">You may reach us at\r\n              <a href=\"[SITEURL]\" rel=\"noopener\" target=\"_blank\" style=\"font-weight: 600\"> [SITE_NAME]</a>\r\n            </p>\r\n<p>We serve Mon-Fri, 9AM-18AM</p></td>\r\n        </tr>\r\n        <tr>\r\n          <td style=\"text-align:center; padding-bottom: 20px;\" valign=\"center\" align=\"center\"><a href=\"mailto:[CEMAIL]\" style=\"margin-right:10px\"><img alt=\"Logo\" src=\"[SITEURL]/assets/email/icon-email.svg\" style=\"width:24px\" data-image=\"dug5xsfwxhzo\"></a>\r\n<a href=\"https://facebook.com/[FB]\" style=\"margin-right:10px\"><img alt=\"Logo\" src=\"[SITEURL]/assets/email/icon-facebook.svg\" style=\"width:24px\" data-image=\"ilyvv0fxmi4d\"></a>\r\n<a href=\"https://twitter.com/[TW]\"><img alt=\"Logo\" src=\"[SITEURL]/assets/email/icon-twitter.svg\" style=\"width:24px\" data-image=\"ebgqwv983ozo\"></a></td>\r\n        </tr>\r\n        <tr>\r\n          <td style=\"font-size: 13px; padding:0 15px; text-align:center; font-weight: 500; color: #A1A5B7;font-family:Arial,Helvetica,sans-serif\" valign=\"center\" align=\"center\"><p> The information above is gathered from the user input. © Copyright [DATE] [COMPANY]. All rights reserved.</p></td>\r\n        </tr>\r\n      </tbody>\r\n    </table>\r\n  </div>\r\n</div>', 'mailer', 'userPassReset');
INSERT INTO `email_templates`
VALUES (7, 'Welcome Email', 'Welcome', 'This template is used to welcome newly registered user when Configuration->Registration Verification and Configuration->Auto Registration are both set to YES', '<div id=\"#kt_app_body_content\" style=\"background-color:#D5D9E2; font-family:Arial,Helvetica,sans-serif; line-height: 1.5; min-height: 100%; font-weight: normal; font-size: 15px; color: #2F3044; margin:0; padding:0; width:100%;\">\r\n  <div style=\"background-color:#ffffff; padding: 45px 0 34px 0; border-radius: 24px; margin:40px auto; max-width: 600px;\">\r\n    <table style=\"border-collapse:collapse\" width=\"100%\" height=\"auto\" cellspacing=\"0\" cellpadding=\"0\" border=\"0\" align=\"center\">\r\n      <tbody>\r\n        <tr>\r\n          <td style=\"text-align:center; padding-bottom: 10px\" valign=\"center\" align=\"center\"><div style=\"text-align:center; margin:0 15px 34px 15px\">\r\n              <div style=\"margin-bottom: 10px\">\r\n                <a href=\"[SITEURL]\" rel=\"noopener\" target=\"_blank\">\r\n                <img alt=\"Logo\" src=\"[SITEURL]uploads/[LOGO]\" style=\"height: 32px\" data-image=\"nx5t5w9hxjjw\">\r\n                </a>\r\n              </div>\r\n              <div style=\"margin-bottom: 15px\">\r\n                <img alt=\"image\" src=\"[SITEURL]/assets/email/email_welcome.svg\" style=\"width:170px\" data-image=\"tdillwcpct3m\">\r\n              </div>\r\n              <div style=\"font-size: 14px; font-weight: 500; margin-bottom: 27px; font-family:Arial,Helvetica,sans-serif;\">\r\n                <p style=\"margin-bottom:9px; color:#181C32; font-size: 22px; font-weight:700\">Hey [NAME], thanks for signing up!</p>\r\n                <p style=\"margin-bottom:2px; color:#7E8299\">You\'re now a member of [SITE_NAME].</p>\r\n                <p style=\"margin-bottom:2px; color:#7E8299\">Here are your login details. Please keep them in a safe place</p>\r\n                <p style=\"margin-bottom:2px; color:#7E8299\">Username: [USERNAME] </p>\r\n                <p style=\"margin-bottom:2px; color:#7E8299\">Password: [PASSWORD] </p>\r\n              </div>\r\n              <a href=\"[LINK]\" target=\"_blank\" style=\"background-color:#2196F3; border-radius:6px;display:inline-block; padding:11px 19px; color: #FFFFFF; font-size: 14px; font-weight:500;\"> Go to login</a>\r\n            </div></td>\r\n        </tr>\r\n        <tr>\r\n          <td style=\"font-size: 13px; text-align:center; padding: 0 10px 10px 10px; font-weight: 500; color: #A1A5B7; font-family:Arial,Helvetica,sans-serif\" valign=\"center\" align=\"center\"><p style=\"color:#181C32; font-size: 16px; font-weight: 600; margin-bottom:9px\">Stay in touch</p>\r\n<p style=\"margin-bottom:4px\">You may reach us at\r\n              <a href=\"[SITEURL]\" rel=\"noopener\" target=\"_blank\" style=\"font-weight: 600\"> [SITE_NAME]</a>\r\n            </p>\r\n<p>We serve Mon-Fri, 9AM-18AM</p></td>\r\n        </tr>\r\n        <tr>\r\n          <td style=\"text-align:center; padding-bottom: 20px;\" valign=\"center\" align=\"center\"><a href=\"mailto:[CEMAIL]\" style=\"margin-right:10px\"><img alt=\"Logo\" src=\"[SITEURL]/assets/email/icon-email.svg\" style=\"width:24px\" data-image=\"nhnhstrwuw40\"></a>\r\n<a href=\"https://facebook.com/[FB]\" style=\"margin-right:10px\"><img alt=\"Logo\" src=\"[SITEURL]/assets/email/icon-facebook.svg\" style=\"width:24px\" data-image=\"imaq57xdbyr5\"></a>\r\n<a href=\"https://twitter.com/[TW]\"><img alt=\"Logo\" src=\"[SITEURL]/assets/email/icon-twitter.svg\" style=\"width:24px\" data-image=\"icgjxbn8ed8f\"></a></td>\r\n        </tr>\r\n        <tr>\r\n          <td style=\"font-size: 13px; padding:0 15px; text-align:center; font-weight: 500; color: #A1A5B7;font-family:Arial,Helvetica,sans-serif\" valign=\"center\" align=\"center\"><p> The information above is gathered from the user input. © Copyright [DATE] [COMPANY]. All rights reserved.</p></td>\r\n        </tr>\r\n      </tbody>\r\n    </table>\r\n  </div>\r\n</div>', 'mailer', 'welcomeEmail');
INSERT INTO `email_templates`
VALUES (8, 'Registration Pending', 'Registration Verification Pending', 'This template is used to send Registration Verification Email, when Configuration->Auto Registration is set to NO', '<div id=\"#kt_app_body_content\" style=\"background-color:#D5D9E2; font-family:Arial,Helvetica,sans-serif; line-height: 1.5; min-height: 100%; font-weight: normal; font-size: 15px; color: #2F3044; margin:0; padding:0; width:100%;\">\r\n  <div style=\"background-color:#ffffff; padding: 45px 0 34px 0; border-radius: 24px; margin:40px auto; max-width: 600px;\">\r\n    <table style=\"border-collapse:collapse\" width=\"100%\" height=\"auto\" cellspacing=\"0\" cellpadding=\"0\" border=\"0\" align=\"center\">\r\n      <tbody>\r\n        <tr>\r\n          <td style=\"text-align:center; padding-bottom: 10px\" valign=\"center\" align=\"center\"><div style=\"text-align:center; margin:0 15px 34px 15px\">\r\n              <div style=\"margin-bottom: 10px\">\r\n                <a href=\"[SITEURL]\" rel=\"noopener\" target=\"_blank\">\r\n                <img alt=\"Logo\" src=\"[SITEURL]/uploads/[LOGO]\" style=\"height: 32px\" data-image=\"k374krla5wrr\">\r\n                </a>\r\n              </div>\r\n              <div style=\"margin-bottom: 15px\">\r\n                <img alt=\"image\" src=\"[SITEURL]/assets/email/email_welcome.svg\" style=\"width:170px\" data-image=\"qra15dri8k2f\">\r\n              </div>\r\n              <div style=\"font-size: 14px; font-weight: 500; margin-bottom: 27px; font-family:Arial,Helvetica,sans-serif;\">\r\n                <p style=\"margin-bottom:9px; color:#181C32; font-size: 22px; font-weight:700\">Hey [NAME], thanks for signing up!</p>\r\n                <p style=\"background: #EFF8FF; border-radius: 12px; padding:14px\">The administrator of this site has requested all new accounts to be activated manually. Your account is currently pending verification process. You will be notify once its activated.</p>\r\n                <p style=\"margin-bottom:2px; color:#7E8299\">Here are your login details. Please keep them in a safe place</p>\r\n                <p style=\"margin-bottom:2px; color:#7E8299\">Username: [USERNAME] </p>\r\n                <p style=\"margin-bottom:2px; color:#7E8299\">Password: [PASSWORD] </p>\r\n              </div>\r\n            </div></td>\r\n        </tr>\r\n        <tr>\r\n          <td style=\"font-size: 13px; text-align:center; padding: 0 10px 10px 10px; font-weight: 500; color: #A1A5B7; font-family:Arial,Helvetica,sans-serif\" valign=\"center\" align=\"center\"><p style=\"color:#181C32; font-size: 16px; font-weight: 600; margin-bottom:9px\">Stay in touch</p>\r\n<p style=\"margin-bottom:4px\">You may reach us at\r\n              <a href=\"[SITEURL]\" rel=\"noopener\" target=\"_blank\" style=\"font-weight: 600\"> [SITE_NAME]</a>\r\n            </p>\r\n<p>We serve Mon-Fri, 9AM-18AM</p></td>\r\n        </tr>\r\n        <tr>\r\n          <td style=\"text-align:center; padding-bottom: 20px;\" valign=\"center\" align=\"center\"><a href=\"mailto:[CEMAIL]\"><img alt=\"Logo\" src=\"[SITEURL]/assets/email/icon-email.svg\" style=\"width:24px\" data-image=\"rts6uvekmpb1\"></a>\r\n<a href=\"https://facebook.com/[FB]\"><img alt=\"Logo\" src=\"[SITEURL]/assets/email/icon-facebook.svg\" style=\"width:24px\" data-image=\"e6p1ivhp3ujq\"></a>\r\n<a href=\"https://twitter.com/[TW]\"><img alt=\"Logo\" src=\"[SITEURL]/assets/email/icon-twitter.svg\" style=\"width:24px\" data-image=\"yow3f4jrns6h\"></a></td>\r\n        </tr>\r\n        <tr>\r\n          <td style=\"font-size: 13px; padding:0 15px; text-align:center; font-weight: 500; color: #A1A5B7;font-family:Arial,Helvetica,sans-serif\" valign=\"center\" align=\"center\"><p> The information above is gathered from the user input. © Copyright [DATE] [COMPANY]. All rights reserved.</p></td>\r\n        </tr>\r\n      </tbody>\r\n    </table>\r\n  </div>\r\n</div>', 'mailer', 'regMailPending');
INSERT INTO `email_templates`
VALUES (9, 'Notify Admin', 'New User Registration', 'This template is used to notify admin of new registration when Configuration->Registration Notification is set to YES', '<div id=\"#kt_app_body_content\" style=\"background-color:#D5D9E2; font-family:Arial,Helvetica,sans-serif; line-height: 1.5; min-height: 100%; font-weight: normal; font-size: 15px; color: #2F3044; margin:0; padding:0; width:100%;\">\r\n  <div style=\"background-color:#ffffff; padding: 45px 0 34px 0; border-radius: 24px; margin:40px auto; max-width: 600px;\">\r\n    <table style=\"border-collapse:collapse\" width=\"100%\" height=\"auto\" cellspacing=\"0\" cellpadding=\"0\" border=\"0\" align=\"center\">\r\n      <tbody>\r\n        <tr>\r\n          <td style=\"text-align:center; padding-bottom: 10px\" valign=\"center\" align=\"center\"><div style=\"text-align:center; margin:0 15px 34px 15px\">\r\n              <div style=\"margin-bottom: 10px\">\r\n                <a href=\"[SITEURL]\" rel=\"noopener\" target=\"_blank\">\r\n                <img alt=\"Logo\" src=\"[SITEURL]/uploads/[LOGO]\" style=\"height: 32px\" data-image=\"xf2oy38egsxw\">\r\n                </a>\r\n              </div>\r\n              <div style=\"margin-bottom: 15px\">\r\n                <img alt=\"image\" src=\"[SITEURL]/assets/email/email_user.svg\" style=\"width:170px\" data-image=\"stbk9ea9r33z\">\r\n              </div>\r\n              <div style=\"font-size: 14px; font-weight: 500; margin-bottom: 27px; font-family:Arial,Helvetica,sans-serif;\">\r\n                <p style=\"margin-bottom:9px; color:#181C32; font-size: 22px; font-weight:700\">Hey Admin!</p>\r\n                <p style=\"margin-bottom:2px; color:#7E8299\">You have a new user registration. </p>\r\n				<p style=\"margin-bottom:2px; color:#7E8299\">You can login into your admin panel to view details:</p>\r\n              </div>\r\n              <div style=\"font-size: 14px; font-weight: 500; margin-bottom: 27px; font-family:Arial,Helvetica,sans-serif;text-align:left\">\r\n                <p style=\"margin-bottom:2px; color:#7E8299\">Email: [EMAIL]</p>\r\n                <p style=\"margin-bottom:2px; color:#7E8299\">Name: [NAME] </p>\r\n                <p style=\"margin-bottom:2px; color:#7E8299\">IP: [IP]</p>\r\n              </div>\r\n            </div></td>\r\n        </tr>\r\n        <tr>\r\n          <td style=\"font-size: 13px; text-align:center; padding: 0 10px 10px 10px; font-weight: 500; color: #A1A5B7; font-family:Arial,Helvetica,sans-serif\" valign=\"center\" align=\"center\"><p style=\"color:#181C32; font-size: 16px; font-weight: 600; margin-bottom:9px\">Stay in touch</p>\r\n<p style=\"margin-bottom:4px\">You may reach us at\r\n              <a href=\"[SITEURL]\" rel=\"noopener\" target=\"_blank\" style=\"font-weight: 600\"> [SITE_NAME]</a>\r\n            </p>\r\n<p>We serve Mon-Fri, 9AM-18AM</p></td>\r\n        </tr>\r\n        <tr>\r\n          <td style=\"text-align:center; padding-bottom: 20px;\" valign=\"center\" align=\"center\"><a href=\"mailto:[CEMAIL]\" style=\"margin-right:10px\"><img alt=\"Logo\" src=\"[SITEURL]/assets/email/icon-email.svg\" style=\"width:24px\" data-image=\"qvzy4b14h1mx\"></a>\r\n<a href=\"https://facebook.com/[FB]\" style=\"margin-right:10px\"><img alt=\"Logo\" src=\"[SITEURL]/assets/email/icon-facebook.svg\" style=\"width:24px\" data-image=\"2wlhqz3dz3be\"></a>\r\n<a href=\"https://twitter.com/[TW]\"><img alt=\"Logo\" src=\"[SITEURL]/assets/email/icon-twitter.svg\" style=\"width:24px\" data-image=\"oj7fgnvph7jm\"></a></td>\r\n        </tr>\r\n        <tr>\r\n          <td style=\"font-size: 13px; padding:0 15px; text-align:center; font-weight: 500; color: #A1A5B7;font-family:Arial,Helvetica,sans-serif\" valign=\"center\" align=\"center\"><p> The information above is gathered from the user input. © Copyright [DATE] [COMPANY]. All rights reserved.</p></td>\r\n        </tr>\r\n      </tbody>\r\n    </table>\r\n  </div>\r\n</div>', 'mailer', 'notifyAdmin');
INSERT INTO `email_templates`
VALUES (10, 'Contact Request', 'Contact Inquiry', 'This template is used to send default Contact Request Form', '<div id=\"#kt_app_body_content\" style=\"background-color:#D5D9E2; font-family:Arial,Helvetica,sans-serif; line-height: 1.5; min-height: 100%; font-weight: normal; font-size: 15px; color: #2F3044; margin:0; padding:0; width:100%;\">\r\n  <div style=\"background-color:#ffffff; padding: 45px 0 34px 0; border-radius: 24px; margin:40px auto; max-width: 600px;\">\r\n    <table style=\"border-collapse:collapse\" width=\"100%\" height=\"auto\" cellspacing=\"0\" cellpadding=\"0\" border=\"0\" align=\"center\">\r\n      <tbody>\r\n        <tr>\r\n          <td style=\"text-align:center; padding-bottom: 10px\" valign=\"center\" align=\"center\"><div style=\"text-align:center; margin:0 15px 34px 15px\">\r\n              <div style=\"margin-bottom: 10px\">\r\n                <a href=\"[SITEURL]\" rel=\"noopener\" target=\"_blank\">\r\n                <img alt=\"Logo\" src=\"[SITEURL]/uploads/[LOGO]\" style=\"height: 32px\" data-image=\"ywpos41bfvx0\">\r\n                </a>\r\n              </div>\r\n              <div style=\"margin-bottom: 15px\">\r\n                <img alt=\"image\" src=\"[SITEURL]/assets/email/email_envelope.svg\" style=\"width:170px\" data-image=\"kciweuwcn8dp\">\r\n              </div>\r\n              <div style=\"font-size: 14px; font-weight: 500; margin-bottom: 27px; font-family:Arial,Helvetica,sans-serif;\">\r\n                <p style=\"margin-bottom:9px; color:#181C32; font-size: 22px; font-weight:700\">Hey Admin!</p>\r\n                <p style=\"margin-bottom:2px; color:#7E8299\">You have a new contact request: </p>\r\n                <p style=\"margin-bottom:2px; color:#7E8299\">From: [NAME] </p>\r\n                <p style=\"margin-bottom:2px; color:#7E8299\">Email: [EMAIL] </p>\r\n                <p style=\"margin-bottom:2px; color:#7E8299\">Telephone: [PHONE] </p>\r\n                <p style=\"margin-bottom:2px; color:#7E8299\">Subject: [MAILSUBJECT] </p>\r\n                <p style=\"margin-bottom:2px; color:#7E8299\">IP: [IP] </p>\r\n              </div>\r\n              <div style=\"font-size: 14px; font-weight: 500; margin-bottom: 27px; font-family:Arial,Helvetica,sans-serif;text-align:left;\"> [MESSAGE] </div>\r\n            </div></td>\r\n        </tr>\r\n        <tr>\r\n          <td style=\"font-size: 13px; text-align:center; padding: 0 10px 10px 10px; font-weight: 500; color: #A1A5B7; font-family:Arial,Helvetica,sans-serif\" valign=\"center\" align=\"center\"><p style=\"color:#181C32; font-size: 16px; font-weight: 600; margin-bottom:9px\">Stay in touch</p>\r\n<p style=\"margin-bottom:4px\">You may reach us at\r\n              <a href=\"[SITEURL]\" rel=\"noopener\" target=\"_blank\" style=\"font-weight: 600\"> [SITE_NAME]</a>\r\n            </p>\r\n<p>We serve Mon-Fri, 9AM-18AM</p></td>\r\n        </tr>\r\n        <tr>\r\n          <td style=\"text-align:center; padding-bottom: 20px;\" valign=\"center\" align=\"center\"><a href=\"mailto:[CEMAIL]\" style=\"margin-right:10px\"><img alt=\"Logo\" src=\"[SITEURL]/assets/email/icon-email.svg\" style=\"width:24px\" data-image=\"sg1gbyqyjz48\"></a>\r\n<a href=\"https://facebook.com/[FB]\" style=\"margin-right:10px\"><img alt=\"Logo\" src=\"[SITEURL]/assets/email/icon-facebook.svg\" style=\"width:24px\" data-image=\"6qccmsconfri\"></a>\r\n<a href=\"https://twitter.com/[TW]\"><img alt=\"Logo\" src=\"[SITEURL]/assets/email/icon-twitter.svg\" style=\"width:24px\" data-image=\"xvyiw16bmplc\"></a></td>\r\n        </tr>\r\n        <tr>\r\n          <td style=\"font-size: 13px; padding:0 15px; text-align:center; font-weight: 500; color: #A1A5B7;font-family:Arial,Helvetica,sans-serif\" valign=\"center\" align=\"center\"><p> The information above is gathered from the user input. © Copyright [DATE] [COMPANY]. All rights reserved.</p></td>\r\n        </tr>\r\n      </tbody>\r\n    </table>\r\n  </div>\r\n</div>', 'mailer', 'contact');
INSERT INTO `email_templates`
VALUES (11, 'Transaction Completed Admin', 'Payment Completed', 'This template is used to notify administrator on successful payment transaction', '<div id=\"#kt_app_body_content\" style=\"background-color:#D5D9E2; font-family:Arial,Helvetica,sans-serif; line-height: 1.5; min-height: 100%; font-weight: normal; font-size: 15px; color: #2F3044; margin:0; padding:0; width:100%;\">\r\n   <div style=\"background-color:#ffffff; padding: 45px 0 34px 0; border-radius: 24px; margin:40px auto; max-width: 600px;\">\r\n      <table style=\"border-collapse:collapse\" width=\"100%\" height=\"auto\" cellspacing=\"0\" cellpadding=\"0\" border=\"0\" align=\"center\">\r\n         <tbody>\r\n         <tr>\r\n            <td style=\"text-align:center; padding-bottom: 10px\" valign=\"center\" align=\"center\"><div style=\"text-align:center; margin:0 15px 34px 15px\">\r\n                  <div style=\"margin-bottom: 10px\">\r\n                     <a href=\"[SITEURL]\" rel=\"noopener\" target=\"_blank\">\r\n                        <img alt=\"Logo\" src=\"[SITEURL]/uploads/[LOGO]\" style=\"height: 32px\" data-image=\"338z2e6crnf7\">\r\n                     </a>\r\n                  </div>\r\n                  <div style=\"margin-bottom: 15px\">\r\n                     <img alt=\"image\" src=\"[SITEURL]/assets/email/email_payment.svg\" style=\"width:170px\" data-image=\"51hzxn30s9q5\">\r\n                  </div>\r\n                  <div style=\"font-size: 14px; font-weight: 500; margin-bottom: 27px; font-family:Arial,Helvetica,sans-serif;\">\r\n                     <p style=\"margin-bottom:9px; color:#181C32; font-size: 22px; font-weight:700\">Hey Admin!</p>\r\n                     <p style=\"margin-bottom:2px; color:#7E8299\">You have received new payment following: </p>\r\n                  </div>\r\n                  <div style=\"font-size: 14px; font-weight: 500; margin-bottom: 27px; font-family:Arial,Helvetica,sans-serif;text-align:left\">\r\n                     <p style=\"margin-bottom:2px; color:#7E8299\">Username: [NAME]</p>\r\n                     <p style=\"margin-bottom:2px; color:#7E8299\">[TYPE]: [ITEMNAME]</p>\r\n                     <p style=\"margin-bottom:2px; color:#7E8299\">CD Key: [CDKEY]</p>\r\n                     <p style=\"margin-bottom:2px; color:#7E8299\">Price: [PRICE]</p>\r\n                     <p style=\"margin-bottom:2px; color:#7E8299\">Status: [STATUS]</p>\r\n                     <p style=\"margin-bottom:2px; color:#7E8299\">Processor: [PP]</p>\r\n                     <p style=\"margin-bottom:2px; color:#7E8299\">IP: [IP]</p>\r\n                  </div>\r\n               </div></td>\r\n         </tr>\r\n         <tr>\r\n            <td style=\"font-size: 13px; text-align:center; padding: 0 10px 10px 10px; font-weight: 500; color: #A1A5B7; font-family:Arial,Helvetica,sans-serif\" valign=\"center\" align=\"center\"><p style=\"color:#181C32; font-size: 16px; font-weight: 600; margin-bottom:9px\">Stay in touch</p>\r\n               <p style=\"margin-bottom:4px\">You may reach us at\r\n                  <a href=\"[SITEURL]\" rel=\"noopener\" target=\"_blank\" style=\"font-weight: 600\"> [SITE_NAME]</a>\r\n               </p>\r\n               <p>We serve Mon-Fri, 9AM-18AM</p></td>\r\n         </tr>\r\n         <tr>\r\n            <td style=\"text-align:center; padding-bottom: 20px;\" valign=\"center\" align=\"center\"><a href=\"mailto:[CEMAIL]\" style=\"margin-right:10px\"><img alt=\"Logo\" src=\"[SITEURL]/assets/email/icon-email.svg\" style=\"width:24px\" data-image=\"x4z9u3sx4rup\"></a>\r\n               <a href=\"https://facebook.com/[FB]\" style=\"margin-right:10px\"><img alt=\"Logo\" src=\"[SITEURL]/assets/email/icon-facebook.svg\" style=\"width:24px\" data-image=\"vcads5ej3eme\"></a>\r\n               <a href=\"https://twitter.com/[TW]\"><img alt=\"Logo\" src=\"[SITEURL]/assets/email/icon-twitter.svg\" style=\"width:24px\" data-image=\"n51e4y5e3st0\"></a></td>\r\n         </tr>\r\n         <tr>\r\n            <td style=\"font-size: 13px; padding:0 15px; text-align:center; font-weight: 500; color: #A1A5B7;font-family:Arial,Helvetica,sans-serif\" valign=\"center\" align=\"center\"><p> The information above is gathered from the user input. © Copyright [DATE] [COMPANY]. All rights reserved.</p></td>\r\n         </tr>\r\n         </tbody>\r\n      </table>\r\n   </div>\r\n</div>', 'mailer', 'payComplete');
INSERT INTO `email_templates`
VALUES (12, 'Transaction Completed User', 'Payment Completed', 'This template is used to notify user on successful payment transaction', '<div id=\"#kt_app_body_content\" style=\"background-color:#D5D9E2; font-family:Arial,Helvetica,sans-serif; line-height: 1.5; min-height: 100%; font-weight: normal; font-size: 15px; color: #2F3044; margin:0; padding:0; width:100%;\">\r\n   <div style=\"background-color:#ffffff; padding: 45px 0 34px 0; border-radius: 24px; margin:40px auto; max-width: 600px;\">\r\n      <table style=\"border-collapse:collapse\" width=\"100%\" height=\"auto\" cellspacing=\"0\" cellpadding=\"0\" border=\"0\" align=\"center\">\r\n         <tbody>\r\n         <tr>\r\n            <td style=\"text-align:center; padding-bottom: 10px\" valign=\"center\" align=\"center\"><div style=\"text-align:center; margin:0 15px 34px 15px\">\r\n                  <div style=\"margin-bottom: 10px\">\r\n                     <a href=\"[SITEURL]\" rel=\"noopener\" target=\"_blank\">\r\n                        <img alt=\"Logo\" src=\"[SITEURL]/uploads/[LOGO]\" style=\"height: 32px\" data-image=\"338z2e6crnf7\">\r\n                     </a>\r\n                  </div>\r\n                  <div style=\"margin-bottom: 15px\">\r\n                     <img alt=\"image\" src=\"[SITEURL]/assets/email/email_payment.svg\" style=\"width:170px\" data-image=\"51hzxn30s9q5\">\r\n                  </div>\r\n                  <div style=\"font-size: 14px; font-weight: 500; margin-bottom: 27px; font-family:Arial,Helvetica,sans-serif;\">\r\n                     <p style=\"margin-bottom:9px; color:#181C32; font-size: 22px; font-weight:700\">Hey [NAME]!</p>\r\n                     <p style=\"margin-bottom:2px; color:#7E8299\">Your payment has been completed successfully. Here are the details: </p>\r\n                  </div>\r\n                  <div style=\"font-size: 14px; font-weight: 500; margin-bottom: 27px; font-family:Arial,Helvetica,sans-serif;text-align:left\">\r\n                     <p style=\"margin-bottom:2px; color:#7E8299\">[TYPE]: [ITEMNAME]</p>\r\n                     <p style=\"margin-bottom:2px; color:#7E8299\">CD Key: [CDKEY]</p>\r\n                     <p style=\"margin-bottom:2px; color:#7E8299\">Price: [PRICE]</p>\r\n                     <p style=\"margin-bottom:2px; color:#7E8299\">Vat/Tax: [TAX]</p>\r\n                     <p style=\"margin-bottom:2px; color:#7E8299\">Processor: [PP]</p>\r\n                  </div>\r\n               </div></td>\r\n         </tr>\r\n         <tr>\r\n            <td style=\"font-size: 13px; text-align:center; padding: 0 10px 10px 10px; font-weight: 500; color: #A1A5B7; font-family:Arial,Helvetica,sans-serif\" valign=\"center\" align=\"center\"><p style=\"color:#181C32; font-size: 16px; font-weight: 600; margin-bottom:9px\">Stay in touch</p>\r\n               <p style=\"margin-bottom:4px\">You may reach us at\r\n                  <a href=\"[SITEURL]\" rel=\"noopener\" target=\"_blank\" style=\"font-weight: 600\"> [SITE_NAME]</a>\r\n               </p>\r\n               <p>We serve Mon-Fri, 9AM-18AM</p></td>\r\n         </tr>\r\n         <tr>\r\n            <td style=\"text-align:center; padding-bottom: 20px;\" valign=\"center\" align=\"center\"><a href=\"mailto:[CEMAIL]\" style=\"margin-right:10px\"><img alt=\"Logo\" src=\"[SITEURL]/assets/email/icon-email.svg\" style=\"width:24px\" data-image=\"x4z9u3sx4rup\"></a>\r\n               <a href=\"https://facebook.com/[FB]\" style=\"margin-right:10px\"><img alt=\"Logo\" src=\"[SITEURL]/assets/email/icon-facebook.svg\" style=\"width:24px\" data-image=\"vcads5ej3eme\"></a>\r\n               <a href=\"https://twitter.com/[TW]\"><img alt=\"Logo\" src=\"[SITEURL]/assets/email/icon-twitter.svg\" style=\"width:24px\" data-image=\"n51e4y5e3st0\"></a></td>\r\n         </tr>\r\n         <tr>\r\n            <td style=\"font-size: 13px; padding:0 15px; text-align:center; font-weight: 500; color: #A1A5B7;font-family:Arial,Helvetica,sans-serif\" valign=\"center\" align=\"center\"><p> The information above is gathered from the user input. © Copyright [DATE] [COMPANY]. All rights reserved.</p></td>\r\n         </tr>\r\n         </tbody>\r\n      </table>\r\n   </div>\r\n</div>', 'mailer', 'payCompleteUser');
INSERT INTO `email_templates`
VALUES (13, 'Membership Expired', 'Membership Has Expired', 'This template is used to notify user when membership is about to expire a day before. ', '<div id=\"#kt_app_body_content\" style=\"background-color:#D5D9E2; font-family:Arial,Helvetica,sans-serif; line-height: 1.5; min-height: 100%; font-weight: normal; font-size: 15px; color: #2F3044; margin:0; padding:0; width:100%;\">\r\n  <div style=\"background-color:#ffffff; padding: 45px 0 34px 0; border-radius: 24px; margin:40px auto; max-width: 600px;\">\r\n    <table style=\"border-collapse:collapse\" width=\"100%\" height=\"auto\" cellspacing=\"0\" cellpadding=\"0\" border=\"0\" align=\"center\">\r\n      <tbody>\r\n        <tr>\r\n          <td style=\"text-align:center; padding-bottom: 10px\" valign=\"center\" align=\"center\"><div style=\"text-align:center; margin:0 15px 34px 15px\">\r\n              <div style=\"margin-bottom: 10px\">\r\n                <a href=\"[SITEURL]\" rel=\"noopener\" target=\"_blank\">\r\n                <img alt=\"Logo\" src=\"[SITEURL]/uploads/[LOGO]\" style=\"height: 32px\" data-image=\"96wzboz0ihr4\">\r\n                </a>\r\n              </div>\r\n              <div style=\"margin-bottom: 15px\">\r\n                <img alt=\"image\" src=\"[SITEURL]/assets/email/email_membership.svg\" style=\"width:170px\" data-image=\"snecu3fz98bu\">\r\n              </div>\r\n              <div style=\"font-size: 14px; font-weight: 500; margin-bottom: 27px; font-family:Arial,Helvetica,sans-serif;\">\r\n                <p style=\"margin-bottom:9px; color:#181C32; font-size: 22px; font-weight:700\">Hey [NAME]!</p>\r\n                <p style=\"margin-bottom:2px; color:#F44336\">Your current membership has expired! </p>\r\n				  <p style=\"margin-bottom:2px; color:#7E8299\">Please login to your user panel to extend or upgrade your membership.. </p>\r\n              </div>\r\n              <a href=\"[LINK]\" target=\"_blank\" style=\"background-color:#2196F3; border-radius:6px;display:inline-block; padding:11px 19px; color: #FFFFFF; font-size: 14px; font-weight:500;\"> Login</a>\r\n            </div></td>\r\n        </tr>\r\n        <tr>\r\n          <td style=\"font-size: 13px; text-align:center; padding: 0 10px 10px 10px; font-weight: 500; color: #A1A5B7; font-family:Arial,Helvetica,sans-serif\" valign=\"center\" align=\"center\"><p style=\"color:#181C32; font-size: 16px; font-weight: 600; margin-bottom:9px\">Stay in touch</p>\r\n<p style=\"margin-bottom:4px\">You may reach us at\r\n              <a href=\"[SITEURL]\" rel=\"noopener\" target=\"_blank\" style=\"font-weight: 600\"> [SITE_NAME]</a>\r\n            </p>\r\n<p>We serve Mon-Fri, 9AM-18AM</p></td>\r\n        </tr>\r\n        <tr>\r\n          <td style=\"text-align:center; padding-bottom: 20px;\" valign=\"center\" align=\"center\"><a href=\"mailto:[CEMAIL]\" style=\"margin-right:10px\"><img alt=\"Logo\" src=\"[SITEURL]/assets/email/icon-email.svg\" style=\"width:24px\" data-image=\"gj75tx95851x\"></a>\r\n<a href=\"https://facebook.com/[FB]\" style=\"margin-right:10px\"><img alt=\"Logo\" src=\"[SITEURL]/assets/email/icon-facebook.svg\" style=\"width:24px\" data-image=\"0yrtm40v9wm8\"></a>\r\n<a href=\"https://twitter.com/[TW]\"><img alt=\"Logo\" src=\"[SITEURL]/assets/email/icon-twitter.svg\" style=\"width:24px\" data-image=\"lz2511lnq040\"></a></td>\r\n        </tr>\r\n        <tr>\r\n          <td style=\"font-size: 13px; padding:0 15px; text-align:center; font-weight: 500; color: #A1A5B7;font-family:Arial,Helvetica,sans-serif\" valign=\"center\" align=\"center\"><p> The information above is gathered from the user input. © Copyright [DATE] [COMPANY]. All rights reserved.</p></td>\r\n        </tr>\r\n      </tbody>\r\n    </table>\r\n  </div>\r\n</div>', 'mailer', 'memExpired');
INSERT INTO `email_templates`
VALUES (14, 'New Comment', 'New Comment Added', 'This template is used to notify admin when comment has been submitted.', '<div id=\"#kt_app_body_content\" style=\"background-color:#D5D9E2; font-family:Arial,Helvetica,sans-serif; line-height: 1.5; min-height: 100%; font-weight: normal; font-size: 15px; color: #2F3044; margin:0; padding:0; width:100%;\">\r\n  <div style=\"background-color:#ffffff; padding: 45px 0 34px 0; border-radius: 24px; margin:40px auto; max-width: 600px;\">\r\n    <table style=\"border-collapse:collapse\" width=\"100%\" height=\"auto\" cellspacing=\"0\" cellpadding=\"0\" border=\"0\" align=\"center\">\r\n      <tbody>\r\n        <tr>\r\n          <td style=\"text-align:center; padding-bottom: 10px\" valign=\"center\" align=\"center\"><div style=\"text-align:center; margin:0 15px 34px 15px\">\r\n              <div style=\"margin-bottom: 10px\">\r\n                <a href=\"[SITEURL]\" rel=\"noopener\" target=\"_blank\">\r\n                <img alt=\"Logo\" src=\"[SITEURL]/uploads/[LOGO]\" style=\"height: 32px\" data-image=\"d3mnag0c7bd8\">\r\n                </a>\r\n              </div>\r\n              <div style=\"margin-bottom: 15px\">\r\n                <img alt=\"image\" src=\"[SITEURL]/assets/email/email_comment.svg\" style=\"width:170px\" data-image=\"56yqk8ial4v9\">\r\n              </div>\r\n              <div style=\"font-size: 14px; font-weight: 500; margin-bottom: 27px; font-family:Arial,Helvetica,sans-serif;\">\r\n                <p style=\"margin-bottom:9px; color:#181C32; font-size: 22px; font-weight:700\">Hey Admin!</p>\r\n                <p style=\"margin-bottom:2px; color:#7E8299\">You have a new comment post. </p>\r\n                <p style=\"margin-bottom:2px; color:#7E8299\">If comments are not auto approved, you will need to manually approve from admin panel. Here are the details: </p>\r\n              </div>\r\n              <div style=\"font-size: 14px; font-weight: 500; margin-bottom: 27px; font-family:Arial,Helvetica,sans-serif;text-align:left\">\r\n                <p style=\"margin-bottom:2px; color:#7E8299\">From: [NAME]</p>\r\n                <p style=\"margin-bottom:2px; color:#7E8299\">Page: [PAGEURL]</p>\r\n                <p style=\"margin-bottom:2px; color:#7E8299\">IP: [IP]</p>\r\n              </div>\r\n              <div style=\"font-size: 14px; font-weight: 500; margin-bottom: 27px; font-family:Arial,Helvetica,sans-serif;text-align:left\"> [MESSAGE] </div>\r\n            </div></td>\r\n        </tr>\r\n        <tr>\r\n          <td style=\"font-size: 13px; text-align:center; padding: 0 10px 10px 10px; font-weight: 500; color: #A1A5B7; font-family:Arial,Helvetica,sans-serif\" valign=\"center\" align=\"center\"><p style=\"color:#181C32; font-size: 16px; font-weight: 600; margin-bottom:9px\">Stay in touch</p>\r\n<p style=\"margin-bottom:4px\">You may reach us at\r\n              <a href=\"[SITEURL]\" rel=\"noopener\" target=\"_blank\" style=\"font-weight: 600\"> [SITE_NAME]</a>\r\n            </p>\r\n<p>We serve Mon-Fri, 9AM-18AM</p></td>\r\n        </tr>\r\n        <tr>\r\n          <td style=\"text-align:center; padding-bottom: 20px;\" valign=\"center\" align=\"center\"><a href=\"mailto:[CEMAIL]\" style=\"margin-right:10px\"><img alt=\"Logo\" src=\"[SITEURL]/assets/email/icon-email.svg\" style=\"width:24px\" data-image=\"zvt2fojn5zqc\"></a>\r\n<a href=\"https://facebook.com/[FB]\" style=\"margin-right:10px\"><img alt=\"Logo\" src=\"[SITEURL]/assets/email/icon-facebook.svg\" style=\"width:24px\" data-image=\"zhfauoxc9irn\"></a>\r\n<a href=\"https://twitter.com/[TW]\"><img alt=\"Logo\" src=\"[SITEURL]/assets/email/icon-twitter.svg\" style=\"width:24px\" data-image=\"d3k55hv60sjy\"></a></td>\r\n        </tr>\r\n        <tr>\r\n          <td style=\"font-size: 13px; padding:0 15px; text-align:center; font-weight: 500; color: #A1A5B7;font-family:Arial,Helvetica,sans-serif\" valign=\"center\" align=\"center\"><p> The information above is gathered from the user input. © Copyright [DATE] [COMPANY]. All rights reserved.</p></td>\r\n        </tr>\r\n      </tbody>\r\n    </table>\r\n  </div>\r\n</div>', 'mailer', 'newComment');
INSERT INTO `email_templates`
VALUES (15, 'Notify User Transaction', 'Your product is ready for download', 'This template is used to notify user when manual transaction has been processed.', '<div id=\"#kt_app_body_content\" style=\"background-color:#D5D9E2; font-family:Arial,Helvetica,sans-serif; line-height: 1.5; min-height: 100%; font-weight: normal; font-size: 15px; color: #2F3044; margin:0; padding:0; width:100%;\">\r\n  <div style=\"background-color:#ffffff; padding: 45px 0 34px 0; border-radius: 24px; margin:40px auto; max-width: 600px;\">\r\n    <table style=\"border-collapse:collapse\" width=\"100%\" height=\"auto\" cellspacing=\"0\" cellpadding=\"0\" border=\"0\" align=\"center\">\r\n      <tbody>\r\n        <tr>\r\n          <td style=\"text-align:center; padding-bottom: 10px\" valign=\"center\" align=\"center\"><div style=\"text-align:center; margin:0 15px 34px 15px\">\r\n              <div style=\"margin-bottom: 10px\">\r\n                <a href=\"[SITEURL]\" rel=\"noopener\" target=\"_blank\">\r\n                <img alt=\"Logo\" src=\"[SITEURL]/uploads/[LOGO]\" style=\"height: 32px\" data-image=\"e0f1san1tw55\">\r\n                </a>\r\n              </div>\r\n              <div style=\"margin-bottom: 15px\">\r\n                <img alt=\"image\" src=\"[SITEURL]/assets/email/email_bag.svg\" style=\"width:170px\" data-image=\"808wpj5ayss4\">\r\n              </div>\r\n              <div style=\"font-size: 14px; font-weight: 500; margin-bottom: 27px; font-family:Arial,Helvetica,sans-serif;\">\r\n                <p style=\"margin-bottom:9px; color:#181C32; font-size: 22px; font-weight:700\">Hey [NAME]!</p>\r\n                <p style=\"margin-bottom:2px; color:#7E8299\">Your product [ITEMNAME] is ready for download </p>\r\n              </div>\r\n		<p style=\"margin-bottom:2px; color:#7E8299;margin-bottom: 16px;\">Login into your dashboard to view this transaction</p>\r\n		<a href=\"[LINK]\" target=\"_blank\" style=\"background-color:#2196F3; border-radius:6px;display:inline-block; padding:11px 19px; color: #FFFFFF; font-size: 14px; font-weight:500;\"> User Dashboard</a>\r\n            </div></td>\r\n        </tr>\r\n        <tr>\r\n          <td style=\"font-size: 13px; text-align:center; padding: 0 10px 10px 10px; font-weight: 500; color: #A1A5B7; font-family:Arial,Helvetica,sans-serif\" valign=\"center\" align=\"center\"><p style=\"color:#181C32; font-size: 16px; font-weight: 600; margin-bottom:9px\">Stay in touch</p>\r\n<p style=\"margin-bottom:4px\">You may reach us at\r\n              <a href=\"[SITEURL]\" rel=\"noopener\" target=\"_blank\" style=\"font-weight: 600\"> [SITE_NAME]</a>\r\n            </p>\r\n<p>We serve Mon-Fri, 9AM-18AM</p></td>\r\n        </tr>\r\n        <tr>\r\n          <td style=\"text-align:center; padding-bottom: 20px;\" valign=\"center\" align=\"center\"><a href=\"mailto:[CEMAIL]\" style=\"margin-right:10px\"><img alt=\"Logo\" src=\"[SITEURL]/assets/email/icon-email.svg\" style=\"width:24px\" data-image=\"uypum0hkj2to\"></a>\r\n<a href=\"https://facebook.com/[FB]\" style=\"margin-right:10px\"><img alt=\"Logo\" src=\"[SITEURL]/assets/email/icon-facebook.svg\" style=\"width:24px\" data-image=\"tej6sqoc1hph\"></a>\r\n<a href=\"https://twitter.com/[TW]\"><img alt=\"Logo\" src=\"[SITEURL]/assets/email/icon-twitter.svg\" style=\"width:24px\" data-image=\"acz5r5lb0g8m\"></a></td>\r\n        </tr>\r\n        <tr>\r\n          <td style=\"font-size: 13px; padding:0 15px; text-align:center; font-weight: 500; color: #A1A5B7;font-family:Arial,Helvetica,sans-serif\" valign=\"center\" align=\"center\"><p> The information above is gathered from the user input. © Copyright [DATE] [COMPANY]. All rights reserved.</p></td>\r\n        </tr>\r\n      </tbody>\r\n    </table>\r\n  </div>\r\n</div>', 'mailer', 'notifyUser');
INSERT INTO `email_templates`
VALUES (16, 'Membership Updated', 'Membership Has been Updated', 'This template is used to notifu user about membership update', '<div id=\"#kt_app_body_content\" style=\"background-color:#D5D9E2; font-family:Arial,Helvetica,sans-serif; line-height: 1.5; min-height: 100%; font-weight: normal; font-size: 15px; color: #2F3044; margin:0; padding:0; width:100%;\">\r\n  <div style=\"background-color:#ffffff; padding: 45px 0 34px 0; border-radius: 24px; margin:40px auto; max-width: 600px;\">\r\n    <table style=\"border-collapse:collapse\" width=\"100%\" height=\"auto\" cellspacing=\"0\" cellpadding=\"0\" border=\"0\" align=\"center\">\r\n      <tbody>\r\n        <tr>\r\n          <td style=\"text-align:center; padding-bottom: 10px\" valign=\"center\" align=\"center\"><div style=\"text-align:center; margin:0 15px 34px 15px\">\r\n              <div style=\"margin-bottom: 10px\">\r\n                <a href=\"[SITEURL]\" rel=\"noopener\" target=\"_blank\">\r\n                <img alt=\"Logo\" src=\"[SITEURL]/uploads/[LOGO]\" style=\"height: 32px\" data-image=\"96wzboz0ihr4\">\r\n                </a>\r\n              </div>\r\n              <div style=\"margin-bottom: 15px\">\r\n                <img alt=\"image\" src=\"[SITEURL]/assets/email/email_membership.svg\" style=\"width:170px\" data-image=\"snecu3fz98bu\">\r\n              </div>\r\n              <div style=\"font-size: 14px; font-weight: 500; margin-bottom: 27px; font-family:Arial,Helvetica,sans-serif;\">\r\n                <p style=\"margin-bottom:9px; color:#181C32; font-size: 22px; font-weight:700\">Hey [NAME]!</p>\r\n                <p style=\"margin-bottom:2px;\">Your current membership has been updated! </p>\r\n                <p style=\"margin-bottom:2px; color:#7E8299\">Membership: [MEMBERSHIP] </p>\r\n                <p style=\"margin-bottom:2px; color:#7E8299\">Expire: [EXPIRE] </p>\r\n              </div>\r\n              <a href=\"[LINK]\" target=\"_blank\" style=\"background-color:#2196F3; border-radius:6px;display:inline-block; padding:11px 19px; color: #FFFFFF; font-size: 14px; font-weight:500;\"> Login</a>\r\n            </div></td>\r\n        </tr>\r\n        <tr>\r\n          <td style=\"font-size: 13px; text-align:center; padding: 0 10px 10px 10px; font-weight: 500; color: #A1A5B7; font-family:Arial,Helvetica,sans-serif\" valign=\"center\" align=\"center\"><p style=\"color:#181C32; font-size: 16px; font-weight: 600; margin-bottom:9px\">Stay in touch</p>\r\n<p style=\"margin-bottom:4px\">You may reach us at\r\n              <a href=\"[SITEURL]\" rel=\"noopener\" target=\"_blank\" style=\"font-weight: 600\"> [SITE_NAME]</a>\r\n            </p>\r\n<p>We serve Mon-Fri, 9AM-18AM</p></td>\r\n        </tr>\r\n        <tr>\r\n          <td style=\"text-align:center; padding-bottom: 20px;\" valign=\"center\" align=\"center\"><a href=\"mailto:[CEMAIL]\" style=\"margin-right:10px\"><img alt=\"Logo\" src=\"[SITEURL]/assets/email/icon-email.svg\" style=\"width:24px\" data-image=\"gj75tx95851x\"></a>\r\n<a href=\"https://facebook.com/[FB]\" style=\"margin-right:10px\"><img alt=\"Logo\" src=\"[SITEURL]/assets/email/icon-facebook.svg\" style=\"width:24px\" data-image=\"0yrtm40v9wm8\"></a>\r\n<a href=\"https://twitter.com/[TW]\"><img alt=\"Logo\" src=\"[SITEURL]/assets/email/icon-twitter.svg\" style=\"width:24px\" data-image=\"lz2511lnq040\"></a></td>\r\n        </tr>\r\n        <tr>\r\n          <td style=\"font-size: 13px; padding:0 15px; text-align:center; font-weight: 500; color: #A1A5B7;font-family:Arial,Helvetica,sans-serif\" valign=\"center\" align=\"center\"><p> The information above is gathered from the user input. © Copyright [DATE] [COMPANY]. All rights reserved.</p></td>\r\n        </tr>\r\n      </tbody>\r\n    </table>\r\n  </div>\r\n</div>', 'mailer', 'memUpdated');;

--
-- Table structure for table `faq`
--

DROP TABLE IF EXISTS `faq`;
CREATE TABLE IF NOT EXISTS `faq` (
  `id` tinyint(3) UNSIGNED NOT NULL AUTO_INCREMENT,
  `question` varchar(150) DEFAULT NULL,
  `answer` text,
  `sorting` tinyint(3) UNSIGNED NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
  ) ENGINE = MyISAM DEFAULT CHARSET = utf8mb4;

--
-- Table structure for table `files`
--

DROP TABLE IF EXISTS `files`;
CREATE TABLE IF NOT EXISTS `files` (
  `id` int(11) UNSIGNED NOT NULL AUTO_INCREMENT,
  `name` varchar(80) NOT NULL,
  `alias` varchar(80) DEFAULT NULL,
  `filesize` int(11) UNSIGNED NOT NULL DEFAULT '0',
  `extension` varchar(4) DEFAULT NULL,
  `type` varchar(20) DEFAULT NULL,
  `token` varchar(32) DEFAULT NULL,
  `created` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `active` tinyint(1) UNSIGNED NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`)
  ) ENGINE = MyISAM DEFAULT CHARSET = utf8mb4;

--
-- Table structure for table `gateways`
--

DROP TABLE IF EXISTS `gateways`;
CREATE TABLE IF NOT EXISTS `gateways` (
  `id` int(4) UNSIGNED NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `displayname` varchar(50) NOT NULL,
  `dir` varchar(30) NOT NULL,
  `live` tinyint(1) UNSIGNED NOT NULL DEFAULT '1',
  `extra_txt` varchar(120) DEFAULT NULL,
  `extra_txt2` varchar(120) DEFAULT NULL,
  `extra_txt3` varchar(120) DEFAULT NULL,
  `extra` varchar(120) NOT NULL,
  `extra2` varchar(120) DEFAULT NULL,
  `extra3` varchar(250) DEFAULT NULL,
  `is_recurring` tinyint(1) UNSIGNED NOT NULL DEFAULT '0',
  `active` tinyint(1) UNSIGNED NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`)
  ) ENGINE = MyISAM DEFAULT CHARSET = utf8mb4;

--
-- Dumping data for table `gateways`
--

INSERT INTO `gateways`
VALUES (1, 'paypal', 'PayPal', 'paypal', 1, 'Paypal Email Address', 'Currency Code', 'Not in Use', 'webmaster@domain.com', 'CAD', '', 1, 1);
INSERT INTO `gateways`
VALUES (2, 'skrill', 'Skrill', 'skrill', 1, 'Skrill Email Address', 'Currency Code', 'Secret Passphrase', 'skrill@address.com', 'EUR', 'mypassphrase', 1, 1);
INSERT INTO `gateways`
VALUES (3, 'stripe', 'Stripe', 'stripe', 1, 'Stripe Secret Key', 'Currency Code', 'Publishable Key', '', 'CAD', '', 1, 1);
INSERT INTO `gateways`
VALUES (4, 'payfast', 'PayFast', 'payfast', 1, 'Merchant ID', 'Merchant Key', 'PassPhrase', '', '', '', 1, 1);
INSERT INTO `gateways`
VALUES (5, 'ideal', 'iDeal', 'ideal', 1, 'API Key', 'Currency Code', 'Not in Use', '', 'EUR', NULL, 0, 1);
INSERT INTO `gateways`
VALUES (6, 'paystack', 'Paystack', 'paystack', 1, 'Secret Key', 'Currency Code', 'Public Key', 'sk_test_', 'ZAR', 'pk_test_', 0, 1);
INSERT INTO `gateways`
VALUES (7, 'offline', 'Offline', 'offline', 1, 'Currency Code', 'Not in Use', 'Not in Use', 'CAD', '', 'Please send a check to Store Name, Store Street, Store Town, Store State / County, Store Postcode.', 0, 1);
INSERT INTO `gateways`
VALUES (8, 'razorpay', 'RazorPay', 'razorpay', 1, 'Api Key', 'Currency Code', 'Secret Key', '', 'INR', '', 0, 1);

--
-- Table structure for table `images`
--

DROP TABLE IF EXISTS `images`;
CREATE TABLE IF NOT EXISTS `images` (
  `id` int(11) UNSIGNED NOT NULL AUTO_INCREMENT,
  `parent_id` int(11) NOT NULL DEFAULT '0',
  `name` varchar(60) DEFAULT NULL,
  `sorting` int(11) UNSIGNED NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `idx_parent_id` (`parent_id`)
  ) ENGINE = MyISAM DEFAULT CHARSET = utf8mb4;

--
-- Table structure for table `invoices`
--

DROP TABLE IF EXISTS `invoices`;
CREATE TABLE IF NOT EXISTS `invoices` (
  `id` int(11) UNSIGNED NOT NULL AUTO_INCREMENT,
  `invoice_id` int(11) UNSIGNED NOT NULL DEFAULT '0',
  `transaction_id` varchar(32) NOT NULL DEFAULT '0',
  `items` blob,
  `user_id` int(11) UNSIGNED NOT NULL DEFAULT '0',
  `tax` decimal(10, 2) UNSIGNED NOT NULL DEFAULT '0.00',
  `coupon` decimal(10, 2) UNSIGNED NOT NULL DEFAULT '0.00',
  `subtotal` decimal(10, 2) UNSIGNED NOT NULL DEFAULT '0.00',
  `grand` decimal(10, 2) UNSIGNED NOT NULL DEFAULT '0.00',
  `currency` varchar(6) DEFAULT NULL,
  `created` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
  ) ENGINE = MyISAM DEFAULT CHARSET = utf8mb4;

--
-- Table structure for table `memberships`
--

DROP TABLE IF EXISTS `memberships`;
CREATE TABLE IF NOT EXISTS `memberships` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(50) NOT NULL,
  `description` varchar(150) DEFAULT NULL,
  `body` text,
  `price` decimal(12,2) unsigned NOT NULL DEFAULT '0.00',
  `days` smallint(2) unsigned NOT NULL DEFAULT '0',
  `period` varchar(1) NOT NULL DEFAULT 'D',
  `downloads` smallint(1) NOT NULL DEFAULT '-1',
  `recurring` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `sorting` smallint(4) unsigned NOT NULL DEFAULT '0',
  `thumb` varchar(40) DEFAULT NULL,
  `private` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `active` tinyint(1) unsigned NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`)
  ) ENGINE = MyISAM DEFAULT CHARSET = utf8mb4;

--
-- Dumping data for table `memberships`
--

INSERT INTO `memberships`
VALUES (1, 'Bronze', 'This is 30 days basic membership', NULL, '2.99', 1, 'M', -1, 1, 2, 'bronze.svg', 0, 1);
INSERT INTO `memberships`
VALUES (2, 'Gold', 'This is 90 days basic membership', '', '6.99', 90, 'D', 5, 0, 3, 'gold.svg', 0, 1);
INSERT INTO `memberships`
VALUES (3, 'Platinum', 'Platinum Yearly Subscription', NULL, '149.99', 1, 'Y', -1, 1, 4, 'platinum.svg', 0, 1);
INSERT INTO `memberships`
VALUES (4, 'Silver', 'This is 7 days basic membership.', '<div class=\"row gutters\">\r\n   <div class=\"columns phone-100\">\r\n      <ul class=\"wojo styled check circle list positive\">\r\n         <li class=\"item\">Up to 2 people</li>\r\n         <li class=\"item\">Collect data</li>\r\n         <li class=\"item\">Code extensibility</li>\r\n      </ul>\r\n   </div>\r\n   <div class=\"columns phone-100\">\r\n      <ul class=\"wojo styled x circle list negative\">\r\n         <li class=\"item\">Custom reports</li>\r\n         <li class=\"item\">Product support</li>\r\n         <li class=\"item\">Activity reporting</li>\r\n      </ul>\r\n   </div>\r\n</div>', '1.99', 1, 'W', -1, 0, 1, 'silver.svg', 0, 1);

--
-- Table structure for table `membership_history`
--

DROP TABLE IF EXISTS `membership_history`;
CREATE TABLE IF NOT EXISTS `membership_history` (
  `id` int(11) UNSIGNED NOT NULL AUTO_INCREMENT,
  `transaction_id` int(11) UNSIGNED NOT NULL DEFAULT '0',
  `user_id` int(11) UNSIGNED NOT NULL DEFAULT '0',
  `membership_id` int(11) UNSIGNED NOT NULL DEFAULT '0',
  `activated` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `expire` timestamp NULL DEFAULT NULL,
  `recurring` tinyint(1) UNSIGNED NOT NULL DEFAULT '0',
  `active` tinyint(1) UNSIGNED NOT NULL DEFAULT '0' COMMENT '0 = expired, 1 = active',
  PRIMARY KEY (`id`),
  KEY `idx_transaction` (`transaction_id`),
  KEY `idx_user` (`user_id`),
  KEY `idx_membership` (`membership_id`)
  ) ENGINE = MyISAM DEFAULT CHARSET = utf8mb4;

--
-- Dumping data for table `menus`
--

DROP TABLE IF EXISTS `menus`;
CREATE TABLE IF NOT EXISTS `menus` (
  `id` int(4) UNSIGNED NOT NULL AUTO_INCREMENT,
  `page_id` int(4) UNSIGNED NOT NULL DEFAULT '0',
  `name` varchar(100) NOT NULL,
  `content_type` varchar(20) NOT NULL,
  `link` varchar(255) DEFAULT NULL,
  `target` varchar(8) DEFAULT '_blank',
  `sorting` int(4) UNSIGNED NOT NULL DEFAULT '0',
  `active` tinyint(1) UNSIGNED NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `content_id` (`active`)
  ) ENGINE = MyISAM DEFAULT CHARSET = utf8mb4;

--
-- Dumping data for table `menus`
--

INSERT INTO `menus`
VALUES (1, 4, 'Contact Us', 'page', '', '', 5, 1);
INSERT INTO `menus`
VALUES (2, 1, 'Home', 'page', NULL, '', 1, 0);
INSERT INTO `menus`
VALUES (3, 2, 'About Us', 'page', NULL, '', 4, 1);
INSERT INTO `menus`
VALUES (4, 3, 'F.A.Q.', 'page', NULL, '', 2, 1);
INSERT INTO `menus`
VALUES (5, 0, 'Ext Link', 'web', 'https://www.google.com', '_blank', 6, 0);
INSERT INTO `menus`
VALUES (6, 5, 'Privacy Policy', 'page', NULL, '_self', 7, 1);
INSERT INTO `menus`
VALUES (7, 6, 'VIP Access', 'page', NULL, '_sefl', 8, 1);
INSERT INTO `menus`
VALUES (8, 0, 'News', 'web', '[SITEURL]/news/', '_self', 9, 1);
INSERT INTO `menus`
VALUES (9, 0, 'Blog', 'web', '[SITEURL]/blog/', '_self', 3, 1);

--
-- Table structure for table `news`
--

DROP TABLE IF EXISTS `news`;
CREATE TABLE IF NOT EXISTS `news` (
  `id` int(6) UNSIGNED NOT NULL AUTO_INCREMENT,
  `title` varchar(80) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `body` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `author` varchar(55) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `created` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `active` tinyint(1) UNSIGNED NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
  ) ENGINE = MyISAM DEFAULT CHARSET = utf8mb4;

--
-- Table structure for table `pages`
--

DROP TABLE IF EXISTS `pages`;
CREATE TABLE IF NOT EXISTS `pages` (
  `id` int(6) UNSIGNED NOT NULL AUTO_INCREMENT,
  `title` varchar(200) NOT NULL,
  `slug` varchar(200) NOT NULL,
  `body` longtext,
  `page_type` varchar(25) NOT NULL DEFAULT 'normal',
  `address` tinytext,
  `keywords` varchar(250) DEFAULT NULL,
  `description` varchar(250) DEFAULT NULL,
  `created` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `active` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
  ) ENGINE = MyISAM DEFAULT CHARSET = utf8mb4;

--
-- Dumping data for table `pages`
--

INSERT INTO `pages`
VALUES (1, 'Welcome to our site', 'welcome-to-our-site', '<div class=\"wojo-grid\">\r\n  <div class=\"row gutters\">\r\n    <div class=\"columns phone-100\">\r\n      <div class=\"wojo icon message\">\r\n         <img src=\"[SITEURL]/uploads/images/oc-protected-card.svg\" class=\"wojo small image\">\r\n<div class=\"content\">\r\n<h5>Secure Checkout</h5>\r\nGuaranteed safe checkout\r\n        </div>\r\n      </div>\r\n    </div>\r\n    <div class=\"columns phone-100\">\r\n      <div class=\"wojo icon message\">\r\n         <img src=\"[SITEURL]/uploads/images/oc-money-profits.svg\" class=\"wojo small image\">\r\n<div class=\"content\">\r\n<h5>Payments</h5>\r\nMultiple payment options\r\n        </div>\r\n      </div>\r\n    </div>\r\n    <div class=\"columns phone-100\">\r\n      <div class=\"wojo icon message\">\r\n         <img src=\"[SITEURL]/uploads/images/oc-return.svg\" class=\"wojo small image\">\r\n<div class=\"content\">\r\n<h5>VIP Access</h5>\r\nEnjoy membership benefits\r\n        </div>\r\n      </div>\r\n    </div>\r\n  </div>\r\n</div>\r\n<div class=\"wojo card homebanner\">\r\n  <div class=\"center-align\">\r\n    <div class=\"wojo-grid\">\r\n      <p class=\"text-color-white text-weight-300\">If you have any questions, comments or concerns, please call the Sales or Advertising department\r\n        at (+000) 555-5555</p>\r\n      <a href=\"tel:+000000000\" class=\"wojo transparent button\">\r\n      <i class=\"icon smartphone\"></i> Call Now: (+000) 555-5555 </a>\r\n    </div>\r\n  </div>\r\n</div>', 'home', NULL, '', '', '2017-05-31 03:02:47', 1);
INSERT INTO `pages`
VALUES (2, 'About Us', 'about-us', '<div class=\"row gutters justify-center\">\r\n    <div class=\"columns screen-70 tablet-80 mobile-100 phone-100\">\r\n        <p class=\"text-size-large\">We cut through complexity, empowering businesses to challenge the status quo, create unlimited opportunities – and change the world.</p>\r\n    </div>\r\n</div>\r\n<div class=\"row gutters justify-center\">\r\n    <div class=\"columns screen-70 tablet-80 mobile-100 phone-100\"> <img src=\"[SITEURL]/uploads/images/about.jpg\" alt=\"\" class=\"wojo image\"> </div>\r\n</div>\r\n<div class=\"row gutters justify-center\">\r\n    <div class=\"columns screen-70 tablet-80 mobile-100 phone-100\">\r\n        <h4>Work environment</h4>\r\n        <p>Only by seeking out diverse talent around the globe and by creating an inclusive workplace can we access the breadth of skills, abilities and creativity that we need to create exceptional and innovative products and services for our customers.</p>\r\n        <p>We strongly believe that an inclusive working environment enables everyone to realise their full potential and to deliver outstanding service to our customers. We continually strive to use all the experiences that our employees bring with them to influence and shape our decision making process.</p>\r\n        <p>We are an equal opportunities employer and we aim to recruit, train and promote based on individual aptitudes and skills.</p>\r\n    </div>\r\n</div>\r\n<div class=\"row gutters justify-center\">\r\n    <div class=\"columns screen-70 tablet-80 mobile-100 phone-100\">\r\n        <h4 class=\"center-align margin-bottom\">Our leadership</h4>\r\n        <div class=\"row big-gutters\">\r\n            <div class=\"columns phone-100 center-align\"><img src=\"[SITEURL]/uploads/images/img4.jpg\" alt=\"\" class=\"wojo small-rounded image\">\r\n                <h6 class=\"margin-top\">David Forren</h6>\r\n                <p>Founder / CEO</p>\r\n            </div>\r\n            <div class=\"columns phone-100 center-align\"><img src=\"[SITEURL]/uploads/images/img5.jpg\" alt=\"\" class=\"wojo small-rounded image\">\r\n                <h6 class=\"margin-top\">Amil Evara</h6>\r\n                <p>UI/UX Designer</p>\r\n            </div>\r\n            <div class=\"columns phone-100 center-align\"><img src=\"[SITEURL]/uploads/images/img9.jpg\" alt=\"\" class=\"wojo small-rounded image\">\r\n                <h6 class=\"margin-top\">Ebele Egbuna</h6>\r\n                <p>Support Consultant</p>\r\n            </div>\r\n        </div>\r\n    </div>\r\n</div>\r\n<div class=\"row gutters justify-center\">\r\n    <div class=\"columns screen-70 tablet-80 mobile-100 phone-100\">\r\n        <div class=\"row big-gutters\">\r\n            <div class=\"columns phone-100 center-align\"><img src=\"[SITEURL]/uploads/images/img7.jpg\" alt=\"\" class=\"wojo small-rounded image\">\r\n                <h6 class=\"margin-top\">Maria Powers</h6>\r\n                <p>Director of sales</p>\r\n            </div>\r\n            <div class=\"columns phone-100 center-align\"><img src=\"[SITEURL]/uploads/images/img8.jpg\" alt=\"\" class=\"wojo small-rounded image\">\r\n                <h6 class=\"margin-top\">Delia Pawelke</h6>\r\n                <p>Front-end Developer</p>\r\n            </div>\r\n            <div class=\"columns phone-100 center-align\"><img src=\"[SITEURL]/uploads/images/img6.jpg\" alt=\"\" class=\"wojo small-rounded image\">\r\n                <h6 class=\"margin-top\">Tom Lowry</h6>\r\n                <p>UI/UX Designer</p>\r\n            </div>\r\n        </div>\r\n    </div>\r\n</div>\r\n<div class=\"row gutters justify-center\">\r\n    <div class=\"columns screen-70 tablet-80 mobile-100 phone-100 center-align\"> <img src=\"[SITEURL]/uploads/images/plane.svg\" alt=\"\" class=\"wojo medium inline image\">\r\n        <div class=\"text-size-big margin-top\">We\'re always looking for talented freelancers to work with. Get in touch if you think you’d be a good fit!</div>\r\n    </div>\r\n</div>', 'normal', NULL, '', '', '2017-05-02 03:02:50', 1);
INSERT INTO `pages`
VALUES (3, 'Frequently Asked Questions', 'faq', '<p>Here you can find most common questions regarding DDP</p>', 'faq', NULL, '', '', '2017-05-11 03:02:54', 1);
INSERT INTO `pages`
VALUES (4, 'Contact Us', 'contact-us', '<p class=\"center-aligned\">Fill up the form and hit the \"Send\". One of our representatives will get back to you as soon as possible.</p>\r\n<div class=\"row grid phone-1 mobile-2 tablet-2 screen-2 big-gutters\">\r\n  <div class=\"columns\">\r\n    <i class=\"icon primary large map marker\"></i>\r\n    <div class=\"wojo big space divider\"></div>\r\n    <h4>ADDRESS</h4>\r\n    <div class=\"wojo big space divider\"></div>\r\n    <p>123 Burke Street, Toronto ON<br>\r\n      2MK 1Y0 CANADA</p>\r\n  </div>\r\n  <div class=\"columns\">\r\n    <i class=\"icon primary large phone\"></i>\r\n    <div class=\"wojo big space divider\"></div>\r\n    <h4>PHONE</h4>\r\n    <div class=\"wojo big space divider\"></div>\r\n    <p> +(01) 05-682-0355<br>\r\n      +(01) 95-814-8535 </p>\r\n  </div>\r\n  <div class=\"columns\">\r\n    <i class=\"icon primary large envelope\"></i>\r\n    <div class=\"wojo big space divider\"></div>\r\n    <h4>EMAIL</h4>\r\n    <div class=\"wojo big space divider\"></div>\r\n    <p>info@mycompany.com<br>\r\n      info@mycompany.eu</p>\r\n  </div>\r\n  <div class=\"columns\">\r\n    <i class=\"icon primary large clock\"></i>\r\n    <div class=\"wojo big space divider\"></div>\r\n    <h4>BUSINESS HOURS</h4>\r\n    <div class=\"wojo big space divider\"></div>\r\n    <p> Mon - Fri: 09AM to 06PM<br>\r\n      Sat - Sun: 10AM to 04PM</p>\r\n  </div>\r\n</div>', 'contact', NULL, NULL, NULL, '2017-05-20 03:02:58', 1);
INSERT INTO `pages`
VALUES (5, 'Privacy Policy', 'privacy-policy', '<p>Last updated: October 20. 2017</p>\r\n<p>My Company (\"us\", \"we\", or \"our\") operates <a href=\"https://www.mysite.com\" class=\"redactor-autoparser-object\">https://www.mysite.com</a>  (the\r\n  \"Site\"). This page informs you of our policies regarding the\r\n  collection, use and disclosure of Personal Information we receive from users of\r\n  the Site.</p>\r\n<p>We use your Personal Information only for providing and\r\n  improving the Site. By using the Site, you agree to the collection and use of\r\n  information in accordance with this policy.<br><br></p>\r\n<p><strong>Information\r\n  Collection And Use</strong></p>\r\n<p>While using our Site, we may ask you to provide us with\r\n  certain personally identifiable information that can be used to contact or\r\n  identify you. Personally identifiable information may include, but is not\r\n  limited to your name (\"Personal Information\").<br><br><br></p>\r\n<p><strong>Log Data</strong></p>\r\n<p>Like many site operators, we collect information that your\r\n  browser sends whenever you visit our Site (\"Log Data\").</p>\r\n<p>This Log Data may include information such as your\r\n  computer\'s Internet Protocol (\"IP\") address, browser type, browser\r\n  version, the pages of our Site that you visit, the time and date of your visit,\r\n  the time spent on those pages and other statistics.</p>\r\n<p>In addition, we may use third party services such as Google\r\n  Analytics that collect, monitor and analyze this …<br><br><br></p>\r\n<p><strong>Communications</strong></p>\r\n<p>We may use your Personal Information to contact you with\r\n  newsletters, marketing or promotional materials and other information that ...<br><br><br></p>\r\n<p><strong>Cookies</strong></p>\r\n<p>Cookies are files with small amount of data, which may\r\n  include an anonymous unique identifier. Cookies are sent to your browser from a\r\n  web site and stored on your computer\'s hard drive.</p>\r\n<p>Like many sites, we use \"cookies\" to collect\r\n  information. You can instruct your browser to refuse all cookies or to indicate\r\n  when a cookie is being sent. However, if you do not accept cookies, you may not\r\n  be able to use some portions of our Site.<br><br><br></p>\r\n<p><strong>Security</strong></p>\r\n<p>The security of your Personal Information is important to\r\n  us, but remember that no method of transmission over the Internet, or method of\r\n  electronic storage, is 100% secure. While we strive to use commercially\r\n  acceptable means to protect your Personal Information, we cannot guarantee its\r\n  absolute security.<br><br><br></p>\r\n<p><strong>Changes To This\r\n  Privacy Policy</strong></p>\r\n<p>This Privacy Policy is effective as of (October 20. 2017) and will remain in effect except\r\n  with respect to any changes in its provisions in the future, which will be in\r\n  effect immediately after being posted on this page.</p>\r\n<p>We reserve the right to update or change our Privacy Policy\r\n  at any time and you should check this Privacy Policy periodically. Your\r\n  continued use of the Service after we post any modifications to the Privacy\r\n  Policy on this page will constitute your acknowledgment of the modifications\r\n  and your consent to abide and be bound by the modified Privacy Policy.</p>\r\n<p>If we make any material changes to this Privacy Policy, we\r\n  will notify you either through the email address you have provided us, or by\r\n  placing a prominent notice on our website.<br><br><br></p>\r\n<p><strong>Contact Us</strong></p>\r\n<p>If you have any questions about this Privacy Policy, please\r\n  <a href=\"[SITEURL]/content/contact-us\">contact us.</a></p>', 'privacy', NULL, '', '', '2017-05-29 03:03:02', 1);
INSERT INTO `pages`
VALUES (6, 'VIP Access', 'vip', '<p>Take a look at our vip access packages, and choose the one that best fits your needs...</p>', 'membership', NULL, '', '', '2017-11-13 01:24:44', 1);

--
-- Table structure for table `payments`
--

DROP TABLE IF EXISTS `payments`;
CREATE TABLE IF NOT EXISTS `payments` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `txn_id` varchar(30) DEFAULT NULL,
  `product_id` int(11) unsigned NOT NULL DEFAULT '0',
  `user_id` int(11) unsigned NOT NULL DEFAULT '0',
  `membership_id` int(11) unsigned NOT NULL DEFAULT '0',
  `downloads` smallint(4) unsigned NOT NULL DEFAULT '0',
  `file_date` int(11) unsigned NOT NULL DEFAULT '0',
  `ip` varbinary(16) DEFAULT NULL,
  `qty` tinyint(1) unsigned NOT NULL DEFAULT '1',
  `amount` decimal(12, 2) unsigned NOT NULL DEFAULT '0.00',
  `tax` decimal(12, 2) unsigned NOT NULL DEFAULT '0.00',
  `coupon` decimal(12, 2) unsigned NOT NULL DEFAULT '0.00',
  `total` decimal(12, 2) unsigned NOT NULL DEFAULT '0.00',
  `currency` varchar(4) DEFAULT NULL,
  `cdkey` varchar(60) DEFAULT NULL,
  `pp` varchar(16) DEFAULT NULL,
  `memo` varchar(150) DEFAULT NULL,
  `status` tinyint(1) unsigned NOT NULL DEFAULT '1',
  `created` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `idx_prouct` (`product_id`),
  KEY `idx_user` (`user_id`),
  KEY `idx_membership` (`membership_id`)
  ) ENGINE = MyISAM DEFAULT CHARSET = utf8mb4;

--
-- Table structure for table `privileges`
--

DROP TABLE IF EXISTS `privileges`;
CREATE TABLE IF NOT EXISTS `privileges` (
  `id` smallint(6) UNSIGNED NOT NULL AUTO_INCREMENT,
  `code` varchar(20) NOT NULL,
  `name` varchar(30) NOT NULL,
  `description` varchar(60) DEFAULT NULL,
  `mode` varchar(8) NOT NULL,
  `type` varchar(40) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`)
  ) ENGINE = MyISAM DEFAULT CHARSET = utf8mb4;

--
-- Dumping data for table `privileges`
--

INSERT INTO `privileges`
VALUES (1, 'manage_users', 'Manage Users', 'Permission to add/edit/delete users', 'manage', 'Users');
INSERT INTO `privileges`
VALUES (2, 'manage_files', 'Manage Files', 'Permission to add/edit files', 'manage', 'Files');
INSERT INTO `privileges`
VALUES (3, 'manage_pages', 'Manage Pages', 'Permission to add/edit/delete pages', 'manage', 'Pages');
INSERT INTO `privileges`
VALUES (4, 'manage_backup', 'Manage Backups', 'Permission to create and restore backups', 'manage', 'Backup');
INSERT INTO `privileges`
VALUES (5, 'manage_language', 'Manage Language', 'Permission to translate languages', 'manage', 'Language');
INSERT INTO `privileges`
VALUES (6, 'manage_email', 'Manage Email Templates', 'Permission to manage email tempates', 'manage', 'Emails');
INSERT INTO `privileges`
VALUES (7, 'manage_countries', 'Manage Countries', 'Permission to manage countries', 'manage', 'Countries');
INSERT INTO `privileges`
VALUES (8, 'manage_coupons', 'Manage Coupons', 'Permission to add/edit/delete coupons', 'manage', 'Coupons');
INSERT INTO `privileges`
VALUES (9, 'manage_fields', 'Manage Custom Fields', 'Permission to add/edit/delete custom fields', 'manage', 'Fields');
INSERT INTO `privileges`
VALUES (10, 'manage_newsletter', 'Manage Newstellers', 'Permission to manage newsletter', 'manage', 'Newsletter');
INSERT INTO `privileges`
VALUES (11, 'manage_news', 'Manage News', 'Permission to add/edit/delete news', 'manage', 'News');
INSERT INTO `privileges`
VALUES (12, 'manage_categories', 'Manage Categories', 'Permission to add/edit and delete categories', 'manage', 'Categories');
INSERT INTO `privileges`
VALUES (13, 'manage_menus', 'Manage Menus', 'Permission to add/edit and delete menus', 'manage', 'Menus');
INSERT INTO `privileges`
VALUES (14, 'manage_products', 'Manage Products', 'Permission to add/edit and delete products', 'manage', 'Products');
INSERT INTO `privileges`
VALUES (15, 'manage_faq', 'Manage F.A.Q.', 'Permission to add/edit and delete f.a.q.', 'manage', 'Faq');
INSERT INTO `privileges`
VALUES (16, 'manage_memberships', 'Manage Memberships', 'Permission to add/edit and delete memberships', 'manage', 'Membership');
INSERT INTO `privileges`
VALUES (17, 'manage_blog', 'Manage Blog', 'Permission to add/edit/delete blog', 'manage', 'Blog');


--
-- Table structure for table `products`
--

DROP TABLE IF EXISTS `products`;
CREATE TABLE IF NOT EXISTS `products` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `category_id` int(11) unsigned NOT NULL DEFAULT '0',
  `title` varchar(150) NOT NULL,
  `slug` varchar(150) NOT NULL,
  `price` decimal(12, 2) unsigned NOT NULL DEFAULT '0.00',
  `sprice` decimal(12, 2) unsigned NOT NULL DEFAULT '0.00',
  `is_sale` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `categories` varchar(60) NOT NULL DEFAULT '0',
  `membership_id` varchar(20) NOT NULL DEFAULT '-1',
  `files` varchar(60) NOT NULL DEFAULT '0',
  `body` text,
  `pbody` text,
  `thumb` varchar(50) DEFAULT NULL,
  `tags` varchar(150) DEFAULT NULL,
  `audio` varchar(50) DEFAULT NULL,
  `images` blob,
  `youtube` varchar(200) DEFAULT NULL,
  `affiliate` varchar(150) DEFAULT NULL,
  `type` varchar(10) NOT NULL DEFAULT 'normal',
  `expiry` int(1) NOT NULL DEFAULT '0',
  `expiry_type` varchar(10) DEFAULT 'downs',
  `hits` mediumint(6) NOT NULL DEFAULT '0',
  `likes` int(11) unsigned NOT NULL DEFAULT '0',
  `ratings` int(6) unsigned NOT NULL DEFAULT '0',
  `token` varchar(32) NOT NULL DEFAULT '0',
  `keywords` text,
  `description` text,
  `created` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `lastmodified` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `active` tinyint(1) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `idx_category` (`category_id`),
  KEY `idx_file` (`files`),
  FULLTEXT KEY `idx_body` (`body`),
  FULLTEXT KEY `idx_title` (`title`)
  ) ENGINE = MyISAM DEFAULT CHARSET = utf8mb4;

--
-- Table structure for table `roles`
--

DROP TABLE IF EXISTS `roles`;
CREATE TABLE IF NOT EXISTS `roles` (
  `id` smallint(4) UNSIGNED NOT NULL AUTO_INCREMENT,
  `code` varchar(10) NOT NULL,
  `icon` varchar(20) DEFAULT NULL,
  `name` varchar(30) NOT NULL,
  `description` varchar(200) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`)
  ) ENGINE = MyISAM DEFAULT CHARSET = utf8mb4;

--
-- Dumping data for table `roles`
--

INSERT INTO `roles`
VALUES (1, 'owner', 'badge', 'Site Owner', 'Site Owner is the owner of the site, has all privileges and could not be removed.');
INSERT INTO `roles`
VALUES (2, 'staff', 'trophy', 'Staff Member', 'The &#34;Staff&#34; members  is required to assist the Owner, has different privileges and may be created by Site Owner.');
INSERT INTO `roles`
VALUES (3, 'editor', 'note', 'Editor', 'The &#34;Editor&#34; is required to assist the Staff Members, has different privileges and may be created by Site Owner.');

--
-- Table structure for table `role_privileges`
--

DROP TABLE IF EXISTS `role_privileges`;
CREATE TABLE IF NOT EXISTS `role_privileges` (
  `id` int(11) UNSIGNED NOT NULL AUTO_INCREMENT,
  `rid` int(6) UNSIGNED NOT NULL DEFAULT '0',
  `pid` int(6) UNSIGNED NOT NULL DEFAULT '0',
  `active` tinyint(1) UNSIGNED NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  KEY `idx` (`rid`, `pid`)
  ) ENGINE = MyISAM DEFAULT CHARSET = utf8mb4;

--
-- Dumping data for table `role_privileges`
--

INSERT INTO `role_privileges`
VALUES (1, 1, 1, 1);
INSERT INTO `role_privileges`
VALUES (2, 2, 1, 1);
INSERT INTO `role_privileges`
VALUES (3, 3, 1, 0);
INSERT INTO `role_privileges`
VALUES (4, 1, 2, 1);
INSERT INTO `role_privileges`
VALUES (5, 2, 2, 1);
INSERT INTO `role_privileges`
VALUES (6, 3, 2, 0);
INSERT INTO `role_privileges`
VALUES (7, 1, 3, 1);
INSERT INTO `role_privileges`
VALUES (8, 2, 3, 1);
INSERT INTO `role_privileges`
VALUES (9, 3, 3, 1);
INSERT INTO `role_privileges`
VALUES (10, 1, 4, 1);
INSERT INTO `role_privileges`
VALUES (11, 2, 4, 1);
INSERT INTO `role_privileges`
VALUES (12, 3, 4, 0);
INSERT INTO `role_privileges`
VALUES (13, 1, 5, 1);
INSERT INTO `role_privileges`
VALUES (14, 2, 5, 1);
INSERT INTO `role_privileges`
VALUES (15, 3, 5, 1);
INSERT INTO `role_privileges`
VALUES (16, 1, 6, 1);
INSERT INTO `role_privileges`
VALUES (17, 2, 6, 1);
INSERT INTO `role_privileges`
VALUES (18, 3, 6, 1);
INSERT INTO `role_privileges`
VALUES (19, 1, 7, 1);
INSERT INTO `role_privileges`
VALUES (20, 2, 7, 1);
INSERT INTO `role_privileges`
VALUES (21, 3, 7, 0);
INSERT INTO `role_privileges`
VALUES (22, 1, 8, 1);
INSERT INTO `role_privileges`
VALUES (23, 2, 8, 1);
INSERT INTO `role_privileges`
VALUES (24, 3, 8, 0);
INSERT INTO `role_privileges`
VALUES (25, 1, 9, 1);
INSERT INTO `role_privileges`
VALUES (26, 2, 9, 1);
INSERT INTO `role_privileges`
VALUES (27, 3, 9, 1);
INSERT INTO `role_privileges`
VALUES (28, 1, 10, 1);
INSERT INTO `role_privileges`
VALUES (29, 2, 10, 0);
INSERT INTO `role_privileges`
VALUES (30, 3, 10, 0);
INSERT INTO `role_privileges`
VALUES (31, 1, 11, 1);
INSERT INTO `role_privileges`
VALUES (32, 2, 11, 1);
INSERT INTO `role_privileges`
VALUES (33, 3, 11, 1);
INSERT INTO `role_privileges`
VALUES (34, 1, 12, 1);
INSERT INTO `role_privileges`
VALUES (35, 2, 12, 1);
INSERT INTO `role_privileges`
VALUES (36, 3, 12, 1);
INSERT INTO `role_privileges`
VALUES (37, 1, 13, 1);
INSERT INTO `role_privileges`
VALUES (38, 2, 13, 1);
INSERT INTO `role_privileges`
VALUES (39, 3, 13, 1);
INSERT INTO `role_privileges`
VALUES (40, 1, 14, 1);
INSERT INTO `role_privileges`
VALUES (41, 2, 14, 1);
INSERT INTO `role_privileges`
VALUES (42, 3, 14, 0);
INSERT INTO `role_privileges`
VALUES (43, 1, 15, 1);
INSERT INTO `role_privileges`
VALUES (44, 2, 15, 1);
INSERT INTO `role_privileges`
VALUES (45, 3, 15, 1);
INSERT INTO `role_privileges`
VALUES (46, 1, 16, 1);
INSERT INTO `role_privileges`
VALUES (47, 2, 16, 1);
INSERT INTO `role_privileges`
VALUES (48, 3, 16, 1);
INSERT INTO `role_privileges`
VALUES (49, 1, 17, 1);
INSERT INTO `role_privileges`
VALUES (50, 2, 17, 1);
INSERT INTO `role_privileges`
VALUES (51, 3, 17, 0);

--
-- Table structure for table `settings`
--

DROP TABLE IF EXISTS `settings`;
CREATE TABLE IF NOT EXISTS `settings` (
  `id` tinyint(1) unsigned NOT NULL AUTO_INCREMENT,
  `site_name` varchar(100) NOT NULL,
  `company` varchar(100) NOT NULL,
  `site_dir` varchar(50) DEFAULT NULL,
  `site_email` varchar(50) NOT NULL,
  `color` varchar(16) DEFAULT NULL,
  `theme` varchar(32) NOT NULL,
  `perpage` tinyint(2) unsigned NOT NULL,
  `featured` tinyint(1) unsigned NOT NULL DEFAULT '16',
  `cperpage` tinyint(1) unsigned NOT NULL DEFAULT '16',
  `home_layout` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '0 = grid, 1 = list',
  `backup` varchar(64) NOT NULL,
  `thumb_w` smallint(3) unsigned NOT NULL,
  `thumb_h` smallint(3) unsigned NOT NULL,
  `avatar_w` smallint(2) unsigned NOT NULL,
  `avatar_h` smallint(2) unsigned NOT NULL,
  `short_date` varchar(20) NOT NULL,
  `long_date` varchar(30) NOT NULL,
  `time_format` varchar(10) DEFAULT NULL,
  `calendar_date` varchar(30) DEFAULT NULL,
  `dtz` varchar(120) DEFAULT NULL,
  `locale` varchar(200) DEFAULT NULL,
  `weekstart` tinyint(1) unsigned NOT NULL DEFAULT '1',
  `lang` varchar(2) NOT NULL DEFAULT 'en',
  `lang_list` blob NOT NULL,
  `allow_free` varchar(3) NOT NULL DEFAULT 'yes',
  `enable_comments` tinyint(1) unsigned NOT NULL DEFAULT '1',
  `ploader` tinyint(1) unsigned NOT NULL DEFAULT '1',
  `eucookie` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `offline` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `offline_msg` text,
  `offline_d` date DEFAULT NULL,
  `offline_t` time DEFAULT NULL,
  `logo` varchar(50) DEFAULT NULL,
  `plogo` varchar(50) DEFAULT NULL,
  `currency` varchar(4) DEFAULT NULL,
  `enable_tax` tinyint(1) unsigned NOT NULL DEFAULT '1',
  `tax_rate` float(6, 2) unsigned NOT NULL DEFAULT '0.00',
  `file_dir` varchar(150) DEFAULT NULL,
  `reg_verify` tinyint(1) unsigned NOT NULL DEFAULT '1',
  `auto_verify` tinyint(1) unsigned NOT NULL DEFAULT '1',
  `notify_admin` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `flood` int(3) unsigned NOT NULL DEFAULT '3600',
  `attempt` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `logging` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `analytics` text,
  `mailer` enum ('SMTP','SMAIL') DEFAULT NULL,
  `sendmail` varchar(60) DEFAULT NULL,
  `smtp_host` varchar(150) DEFAULT NULL,
  `smtp_user` varchar(50) DEFAULT NULL,
  `smtp_pass` varchar(50) DEFAULT NULL,
  `smtp_port` varchar(3) DEFAULT NULL,
  `is_ssl` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `inv_info` text,
  `inv_note` text,
  `social_media` blob,
  `page_slugs` blob,
  `mapapi` varchar(120) DEFAULT NULL,
  `wojon` decimal(4, 2) unsigned NOT NULL DEFAULT '0.00',
  `wojov` decimal(4, 2) unsigned NOT NULL DEFAULT '0.00',
  PRIMARY KEY (`id`)
  ) ENGINE = MyISAM DEFAULT CHARSET = utf8mb4;

--
-- Dumping data for table `settings`
--

INSERT INTO `settings`
VALUES (1, 'Your Website', 'Wojoscripts', '', 'info@domain.com', '_default.css', 'modern', 12, 14, 18, 1, '11-Oct-2017_23-52-35.sql', 300, 300, 250, 250, 'dd MMM yyyy', 'MMMM dd, yyyy hh:mm a', 'HH:mm', 'dd-mm-yyyy', 'America/Toronto', 'en_CA', 1, 'en', 0x5b7b226964223a312c226e616d65223a22456e676c697368222c2261626272223a22656e222c226c616e67646972223a226c7472222c22636f6c6f72223a2223374143423935222c22617574686f72223a22687474703a5c2f5c2f7777772e776f6a6f736372697074732e636f6d222c22686f6d65223a317d2c7b226964223a342c226e616d65223a224672656e6368222c2261626272223a226672222c226c616e67646972223a226c7472222c22636f6c6f72223a2223303062636434222c22617574686f72223a22687474703a5c2f5c2f7777772e776f6a6f736372697074732e636f6d222c22686f6d65223a307d5d, 'yes', 1, 0, 0, 0, '<p>Our website is under construction, we are working very hard to give you the best experience on our new web site.</p>', '2023-11-25', '17:19:00', 'logo.svg', 'print_logo.svg', 'CAD', 0, 13.00, 'W:/public_html/ddp5/filedata/', 1, 1, 1, 1800, 3, 1, '', 'SMTP', '/usr/sbin/sendmail -t -i', 'in-v3.mailjet.com', 'ad41526fadcffbd09274ffa586edbc85', '032d482ff40c95c89cb84c265094c50a', '587', 0, '<p><strong>ABC Company Pty Ltd</strong><br>123 Burke Street, Toronto ON, CANADA<br>Tel : (416) 1234-5678, Fax : (416) 1234-5679<br>Email : sales@abc-company.com</p>', '<p>TERMS & CONDITIONS<br>1. Interest may be levied on overdue accounts. <br>2. Goods sold are not returnable or refundable</p>', 0x7b2266616365626f6f6b223a2266616365626f6f6b5f70616765222c2274776974746572223a22747769747465725f70616765227d, 0x7b22686f6d65223a5b7b22706167655f74797065223a22686f6d65227d5d2c22636f6e74616374223a5b7b22706167655f74797065223a22636f6e74616374227d5d2c2270726976616379223a5b7b22706167655f74797065223a2270726976616379227d5d7d, NULL, '1.00', '5.50');

--
-- Table structure for table `trash`
--

DROP TABLE IF EXISTS `trash`;
CREATE TABLE IF NOT EXISTS `trash` (
  `id` int(11) UNSIGNED NOT NULL AUTO_INCREMENT,
  `parent` varchar(15) DEFAULT NULL,
  `parent_id` int(11) UNSIGNED NOT NULL DEFAULT '0',
  `type` varchar(15) DEFAULT NULL,
  `dataset` blob,
  `created` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
  ) ENGINE = MyISAM DEFAULT CHARSET = utf8mb4;

--
-- Table structure for table `users`
--

DROP TABLE IF EXISTS `users`;
CREATE TABLE IF NOT EXISTS `users` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `username` varchar(20) NOT NULL,
  `fname` varchar(64) NOT NULL,
  `lname` varchar(64) NOT NULL,
  `membership_id` smallint(3) unsigned NOT NULL DEFAULT '0',
  `mem_expire` datetime DEFAULT '1970-01-01 00:00:00',
  `downloads` smallint(6) unsigned NOT NULL DEFAULT '0',
  `email` varchar(60) NOT NULL,
  `hash` varchar(70) NOT NULL,
  `token` varchar(40) NOT NULL DEFAULT '0',
  `userlevel` tinyint(1) unsigned NOT NULL DEFAULT '1',
  `sesid` varchar(80) NOT NULL DEFAULT '0',
  `type` varchar(10) NOT NULL DEFAULT 'member',
  `lastlogin` datetime DEFAULT NULL,
  `lastip` varbinary(16) DEFAULT '000.000.000.000',
  `avatar` varchar(50) DEFAULT NULL,
  `address` varchar(100) DEFAULT NULL,
  `city` varchar(50) DEFAULT NULL,
  `state` varchar(50) DEFAULT NULL,
  `zip` varchar(10) DEFAULT NULL,
  `country` varchar(4) DEFAULT NULL,
  `notify` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `access` text,
  `notes` tinytext,
  `info` tinytext,
  `newsletter` tinyint(1) unsigned NOT NULL DEFAULT '1',
  `stripe_cus` varchar(80) DEFAULT NULL,
  `created` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `active` enum('y','n','t','b') NOT NULL DEFAULT 'n',
  PRIMARY KEY (`id`)
  ) ENGINE = MyISAM DEFAULT CHARSET = utf8mb4;

--
-- Table structure for table `wishlist`
--

DROP TABLE IF EXISTS `wishlist`;
CREATE TABLE IF NOT EXISTS `wishlist` (
  `id` int(11) UNSIGNED NOT NULL AUTO_INCREMENT,
  `user_id` int(11) UNSIGNED NOT NULL DEFAULT '0',
  `product_id` int(11) UNSIGNED NOT NULL DEFAULT '0',
  `created` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `idx_user` (`user_id`),
  KEY `idx_product` (`product_id`)
  ) ENGINE = MyISAM DEFAULT CHARSET = utf8mb4;