<?php
   /**
    * _membership_history
    *
    * @package Wojo Framework
    * @author wojoscripts.com
    * @copyright 2023
    * @version 5.50: _membership_history.tpl.php, v1.00 9/19/2023 12:40 PM Gewa Exp $
    *
    */
   if (!defined('_WOJO')) {
      die('Direct access to this location is not allowed.');
   }
?>
<div class="wojo segment margin-bottom">
   <div id="legend" class="wojo small horizontal list"></div>
   <div id="payment_chart" class="height300"></div>
</div>
<?php if ($this->plist): ?>
   <div class="wojo segment">
      <div class="row gutters align-middle">
         <div class="columns">
            <h6 class="text-color-secondary"><?php echo Language::$word->TRANSACTION; ?></h6>
         </div>
         <div class="columns auto">
            <a href="<?php echo ADMINVIEW . '/helper.php?action=exportMembershipPayments&amp;id=' . $this->data->id; ?>" class="wojo small primary button"><?php echo Language::$word->EXPORT; ?></a>
         </div>
      </div>

      <table class="wojo basic responsive table">
         <thead>
         <tr>
            <th data-sort="string"><?php echo Language::$word->USER; ?></th>
            <th data-sort="int"><?php echo Language::$word->TRX_AMOUNT; ?></th>
            <th data-sort="int"><?php echo Language::$word->TRX_TAX; ?></th>
            <th data-sort="int"><?php echo Language::$word->TRX_COUPON; ?></th>
            <th data-sort="int"><?php echo Language::$word->TRX_TOTAMT; ?></th>
            <th data-sort="int"><?php echo Language::$word->CREATED; ?></th>
         </tr>
         </thead>
         <?php foreach ($this->plist as $row): ?>
            <tr>
               <td>
                  <a class="inverted" href="<?php echo Url::url('/admin/users/edit', $row->user_id); ?>"><?php echo $row->name; ?></a>
               </td>
               <td><?php echo $row->amount; ?></td>
               <td><?php echo $row->tax; ?></td>
               <td><?php echo $row->coupon; ?></td>
               <td><?php echo $row->total; ?></td>
               <td data-sort-value="<?php echo strtotime($row->created); ?>"><?php echo Date::doDate('short_date', $row->created); ?></td>
            </tr>
         <?php endforeach; ?>
      </table>
      <div class="wojo secondary passive label"><?php echo Language::$word->TRX_TOTAMT; ?>
         <?php echo Utility::formatMoney(Stats::doArraySum($this->plist, 'total')); ?></div>
   </div>
<?php endif; ?>
<div class="padding-small-horizontal">
   <div class="row gutters align-middle">
      <div class="columns mobile-100 phone-100">
         <div class="text-size-small text-weight-500"><?php echo Language::$word->TOTAL . ': ' . $this->pager->items_total; ?>
            / <?php echo Language::$word->CURPAGE . ': ' . $this->pager->current_page . ' ' . Language::$word->OF . ' ' . $this->pager->num_pages; ?></div>
      </div>
      <div class="columns mobile-100 phone-100 auto"><?php echo $this->pager->display(); ?></div>
   </div>
</div>
<script type="text/javascript" src="<?php echo SITEURL; ?>/assets/morris.min.js"></script>
<script type="text/javascript" src="<?php echo SITEURL; ?>/assets/raphael.min.js"></script>
<script type="text/javascript">
   // <![CDATA[
   $(document).ready(function () {

      $('#payment_chart').parent().addClass('loading');
      $.ajax({
         type: 'GET',
         url: "<?php echo ADMINVIEW . '/helper.php?action=getMembershipPaymentsChart&id=' . $this->data->id;?>&timerange=all",
         dataType: 'json'
      }).done(function (json) {
         let legend = '';
         json.legend.map(function (val) {
            legend += val;
         });
         $('#legend').html(legend);
         Morris.Area({
            element: 'payment_chart',
            data: json.data,
            xkey: 'm',
            ykeys: json.label,
            labels: json.label,
            parseTime: false,
            lineWidth: 1,
            pointSize: 5,
            lineColors: json.color,
            gridTextFamily: 'Wojo Sans',
            gridTextColor: 'rgba(0,0,0,0.6)',
            gridTextSize: 14,
            fillOpacity: '.1',
            hideHover: 'auto',
            preUnits: json.preUnits,
            behaveLikeLine: true,
            hoverCallback: function (index, json, content) {
               let text = $(content)[1].textContent;
               return content.replace(text, text.replace(json.preUnits, ''));
            },
            smooth: true,
            resize: true,
         });
         $('#payment_chart').parent().removeClass('loading');
      });
   });
   // ]]>
</script>
