<?php
   /**
    * _products_history
    *
    * @package Wojo Framework
    * @author wojoscripts.com
    * @copyright 2023
    * @version 5.50: _products_history.tpl.php, v1.00 11/15/2023 11:39 AM Gewa Exp $
    *
    */
   if (!defined('_WOJO')) {
      die('Direct access to this location is not allowed.');
   }
?>
<div class="wojo segment margin-bottom">
   <div id="legend" class="wojo small horizontal list"></div>
   <div id="payment_chart" class="height300"></div>
</div>
<?php if($this->data):?>
   <div class="wojo segment margin-bottom">
      <div class="row gutters align-middle">
         <div class="columns">
            <h6 class="wojo secondary text"><?php echo Language::$word->TRANSACTION;?></h6>
         </div>
         <div class="columns auto"><a href="<?php echo ADMINVIEW . '/helper.php?action=itemPayments&amp;id=' . $this->row->id;?>" class="wojo small secondary button"><?php echo Language::$word->EXPORT;?></a>
         </div>
      </div>
      <table class="wojo responsive basic table">
         <thead>
         <tr>
            <th><?php echo Language::$word->NAME;?></th>
            <th><?php echo Language::$word->TRX_AMOUNT;?></th>
            <th><?php echo Language::$word->TRX_TAX;?></th>
            <th><?php echo Language::$word->TRX_COUPON;?></th>
            <th><?php echo Language::$word->TRX_TOTAMT;?></th>
            <th><?php echo Language::$word->CREATED;?></th>
         </tr>
         </thead>
         <?php $total = 0;?>
         <?php foreach ($this->data as $prow):?>
            <?php $total += $prow->total;?>
            <tr>
               <td><a href="<?php echo Url::url('/admin/users/edit', $prow->user_id);?>"><?php echo $prow->name;?></a></td>
               <td><?php echo $prow->amount;?></td>
               <td><?php echo $prow->tax;?></td>
               <td><?php echo $prow->coupon;?></td>
               <td><?php echo $prow->total;?></td>
               <td><?php echo Date::doDate('short_date', $prow->created);?></td>
            </tr>
         <?php endforeach;?>
      </table>
      <div class="wojo secondary passive label"><?php echo Language::$word->TRX_TOTAMT;?>
         <?php echo Utility::formatMoney($total);?></div>
   </div>
<?php endif;?>
<div class="padding-small-horizontal">
   <div class="row gutters align-middle">
      <div class="columns mobile-100 phone-100">
         <div class="text-size-small text-weight-500"><?php echo Language::$word->TOTAL . ': ' . $this->pager->items_total; ?>
            / <?php echo Language::$word->CURPAGE . ': ' . $this->pager->current_page . ' ' . Language::$word->OF . ' ' . $this->pager->num_pages; ?></div>
      </div>
      <div class="columns mobile-100 phone-100 auto"><?php echo $this->pager->display(); ?></div>
   </div>
</div>
<script src="<?php echo SITEURL;?>/assets/morris.min.js"></script>
<script src="<?php echo SITEURL;?>/assets/raphael.min.js"></script>