<?php
   /**
    * _products_list
    *
    * @package Wojo Framework
    * @author wojoscripts.com
    * @copyright 2023
    * @version 5.50: _products_list.tpl.php, v1.00 11/15/2023 11:40 AM Gewa Exp $
    *
    */
   if (!defined('_WOJO')) {
      die('Direct access to this location is not allowed.');
   }
?>
<div class="row gutters align-middle">
   <div class="columns screen-40 tablet-40 mobile-100">
      <form method="post" id="wojo_form" name="wojo_form" class="wojo form">
         <div class="wojo small action input">
            <input name="find" placeholder="<?php echo Language::$word->SEARCH; ?>" type="text">
            <button class="wojo icon primary inverted button">
               <i class="icon search"></i>
            </button>
         </div>
      </form>
   </div>
   <div class="columns mobile-hide phone-hide"></div>
   <div class="columns auto mobile-50 phone-100">
      <a href="<?php echo Url::url(Router::$path, 'new/'); ?>" class="wojo small secondary fluid button">
         <i class="icon plus alt"></i><?php echo Language::$word->PRD_NEW; ?></a>
   </div>
   <div class="columns auto mobile-50 phone-50">
      <a class="wojo secondary passive inverted small icon button">
         <i class="icon list"></i>
      </a>
      <a href="<?php echo Url::url(Router::$path, 'grid/'); ?>" class="wojo small small primary icon button">
         <i class="icon grid"></i>
      </a>
   </div>
</div>
<div class="center-align">
   <div class="wojo small divided horizontal list">
      <div class="disabled item text-weight-700">
         <?php echo Language::$word->SORTING_O; ?>
      </div>
      <a href="<?php echo Url::url(Router::$path); ?>" class="item<?php echo Url::setActive('order', false); ?>">
         <?php echo Language::$word->RESET; ?>
      </a>
      <a href="<?php echo Url::url(Router::$path, '?order=items|DESC'); ?>"
         class="item<?php echo Url::setActive('order', 'items'); ?>">
         <?php echo Language::$word->PURCHASES; ?>
      </a>
      <a href="<?php echo Url::url(Router::$path, '?order=price|DESC'); ?>"
         class="item<?php echo Url::setActive('order', 'price'); ?>">
         <?php echo Language::$word->PRD_PRICE; ?>
      </a>
      <a href="<?php echo Url::url(Router::$path, '?order=fname|DESC'); ?>"
         class="item<?php echo Url::setActive('order', 'fname'); ?>">
         <?php echo Language::$word->NAME; ?>
      </a>
      <a href="<?php echo Url::sortItems(Url::url(Router::$path), 'order'); ?>" class="item">
         <i class="icon caret <?php echo Url::ascDesc('order'); ?> link"></i>
      </a>
   </div>
</div>
<div class="center-align margin-vertical">
   <?php echo Validator::alphaBits(Url::url(Router::$path)); ?>
</div>
<?php if (!$this->data): ?>
   <div class="center-align">
      <img src="<?php echo ADMINVIEW; ?>/images/notfound.svg" alt="" class="wojo big inline image">
      <div class="margin-small-top">
         <p class="wojo small icon alert inverted attached compact message">
            <i class="icon exclamation triangle"></i><?php echo Language::$word->PRD_EMPTY; ?></p>
      </div>
   </div>
<?php else: ?>
   <?php foreach ($this->data as $row): ?>
      <div class="wojo card" id="item_<?php echo $row->id; ?>">
         <div class="header">
            <div class="row horizontal gutters align top">
               <div class="columns auto phone-100">
                  <a href="<?php echo Url::url(Router::$path, 'edit/' . $row->id); ?>"><img src="<?php echo Product::hasThumb($row->thumb, $row->id); ?>" alt="" class="wojo normal image responsive"></a>
               </div>
               <div class="columns">
                  <p class="text-size-small">
                     <a href="<?php echo Url::url('/admin/categories/edit', $row->category_id); ?>"><?php echo $row->name; ?></a>
                  </p>
                  <h5>
                     <a class="grey" href="<?php echo Url::url(Router::$path, 'edit/' . $row->id); ?>"><?php echo $row->title; ?></a>
                  </h5>
                  <p><?php echo Utility::formatMoney($row->price); ?></p>
               </div>
            </div>
         </div>
         <div class="footer divided">
            <div class="row align-middle">
               <div class="columns">
                  <div class="wojo small divided horizontal block list">
                     <div class="item">
                        <div class="header"><?php echo Language::$word->COMMENTS; ?>
                           <span class="description"><?php echo $row->comments; ?></span>
                        </div>
                     </div>
                     <div class="item">
                        <div class="header"><?php echo Language::$word->PURCHASES; ?>
                           <span class="description"><?php echo ($row->sales > 0)? '<a href="' . Url::url('/admin/products', 'history/' . $row->id) . '">' . $row->sales . '</a>' : '-/-'; ?></span>
                        </div>
                     </div>
                     <div class="item">
                        <div class="header"><?php echo Language::$word->MEMBERSHIP; ?>
                           <span class="description"><?php echo $row->memberships? : '-/-'; ?></span>
                        </div>
                     </div>
                     <div class="item">
                        <div class="header"><?php echo Language::$word->LIKES; ?>
                           <span class="description"><?php echo $row->likes; ?></span>
                        </div>
                     </div>
                  </div>
               </div>
               <div class="columns auto">
                  <a data-wdropdown="#prodDrop_<?php echo $row->id; ?>" class="wojo small primary inverted icon circular button">
                     <i class="icon three dots"></i>
                  </a>
                  <div class="wojo dropdown small pointing top-right" id="prodDrop_<?php echo $row->id; ?>">
                     <a class="item" href="<?php echo Url::url(Router::$path, 'edit/' . $row->id); ?>">
                        <i class="icon pencil"></i>
                        <?php echo Language::$word->EDIT; ?></a>
                     <a class="item" href="<?php echo Url::url('/admin/products', 'history/' . $row->id); ?>">
                        <i class="icon time history"></i>
                        <?php echo Language::$word->HISTORY; ?></a>
                     <div class="divider"></div>
                     <a data-set='{"option":[{"delete":"deleteProduct","title": "<?php echo Validator::sanitize($row->title, 'chars'); ?>","id": "<?php echo $row->id; ?>"}],"action":"delete","parent":"#item_<?php echo $row->id; ?>"}' class="item text-weight-500 data">
                        <i class="icon trash"></i><?php echo Language::$word->DELETE; ?>
                     </a>
                  </div>
               </div>
            </div>
         </div>
      </div>
   <?php endforeach; ?>
<?php endif; ?>
<div class="padding-small-horizontal">
   <div class="row gutters align-middle">
      <div class="columns mobile-100 phone-100">
         <div class="text-size-small text-weight-500"><?php echo Language::$word->TOTAL . ': ' . $this->pager->items_total; ?>
            / <?php echo Language::$word->CURPAGE . ': ' . $this->pager->current_page . ' ' . Language::$word->OF . ' ' . $this->pager->num_pages; ?></div>
      </div>
      <div class="columns mobile-100 phone-100 auto"><?php echo $this->pager->display(); ?></div>
   </div>
</div>