<?php
   /**
    * _user_edit
    *
    * @package Wojo Framework
    * @author wojoscripts.com
    * @copyright 2023
    * @version 5.50: _user_edit.tpl.php, v1.00 11/1/2023 8:07 PM Gewa Exp $
    *
    */
   if (!defined('_WOJO')) {
      die('Direct access to this location is not allowed.');
   }
?>
<form method="post" id="wojo_form" name="wojo_form">
   <div class="wojo segment form">
      <div class="wojo fields align-middle">
         <div class="field four wide labeled">
            <label><?php echo Language::$word->FNAME; ?>
               <i class="icon asterisk"></i>
            </label>
         </div>
         <div class="field">
            <input name="fname" type="text" placeholder="<?php echo Language::$word->FNAME; ?>" value="<?php echo $this->data->fname; ?>">
         </div>
      </div>
      <div class="wojo fields align-middle">
         <div class="field four wide labeled">
            <label><?php echo Language::$word->LNAME; ?>
               <i class="icon asterisk"></i>
            </label>
         </div>
         <div class="field">
            <input name="lname" type="text" placeholder="<?php echo Language::$word->LNAME; ?>" value="<?php echo $this->data->lname; ?>">
         </div>
      </div>
      <div class="wojo fields align-middle">
         <div class="field four wide labeled">
            <label><?php echo Language::$word->EMAIL; ?>
               <i class="icon asterisk"></i>
            </label>
         </div>
         <div class="field">
            <input name="email" type="text" placeholder="<?php echo Language::$word->EMAIL; ?>" value="<?php echo $this->data->email; ?>">
         </div>
      </div>
      <div class="wojo fields align-middle">
         <div class="field four wide labeled">
            <label>
               <?php echo Language::$word->NEWPASS; ?>
               <i class="icon asterisk"></i>
            </label>
         </div>
         <div class="field">
            <input type="text" name="password">
         </div>
      </div>
      <div class="wojo fields align-middle">
         <div class="field four wide labeled">
            <label><?php echo Language::$word->USR_MEMBERSHIP; ?></label>
         </div>
         <div class="field">
            <select name="membership_id">
               <option value="0">-/-</option>
               <?php echo Utility::loopOptions($this->memberships, 'id', 'title', $this->data->membership_id); ?>
            </select>
         </div>
         <div class="field auto">
            <div class="wojo fitted inline toggle checkbox">
               <input name="update_membership" type="checkbox" value="1" id="update_membership">
               <label for="update_membership"><?php echo Language::$word->YES; ?></label>
            </div>
         </div>
      </div>
      <div class="wojo fields align-middle">
         <div class="field four wide labeled">
            <label><?php echo Language::$word->USR_EXTEND; ?></label>
         </div>
         <div class="field">
            <div class="wojo icon input">
               <input placeholder="<?php echo Language::$word->TO; ?>" name="mem_expire" type="text" value="<?php echo Date::doDate('MM/dd/yyyy', Date::numberOfDays('+ 30 day')); ?>" readonly class="datepick">
               <i class="icon date"></i>
            </div>
         </div>
         <div class="field auto">
            <div class="wojo fitted inline toggle checkbox">
               <input name="update_membership" type="checkbox" value="1" id="extend_membership">
               <label for="extend_membership"><?php echo Language::$word->YES; ?></label>
            </div>
         </div>
      </div>
      <div class="padding-top">
         <h5><?php echo Language::$word->CF_TITLE; ?></h5>
         <?php echo $this->custom_fields; ?></div>
      <div class="wojo auto very wide divider"></div>
      <h5><?php echo Language::$word->USR_ADDRESS; ?></h5>
      <div class="wojo fields align-middle">
         <div class="field four wide labeled">
            <label><?php echo Language::$word->ADDRESS; ?></label>
         </div>
         <div class="field">
            <input type="text" placeholder="<?php echo Language::$word->ADDRESS; ?>" name="address" value="<?php echo $this->data->address; ?>">
         </div>
      </div>
      <div class="wojo fields align-middle">
         <div class="field four wide labeled">
            <label><?php echo Language::$word->CITY; ?></label>
         </div>
         <div class="field">
            <input type="text" placeholder="<?php echo Language::$word->CITY; ?>" name="city" value="<?php echo $this->data->city; ?>">
         </div>
      </div>
      <div class="wojo fields align-middle">
         <div class="field four wide labeled">
            <label><?php echo Language::$word->STATE; ?></label>
         </div>
         <div class="field">
            <input type="text" placeholder="<?php echo Language::$word->STATE; ?>" name="state" value="<?php echo $this->data->state; ?>">
         </div>
      </div>
      <div class="wojo fields align-middle">
         <div class="basic field four wide labeled">
            <label><?php echo Language::$word->COUNTRY; ?>/<?php echo Language::$word->ZIP; ?></label>
         </div>
         <div class="basic field">
            <div class="wojo action input">
               <input type="text" placeholder="<?php echo Language::$word->ZIP; ?>" name="zip" value="<?php echo $this->data->zip; ?>">
               <select name="country">
                  <?php echo Utility::loopOptions($this->countries, 'abbr', 'name', $this->data->country); ?>
               </select>
            </div>
         </div>
      </div>
      <div class="wojo auto divider"></div>
      <div class="wojo fields">
         <div class="field">
            <label class="inverted"><?php echo Language::$word->CREATED; ?></label>
            <?php echo Date::doDate('long_date', $this->data->created); ?>
         </div>
         <div class="field">
            <label class="inverted"><?php echo Language::$word->LASTLOGIN; ?></label>
            <?php echo $this->data->lastlogin? Date::doDate('long_date', $this->data->lastlogin) : Language::$word->NEVER; ?>
         </div>
         <div class="field">
            <label class="inverted"><?php echo Language::$word->LASTIP; ?></label>
            <?php echo $this->data->lastip; ?>
         </div>
      </div>
      <div class="wojo auto divider"></div>
      <div class="wojo fields">
         <div class="field">
            <label><?php echo Language::$word->STATUS; ?></label>
            <div class="wojo checkbox radio fitted inline">
               <input name="active" type="radio" value="y" id="active_y" <?php echo Validator::getChecked($this->data->active, 'y'); ?>>
               <label for="active_y"><?php echo Language::$word->ACTIVE; ?></label>
            </div>
            <div class="wojo checkbox radio fitted inline">
               <input name="active" type="radio" value="n" id="active_n" <?php echo Validator::getChecked($this->data->active, 'n'); ?>>
               <label for="active_n"><?php echo Language::$word->INACTIVE; ?></label>
            </div>
            <div class="wojo checkbox radio fitted inline">
               <input name="active" type="radio" value="t" id="active_t" <?php echo Validator::getChecked($this->data->active, 't'); ?>>
               <label for="active_t"><?php echo Language::$word->PENDING; ?></label>
            </div>
            <div class="wojo checkbox radio fitted inline">
               <input name="active" type="radio" value="b" id="active_b" <?php echo Validator::getChecked($this->data->active, 'b'); ?>>
               <label for="active_b"><?php echo Language::$word->BANNED; ?></label>
            </div>
         </div>
      </div>
      <div class="wojo fields">
         <div class="field">
            <label><?php echo Language::$word->USR_TYPE; ?></label>
            <div class="wojo checkbox radio fitted inline">
               <input name="type" type="radio" value="staff" id="staff" <?php echo Validator::getChecked($this->data->type, 'staff'); ?>>
               <label for="staff"><?php echo Language::$word->STAFF; ?></label>
            </div>
            <div class="wojo checkbox radio fitted inline">
               <input name="type" type="radio" value="editor" id="editor" <?php echo Validator::getChecked($this->data->type, 'editor'); ?>>
               <label for="editor"><?php echo Language::$word->EDITOR; ?></label>
            </div>
            <div class="wojo checkbox radio fitted inline">
               <input name="type" type="radio" value="member" id="member" <?php echo Validator::getChecked($this->data->type, 'member'); ?>>
               <label for="member"><?php echo Language::$word->MEMBER; ?></label>
            </div>
         </div>
         <div class="field">
            <label><?php echo Language::$word->USR_NLETTER; ?></label>
            <div class="wojo checkbox radio fitted inline">
               <input name="newsletter" type="radio" value="1" id="newsletter_1" <?php echo Validator::getChecked($this->data->newsletter, 1); ?>>
               <label for="newsletter_1"><?php echo Language::$word->YES; ?></label>
            </div>
            <div class="wojo checkbox radio fitted inline">
               <input name="newsletter" type="radio" value="0" id="newsletter_0" <?php echo Validator::getChecked($this->data->newsletter, 0); ?>>
               <label for="newsletter_0"><?php echo Language::$word->NO; ?></label>
            </div>
         </div>
      </div>
      <div class="wojo fields">
         <div class="field">
            <label><?php echo Language::$word->USR_NOTE; ?></label>
            <textarea placeholder="<?php echo Language::$word->USR_NOTE; ?>" name="notes"><?php echo $this->data->notes; ?></textarea>
         </div>
      </div>
   </div>
   <div class="center-align margin-top">
      <a href="<?php echo Url::url('/admin/users'); ?>"
         class="wojo simple small button"><?php echo Language::$word->CANCEL; ?></a>
      <button type="button" data-action="processUser" name="dosubmit"
              class="wojo primary button"><?php echo Language::$word->USR_UPDATE; ?></button>
   </div>
   <input type="hidden" name="id" value="<?php echo $this->data->id; ?>">
</form>