<?php
   /**
    * _user_history
    *
    * @package Wojo Framework
    * @author wojoscripts.com
    * @copyright 2023
    * @version 5.50: _user_history.tpl.php, v1.00 11/1/2023 8:08 PM Gewa Exp $
    *
    */
   if (!defined('_WOJO')) {
      die('Direct access to this location is not allowed.');
   }
?>
   <div class="wojo segment margin-bottom">
      <div id="legend" class="wojo small horizontal list"></div>
      <div id="payment_chart" class="height300"></div>
   </div>
<?php if ($this->plist): ?>
   <div class="wojo segment">
      <div class="row gutters align-middle">
         <div class="columns">
            <h6 class="text-color-secondary"><?php echo Language::$word->TRANSACTION; ?></h6>
         </div>
         <div class="columns auto">
            <a href="<?php echo ADMINVIEW . '/helper.php?action=exportUserProductPayments&amp;id=' . $this->data->id; ?>" class="wojo small primary button"><?php echo Language::$word->EXPORT; ?></a>
         </div>
      </div>
      <table class="wojo responsive basic table">
         <thead>
         <tr>
            <th><?php echo Language::$word->NAME; ?></th>
            <th><?php echo Language::$word->TRX_AMOUNT; ?></th>
            <th><?php echo Language::$word->TRX_TAX; ?></th>
            <th><?php echo Language::$word->TRX_COUPON; ?></th>
            <th><?php echo Language::$word->TRX_TOTAMT; ?></th>
            <th><?php echo Language::$word->CREATED; ?></th>
            <th class="collapsing"><?php echo Language::$word->STATUS; ?></th>
         </tr>
         </thead>
         <?php $total = 0; ?>
         <?php foreach ($this->plist as $prow): ?>
            <?php $total += $prow->total; ?>
            <tr>
               <td>
                  <a href="<?php echo Url::url('/admin/products/edit', $prow->product_id); ?>"><?php echo $prow->title; ?></a>
               </td>
               <td><?php echo $prow->amount; ?></td>
               <td><?php echo $prow->tax; ?></td>
               <td><?php echo $prow->coupon; ?></td>
               <td><?php echo $prow->total; ?></td>
               <td><?php echo Date::doDate('short_date', $prow->created); ?></td>
               <td class="center aligned"><?php echo Utility::isPublished($prow->status); ?></td>
            </tr>
         <?php endforeach; ?>
      </table>
      <div class="wojo secondary passive label"><?php echo Language::$word->TRX_TOTAMT; ?>
         <?php echo Utility::formatMoney($total); ?></div>
   </div>
<?php endif; ?>
<script type="text/javascript" src="<?php echo SITEURL;?>/assets/morris.min.js"></script>
<script type="text/javascript" src="<?php echo SITEURL;?>/assets/raphael.min.js"></script>
<script type="text/javascript">
   // <![CDATA[
   $(document).ready(function() {
      function getStats(range) {
         $("#payment_chart").parent().addClass('loading');
         $.ajax({
            type: 'GET',
            url: "<?php echo ADMINVIEW . '/helper.php?action=getUserProductPaymentsChart&id=' . $this->data->id;?>&timerange=" + range,
            dataType: 'json'
         }).done(function(json) {
            let legend = '';
            json.legend.map(function(val) {
               legend += val;
            });
            $("#legend").html(legend);
            Morris.Area({
               element: 'payment_chart',
               data: json.data,
               xkey: 'm',
               ykeys: json.label,
               labels: json.label,
               parseTime: false,
               lineWidth: 1,
               pointSize: 5,
               lineColors: json.color,
               gridTextFamily: 'Wojo Sans',
               gridTextColor: "rgba(0,0,0,0.6)",
               gridTextSize: 14,
               fillOpacity: '.1',
               hideHover: 'auto',
               preUnits: json.preUnits,
               behaveLikeLine:true,
               hoverCallback: function(index, json, content) {
                  let text = $(content)[1].textContent;
                  return content.replace(text, text.replace(json.preUnits, ""));
               },
               smooth: true,
               resize: true,
            });
            $("#payment_chart").parent().removeClass('loading');
         });
      }
      getStats('all');
   });
   // ]]>
</script>