<?php
   /**
    * account
    *
    * @package Wojo Framework
    * @author wojoscripts.com
    * @copyright 2023
    * @version 5.50: account.tpl.php, v1.00 8/9/2023 1:54 PM Gewa Exp $
    *
    */
   if (!defined('_WOJO')) {
      die('Direct access to this location is not allowed.');
   }
?>
<?php switch (Url::segment($this->segments)): case 'password': ?>
   <form method="post" id="wojo_form" name="wojo_form">
      <div class="wojo simple segment form">
         <div class="wojo fields align-middle">
            <div class="field four wide labeled">
               <label><?php echo Language::$word->NEWPASS; ?>
                  <i class="icon asterisk"></i>
               </label>
            </div>
            <div class="field">
               <input type="text" name="password">
            </div>
         </div>
         <div class="wojo fields align-middle">
            <div class="field four wide labeled">
               <label><?php echo Language::$word->CONPASS; ?>
                  <i class="icon asterisk"></i>
               </label>
            </div>
            <div class="field">
               <input type="text" name="password2">
            </div>
         </div>
         <div class="center-align">
            <a href="<?php echo Url::url('/admin/account'); ?>"
               class="wojo simple button"><?php echo Language::$word->CANCEL; ?></a>
            <button type="button" data-action="updatePassword" name="dosubmit"
                    class="wojo primary button"><?php echo Language::$word->USR_PASSUPDATE; ?></button>
         </div>
      </div>
   </form>
   <?php break; ?>
<?php default: ?>
   <form method="post" id="wojo_form" name="wojo_form">
      <div class="row gutters">
         <div class="columns mobile-100 mobile-order-2 phone-order-2">
            <div class="wojo simple segment form">
               <div class="wojo fields align-middle">
                  <div class="field four wide labeled">
                     <label><?php echo Language::$word->FNAME; ?>
                        <i class="icon asterisk"></i>
                     </label>
                  </div>
                  <div class="field">
                     <input type="text" value="<?php echo $this->data->fname; ?>" name="fname">
                  </div>
               </div>
               <div class="wojo fields align-middle">
                  <div class="field four wide labeled">
                     <label><?php echo Language::$word->LNAME; ?>
                        <i class="icon asterisk"></i>
                     </label>
                  </div>
                  <div class="field">
                     <input type="text" value="<?php echo $this->data->lname; ?>" name="lname">
                  </div>
               </div>
               <div class="wojo fields align-middle">
                  <div class="field four wide labeled">
                     <label><?php echo Language::$word->EMAIL; ?>
                        <i class="icon asterisk"></i>
                     </label>
                  </div>
                  <div class="field">
                     <input type="text" value="<?php echo $this->data->email; ?>" name="email">
                  </div>
               </div>
               <?php echo $this->custom_fields; ?>
               <div class="wojo fields disabled align-middle">
                  <div class="field four wide labeled">
                     <label><?php echo Language::$word->CREATED; ?></label>
                  </div>
                  <div class="field">
                     <input type="text" value="<?php echo Date::doDate('short_date', $this->data->created); ?>" readonly>
                  </div>
               </div>
               <div class="wojo fields disabled align-middle">
                  <div class="field four wide labeled">
                     <label><?php echo Language::$word->LASTLOGIN; ?></label>
                  </div>
                  <div class="field">
                     <input type="text" value="<?php echo Date::doDate('short_date', $this->data->lastlogin); ?>">
                  </div>
               </div>
               <div class="wojo fields disabled align-middle">
                  <div class="field four wide labeled">
                     <label><?php echo Language::$word->LASTIP; ?></label>
                  </div>
                  <div class="field">
                     <input type="text" value="<?php echo $this->data->lastip; ?>">
                  </div>
               </div>
            </div>
         </div>
         <div class="columns auto mobile-100 phone-100 mobile-order-1 phone-order-1">
            <div class="wojo simple segment form">
               <div class="basic field">
                  <label class="justify-center"><?php echo Language::$word->AVATAR; ?></label>
                  <input type="file" name="avatar" data-type="image"
                         data-exist="<?php echo ($this->data->avatar)? UPLOADURL . '/avatars/' . $this->data->avatar : UPLOADURL . '/avatars/default.svg'; ?>"
                         accept="image/png, image/jpeg">
               </div>
            </div>
         </div>
      </div>
      <div class="center-align">
         <button type="button" data-action="updateAccount" name="dosubmit"
                 class="wojo primary button"><?php echo Language::$word->USR_UPDATE_A; ?></button>
      </div>
   </form>
   <?php break; ?>
<?php endswitch; ?>