<?php
    /**
     * controller
     *
     * @package Wojo Framework
     * @author wojoscripts.com
     * @copyright 2023
     * @version 5.00: controller.php, v1.00 7/23/2023 8:27 AM Gewa Exp $
     *
     */
    const _WOJO = true;
    require_once('../../../init.php');
    
    if (!App::Auth()->is_Admin()) {
        exit;
    }
    
    Bootstrap::autoloader(array(ADMINBASE . '/blog/'));
    
    $delete = Validator::post('delete');
    $trash = Validator::post('trash');
    $gAction = Validator::get('action');
    $pAction = Validator::post('action');
    $iAction = Validator::post('iaction');
    $restore = Validator::post('restore');
    $title = Validator::post('title') ? Validator::sanitize($_POST['title']) : null;
    
    $blog = App::Blog();
    
    /* == Delete == */
    switch ($delete):
        //Delete Item
        case 'deleteItem':
            if (Database::Go()->delete(Blog::mTable)->where('id', Filter::$id, '=')->run()) {
                File::deleteRecursive(FRONTBASE . Blog::BLOGDATA . Filter::$id, true);
                $json['type'] = 'success';
            }
            
            $json['title'] = Language::$word->SUCCESS;
            $json['message'] = str_replace('[NAME]', $title, Language::$word->_MOD_AM_DEL_OK);
            print json_encode($json);
            break;
        
        //Delete Category
        case 'deleteCategory':
            if ($res = Database::Go()->delete(Blog::cTable)->where('id', Filter::$id, '=')->run()) {
                Database::Go()->delete(Blog::cTable)->where('parent_id', Filter::$id, '=')->run();
            }
            $json['menu'] = Blog::getCategoryDropList($blog->categoryTree(), 0, 0, '&#166;&nbsp;&nbsp;&nbsp;&nbsp;');
            
            $json['type'] = 'success';
            $json['title'] = Language::$word->SUCCESS;
            $json['message'] = str_replace('[NAME]', $title, Language::$word->_MOD_AM_CATDEL_OK);
            print json_encode($json);
            break;
    endswitch;
    
    /* == Post Actions == */
    switch ($pAction):
        //Process Item
        case 'processItem':
            $blog->processItem();
            break;
        //Process Category
        case 'processCategory':
            $blog->processCategory();
            break;
        //Process Configuration
        case 'processConfig':
            $blog->processConfig();
            break;
    endswitch;
    
    /* == Instant Actions == */
    switch ($iAction):
        //Sort Categories
        case 'sortCategories':
            $i = 0;
            $query = 'UPDATE `' . Blog::cTable . '` SET `sorting` = CASE ';
            $list = '';
            foreach ($_POST['sorting'] as $item) {
                $i++;
                $query .= ' WHEN id = ' . $item . ' THEN ' . $i . ' ';
                $list .= $item . ',';
            }
            $list = substr($list, 0, -1);
            $query .=
                'END WHERE id IN (' . $list . ')';
            Database::Go()->rawQuery($query)->run();
            break;
    endswitch;