<?php
   /**
    * _edit
    *
    * @package Wojo Framework
    * @author wojoscripts.com
    * @copyright 2023
    * @version 5.50: _edit.tpl.php, v1.00 9/19/2023 12:40 PM Gewa Exp $
    */
   if (!defined('_WOJO')) {
      die('Direct access to this location is not allowed.');
   }
?>
<form method="post" id="wojo_form" name="wojo_form">
   <div class="wojo form segment margin-bottom">
      <div class="wojo fields">
         <div class="field">
            <label><?php echo Language::$word->NAME; ?>
               <i class="icon asterisk"></i>
            </label>
            <input type="text" placeholder="<?php echo Language::$word->NAME; ?>" value="<?php echo $this->data->title; ?>" name="title">
         </div>
         <div class="field">
            <label><?php echo Language::$word->_MOD_AM_SLUG; ?></label>
            <input type="text" placeholder="<?php echo Language::$word->_MOD_AM_SLUG; ?>" value="<?php echo $this->data->slug; ?>" name="slug">
         </div>
      </div>
      <div class="wojo fields">
         <div class="field">
            <textarea class="bodypost" name="body"><?php echo Url::out_url($this->data->body); ?></textarea>
         </div>
      </div>
      <div class="wojo fields">
         <div class="field">
            <label><?php echo Language::$word->METAKEYS; ?></label>
            <textarea class="small" placeholder="<?php echo Language::$word->METAKEYS; ?>" name="keywords"><?php echo $this->data->keywords; ?></textarea>
         </div>
         <div class="field">
            <label><?php echo Language::$word->METADESC; ?></label>
            <textarea class="small" placeholder="<?php echo Language::$word->METADESC; ?>" name="description"><?php echo $this->data->description; ?></textarea>
         </div>
      </div>
   </div>
   <div class="wojo form segment margin-bottom">
      <div class="wojo fields">
         <div class="field">
            <label><?php echo Language::$word->CATEGORIES; ?></label>
            <div class="scrollbox height300 margin-top">
               <div class="wojo relaxed divided list">
                  <?php echo $this->droplist; ?>
               </div>
            </div>
         </div>
         <div class="field">
            <label><?php echo Language::$word->PRD_IMG; ?></label>
            <input type="file" name="thumb" data-type="image" data-exist="<?php echo Blog::hasThumb($this->data->thumb, $this->data->id); ?>" accept="image/png, image/jpeg">
         </div>
      </div>
      <div class="wojo fields">
         <div class="field">
            <label><?php echo Language::$word->_MOD_AM_CREATED; ?></label>
            <div class="wojo checkbox radio fitted inline">
               <input name="show_created" type="radio" value="1" id="show_created_1" <?php echo Validator::getChecked($this->data->show_created, 1); ?>>
               <label for="show_created_1"><?php echo Language::$word->YES; ?></label>
            </div>
            <div class="wojo checkbox radio fitted inline">
               <input name="show_created" type="radio" value="0" id="show_created_0" <?php echo Validator::getChecked($this->data->show_created, 0); ?>>
               <label for="show_created_0"><?php echo Language::$word->NO; ?></label>
            </div>
         </div>
         <div class="field">
            <label><?php echo Language::$word->_MOD_AM_SHARE; ?></label>
            <div class="wojo checkbox radio fitted inline">
               <input name="show_sharing" type="radio" value="1" id="show_sharing_1" <?php echo Validator::getChecked($this->data->show_sharing, 1); ?>>
               <label for="show_sharing_1"><?php echo Language::$word->YES; ?></label>
            </div>
            <div class="wojo checkbox radio fitted inline">
               <input name="show_sharing" type="radio" value="0" id="show_sharing_0" <?php echo Validator::getChecked($this->data->show_sharing, 0); ?>>
               <label for="show_sharing_0"><?php echo Language::$word->NO; ?></label>
            </div>
         </div>
         <div class="field">
            <label><?php echo Language::$word->PUBLISHED; ?></label>
            <div class="wojo checkbox radio fitted inline">
               <input name="active" type="radio" value="1" id="active_1" <?php echo Validator::getChecked($this->data->active, 1); ?>>
               <label for="active_1"><?php echo Language::$word->YES; ?></label>
            </div>
            <div class="wojo checkbox radio fitted inline">
               <input name="active" type="radio" value="0" id="active_0" <?php echo Validator::getChecked($this->data->active, 0); ?>>
               <label for="active_0"><?php echo Language::$word->NO; ?></label>
            </div>
         </div>
      </div>
   </div>
   <div class="center-align">
      <a href="<?php echo Url::url('/admin', 'blog/'); ?>" class="wojo simple button"><?php echo Language::$word->CANCEL; ?></a>
      <button type="button" data-url="blog" data-action="processItem" name="dosubmit" class="wojo primary button"><?php echo Language::$word->_MOD_AM_UPDATEITM; ?></button>
   </div>
   <input type="hidden" name="id" value="<?php echo $this->data->id; ?>">
</form>