<?php
   /**
    * Blog
    *
    * @package Wojo Framework
    * @author wojoscripts.com
    * @copyright 2020
    * @version $Id: _list.tpl.php, v1.00 2020-01-08 10:12:05 gewa Exp $
    */
   if (!defined('_WOJO')) {
      die('Direct access to this location is not allowed.');
   }
?>
<div class="row gutters align-middle justify-end">
   <div class="columns auto mobile-100 phone-100">
      <a href="<?php echo Url::url(Router::$path, 'new/'); ?>" class="wojo small secondary stacked button">
         <i class="icon plus alt"></i><?php echo Language::$word->_MOD_AM_NEW; ?></a>
      <a data-wdropdown="#dropdown-blogMenu" class="wojo small white icon button">
         <i class="icon three dots"></i>
      </a>
      <div class="wojo small dropdown menu top-right" id="dropdown-blogMenu">
         <a class="item" href="<?php echo Url::url(Router::$path, 'settings/'); ?>">
            <i class="icon sliders horizontal"></i>
            <?php echo Language::$word->SETTINGS; ?></a>
         <a class="item" href="<?php echo Url::url(Router::$path, 'categories/'); ?>">
            <i class="icon unordered list"></i>
            <?php echo Language::$word->CATEGORIES; ?></a>
      </div>
   </div>
</div>
<div class="row gutters justify-center">
   <div class="columns screen-40 tablet-50 mobile-100 phone-100">
      <form method="post" id="wojo_form" name="wojo_form" class="wojo form">
         <div class="wojo action input">
            <input name="find" placeholder="<?php echo Language::$word->SEARCH; ?>" type="text">
            <button class="wojo small icon primary inverted button">
               <i class="icon search"></i>
            </button>
         </div>
      </form>
   </div>
</div>
<div class="center-align">
   <div class="wojo small divided horizontal list">
      <div class="disabled item text-weight-700">
         <?php echo Language::$word->SORTING_O; ?>
      </div>
      <a href="<?php echo Url::url(Router::$path); ?>" class="item<?php echo Url::setActive('order', false); ?>">
         <?php echo Language::$word->RESET; ?>
      </a>
      <a href="<?php echo Url::url(Router::$path, '?order=hits|DESC'); ?>"
         class="item<?php echo Url::setActive('order', 'hits'); ?>">
         <?php echo Language::$word->_MOD_AM_HITS; ?>
      </a>
      <a href="<?php echo Url::url(Router::$path, '?order=category_id|DESC'); ?>"
         class="item<?php echo Url::setActive('order', 'category_id'); ?>">
         <?php echo Language::$word->CATEGORY; ?>
      </a>
      <a href="<?php echo Url::url(Router::$path, '?order=title|DESC'); ?>"
         class="item<?php echo Url::setActive('order', 'title'); ?>">
         <?php echo Language::$word->NAME; ?>
      </a>
      <a href="<?php echo Url::url(Router::$path, '?order=active|DESC'); ?>"
         class="item<?php echo Url::setActive('order', 'active'); ?>">
         <?php echo Language::$word->PUBLISHED; ?>
      </a>
      <a href="<?php echo Url::sortItems(Url::url(Router::$path), 'order'); ?>" class="item">
         <i class="icon caret <?php echo Url::ascDesc('order'); ?> link"></i>
      </a>
   </div>
</div>
<div class="center-align margin-vertical">
   <?php echo Validator::alphaBits(Url::url(Router::$path)); ?>
</div>
<?php if (!$this->data): ?>
   <div class="center-align">
      <img src="<?php echo ADMINVIEW; ?>/images/notfound.svg" alt="" class="wojo big inline image">
      <div class="margin-small-top">
         <p class="wojo small icon alert inverted attached compact message">
            <i class="icon exclamation triangle"></i><?php echo Language::$word->_MOD_AM_NOARTICLE; ?></p>
      </div>
   </div>
<?php else: ?>
<div class="row grid screen-2 tablet-1 mobile-1 phone-1 gutters">
   <?php foreach ($this->data as $row): ?>
      <div class="columns" id="item_<?php echo $row->id; ?>">
         <div class="wojo attached full card">
         <div class="header">
            <div class="row horizontal gutters align top">
               <div class="columns auto phone-100">
                  <a href="<?php echo Url::url(Router::$path, 'edit/' . $row->id); ?>">
                     <img src="<?php echo Blog::hasThumb($row->thumb, $row->id); ?>" alt="" class="wojo normal image responsive">
                  </a>
               </div>
               <div class="columns">
                  <p class="text-size-small">
                     <a href="<?php echo Url::url('/admin/blog/category', $row->category_id); ?>"><?php echo $row->name; ?></a>
                  </p>
                  <h5>
                     <a class="grey" href="<?php echo Url::url(Router::$path, 'edit/' . $row->id); ?>"><?php echo $row->title; ?></a>
                  </h5>
               </div>
            </div>
         </div>
         <div class="footer divided">
            <div class="row align-middle">
               <div class="columns phone-100">
                  <div class="wojo small divided horizontal block list">
                     <div class="item">
                        <span class="text-weight-500"><?php echo Language::$word->_MOD_AM_HITS; ?></span>
                        <span class="description"><?php echo $row->hits; ?></span>
                     </div>
                     <div class="item">
                        <span class="text-weight-500"><?php echo Language::$word->PUBLISHED; ?></span>
                        <span class="description"><?php echo Utility::isPublished($row->active); ?></span>
                     </div>
                  </div>
               </div>
               <div class="columns auto phone-100">
                  <a class="wojo small primary inverted icon button" href="<?php echo Url::url('/admin/blog/edit', $row->id); ?>">
                     <i class="icon pencil"></i>
                  </a>
                  <a data-set='{"option":[{"delete": "deleteItem","title": "<?php echo Validator::sanitize($row->title, 'chars'); ?>","id":<?php echo $row->id; ?>}],"action":"delete","parent":"#item_<?php echo $row->id; ?>","url":"blog/controller.php"}' class="wojo small negative inverted icon button data">
                     <i class="icon trash"></i>
                  </a>
               </div>
            </div>
         </div>
      </div></div>
   <?php endforeach; ?>
</div>
<?php endif; ?>
<div class="padding-small-horizontal">
   <div class="row gutters align-middle">
      <div class="columns mobile-100 phone-100">
         <div class="text-size-small text-weight-500"><?php echo Language::$word->TOTAL . ': ' . $this->pager->items_total; ?>
            / <?php echo Language::$word->CURPAGE . ': ' . $this->pager->current_page . ' ' . Language::$word->OF . ' ' . $this->pager->num_pages; ?></div>
      </div>
      <div class="columns mobile-100 phone-100 auto"><?php echo $this->pager->display(); ?></div>
   </div>
</div>