<?php
   /**
    * settings
    *
    * @package Wojo Framework
    * @author wojoscripts.com
    * @copyright 2023
    * @version 5.50: settings.tpl.php, v1.00 9/19/2023 12:40 PM Gewa Exp $
    */
   if (!defined('_WOJO')) {
      die('Direct access to this location is not allowed.');
   }
?>
<form method="post" id="wojo_form" name="wojo_form">
   <div class="wojo form segment margin-bottom">
      <div class="wojo fields">
         <div class="field">
            <label><?php echo Language::$word->_MOD_AM_LATEST; ?>
               <i class="icon asterisk"></i>
            </label>
            <input name="fperpage" type="range" min="5" max="20" step="1" value="<?php echo $this->data->fperpage; ?>" hidden data-suffix=" itm">
         </div>
      </div>
      <div class="wojo fields">
         <div class="field">
            <label><?php echo Language::$word->_MOD_AM_THUMB_W; ?>
               <i class="icon asterisk"></i>
            </label>
            <input name="thumb_w" type="range" min="100" max="800" step="20" value="<?php echo $this->data->thumb_w; ?>" hidden data-suffix=" px">
         </div>
         <div class="field">
            <label><?php echo Language::$word->_MOD_AM_THUMB_H; ?>
               <i class="icon asterisk"></i>
            </label>
            <input name="thumb_h" type="range" min="100" max="800" step="20" value="<?php echo $this->data->thumb_h; ?>" hidden data-suffix=" px">
         </div>
      </div>
   </div>
   <div class="center-align">
      <a href="<?php echo Url::url('/admin', 'blog/'); ?>" class="wojo simple button"><?php echo Language::$word->CANCEL; ?></a>
      <button type="button" data-url="blog" data-action="processConfig" name="dosubmit" class="wojo primary button"><?php echo Language::$word->CONF_UPDATE; ?></button>
   </div>
</form>