(function ($) {
   'use strict';
   $.Blog = function (settings) {
      let config = {
         url: '',
         aurl: '',
         lang: {
            delMsg3: '',
            delMsg8: '',
            canBtn: '',
            trsBtn: '',
            err: '',
            err1: ''
         }
      };

      if (settings) {
         $.extend(config, settings);
      }

      // sort categories
      if ($.inArray('category', $.url().segment()) !== -1 || $.inArray('categories', $.url().segment()) !== -1) {
         // sort categories
         $('#sortlist > ul > li:has(> ul)').addClass('parent');
         $('#sortlist > ul > li.parent > .content .handle').after('<div class="arrow"><i class="icon chevron down"></i></div>');
         $('#sortlist .arrow').on('click', function () {
            $(this).find('.icon').toggleClass('down up');
            const parent = $(this).closest('li');
            $(parent).children('ul').fadeToggle(150);
            event.preventDefault()
         });

         $('.wojo.nestable').sortable({
            group: 'nested',
            animation: 150,
            fallbackOnBody: true,
            swapThreshold: 0.65,
            handle: '.handle',
            ghostClass: 'ghost',
            onUpdate: function () {
               const items = this.toArray();
               $.ajax({
                  cache: false,
                  type: 'post',
                  url: config.url,
                  dataType: 'json',
                  data: {
                     iaction: 'sortCategories',
                     sorting: items
                  }
               });
            },
         });
      }
   };
})(jQuery);