<?php
   /**
    * category
    *
    * @package Wojo Framework
    * @author wojoscripts.com
    * @copyright 2023
    * @version 5.50: category.tpl.php, v1.00 7/29/2023 1:15 PM Gewa Exp $
    *
    */
   if (!defined('_WOJO')) {
      die('Direct access to this location is not allowed.');
   }

   if (!Auth::hasPrivileges('manage_categories')): print Message::msgError(Language::$word->NOACCESS);
      return; endif;
?>
<?php switch (Url::segment($this->segments)): case 'edit': ?>
   <form method="post" id="wojo_form" name="wojo_form">
      <div class="wojo segment form margin-bottom">
         <div class="wojo fields">
            <div class="field five wide">
               <label><?php echo Language::$word->NAME; ?>
                  <i class="icon asterisk"></i>
               </label>
               <input type="text" placeholder="<?php echo Language::$word->NAME; ?>" name="name" value="<?php echo $this->data->name; ?>">
            </div>
            <div class="field five wide">
               <label><?php echo Language::$word->CT_SLUG; ?></label>
               <input type="text" placeholder="<?php echo Language::$word->CT_SLUG; ?>" name="slug" value="<?php echo $this->data->slug; ?>">
            </div>
         </div>
         <div class="wojo fields">
            <div class="field">
               <label><?php echo Language::$word->CT_PARENT; ?></label>
               <select id="parent_id" name="parent_id">
                  <option value="0"><?php echo Language::$word->CT_TOP; ?></option>
                  <?php echo $this->droplist; ?>
               </select>
            </div>
            <div class="field">
               <label><?php echo Language::$word->PUBLISHED; ?></label>
               <div class="wojo checkbox radio fitted inline">
                  <input name="active" type="radio" value="1" id="active_1" <?php echo Validator::getChecked($this->data->active, 1); ?>>
                  <label for="active_1"><?php echo Language::$word->YES; ?></label>
               </div>
               <div class="wojo checkbox radio fitted inline">
                  <input name="active" type="radio" value="0" id="active_0" <?php echo Validator::getChecked($this->data->active, 0); ?>>
                  <label for="active_0"><?php echo Language::$word->NO; ?></label>
               </div>
            </div>
         </div>
         <div class="wojo fields">
            <div class="field">
               <label><?php echo Language::$word->DESCRIPTION; ?></label>
               <textarea class="small" placeholder="<?php echo Language::$word->DESCRIPTION; ?>" name="body"><?php echo Url::out_url($this->data->body); ?></textarea>
            </div>
         </div>
         <div class="wojo fields">
            <div class="field">
               <label><?php echo Language::$word->METAKEYS; ?></label>
               <textarea class="small" placeholder="<?php echo Language::$word->METAKEYS; ?>" name="keywords"><?php echo $this->data->keywords; ?></textarea>
            </div>
            <div class="field">
               <label><?php echo Language::$word->METADESC; ?>
               </label>
               <textarea class="small" placeholder="<?php echo Language::$word->METADESC; ?>" name="description"><?php echo $this->data->description; ?></textarea>
            </div>
         </div>
      </div>
      <div id="sortlist" class="nestable">
         <?php if ($this->droplist) : echo $this->sortlist; endif; ?>
      </div>
      <div class="center-align margin-top">
         <a href="<?php echo Url::url('/admin/categories'); ?>" class="wojo simple small button"><?php echo Language::$word->CANCEL; ?></a>
         <button type="button" data-action="processCategory" name="dosubmit" class="wojo primary button"><?php echo Language::$word->CT_UPDATE; ?></button>
      </div>
      <input type="hidden" name="id" value="<?php echo $this->data->id; ?>">
   </form>
   <?php break; ?>
<?php default: ?>
   <form method="post" id="wojo_form" name="wojo_form">
      <div class="wojo segment form margin-bottom">
         <div class="wojo fields">
            <div class="field five wide">
               <label><?php echo Language::$word->NAME; ?>
                  <i class="icon asterisk"></i>
               </label>
               <input type="text" placeholder="<?php echo Language::$word->NAME; ?>" name="name">
            </div>
            <div class="field five wide">
               <label><?php echo Language::$word->CT_SLUG; ?></label>
               <input type="text" placeholder="<?php echo Language::$word->CT_SLUG; ?>" name="slug">
            </div>
         </div>
         <div class="wojo fields">
            <div class="field">
               <label><?php echo Language::$word->CT_PARENT; ?></label>
               <select id="parent_id" name="parent_id">
                  <option value="0"><?php echo Language::$word->CT_TOP; ?></option>
                  <?php echo $this->droplist; ?>
               </select>
            </div>
            <div class="field">
               <label><?php echo Language::$word->PUBLISHED; ?></label>
               <div class="wojo checkbox radio fitted inline">
                  <input name="active" type="radio" value="1" id="active_1" checked="checked">
                  <label for="active_1"><?php echo Language::$word->YES; ?></label>
               </div>
               <div class="wojo checkbox radio fitted inline">
                  <input name="active" type="radio" value="0" id="active_0">
                  <label for="active_0"><?php echo Language::$word->NO; ?></label>
               </div>
            </div>
         </div>
         <div class="wojo fields">
            <div class="field">
               <label><?php echo Language::$word->DESCRIPTION; ?></label>
               <textarea class="small" placeholder="<?php echo Language::$word->DESCRIPTION; ?>" name="body"></textarea>
            </div>
         </div>
         <div class="wojo fields">
            <div class="field">
               <label><?php echo Language::$word->METAKEYS; ?></label>
               <textarea class="small" placeholder="<?php echo Language::$word->METAKEYS; ?>" name="keywords"></textarea>
            </div>
            <div class="field">
               <label><?php echo Language::$word->METADESC; ?>
               </label>
               <textarea class="small" placeholder="<?php echo Language::$word->METADESC; ?>" name="description"></textarea>
            </div>
         </div>
      </div>
      <div id="sortlist" class="nestable">
         <?php if ($this->droplist) : echo $this->sortlist; endif; ?>
      </div>
      <div class="center-align margin-top">
         <button type="button" data-action="processCategory" name="dosubmit"
                 class="wojo primary button"><?php echo Language::$word->CT_CREATE; ?></button>
      </div>
   </form>
   <?php break; ?>
<?php endswitch; ?>
<script src="<?php echo SITEURL; ?>/assets/sortable.js"></script>
<script src="<?php echo ADMINVIEW; ?>/js/categories.js"></script>
<script type="text/javascript">
   // <![CDATA[
   $(document).ready(function () {
      $.Categories({
         url: "<?php echo ADMINVIEW;?>",
         lang: {
            delMsg3: "<?php echo Language::$word->TRASH;?>",
            delMsg8: "<?php echo Language::$word->DELCONFIRM3;?>",
            canBtn: "<?php echo Language::$word->CANCEL;?>",
            trsBtn: "<?php echo Language::$word->MTOTRASH;?>",
         }
      });
   });
   // ]]>
</script>
