<?php
   /**
    * comment
    *
    * @package Wojo Framework
    * @author wojoscripts.com
    * @copyright 2023
    * @version 5.50: comment.tpl.php, v1.00 8/2/2023 11:44 AM Gewa Exp $
    *
    */
   if (!defined('_WOJO')) {
      die('Direct access to this location is not allowed.');
   }

   if (!Auth::checkAcl('owner')) : print Message::msgError(Language::$word->NOACCESS);
      return; endif;
?>
<?php switch (Url::segment($this->segments)): case 'edit': ?>
   <form method="post" id="wojo_form" name="wojo_form">
      <div class="wojo segment form margin-bottom">
         <div class="wojo fields">
            <div class="field">
               <label><?php echo Language::$word->CMT_NAMEREQ; ?></label>
               <div class="wojo checkbox radio inline">
                  <input name="name_req" type="radio" value="1" <?php echo Validator::getChecked($this->row->name_req, 1); ?> id="name_req_1">
                  <label for="name_req_1"><?php echo Language::$word->YES; ?></label>
               </div>
               <div class="wojo checkbox radio inline">
                  <input name="name_req" type="radio" value="0" <?php echo Validator::getChecked($this->row->name_req, 0); ?> id="name_req_0">
                  <label for="name_req_0"><?php echo Language::$word->NO; ?></label>
               </div>
            </div>
            <div class="field">
               <label><?php echo Language::$word->CMT_RATING; ?></label>
               <div class="wojo checkbox radio inline">
                  <input name="rating" type="radio" value="1" <?php echo Validator::getChecked($this->row->rating, 1); ?> id="rating_1">
                  <label for="rating_1"><?php echo Language::$word->YES; ?></label>
               </div>
               <div class="wojo checkbox radio inline">
                  <input name="rating" type="radio" value="0" <?php echo Validator::getChecked($this->row->rating, 0); ?> id="rating_0">
                  <label for="rating_0"><?php echo Language::$word->NO; ?></label>
               </div>
            </div>
            <div class="field">
               <label><?php echo Language::$word->CMT_SHOWCAP; ?></label>
               <div class="wojo checkbox radio inline">
                  <input name="show_captcha" type="radio" value="1" <?php echo Validator::getChecked($this->row->show_captcha, 1); ?> id="show_captcha_1">
                  <label for="show_captcha_1"><?php echo Language::$word->YES; ?></label>
               </div>
               <div class="wojo checkbox radio inline">
                  <input name="show_captcha" type="radio" value="0" <?php echo Validator::getChecked($this->row->show_captcha, 0); ?> id="show_captcha_0">
                  <label for="show_captcha_0"><?php echo Language::$word->NO; ?></label>
               </div>
            </div>
         </div>
         <div class="wojo fields">
            <div class="field">
               <label><?php echo Language::$word->CMT_AUTOA; ?></label>
               <div class="wojo checkbox radio inline">
                  <input name="auto_approve" type="radio" value="1" <?php echo Validator::getChecked($this->row->auto_approve, 1); ?> id="auto_approve_1">
                  <label for="auto_approve_1"><?php echo Language::$word->YES; ?></label>
               </div>
               <div class="wojo checkbox radio inline">
                  <input name="auto_approve" type="radio" value="0" <?php echo Validator::getChecked($this->row->auto_approve, 0); ?> id="auto_approve_0">
                  <label for="auto_approve_0"><?php echo Language::$word->NO; ?></label>
               </div>
            </div>
            <div class="field">
               <label><?php echo Language::$word->CMT_PUBLIC; ?></label>
               <div class="wojo checkbox radio inline">
                  <input name="public_access" type="radio" value="1" <?php echo Validator::getChecked($this->row->public_access, 1); ?> id="public_access_1">
                  <label for="public_access_1"><?php echo Language::$word->YES; ?></label>
               </div>
               <div class="wojo checkbox radio inline">
                  <input name="public_access" type="radio" value="0" <?php echo Validator::getChecked($this->row->public_access, 0); ?> id="public_access_0">
                  <label for="public_access_0"><?php echo Language::$word->NO; ?></label>
               </div>
            </div>
            <div class="field">
               <label><?php echo Language::$word->CMT_NOTIFY; ?></label>
               <div class="wojo checkbox radio inline">
                  <input name="notify_new" type="radio" value="1" <?php echo Validator::getChecked($this->row->notify_new, 1); ?> id="notify_new_1">
                  <label for="notify_new_1"><?php echo Language::$word->YES; ?></label>
               </div>
               <div class="wojo checkbox radio inline">
                  <input name="notify_new" type="radio" value="0" <?php echo Validator::getChecked($this->row->notify_new, 0); ?> id="notify_new_0">
                  <label for="notify_new_0"><?php echo Language::$word->NO; ?></label>
               </div>
            </div>
         </div>
         <div class="wojo fields">
            <div class="field">
               <label><?php echo Language::$word->CMT_SINCE; ?></label>
               <div class="wojo checkbox radio inline fitted">
                  <input name="timesince" type="radio" value="1" <?php echo Validator::getChecked($this->row->timesince, 1); ?> id="timesince_1">
                  <label for="timesince_1"><?php echo Language::$word->YES; ?></label>
               </div>
               <div class="wojo checkbox radio inline fitted">
                  <input name="timesince" type="radio" value="0" <?php echo Validator::getChecked($this->row->timesince, 0); ?> id="timesince_0">
                  <label for="timesince_0"><?php echo Language::$word->NO; ?></label>
               </div>
            </div>
            <div class="field">
               <label><?php echo Language::$word->CMT_DATEFORMAT; ?></label>
               <select name="dateformat">
                  <?php echo Date::getShortDate($this->row->dateformat); ?>
                  <?php echo Date::getLongDate($this->row->dateformat); ?>
               </select>
            </div>
            <div class="field">
               <label><?php echo Language::$word->CMT_SORTING; ?></label>
               <select name="sorting">
                  <option value="DESC" <?php echo Validator::getSelected($this->row->sorting, 'DESC'); ?>><?php echo Language::$word->CMT_SORTING_T; ?></option>
                  <option value="ASC" <?php echo Validator::getSelected($this->row->sorting, 'ASC'); ?>><?php echo Language::$word->CMT_SORTING_B; ?></option>
               </select>
            </div>
         </div>
         <div class="wojo fields">
            <div class="field">
               <label><?php echo Language::$word->CMT_CHARS; ?></label>
               <input name="char_limit" type="range" min="20" max="400" step="10" value="<?php echo $this->row->char_limit; ?>" hidden data-suffix=" char" data-type="labels" data-labels="20,50,100,200,400">
            </div>
            <div class="field">
               <label><?php echo Language::$word->CMT_CPP; ?></label>
               <input name="perpage" type="range" min="5" max="50" step="5" value="<?php echo $this->row->perpage; ?>" hidden data-suffix=" itm" data-type="labels" data-labels="5,20,35,50">
            </div>
         </div>
         <div class="wojo fields">
            <div class="field">
               <label><?php echo Language::$word->CMT_BLACK; ?></label>
               <textarea placeholder="<?php echo Language::$word->CMT_BLACK; ?>" name="blacklist_words"><?php echo $this->row->blacklist_words; ?></textarea>
            </div>
         </div>
      </div>
      <div class="center-align">
         <button type="button" data-action="commentConfig" name="dosubmit" class="wojo primary button"><?php echo Language::$word->CMT_UPDATE; ?></button>
      </div>
   </form>
   <?php break; ?>
<?php default: ?>
   <div class="row gutters justify-end">
      <div class="columns auto mobile-100 phone-100">
         <a href="<?php echo Url::url(Router::$path, 'edit/'); ?>" class="wojo icon primary button">
            <i class="icon gears"></i>
         </a>
      </div>
   </div>
   <?php if (!$this->data): ?>
      <div class="center-align">
         <img src="<?php echo ADMINVIEW; ?>/images/notfound.svg" alt="" class="wojo big inline image">
         <div class="margin-small-top">
            <p class="wojo small icon alert inverted attached compact message">
               <i class="icon exclamation triangle"></i><?php echo Language::$word->CMT_EMPTY; ?></p>
         </div>
      </div>
   <?php else: ?>
      <?php foreach ($this->data as $row): ?>
         <div class="wojo simple segment margin-bottom" id="item_<?php echo $row->id; ?>">
            <div class="row">
               <div class="columns mobile-100 phone-order-2">
                  <p class="text-weight-500 text-size-medium">
                     <?php echo ($row->uname)? : $row->username; ?>
                  </p>
                  <div class="text-size-small"><?php echo $row->body; ?></div>
                  <span class="text-size-tiny text-weight-600 uppercase-text"><?php echo Date::doDate('long_date', $row->created); ?></span>
               </div>
               <div class="columns auto phone-100 right-align">
                  <a data-set='{"option":[{"iaction":"commentApprove", "id":<?php echo $row->id; ?>}], "url":"/helper.php", "complete":"remove", "parent":"#item_<?php echo $row->id; ?>"}' data-tooltip="<?php echo Language::$word->APPROVE; ?>" class="wojo small icon button primary inverted iaction">
                     <i class="icon check"></i>
                  </a>
                  <a data-set='{"option":[{"delete": "deleteComment","title": "ID","id":<?php echo $row->id; ?>}],"action":"delete","parent":"#item_<?php echo $row->id; ?>"}' class="wojo small icon button negative inverted data">
                     <i class="icon trash"></i>
                  </a>
               </div>
            </div>
         </div>
      <?php endforeach; ?>
   <?php endif; ?>
   <div class="margin-top padding-small-horizontal">
      <div class="row gutters align-middle">
         <div class="columns mobile-100 phone-100">
            <div class="text-size-small text-weight-500"><?php echo Language::$word->TOTAL . ': ' . $this->pager->items_total; ?>
               / <?php echo Language::$word->CURPAGE . ': ' . $this->pager->current_page . ' ' . Language::$word->OF . ' ' . $this->pager->num_pages; ?></div>
         </div>
         <div class="columns mobile-100 phone-100 auto"><?php echo $this->pager->display(); ?></div>
      </div>
   </div>
   <?php break; ?>
<?php endswitch; ?>