<?php
    /**
     * controller
     *
     * @package Wojo Framework
     * @author wojoscripts.com
     * @copyright 2023
     * @version 5.00: controller.php, v1.00 7/23/2023 8:27 AM Gewa Exp $
     *
     */
    const _WOJO = true;
    require_once('../../init.php');
    
    if (!App::Auth()->is_Admin()) {
        exit;
    }
    
    $delete = Validator::post('delete');
    $trash = Validator::post('trash');
    $action = Validator::post('action');
    $restore = Validator::post('restore');
    $title = Validator::post('title') ? Validator::sanitize($_POST['title']) : null;
    
    $content = App::Content();
    $admin = App::Admin();
    $product = App::Product();
    $membership = App::Membership();
    $user = App::User();
    $core = App::Core();
    
    switch ($action):
        //Process Menu
        case 'processMenu':
            $content->processMenu();
            break;
        
        //Process Page
        case 'processPage':
            $content->processPage();
            break;
        
        //Process Category
        case 'processCategory':
            $content->processCategory();
            break;
        
        //Process Coupon
        case 'processCoupon':
            $content->processCoupon();
            break;
        
        //Comment Configuration
        case 'commentConfig':
            App::Comment()->processConfig();
            break;
        
        //Process Email Template
        case 'processTemplate':
            $content->processTemplate();
            break;
        
        //Process Newsletter
        case 'processMailer':
            $admin->processMailer();
            break;
        
        //Process Custom Field
        case 'processField':
            $content->processField();
            break;
        
        //Process Membership
        case 'processMembership':
            $membership->processMembership();
            break;
        
        //Process Coupon
        case 'processNews':
            $content->processNews();
            break;
        
        //Process Faq
        case 'processFaq':
            $content->processFaq();
            break;
        
        //Process User
        case 'processUser':
            $user->processUser();
            break;
        
        //Update Account
        case 'updateAccount':
            $admin->updateAccount();
            break;
        
        //Update Password
        case 'updatePassword':
            $admin->updateAdminPassword();
            break;
        
        //Process Country
        case 'processCountry':
            $content->processCountry();
            break;
        
        //Process Transaction
        case 'processTransaction':
            $admin->processTransaction();
            break;
        
        //Process Transaction
        case 'processConfig':
            $core->processConfig();
            break;
        
        //Delete Inactive Users
        case 'processMInactive':
            Stats::deleteInactive(intval($_POST['days']));
            break;
        
        //Delete Banned Users
        case 'processMIBanned':
            Stats::deleteBanned();
            break;
        
        //Delete Cart
        case 'processMCart':
            Stats::emptyCart();
            break;
        
        //Generate SiteMap
        case 'processMap':
            Admin::writeSiteMap();
            break;
        
        //Process Gateway
        case 'processGateway':
            $admin->processGateway();
            break;
        
        //Process Product
        case 'processItem':
            $product->processItem();
            break;
    endswitch;
    
    /* == Trash Actions == */
    switch ($trash):
        //Trash Menu
        case 'trashMenu':
            if ($row = Database::Go()->select(Content::mTable)->where('id', Filter::$id, '=')->first()->run()) {
                $data = array(
                    'type' => 'menu',
                    'parent_id' => Filter::$id,
                    'dataset' => json_encode($row)
                );
                Database::Go()->insert(Core::txTable, $data);
                Database::Go()->delete(Content::mTable)->where('id', $row->id, '=')->run();
                $json['type'] = 'success';
            }
            
            $json['title'] = Language::$word->SUCCESS;
            $json['message'] = str_replace('[NAME]', $title, Language::$word->NW_TRASH_OK);
            print json_encode($json);
            break;
        
        //Trash Category
        case 'trashCategory':
            if ($row = Database::Go()->select(Content::cTable)->where('id', Filter::$id, '=')->first()->run()) {
                $data = array(
                    'type' => 'category',
                    'parent_id' => Filter::$id,
                    'dataset' => json_encode($row)
                );
                Database::Go()->insert(Core::txTable, $data);
                Database::Go()->delete(Content::cTable)->where('id', $row->id, '=')->run();
                if ($result = Database::Go()->select(Content::cTable)->where('parent_id', $row->id, '=')->run()) {
                    $dataArray = array();
                    foreach ($result as $item) {
                        $dataArray[] = array(
                            'parent' => 'category',
                            'type' => 'subcategory',
                            'parent_id' => $row->id,
                            'dataset' => json_encode($item),
                        );
                    }
                    Database::Go()->batch(Core::txTable, $dataArray)->run();
                    Database::Go()->delete(Content::cTable)->where('parent_id', $row->id, '=')->run();
                }
                $json['type'] = 'success';
            }
            
            $json['title'] = Language::$word->SUCCESS;
            $json['message'] = str_replace('[NAME]', $title, Language::$word->CT_TRASH_OK);
            print json_encode($json);
            break;
        
        //Trash Coupon
        case 'trashCoupon':
            if ($row = Database::Go()->select(Content::dcTable)->where('id', Filter::$id, '=')->first()->run()) {
                $data = array(
                    'type' => 'coupon',
                    'parent_id' => Filter::$id,
                    'dataset' => json_encode($row)
                );
                Database::Go()->insert(Core::txTable, $data);
                Database::Go()->delete(Content::dcTable)->where('id', $row->id, '=')->run();
                $json['type'] = 'success';
            }
            
            $json['title'] = Language::$word->SUCCESS;
            $json['message'] = str_replace('[NAME]', $title, Language::$word->DC_TRASH_OK);
            print json_encode($json);
            break;
        
        //Trash News
        case 'trashNews':
            if ($row = Database::Go()->select(Content::nTable)->where('id', Filter::$id, '=')->first()->run()) {
                $data = array(
                    'type' => 'coupon',
                    'parent_id' => Filter::$id,
                    'dataset' => json_encode($row)
                );
                Database::Go()->insert(Core::txTable, $data);
                Database::Go()->delete(Content::nTable)->where('id', $row->id, '=')->run();
                $json['type'] = 'success';
            }
            
            $json['title'] = Language::$word->SUCCESS;
            $json['message'] = str_replace('[NAME]', $title, Language::$word->NW_TRASH_OK);
            print json_encode($json);
            break;
        
        //Trash Faq
        case 'trashFaq':
            if ($row = Database::Go()->select(Content::fTable)->where('id', Filter::$id, '=')->first()->run()) {
                $data = array(
                    'type' => 'coupon',
                    'parent_id' => Filter::$id,
                    'dataset' => json_encode($row)
                );
                Database::Go()->insert(Core::txTable, $data);
                Database::Go()->delete(Content::fTable)->where('id', $row->id, '=')->run();
                $json['type'] = 'success';
            }
            
            $json['title'] = Language::$word->SUCCESS;
            $json['message'] = str_replace('[NAME]', $title, Language::$word->FAQ_TRASH_OK);
            print json_encode($json);
            break;
        
        //Trash User
        case 'trashUser':
            if ($row = Database::Go()->select(User::mTable)->where('id', Filter::$id, '=')->first()->run()) {
                $data = array(
                    'type' => 'user',
                    'parent_id' => Filter::$id,
                    'dataset' => json_encode($row)
                );
                Database::Go()->insert(Core::txTable, $data)->run();
                Database::Go()->delete(User::mTable)->where('id', $row->id, '=')->run();
            }
            
            $message = str_replace('[NAME]', $title, Language::$word->USR_TRASH_OK);
            Message::msgReply(Database::Go()->affected(), 'success', $message);
            break;
            
        //Trash Page
        case 'trashPage':
            if ($row = Database::Go()->select(Content::pTable)->where('id', Filter::$id, '=')->first()->run()) {
                $data = array(
                    'type' => 'page',
                    'parent_id' => Filter::$id,
                    'dataset' => json_encode($row)
                );
                Database::Go()->insert(Core::txTable, $data)->run();
                Database::Go()->delete(Content::pTable)->where('id', $row->id, '=')->run();
            }
            
            $message = str_replace('[NAME]', $title, Language::$word->PAG_TRASH_OK);
            Message::msgReply(Database::Go()->affected(), 'success', $message);
            break;
    endswitch;
    
    /* == Delete Actions == */
    switch ($delete):
        //Delete Comment
        case 'deleteComment':
            if ($row = Database::Go()->delete(Comment::mTable)->where('id', Filter::$id, '=')->first()->run()) {
                $json['type'] = 'success';
            }
            
            $json['title'] = Language::$word->SUCCESS;
            $json['message'] = str_replace('[ID]', $title, Language::$word->CMT_DEL_OK);
            print json_encode($json);
            break;
        
        //Delete Field
        case 'deleteField':
            if ($row = Database::Go()->delete(Content::cfTable)->where('id', Filter::$id, '=')->first()->run()) {
                Database::Go()->delete(Content::cfdTable)->where('field_id', Filter::$id, '=')->run();
                $json['type'] = 'success';
            }
            
            $json['title'] = Language::$word->SUCCESS;
            $json['message'] = str_replace('[NAME]', $title, Language::$word->CF_DEL_OK);
            print json_encode($json);
            break;
        
        //Delete Product
        case 'deleteProduct':
            if ($row = Database::Go()->delete(Product::mTable)->where('id', Filter::$id, '=')->run()) {
                Database::Go()->delete(Comment::mTable)->where('product_id', Filter::$id, '=')->run();
                Database::Go()->delete(Content::cfdTable)->where('product_id', Filter::$id, '=')->run();
                Database::Go()->delete(Product::cdTable)->where('product_id', Filter::$id, '=')->run();
                Database::Go()->delete(Product::xTable)->where('product_id', Filter::$id, '=')->run();
                Database::Go()->delete(Product::iTable)->where('parent_id', Filter::$id, '=')->run();
                File::deleteRecursive(UPLOADS . Product::DATA . Filter::$id, true);
                $json['type'] = 'success';
            }
            
            $json['title'] = Language::$word->SUCCESS;
            $json['message'] = str_replace('[NAME]', $title, Language::$word->PRD_DELETE_OK);
            print json_encode($json);
            break;
        
        //Delete Image
        case 'deleteImage':
            if ($row = Database::Go()->select(Product::iTable)->where('id', Filter::$id, '=')->first()->run()) {
                File::deleteFile(UPLOADS . Product::DATA . $row->parent_id . '/' . $row->name);
                File::deleteFile(UPLOADS . Product::DATA . $row->parent_id . '/thumbs/' . $row->name);
                Database::Go()->delete(Product::iTable)->where('id', Filter::$id, '=')->run();
                $json['type'] = 'success';
            }
            
            $json['title'] = Language::$word->SUCCESS;
            $json['message'] = Language::$word->PRD_IMG_DELETE_OK;
            print json_encode($json);
            break;
        
        //Delete File
        case 'deleteFile':
            if ($row = Database::Go()->select(Product::fTable)->where('id', Filter::$id, '=')->first()->run()) {
                File::deleteFile(App::Core()->file_dir . $row->alias);
                Database::Go()->delete(Product::fTable)->where('id', $row->id, '=')->run();
                $json['type'] = 'success';
            }
            
            $json['title'] = Language::$word->SUCCESS;
            $json['message'] = str_replace('[NAME]', $title, Language::$word->FM_DELETE_OK);
            print json_encode($json);
            break;
        
        //Delete Database Backup
        case 'deleteBackup':
            File::deleteFile(UPLOADS . '/backups/' . $title);
            
            $json['type'] = 'success';
            $json['title'] = Language::$word->SUCCESS;
            $json['message'] = str_replace('[NAME]', $title, Language::$word->DBM_DELETE_OK);
            print json_encode($json);
            break;
        
        /* == Delete From Trash == */
        case 'deleteMenu':
        case 'deletePage':
        case 'deleteNews':
        case 'deleteMembership':
        case 'deleteUser':
        case 'deleteFaq':
        case 'deleteCategory':
            Database::Go()->delete(Core::txTable)->where('id', Filter::$id, '=')->run();
            $json['type'] = 'success';
            print json_encode($json);
            break;
        
        /* == Delete Trash == */
        case 'trashAll':
            Database::Go()->truncate(Core::txTable)->run();
            Message::msgReply(true, 'success', Language::$word->TRASH_DEL_OK);
            break;
    endswitch;
    
    /* == Restore Actions == */
    switch ($restore):
        //Restore Menu
        case 'restoreMenu':
            if ($result = Database::Go()->select(Core::txTable, array('dataset'))->where('id', Filter::$id, '=')->first()->run()) {
                $array = Utility::jSonToArray($result->dataset);
                Core::restoreFromTrash($array, Content::mTable);
                Database::Go()->delete(Core::txTable)->where('id', Filter::$id, '=')->run();
                
                Message::msgReply(true, 'success', str_replace('[NAME]', $title, Language::$word->MU_RESTORE_OK));
            }
            break;
        
        /* == Restore Category == */
        case 'restoreCategory':
            if ($result = Database::Go()->select(Core::txTable, array('dataset'))->where('id', Filter::$id, '=')->first()->run()) {
                $array = Utility::jSonToArray($result->dataset);
                Core::restoreFromTrash($array, Content::cTable);
                Database::Go()->delete(Core::txTable)->where('id', Filter::$id, '=')->run();
                
                Message::msgReply(true, 'success', str_replace('[NAME]', $title, Language::$word->CT_RESTORE_OK));
            }
            break;
        
        /* == Restore Page == */
        case 'restorePage':
            if ($result = Database::Go()->select(Core::txTable, array('dataset'))->where('id', Filter::$id, '=')->first()->run()) {
                $array = Utility::jSonToArray($result->dataset);
                Core::restoreFromTrash($array, Content::pTable);
                Database::Go()->delete(Core::txTable)->where('id', Filter::$id, '=')->run();
                
                Message::msgReply(true, 'success', str_replace('[NAME]', $title, Language::$word->PAG_RESTORE_OK));
            }
            break;
        
        /* == Restore Faq == */
        case 'restoreFaq':
            if ($result = Database::Go()->select(Core::txTable, array('dataset'))->where('id', Filter::$id, '=')->first()->run()) {
                $array = Utility::jSonToArray($result->dataset);
                Core::restoreFromTrash($array, Content::fTable);
                Database::Go()->delete(Core::txTable)->where('id', Filter::$id, '=')->run();
                
                Message::msgReply(true, 'success', str_replace('[NAME]', $title, Language::$word->FAQ_RESTORE_OK));
            }
            break;
        
        /* == Restore Membership == */
        case 'restoreMembership':
            if ($result = Database::Go()->select(Core::txTable, array('dataset'))->where('id', Filter::$id, '=')->first()->run()) {
                $array = Utility::jSonToArray($result->dataset);
                Core::restoreFromTrash($array, Membership::mTable);
                Database::Go()->delete(Core::txTable)->where('id', Filter::$id, '=')->run();
                
                Message::msgReply(true, 'success', str_replace('[NAME]', $title, Language::$word->MEM_RESTORE_OK));
            }
            break;
        
        /* == Restore News == */
        case 'restoreNews':
            if ($result = Database::Go()->select(Core::txTable, array('dataset'))->where('id', Filter::$id, '=')->first()->run()) {
                $array = Utility::jSonToArray($result->dataset);
                Core::restoreFromTrash($array, Content::nTable);
                Database::Go()->delete(Core::txTable)->where('id', Filter::$id, '=')->run();
                
                Message::msgReply(true, 'success', str_replace('[NAME]', $title, Language::$word->NW_RESTORE_OK));
            }
            break;
        
        /* == Restore Coupon == */
        case 'restoreCoupon':
            if ($result = Database::Go()->select(Core::txTable, array('dataset'))->where('id', Filter::$id, '=')->first()->run()) {
                $array = Utility::jSonToArray($result->dataset);
                Core::restoreFromTrash($array, Content::dcTable);
                Database::Go()->delete(Core::txTable)->where('id', Filter::$id, '=')->run();
                
                Message::msgReply(true, 'success', str_replace('[NAME]', $title, Language::$word->DC_RESTORE_OK));
            }
            break;
        
        //Restore User
        case 'restoreUser':
            if ($result = Database::Go()->select(Core::txTable, array('dataset'))->where('id', Filter::$id, '=')->first()->run()) {
                $array = Utility::jSonToArray($result->dataset);
                Core::restoreFromTrash($array, User::mTable);
                Database::Go()->delete(Core::txTable)->where('id', Filter::$id, '=')->run();
                
                Message::msgReply(true, 'success', str_replace('[NAME]', $title, Language::$word->USR_RESTORE_OK));
            }
            break;
        
        //Restore Database
        case 'restoreBackup':
            DatabaseTools::doRestore($title);
            break;
    endswitch;