<?php
   /**
    * coupon
    *
    * @package Wojo Framework
    * @author wojoscripts.com
    * @copyright 2023
    * @version 5.50: coupon.tpl.php, v1.00 8/1/2023 2:22 PM Gewa Exp $
    *
    */
   if (!defined('_WOJO')) {
      die('Direct access to this location is not allowed.');
   }

   if (!Auth::hasPrivileges('manage_coupons')): print Message::msgError(Language::$word->NOACCESS);
      return; endif;
?>
<?php switch (Url::segment($this->segments)): case 'edit': ?>
   <form method="post" id="wojo_form" name="wojo_form">
      <div class="wojo segment form margin-bottom">
         <div class="wojo fields">
            <div class="field five wide">
               <label><?php echo Language::$word->NAME; ?>
                  <i class="icon asterisk"></i>
               </label>
               <div class="wojo input">
                  <input type="text" placeholder="<?php echo Language::$word->NAME; ?>" value="<?php echo $this->data->title; ?>" name="title">
               </div>
            </div>
            <div class="field five wide">
               <label><?php echo Language::$word->DC_CODE; ?>
                  <i class="icon asterisk"></i>
               </label>
               <div class="wojo input">
                  <input type="text" placeholder="<?php echo Language::$word->DC_CODE; ?>" value="<?php echo $this->data->code; ?>" name="code">
               </div>
            </div>
         </div>
         <div class="wojo fields">
            <div class="field five wide">
               <label><?php echo Language::$word->DC_VALID; ?>
                  <i class="icon asterisk"></i>
               </label>
               <div class="wojo icon input">
                  <input name="validuntil" type="text" placeholder="<?php echo Language::$word->TO; ?>" value="<?php echo Date::doDate('calendar', $this->data->validuntil); ?>" readonly class="datepick">
                  <i class="icon date"></i>
               </div>
            </div>
            <div class="field five wide">
               <label><?php echo Language::$word->DC_DISC; ?>
                  <i class="icon asterisk"></i>
               </label>
               <div class="wojo action input">
                  <input type="text" placeholder="<?php echo Language::$word->DC_DISC; ?>" value="<?php echo $this->data->discount; ?>" name="discount">
                  <select name="type">
                     <option value="p" <?php echo Validator::getSelected($this->data->type, 'p'); ?>><?php echo Language::$word->DC_TYPE_P; ?></option>
                     <option value="a" <?php echo Validator::getSelected($this->data->type, 'a'); ?>><?php echo Language::$word->DC_TYPE_A; ?></option>
                  </select>
               </div>
            </div>
         </div>
         <div class="wojo fields">
            <div class="field five wide">
               <label><?php echo Language::$word->DC_MIN; ?>
                  <i class="icon asterisk"></i>
               </label>
               <div class="wojo labeled input">
                  <div class="wojo simple label"><?php echo Utility::currencySymbol(); ?></div>
                  <input type="text" placeholder="<?php echo Language::$word->DC_MIN; ?>" value="<?php echo $this->data->minval; ?>" name="minval">
                  <div class="wojo simple label">
                     <?php echo App::Core()->currency; ?>
                  </div>
               </div>
            </div>
            <div class="field">
               <label><?php echo Language::$word->PUBLISHED; ?></label>
               <div class="wojo checkbox radio inline">
                  <input name="active" type="radio" value="1" <?php echo Validator::getChecked($this->data->active, 1); ?> id="active_1">
                  <label for="active_1"><?php echo Language::$word->YES; ?></label>
               </div>
               <div class="wojo checkbox radio inline">
                  <input name="active" type="radio" value="0" <?php echo Validator::getChecked($this->data->active, 0); ?> id="active_0">
                  <label for="active_0"><?php echo Language::$word->NO; ?></label>
               </div>
            </div>
         </div>
      </div>
      <div class="center-align">
         <a href="<?php echo Url::url('/admin/coupons'); ?>" class="wojo simple button"><?php echo Language::$word->CANCEL; ?></a>
         <button type="button" data-action="processCoupon" name="dosubmit" class="wojo primary button"><?php echo Language::$word->DC_UPDATE; ?></button>
      </div>
      <input type="hidden" name="id" value="<?php echo $this->data->id; ?>">
   </form>
   <?php break; ?>
<?php case 'new': ?>
   <form method="post" id="wojo_form" name="wojo_form">
      <div class="wojo segment form margin-bottom">
         <div class="wojo fields">
            <div class="field five wide">
               <label><?php echo Language::$word->NAME; ?>
                  <i class="icon asterisk"></i>
               </label>
               <div class="wojo input">
                  <input type="text" placeholder="<?php echo Language::$word->NAME; ?>" name="title">
               </div>
            </div>
            <div class="field five wide">
               <label><?php echo Language::$word->DC_CODE; ?>
                  <i class="icon asterisk"></i>
               </label>
               <div class="wojo input">
                  <input type="text" placeholder="<?php echo Language::$word->DC_CODE; ?>" name="code">
               </div>
            </div>
         </div>
         <div class="wojo fields">
            <div class="field five wide">
               <label><?php echo Language::$word->DC_VALID; ?>
                  <i class="icon asterisk"></i>
               </label>
               <div class="wojo icon input">
                  <input placeholder="<?php echo Language::$word->TO; ?>" name="validuntil" type="text" value="<?php echo Date::doDate('calendar', Date::numberOfDays('+1 month')); ?>" readonly class="datepick">
                  <i class="icon date"></i>
               </div>
            </div>
            <div class="field five wide">
               <label><?php echo Language::$word->DC_DISC; ?>
                  <i class="icon asterisk"></i>
               </label>
               <div class="wojo action input">
                  <input type="text" placeholder="<?php echo Language::$word->DC_DISC; ?>" name="discount">
                  <select name="type">
                     <option value="p"><?php echo Language::$word->DC_TYPE_P; ?></option>
                     <option value="a"><?php echo Language::$word->DC_TYPE_A; ?></option>
                  </select>
               </div>
            </div>
         </div>
         <div class="wojo fields">
            <div class="field five wide">
               <label><?php echo Language::$word->DC_MIN; ?>
                  <i class="icon asterisk"></i>
               </label>
               <div class="wojo labeled input">
                  <div class="wojo simple label"><?php echo Utility::currencySymbol(); ?></div>
                  <input type="text" placeholder="1.00" name="minval">
                  <div class="wojo simple label">
                     <?php echo App::Core()->currency; ?>
                  </div>
               </div>
            </div>
            <div class="field">
               <label><?php echo Language::$word->PUBLISHED; ?></label>
               <div class="wojo checkbox radio inline">
                  <input name="active" type="radio" value="1" id="active_1">
                  <label for="active_1"><?php echo Language::$word->YES; ?></label>
               </div>
               <div class="wojo checkbox radio inline">
                  <input name="active" type="radio" value="0" checked="checked" id="active_0">
                  <label for="active_0"><?php echo Language::$word->NO; ?></label>
               </div>
            </div>
         </div>
      </div>
      <div class="center-align">
         <a href="<?php echo Url::url('/admin/coupons'); ?>" class="wojo simple small button"><?php echo Language::$word->CANCEL; ?></a>
         <button type="button" data-action="processCoupon" name="dosubmit" class="wojo primary button"><?php echo Language::$word->DC_CREATE; ?></button>
      </div>
   </form>
   <?php break; ?>
<?php default: ?>
   <div class="row gutters justify-end">
      <div class="columns auto mobile-100 phone-100">
         <a href="<?php echo Url::url(Router::$path, 'new/'); ?>" class="wojo small secondary fluid button">
            <i class="icon plus alt"></i><?php echo Language::$word->DC_NEW; ?></a>
      </div>
   </div>
   <?php if (!$this->data): ?>
      <div class="center-align">
         <img src="<?php echo ADMINVIEW; ?>/images/notfound.svg" alt="" class="wojo big inline image">
         <div class="margin-small-top">
            <p class="wojo small icon alert inverted attached compact message">
               <i class="icon exclamation triangle"></i><?php echo Language::$word->DC_EMPTY; ?></p>
         </div>
      </div>
   <?php else: ?>
      <div class="wojo cards screen-3 tablet-3 mobile-1">
         <?php foreach ($this->data as $k => $row): ?>
            <div class="card" id="item_<?php echo $row->id; ?>">
               <div class="content dimmable <?php echo ($row->active == 0)? 'active' : ''; ?>"
                    id="cp_<?php echo $row->id; ?>">
                  <a href="<?php echo Url::url(Router::$path, 'edit/' . $row->id); ?>">
                     <img src="<?php echo ADMINVIEW; ?>/images/coupon.svg" alt="">
                  </a>
                  <p class="center aligned">
                     <a href="<?php echo Url::url(Router::$path, 'edit/' . $row->id); ?>"><?php echo $row->title; ?></a>
                  </p>
               </div>
               <div class="divided footer">
                  <div class="row align-middle">
                     <div class="columns">
                        <a data-set='{"option":[{"trash": "trashCoupon","title": "<?php echo Validator::sanitize($row->title, 'chars'); ?>","id": <?php echo $row->id; ?>}],"action":"trash","parent":"#item_<?php echo $row->id; ?>"}'
                           class="wojo negative small inverted icon button data">
                           <i class="icon trash"></i>
                        </a>
                     </div>
                     <div class="columns auto">
                        <div class="wojo fitted toggle checkbox is_dimmable"
                             data-set='{"option":[{"action": "couponStatus","id":<?php echo $row->id; ?>}],"parent":"#cp_<?php echo $row->id; ?>"}'>
                           <input name="active" type="checkbox" value="1" <?php echo Validator::getChecked($row->active, 1); ?>
                                  id="cpn_<?php echo $row->id; ?>">
                           <label for="cpn_<?php echo $row->id; ?>"><?php echo Language::$word->ACTIVE; ?></label>
                        </div>
                     </div>
                  </div>
               </div>
            </div>
         <?php endforeach; ?>
      </div>
   <?php endif; ?>
   <?php break; ?>
<?php endswitch; ?>