<?php
   /**
    * faq
    *
    * @package Wojo Framework
    * @author wojoscripts.com
    * @copyright 2023
    * @version 5.50: faq.tpl.php, v1.00 11/1/2023 1:59 PM Gewa Exp $
    *
    */
   if (!defined('_WOJO')) {
      die('Direct access to this location is not allowed.');
   }

   if (!Auth::hasPrivileges('manage_faq')): print Message::msgError(Language::$word->NOACCESS);
      return;
   endif;
?>
<?php switch (Url::segment($this->segments)): case 'edit': ?>
   <form method="post" id="wojo_form" name="wojo_form">
      <div class="wojo simple segment form margin-bottom">
         <div class="wojo fields align-middle">
            <div class="field four wide labeled">
               <label><?php echo Language::$word->FAQ_QUESTION; ?>
                  <i class="icon asterisk"></i>
               </label>
            </div>
            <div class="field">
               <input type="text" placeholder="<?php echo Language::$word->FAQ_QUESTION; ?>" name="question" value="<?php echo $this->data->question; ?>">
            </div>
         </div>
         <div class="wojo fields align-middle">
            <div class="field four wide labeled">
               <label><?php echo Language::$word->FAQ_ANSWER; ?>
                  <i class="icon asterisk"></i>
               </label>
            </div>
            <div class="field">
               <textarea name="answer" placeholder="<?php echo Language::$word->FAQ_ANSWER; ?>"><?php echo $this->data->answer; ?></textarea>
            </div>
         </div>
      </div>
      <div class="center-align">
         <a href="<?php echo Url::url('/admin/faq'); ?>" class="wojo small simple button"><?php echo Language::$word->CANCEL; ?></a>
         <button type="button" data-action="processFaq" name="dosubmit" class="wojo primary button"><?php echo Language::$word->FAQ_UPDATE; ?></button>
      </div>
      <input type="hidden" name="id" value="<?php echo $this->data->id; ?>">
   </form>
   <?php break; ?>
<?php case 'new': ?>
   <form method="post" id="wojo_form" name="wojo_form">
      <div class="wojo simple segment form margin-bottom">
         <div class="wojo fields align-middle">
            <div class="field four wide labeled">
               <label><?php echo Language::$word->FAQ_QUESTION; ?>
                  <i class="icon asterisk"></i>
               </label>
            </div>
            <div class="field">
               <input type="text" placeholder="<?php echo Language::$word->FAQ_QUESTION; ?>" name="question">
            </div>
         </div>
         <div class="wojo fields align-middle">
            <div class="field four wide labeled">
               <label><?php echo Language::$word->FAQ_ANSWER; ?>
                  <i class="icon asterisk"></i>
               </label>
            </div>
            <div class="field">
               <textarea name="answer" placeholder="<?php echo Language::$word->FAQ_ANSWER; ?>"></textarea>
            </div>
         </div>
      </div>
      <div class="center-align">
         <a href="<?php echo Url::url('/admin/faq'); ?>" class="wojo small simple button"><?php echo Language::$word->CANCEL; ?></a>
         <button type="button" data-action="processFaq" name="dosubmit" class="wojo primary button"><?php echo Language::$word->FAQ_CREATE; ?></button>
      </div>
   </form>
   <?php break; ?>
<?php default: ?>
   <div class="row gutters justify-end">
      <div class="columns auto mobile-100 phone-100">
         <a href="<?php echo Url::url(Router::$path, 'new/'); ?>" class="wojo small secondary fluid button">
            <i class="icon plus alt"></i><?php echo Language::$word->FAQ_NEW; ?></a>
      </div>
   </div>
   <?php if (!$this->data): ?>
      <div class="center-align">
         <img src="<?php echo ADMINVIEW; ?>/images/notfound.svg" alt="" class="wojo big inline image">
         <div class="margin-small-top">
            <p class="wojo small icon alert inverted attached compact message">
               <i class="icon exclamation triangle"></i><?php echo Language::$word->FAQ_EMPTY; ?></p>
         </div>
      </div>
   <?php else: ?>
      <div class="wojo sortable framed cards screen-3 tablet-3 mobile-1" id="sortable">
         <?php foreach ($this->data as $row): ?>
            <div class="card" id="item_<?php echo $row->id; ?>" data-id="<?php echo $row->id; ?>">
               <div class="content">
                  <div class="row">
                     <div class="columns">
                        <div class="wojo simple label draggable">
                           <i class="icon grip horizontal"></i>
                        </div>
                     </div>
                     <div class="columns auto">
                        <a data-set='{"option":[{"action": "trashFaq","title": "<?php echo Validator::sanitize($row->question, 'chars'); ?>","id": <?php echo $row->id; ?>}],"action":"trash","parent":"#item_<?php echo $row->id; ?>"}' class="wojo negative small inverted icon button data">
                           <i class="icon trash"></i>
                        </a>
                     </div>
                  </div>
                  <a class="text-weight-500" href="<?php echo Url::url(Router::$path, 'edit/' . $row->id); ?>"><?php echo $row->question; ?></a>
               </div>
            </div>
         <?php endforeach; ?>
      </div>
   <?php endif; ?>
   <script type="text/javascript" src="<?php echo SITEURL; ?>/assets/sortable.js"></script>
   <script type="text/javascript">
      // <![CDATA[
      $(document).ready(function () {
         $('#sortable').sortable({
            ghostClass: 'ghost',
            handle: '.label',
            animation: 600,
            onUpdate: function () {
               let order = this.toArray();
               $.ajax({
                  type: 'post',
                  url: "<?php echo ADMINVIEW . '/helper.php';?>",
                  dataType: 'json',
                  data: {
                     iaction: 'sortFaq',
                     sorting: order
                  }
               });
            }
         });
      });
      // ]]>
   </script>
   <?php break; ?>
<?php endswitch; ?>
