(function ($) {
   'use strict';
   $.Categories = function (settings) {
      const config = {
         url: '',
         lang: {
            delMsg3: '',
            delMsg8: '',
            canBtn: '',
            trsBtn: '',
         }
      };

      if (settings) {
         $.extend(config, settings);
      }

      // sort categories
      $("#sortlist > ul > li:has(> ul)").addClass('parent');
      $("#sortlist > ul > li.parent > .content .handle").after("<div class=\"arrow\"><i class=\"icon chevron down\"></i></div>");
      $('#sortlist .arrow').on('click', function () {
         $(this).find(".icon").toggleClass("down up");
         const parent = $(this).closest("li");
         $(parent).children("ul").fadeToggle(150);
         event.preventDefault()
      });

      $('.wojo.nestable').sortable({
         group: 'nested',
         animation: 150,
         fallbackOnBody: true,
         swapThreshold: 0.65,
         handle: ".handle",
         ghostClass: "ghost",
         onUpdate: function () {
            const items = this.toArray();
            $.ajax({
               cache: false,
               type: "post",
               url: config.url + '/helper.php',
               dataType: "json",
               data: {
                  iaction: "sortCategories",
                  sorting: items
               }
            });
         },
      });
   };
})(jQuery);