(function ($) {
   'use strict';
   $.Menus = function (settings) {
      const config = {
         url: '',
      };
      const $ci = $('#contentid');
      const $wi = $('#webid');
      const $pi = $('#page_id');
      if (settings) {
         $.extend(config, settings);
      }

      $('#contenttype').on('change', function () {
         const $icon = $(this).parent();
         $icon.addClass('loading');
         let option = $(this).val();
         $.get(config.url + '/helper.php', {
            action: 'contentType',
            type: option,
         }, function (json) {
            switch (json.type) {
               case 'page':
                  $ci.show();
                  $wi.hide();
                  $pi.html(json.message);
                  $pi.prop('name', 'page_id');
                  break;

               default:
                  $ci.hide();
                  $wi.show();
                  $pi.prop('name', 'web_id');
                  break;
            }

            $icon.removeClass('loading');
         }, 'json');
      });

      // sort menu
      $('.wojo.nestable').sortable({
         group: 'nested',
         animation: 150,
         fallbackOnBody: true,
         swapThreshold: 0.65,
         handle: '.handle',
         ghostClass: 'ghost',
         onUpdate: function () {
            const items = this.toArray();
            $.ajax({
               cache: false,
               type: 'post',
               url: config.url + '/helper.php',
               dataType: 'json',
               data: {
                  iaction: 'sortMenus',
                  sorting: items
               }
            });
         },
      });
   };
})(jQuery);