(function ($) {
   'use strict';
   $.Transaction = function (settings) {
      const config = {
         url: ''
      };
      if (settings) {
         $.extend(config, settings);
      }
      let timeout;
      $(document).on('keyup', '.wojo.ajax.input input', function () {
         window.clearTimeout(timeout);
         let $container = $('.wojo.ajax.input .results');
         let $icon = $(this).next('.icon');
         let search_string = $(this).val();
         let url = config.url + '/helper.php';
         $container.empty();

         if (search_string.length > 2) {
            $icon.removeClass('search').addClass('spinning spinner circles');
            timeout = window.setTimeout(function () {
               $.ajax({
                  type: 'post',
                  dataType: 'json',
                  url: url,
                  data: {
                     value: search_string,
                     action: 'ajax_search'
                  },
                  success: function (json) {
                     if (json.status === 'success') {
                        $container.html(json.html).show();
                     }
                     $icon.removeClass('spinning spinner circles').addClass('search');
                     $container.on('click', 'a', function () {
                        let id = $(this).data('id');
                        let name = $(this).data('name');
                        $('input[name=user_id]').val(id);
                        $('input[name=user_selection]').val(name);
                        $container.fadeOut().empty();
                     });
                  },
                  error: function () {
                     $icon.removeClass('spinning spinner circles').addClass('search');
                  }
               });
            }, 700);
         }
         return false;
      });

      $('#dropdown-timeRange').on('click', '.item', function () {
         $('#payment_chart').html('');
         getStats($(this).data('value'));
      });

      function getStats(range) {
         $('#pData').addClass('loading');
         $('#payment_chart').empty();
         $.ajax({
            type: 'GET',
            url: config.url + '/helper.php',
            data: {
               action: 'getSalesChart',
               timerange: range
            },
            dataType: 'json'
         }).done(function (json) {
            let legend = '';
            json.legend.map(function (val) {
               legend += val;
            });
            $('#legend').html(legend);
            Morris.Line({
               element: 'payment_chart',
               data: json.data,
               xkey: 'm',
               ykeys: json.label,
               labels: json.label,
               parseTime: false,
               lineWidth: 4,
               pointSize: 6,
               lineColors: json.color,
               gridTextFamily: 'Wojo Sans',
               gridTextWeight: 500,
               gridTextColor: 'rgba(0,0,0,0.6)',
               gridTextSize: 14,
               fillOpacity: '.1',
               hideHover: 'auto',
               preUnits: json.preUnits,
               hoverCallback: function (index, json, content) {
                  let text = $(content)[1].textContent;
                  return content.replace(text, text.replace(json.preUnits, ''));
               },
               smooth: true,
               resize: true,
            });
            $('#pData').removeClass('loading');
         });
      }

      if ($.inArray('new', $.url().segment()) === -1) {
         getStats('all');
      }
   };
})(jQuery);