<?php
   /**
    * menu
    *
    * @package Wojo Framework
    * @author wojoscripts.com
    * @copyright 2023
    * @version 5.50: menu.tpl.php, v1.00 7/24/2023 4:00 PM Gewa Exp $
    *
    */
   if (!defined('_WOJO')) {
      die('Direct access to this location is not allowed.');
   }

   if (!Auth::hasPrivileges('manage_menus')): print Message::msgError(Language::$word->NOACCESS);
      return; endif;
?>
<?php switch (Url::segment($this->segments)): case 'edit': ?>
   <form method="post" id="wojo_form" name="wojo_form">
      <div class="row gutters">
         <div class="columns screen-70 tablet-50 mobile-100 phone-100">
            <div class="wojo segment form margin-bottom">
               <div class="wojo block fields">
                  <div class="field">
                     <label><?php echo Language::$word->NAME; ?>
                        <i class="icon asterisk"></i>
                     </label>
                     <input type="text" placeholder="<?php echo Language::$word->NAME; ?>" value="<?php echo $this->data->name; ?>" name="name">
                  </div>
                  <div class="field">
                     <label><?php echo Language::$word->MU_TYPE; ?>
                        <i class="icon asterisk"></i>
                     </label>
                     <select name="content_type" id="contenttype">
                        <option value=""><?php echo Language::$word->MU_TYPE; ?></option>
                        <?php echo Utility::loopOptionsSimpleAlt($this->contenttype, $this->data->content_type); ?>
                     </select>
                  </div>
                  <div class="field" id="contentid" style="display:<?php echo ($this->data->content_type != 'web')? 'block' : 'none'; ?>">
                     <label><?php echo Language::$word->MU_PAGE; ?></label>
                     <select name="page_id" id="page_id">
                        <?php if ($this->data->content_type == 'page'): ?>
                           <?php echo Utility::loopOptions($this->pagelist, 'id', 'title', $this->data->page_id); ?>
                        <?php endif; ?>
                     </select>
                  </div>
                  <div id="webid" style="display:<?php echo ($this->data->content_type == 'web')? 'block' : 'none'; ?>">
                     <div class="field">
                        <label><?php echo Language::$word->MU_EXT_URL; ?></label>
                        <input type="text" name="web" placeholder="<?php echo Language::$word->MU_EXT_URL; ?>" value="<?php echo $this->data->link; ?>">
                     </div>
                     <div class="field">
                        <label><?php echo Language::$word->MU_TARGET_L; ?></label>
                        <select name="target">
                           <option value=""><?php echo Language::$word->MU_TARGET; ?></option>
                           <option value="_blank" <?php echo Validator::getSelected($this->data->target, '_blank'); ?>><?php echo Language::$word->MU_TARGET_B; ?></option>
                           <option value="_self" <?php echo Validator::getSelected($this->data->target, '_self'); ?>><?php echo Language::$word->MU_TARGET_S; ?></option>
                        </select>
                     </div>
                  </div>
               </div>
               <div class="wojo fields">
                  <div class="field">
                     <label><?php echo Language::$word->PUBLISHED; ?></label>
                     <div class="wojo checkbox radio fitted inline">
                        <input name="active" type="radio" value="1" id="active_1" <?php echo Validator::getChecked($this->data->active, 1); ?>>
                        <label for="active_1"><?php echo Language::$word->YES; ?></label>
                     </div>
                     <div class="wojo checkbox radio fitted inline">
                        <input name="active" type="radio" value="0" id="active_0" <?php echo Validator::getChecked($this->data->active, 0); ?>>
                        <label for="active_0"><?php echo Language::$word->NO; ?></label>
                     </div>
                  </div>
               </div>
            </div>
            <div class="center-align">
               <a href="<?php echo Url::url('/admin/menus'); ?>" class="wojo small simple button"><?php echo Language::$word->CANCEL; ?></a>
               <button type="button" data-action="processMenu" name="dosubmit" class="wojo primary button"><?php echo Language::$word->MU_UPDATE; ?></button>
            </div>
         </div>
         <div class="columns screen-30 tablet-50 mobile-100 phone-100">
            <p class="text-size-small"><?php echo Language::$word->MU_INFO1; ?></p>
            <div id="sortlist" class="nestable">
               <?php if ($this->sortlist) : echo $this->sortlist; endif; ?>
            </div>
         </div>
      </div>
      <input type="hidden" name="id" value="<?php echo $this->data->id; ?>">
   </form>
   <script src="<?php echo SITEURL; ?>/assets/sortable.js"></script>
   <script type="text/javascript" src="<?php echo ADMINVIEW; ?>/js/menus.js"></script>
   <script type="text/javascript">
      // <![CDATA[
      $(document).ready(function () {
         $.Menus({
            url: "<?php echo ADMINVIEW;?>",
         });
      });
      // ]]>
   </script>
   <?php break; ?>
<?php default: ?>
   <form method="post" id="wojo_form" name="wojo_form">
      <div class="row gutters">
         <div class="columns screen-70 tablet-50 mobile-100 phone-100">
            <div class="wojo segment form margin-bottom">
               <div class="wojo block fields">
                  <div class="field">
                     <label><?php echo Language::$word->NAME; ?>
                        <i class="icon asterisk"></i>
                     </label>
                     <input type="text" placeholder="<?php echo Language::$word->NAME; ?>" name="name">
                  </div>
                  <div class="field">
                     <label><?php echo Language::$word->MU_TYPE; ?>
                        <i class="icon asterisk"></i>
                     </label>
                     <select name="content_type" id="contenttype">
                        <option value=""><?php echo Language::$word->MU_TYPE; ?></option>
                        <?php echo Utility::loopOptionsSimpleAlt($this->contenttype); ?>
                     </select>
                  </div>
                  <div class="field" id="contentid">
                     <label><?php echo Language::$word->MU_PAGE; ?></label>
                     <select name="content_id" id="page_id">
                        <option value="0"><?php echo Language::$word->NONE; ?></option>
                     </select>
                  </div>
                  <div id="webid" class="hide-all">
                     <div class="field">
                        <label><?php echo Language::$word->MU_EXT_URL; ?></label>
                        <input type="text" name="web" placeholder="<?php echo Language::$word->MU_EXT_URL; ?>">
                     </div>
                     <div class="field">
                        <label><?php echo Language::$word->MU_TARGET_L; ?></label>
                        <select name="target">
                           <option value=""><?php echo Language::$word->MU_TARGET; ?></option>
                           <option value="_blank"><?php echo Language::$word->MU_TARGET_B; ?></option>
                           <option value="_self"><?php echo Language::$word->MU_TARGET_S; ?></option>
                        </select>
                     </div>
                  </div>
               </div>
               <div class="wojo fields">
                  <div class="field">
                     <label><?php echo Language::$word->PUBLISHED; ?></label>
                     <div class="wojo checkbox radio inline">
                        <input name="active" type="radio" value="1" id="active_1">
                        <label for="active_1"><?php echo Language::$word->YES; ?></label>
                     </div>
                     <div class="wojo checkbox radio inline">
                        <input name="active" type="radio" value="0" checked="checked" id="active_0">
                        <label for="active_0"><?php echo Language::$word->NO; ?></label>
                     </div>
                  </div>
               </div>
            </div>
            <div class="center-align">
               <button type="button" data-action="processMenu" name="dosubmit" class="wojo primary button"><?php echo Language::$word->MU_CREATE; ?></button>
            </div>
         </div>
         <div class="columns screen-30 tablet-50 mobile-100 phone-100">
            <p class="text-size-small"><?php echo Language::$word->MU_INFO1; ?></p>
            <div id="sortlist" class="nestable">
               <?php if ($this->sortlist) : echo $this->sortlist; endif; ?>
            </div>
         </div>
      </div>
   </form>
   <script src="<?php echo SITEURL; ?>/assets/sortable.js"></script>
   <script type="text/javascript" src="<?php echo ADMINVIEW; ?>/js/menus.js"></script>
   <script type="text/javascript">
      // <![CDATA[
      $(document).ready(function () {
         $.Menus({
            url: "<?php echo ADMINVIEW;?>",
         });
      });
      // ]]>
   </script>
   <?php break; ?>
<?php endswitch; ?>