<?php
   /**
    * page
    *
    * @package Wojo Framework
    * @author wojoscripts.com
    * @copyright 2023
    * @version 5.50: page.tpl.php, v1.00 7/25/2023 9:34 AM Gewa Exp $
    *
    */
   if (!defined('_WOJO')) {
      die('Direct access to this location is not allowed.');
   }

   if (!Auth::hasPrivileges('manage_pages')): print Message::msgError(Language::$word->NOACCESS);
      return; endif;
?>
<?php switch (Url::segment($this->segments)): case 'edit': ?>
   <form method="post" id="wojo_form" name="wojo_form">
      <div class="wojo simple segment form margin-bottom">
         <div class="wojo two fields">
            <div class="field">
               <label><?php echo Language::$word->NAME; ?>
                  <i class="icon asterisk"></i>
               </label>
               <div class="wojo input">
                  <input type="text" placeholder="<?php echo Language::$word->NAME; ?>" value="<?php echo $this->data->title; ?>" name="title">
               </div>
            </div>
            <div class="field">
               <label><?php echo Language::$word->PAG_SLUG; ?></label>
               <div class="wojo input">
                  <input type="text" placeholder="<?php echo Language::$word->PAG_SLUG; ?>" value="<?php echo $this->data->slug; ?>" name="slug">
               </div>
            </div>
         </div>
         <div class="wojo fields">
            <div class="field">
               <textarea class="bodypost" name="body"><?php echo Url::out_url($this->data->body); ?></textarea>
            </div>
         </div>
         <div class="wojo fields">
            <div class="field">
               <label><?php echo Language::$word->PUBLISHED; ?></label>
               <div class="wojo checkbox radio fitted inline">
                  <input name="active" type="radio" value="1" id="active_1" <?php echo Validator::getChecked($this->data->active, 1); ?>>
                  <label for="active_1"><?php echo Language::$word->YES; ?></label>
               </div>
               <div class="wojo checkbox radio fitted inline">
                  <input name="active" type="radio" value="0" id="active_0" <?php echo Validator::getChecked($this->data->active, 0); ?>>
                  <label for="active_0"><?php echo Language::$word->NO; ?></label>
               </div>
            </div>
         </div>
         <div class="wojo fields">
            <div class="field">
               <label><?php echo Language::$word->METAKEYS; ?></label>
               <textarea class="small" placeholder="<?php echo Language::$word->METAKEYS; ?>" name="keywords"><?php echo $this->data->keywords; ?></textarea>
            </div>
            <div class="field">
               <label><?php echo Language::$word->METADESC; ?></label>
               <textarea class="small" placeholder="<?php echo Language::$word->METADESC; ?>" name="description"><?php echo $this->data->description; ?></textarea>
            </div>
         </div>
      </div>
      <div class="center-align">
         <a href="<?php echo Url::url('/admin/pages'); ?>" class="wojo simple small button"><?php echo Language::$word->CANCEL; ?></a>
         <button type="button" data-action="processPage" name="dosubmit" class="wojo primary button"><?php echo Language::$word->PAG_UPDATE; ?></button>
      </div>
      <input type="hidden" name="id" value="<?php echo $this->data->id; ?>">
   </form>
   <?php break; ?>
<?php case 'new': ?>
   <form method="post" id="wojo_form" name="wojo_form">
      <div class="wojo simple segment form margin-bottom">
         <div class="wojo two fields">
            <div class="field">
               <label><?php echo Language::$word->NAME; ?>
                  <i class="icon asterisk"></i>
               </label>
               <div class="wojo input">
                  <input type="text" placeholder="<?php echo Language::$word->NAME; ?>" name="title">
               </div>
            </div>
            <div class="field">
               <label><?php echo Language::$word->PAG_SLUG; ?>
                  <i class="icon asterisk"></i>
               </label>
               <div class="wojo input">
                  <input type="text" placeholder="<?php echo Language::$word->PAG_SLUG; ?>" name="slug">
               </div>
            </div>
         </div>
         <div class="wojo fields">
            <div class="field">
               <textarea class="bodypost" name="body"></textarea>
            </div>
         </div>
         <div class="wojo fields">
            <div class="field">
               <div class="wojo checkbox radio fitted inline">
                  <input name="active" type="radio" value="1" id="active_1" checked="checked">
                  <label for="active_1"><?php echo Language::$word->YES; ?></label>
               </div>
               <div class="wojo checkbox radio fitted inline">
                  <input name="active" type="radio" value="0" id="active_0">
                  <label for="active_0"><?php echo Language::$word->NO; ?></label>
               </div>
            </div>
         </div>
         <div class="wojo fields">
            <div class="field">
               <label><?php echo Language::$word->METAKEYS; ?></label>
               <textarea class="small" placeholder="<?php echo Language::$word->METAKEYS; ?>" name="keywords"></textarea>
            </div>
            <div class="field">
               <label><?php echo Language::$word->METADESC; ?></label>
               <textarea class="small" placeholder="<?php echo Language::$word->METADESC; ?>" name="description"></textarea>
            </div>
         </div>
      </div>
      <div class="center-align">
         <a href="<?php echo Url::url('/admin/pages'); ?>" class="wojo simple small button"><?php echo Language::$word->CANCEL; ?></a>
         <button type="button" data-action="processPage" name="dosubmit" class="wojo primary button"><?php echo Language::$word->PAG_CREATE; ?></button>
      </div>
   </form>
   <?php break; ?>
<?php default: ?>
   <div class="row gutters justify-end">
      <div class="columns auto mobile-100 phone-100">
         <a href="<?php echo Url::url(Router::$path, 'new/'); ?>" class="wojo small secondary fluid button">
            <i class="icon plus alt"></i><?php echo Language::$word->PAG_NEW; ?></a>
      </div>
   </div>
   <?php if (!$this->data): ?>
      <div class="center-align">
         <img src="<?php echo ADMINVIEW; ?>/images/notfound.svg" alt="" class="wojo big inline image">
         <div class="margin-small-top">
            <p class="wojo small icon alert inverted attached compact message">
               <i
                 class="icon exclamation triangle"></i><?php echo Language::$word->PAG_NOPAGE; ?></p>
         </div>
      </div>
   <?php else: ?>
      <?php foreach ($this->data as $row): ?>
         <div class="wojo card" id="item_<?php echo $row->id; ?>">
            <div class="header">
               <div class="row horizontal-gutters align-middle">
                  <div class="columns auto"><?php echo Content::pageType($row->page_type); ?></div>
                  <div class="columns">
                     <a class="text-weight-500" href="<?php echo Url::url(Router::$path, 'edit/' . $row->id); ?>"><?php echo $row->title; ?></a>
                     <p>
                        <small><?php echo Date::doDate('short_date', $row->created); ?></small>
                     </p>
                  </div>
                  <div class="columns auto">
                     <a href="<?php echo Url::url(Router::$path, 'edit/' . $row->id); ?>" class="wojo icon primary inverted circular button">
                        <i class="icon pencil"></i>
                     </a>
                     <?php if ($row->page_type == 'normal'): ?>
                        <a data-set='{"option":[{"trash": "trashPage","title": "<?php echo Validator::sanitize($row->title, 'chars'); ?>","id": "<?php echo $row->id; ?>"}],"action":"trash","subtext":"<?php echo Language::$word->DELCONFIRM3; ?>","parent":"#item_<?php echo $row->id; ?>"}' class="wojo icon simple button data">
                           <i class="icon negative trash"></i>
                        </a>
                     <?php else: ?>
                        <a class="wojo icon simple disabled button">
                           <i class="icon x alt"></i>
                        </a>
                     <?php endif; ?>
                  </div>
               </div>
            </div>
         </div>
      <?php endforeach; ?>
   <?php endif; ?>
   <?php break; ?>
<?php endswitch; ?>