<?php
   /**
    * template
    *
    * @package Wojo Framework
    * @author wojoscripts.com
    * @copyright 2023
    * @version 5.50: template.tpl.php, v1.00 8/4/2023 10:13 AM Gewa Exp $
    *
    */
   if (!defined('_WOJO')) {
      die('Direct access to this location is not allowed.');
   }

   if (!Auth::hasPrivileges('manage_email')): print Message::msgError(Language::$word->NOACCESS);
      return; endif;
?>
<?php switch (Url::segment($this->segments)): case 'edit': ?>
   <form method="post" id="wojo_form" name="wojo_form">
      <div class="wojo segment form margin-bottom">
         <div class="wojo fields">
            <div class="field five wide">
               <label><?php echo Language::$word->ET_NAME; ?>
                  <i class="icon asterisk"></i>
               </label>
               <div class="wojo input">
                  <input type="text" placeholder="<?php echo Language::$word->ET_NAME; ?>" value="<?php echo $this->data->name; ?>" name="name">
               </div>
            </div>
            <div class="field five wide">
               <label><?php echo Language::$word->ET_SUBJECT; ?>
                  <i class="icon asterisk"></i>
               </label>
               <div class="wojo input">
                  <input type="text" placeholder="<?php echo Language::$word->ET_SUBJECT; ?>" value="<?php echo $this->data->subject; ?>" name="subject">
               </div>
            </div>
         </div>
         <div class="wojo fields">
            <div class="basic field">
               <textarea class="bodypost" name="body"><?php echo str_replace(array('[SITEURL]', '[LOGO]'), array(SITEURL, $this->core->plogo), $this->data->body); ?></textarea>
               <p class="wojo small icon negative text">
                  <i class="icon negative info sign"></i>
                  <?php echo Language::$word->NOTEVAR; ?></p>
            </div>
         </div>
         <div class="wojo divider"></div>
         <div class="wojo fields">
            <div class="field">
               <label><?php echo Language::$word->DESCRIPTION; ?></label>
               <div class="wojo small input">
                  <textarea class="small" placeholder="<?php echo Language::$word->DESCRIPTION; ?>" name="help"><?php echo $this->data->help; ?></textarea>
               </div>
            </div>
         </div>
      </div>
      <div class="center-align">
         <a href="<?php echo Url::url('/admin/templates'); ?>" class="wojo simple small button"><?php echo Language::$word->CANCEL; ?></a>
         <button type="button" data-action="processTemplate" name="dosubmit" class="wojo primary button"><?php echo Language::$word->ET_UPDATE; ?></button>
      </div>
      <input type="hidden" name="id" value="<?php echo $this->data->id; ?>">
   </form>
   <?php break; ?>
<?php default: ?>
   <?php if (!$this->data): ?>
      <div class="center-align">
         <img src="<?php echo ADMINVIEW; ?>/images/notfound.svg" alt="" class="wojo big inline image">
         <div class="margin-small-top">
            <p class="wojo small icon alert inverted attached compact message">
               <i
                 class="icon exclamation triangle"></i><?php echo Language::$word->ET_INFO; ?></p>
         </div>
      </div>
   <?php else: ?>
      <table class="wojo responsive table">
         <thead>
         <tr>
            <th class="disabled"></th>
            <th data-sort="string"><?php echo Language::$word->ET_NAME; ?></th>
            <th data-sort="string"><?php echo Language::$word->ET_SUBJECT; ?></th>
            <th class="disabled"><?php echo Language::$word->ACTIONS; ?></th>
         </tr>
         </thead>
         <tbody>
         <?php foreach ($this->data as $row): ?>
            <tr id="item_<?php echo $row->id; ?>">
               <td class="auto">
                  <span class="wojo small simple label"><?php echo $row->id; ?></span>
               </td>
               <td>
                  <a href="<?php echo Url::url(Router::$path, 'edit/' . $row->id); ?>" class="inverted">
                     <?php echo $row->name; ?></a>
               </td>
               <td><?php echo $row->subject; ?></td>
               <td class="auto">
                  <a href="<?php echo Url::url(Router::$path, 'edit/' . $row->id); ?>"
                     class="wojo icon primary inverted circular button">
                     <i class="icon pencil"></i>
                  </a>
               </td>
            </tr>
         <?php endforeach; ?>
         </tbody>
      </table>
   <?php endif; ?>
   <?php break; ?>
<?php endswitch; ?>