<?php
   /**
    * transaction
    *
    * @package Wojo Framework
    * @author wojoscripts.com
    * @copyright 2023
    * @version 5.50: transaction.tpl.php, v1.00 11/11/2023 9:21 PM Gewa Exp $
    *
    */
   if (!defined('_WOJO')) {
      die('Direct access to this location is not allowed.');
   }

   App::Auth()->checkOwner();
?>
<?php switch (Url::segment($this->segments)): case 'new': ?>
   <form method="post" id="wojo_form" name="wojo_form">
      <div class="wojo segment form margin-bottom">
         <div class="wojo fields align-middle">
            <div class="field four wide labeled">
               <label><?php echo Language::$word->USER; ?>
                  <i class="icon asterisk"></i>
               </label>
            </div>
            <div class="field">
               <div class="wojo ajax action icon input">
                  <input name="user_selection" placeholder="<?php echo Language::$word->SEARCH; ?>" type="text">
                  <i class="icon search"></i>
                  <div class="results"></div>
               </div>
               <input type="hidden" name="user_id" value="">
            </div>
         </div>
         <div class="wojo fields align-middle">
            <div class="field four wide labeled">
               <label><?php echo Language::$word->CF_SEC_P; ?>
                  <i class="icon asterisk"></i>
               </label>
            </div>
            <div class="field">
               <select name="product_id">
                  <?php echo Utility::loopOptions($this->products, 'id', 'title'); ?>
               </select>
            </div>
         </div>
         <div class="wojo fields align-middle">
            <div class="field four wide labeled">
               <label><?php echo Language::$word->GW_NAME; ?>
                  <i class="icon asterisk"></i>
               </label>
            </div>
            <div class="field">
               <select name="pp">
                  <?php echo Utility::loopOptions($this->gateways, 'name', 'displayname'); ?>
               </select>
            </div>
         </div>
         <div class="wojo fields align-middle">
            <div class="field four wide labeled">
               <label><?php echo Language::$word->QUANTITY; ?>
                  <i class="icon asterisk"></i>
               </label>
            </div>
            <div class="field">
               <input name="qty" type="range" min="1" max="20" step="1" value="1" hidden data-suffix=" qty" data-type="labels" data-labels="1,5,10,15,20">
            </div>
         </div>
         <div class="wojo fields">
            <div class="field four wide labeled">
               <label><?php echo Language::$word->USR_NOTIFY; ?>
                  <i class="icon asterisk"></i>
               </label>
            </div>
            <div class="field">
               <div class="wojo checkbox toggle inline">
                  <input name="notify" type="checkbox" value="1" id="notify_0">
                  <label for="notify_0"><?php echo Language::$word->YES; ?></label>
               </div>
            </div>
         </div>
         <div class="wojo fields">
            <div class="field four wide labeled">
               <label><?php echo Language::$word->TRX_MEMO; ?></label>
            </div>
            <div class="field">
               <textarea name="memo" placeholder="<?php echo Language::$word->TRX_MEMO; ?>"></textarea>
            </div>
         </div>
      </div>
      <div class="center-align">
         <a href="<?php echo Url::url('/admin/transactions'); ?>" class="wojo small simple button"><?php echo Language::$word->CANCEL; ?></a>
         <button type="button" data-action="processTransaction" name="dosubmit" class="wojo secondary button"><?php echo Language::$word->TRX_CREATE; ?></button>
      </div>
   </form>
   <?php break; ?>
<?php default: ?>
   <div class="row gutters justify-end">
      <div class="columns auto mobile-100 phone-100">
         <a href="<?php echo Url::url(Router::$path, 'new/'); ?>" class="wojo small secondary fluid button">
            <i class="icon plus alt"></i><?php echo Language::$word->TRX_NEW; ?></a>
      </div>
   </div>
   <div class="wojo top attached card" id="pData">
      <div class="content">
         <div class="row small-gutters align-middle">
            <div class="columns auto">
               <a data-wdropdown="#dropdown-timeRange" class="wojo primary icon button" id="timeRange">
                  <i class="icon three dots vertical"></i>
               </a>
               <div class="wojo small dropdown pointing menu top-left" id="dropdown-timeRange">
                  <a class="item" data-value="all"><?php echo Language::$word->ALL; ?></a>
                  <a class="item" data-value="day"><?php echo Language::$word->TODAY; ?></a>
                  <a class="item" data-value="week"><?php echo Language::$word->THIS_WEEK; ?></a>
                  <a class="item" data-value="month"><?php echo Language::$word->THIS_MONTH; ?></a>
                  <a class="item" data-value="year"><?php echo Language::$word->THIS_YEAR; ?></a>
               </div>
            </div>
            <div class="columns right-align">
               <div id="legend" class="wojo small horizontal list"></div>
            </div>
         </div>
         <div id="payment_chart" class="height400"></div>
      </div>
   </div>
   <div class="wojo form margin-top">
      <form method="get" id="wojo_form" action="<?php echo Url::url(Router::$path); ?>" name="wojo_form">
         <div class="row align-middle justify-center gutters">
            <div class="columns screen-30 tablet-40 mobile-100 phone-100">
               <div class="wojo icon input">
                  <input name="fromdate" type="text" placeholder="<?php echo Language::$word->FROM; ?>" readonly id="fromdate">
                  <i class="icon calendar range"></i>
               </div>
            </div>
            <div class="columns screen-30 tablet-40 mobile-100 phone-100">
               <div class="wojo action input">
                  <input name="enddate" type="text" placeholder="<?php echo Language::$word->TO; ?>" readonly id="enddate">
                  <button id="doDates" class="wojo icon primary inverted button">
                     <i class="icon search"></i>
                  </button>
               </div>
            </div>
            <div class="columns auto phone-hide">
               <a href="<?php echo Url::url(Router::$path); ?>" class="wojo secondary icon button">
                  <i class="icon time history"></i>
               </a>
            </div>
            <div class="columns auto phone-hide">
               <a href="<?php echo ADMINVIEW . '/helper.php?action=exportAllTransactions' . Url::query(); ?>" class="wojo primary icon button">
                  <i class="icon wysiwyg table"></i>
               </a>
            </div>
         </div>
      </form>
   </div>
   <?php if (!$this->data): ?>
      <div class="center-align">
         <img src="<?php echo ADMINVIEW; ?>/images/empty.svg" alt="" class="wojo big inline image">
         <div class="margin-small-top">
            <p class="wojo small icon alert inverted attached compact message">
               <i class="icon exclamation triangle"></i><?php echo Language::$word->SYSTEM_ERR3; ?></p>
         </div>
      </div>
   <?php else: ?>
      <div class="wojo simple segment margin-bottom">
         <table class="wojo basic responsive table">
            <thead>
            <tr>
               <th class="disabled center-align">
                  <i class="icon disabled id"></i>
               </th>
               <th><?php echo Language::$word->ITEM; ?></th>
               <th><?php echo Language::$word->USER; ?></th>
               <th><?php echo Language::$word->TRX_PP; ?></th>
               <th><?php echo Language::$word->TRX_TOTAMT; ?></th>
               <th><?php echo Language::$word->CREATED; ?></th>
            </tr>
            </thead>
            <?php foreach ($this->data as $row): ?>
               <tr id="item_<?php echo $row->id; ?>">
                  <td class="auto">
                     <span class="wojo small dark inverted label"><?php echo $row->id; ?></span>
                  </td>
                  <td>
                     <a class="text-weight-500" href="<?php echo Url::url('/admin/products/edit', $row->product_id); ?>"><?php echo $row->title; ?></a>
                  </td>
                  <td>
                     <a class="text-weight-500" href="<?php echo Url::url('/admin/users/edit', $row->user_id); ?>"><?php echo $row->name; ?></a>
                  </td>
                  <td><?php echo $row->pp; ?></td>
                  <td><?php echo $row->total; ?></td>
                  <td data-sort-value="<?php echo strtotime($row->created); ?>"><?php echo Date::doDate('short_date', $row->created); ?></td>
               </tr>
            <?php endforeach; ?>
         </table>
         <div class="wojo small primary inverted label"><?php echo Language::$word->TRX_TOTAMT; ?><?php echo Utility::formatMoney(Stats::doArraySum($this->data, 'total')); ?></div>
      </div>
      <div class="margin-top padding-small-horizontal">
         <div class="row gutters align-middle">
            <div class="columns mobile-100 phone-100">
               <div class="text-size-small text-weight-500"><?php echo Language::$word->TOTAL . ': ' . $this->pager->items_total; ?>
                  / <?php echo Language::$word->CURPAGE . ': ' . $this->pager->current_page . ' ' . Language::$word->OF . ' ' . $this->pager->num_pages; ?></div>
            </div>
            <div class="columns mobile-100 phone-100 auto"><?php echo $this->pager->display(); ?></div>
         </div>
      </div>
   <?php endif; ?>
   <?php break; ?>
<?php endswitch; ?>
<script type="text/javascript" src="<?php echo SITEURL; ?>/assets/morris.min.js"></script>
<script type="text/javascript" src="<?php echo SITEURL; ?>/assets/raphael.min.js"></script>
<script src="<?php echo ADMINVIEW; ?>/js/transaction.js"></script>
<script type="text/javascript">
   // <![CDATA[
   $(document).ready(function () {
      $.Transaction({
         url: "<?php echo ADMINVIEW;?>",
      });
   });
   // ]]>
</script>