<?php
   /**
    * _category_grid
    *
    * @package Wojo Framework
    * @author wojoscripts.com
    * @copyright 2023
    * @version 5.50: _category_grid.tpl.php, v1.00 11/15/2023 11:40 AM Gewa Exp $
    *
    */
   if (!defined('_WOJO')) {
      die('Direct access to this location is not allowed.');
   }
?>
<div class="row grid phone-1 mobile-2 tablet-3 screen-4 small-gutters">
   <?php foreach ($this->featured as $row): ?>
      <div class="columns" id="item_<?php echo $row->id; ?>">
         <div class="wojo attached card">
            <?php if ($row->is_sale): ?>
               <span class="wojo small dark top right attached label">-<?php echo Utility::salePercent($row->price, $row->sprice); ?>%</span>
            <?php endif; ?>
            <div class="content">
               <div class="center-align margin-bottom">
                  <a href="<?php echo Url::url('/product', $row->slug); ?>">
                     <img src="<?php echo Product::hasThumb($row->thumb, $row->id); ?>" alt="<?php echo $row->title; ?>" class="wojo responsive image">
                  </a>
               </div>
               <h5 class="truncate">
                  <a href="<?php echo Url::url('/product', $row->slug); ?>" class="dark"><?php echo $row->title ?></a>
               </h5>
               <div class="text-size-small icon-text">
                  <?php echo $row->memberships? '<i class="icon bookmark"></i>' . $row->memberships : '<i class="icon dash"></i>' . Language::$word->MEMBERSHIP . ':  ' . Language::$word->NONE; ?></div>
               <p class="text-weight-700"><?php echo Utility::renderPrice($row->is_sale, $row->price, $row->sprice, 'dark'); ?></p>
               <div class="center-align">
                  <div class="wojo small divided horizontal list">
                     <div class="item">
                        <i class="icon primary star"></i>
                        <?php echo $row->likes; ?>
                     </div>
                     <div class="item">
                        <i class="icon primary chat dots square"></i>
                        <?php echo $row->comments; ?>
                     </div>
                     <div class="item">
                        <?php echo Date::doDate('short_date', $row->created); ?>
                     </div>
                  </div>
               </div>
               <div class="center-align">
                  <?php include(THEMEBASE . '/snippets/gridButton.tpl.php'); ?>
                  <a data-tooltip="<?php echo Language::$word->WISHLIST; ?>" data-layout="grid" data-id="<?php echo $row->id; ?>" class="wishlist wojo simple white icon button">
                     <i class="icon heart"></i>
                  </a>
                  <a data-tooltip="<?php echo Language::$word->COMPARE; ?>" data-layout="grid" data-id="<?php echo $row->id; ?>" class="compare wojo simple white icon button">
                     <i class="icon collection"></i>
                  </a>
               </div>
            </div>
         </div>
      </div>
   <?php endforeach; ?>
</div>