<?php
   /**
    * _category_list
    *
    * @package Wojo Framework
    * @author wojoscripts.com
    * @copyright 2023
    * @version 5.50: _category_list.tpl.php, v1.00 11/15/2023 11:40 AM Gewa Exp $
    *
    */
   if (!defined('_WOJO')) {
      die('Direct access to this location is not allowed.');
   }
?>
<?php foreach ($this->featured as $row): ?>
   <div class="wojo card" id="item_<?php echo $row->id; ?>">
      <?php if ($row->is_sale): ?>
         <span class="wojo tiny dark top right attached label">-<?php echo Utility::salePercent($row->price, $row->sprice); ?>%</span>
      <?php endif; ?>
      <div class="header">
         <div class="row horizontal-gutters">
            <div class="columns auto phone-100 center-align">
               <a href="<?php echo Url::url('/product', $row->slug); ?>">
                  <img src="<?php echo Product::hasThumb($row->thumb, $row->id); ?>" alt="<?php echo $row->title ?>" class="wojo normal responsive inline image">
               </a>
            </div>
            <div class="columns phone-100">
               <h4>
                  <a href="<?php echo Url::url('/product', $row->slug); ?>" class="grey"><?php echo $row->title ?></a>
               </h4>
               <p class="text-weight-700"><?php echo Utility::renderPrice($row->is_sale, $row->price, $row->sprice, 'negative'); ?></p>
               <div class="wojo small divided horizontal list">
                  <div class="item">
                     <i class="icon primary star"></i>
                     <?php echo $row->likes; ?>
                  </div>
                  <div class="item">
                     <i class="icon primary chat dots square"></i>
                     <?php echo $row->comments; ?>
                  </div>
                  <div class="item">
                     <?php echo Date::doDate('short_date', $row->created); ?>
                  </div>
                  <?php if ($row->memberships): ?>
                     <div class="item">
                        <i class="icon bookmark"></i>
                        <?php echo $row->memberships; ?>
                     </div>
                  <?php endif; ?>
               </div>
               <div>
                  <a data-tooltip="<?php echo Language::$word->WISHLIST; ?>" data-layout="list" data-id="<?php echo $row->id ?>" class="wojo simple white icon button wishlist">
                     <i class="icon heart"></i>
                  </a>
                  <a data-tooltip="<?php echo Language::$word->COMPARE; ?>" data-layout="list" data-id="<?php echo $row->id ?>" class="wojo simple white icon button compare">
                     <i class="icon collection"></i>
                  </a>
                  <?php include(THEMEBASE . '/snippets/listButton.tpl.php'); ?>
               </div>

               <?php if ($row->audio): ?>
                  <div class="margin-small-top">
                     <audio preload="auto" controls>
                        <source src="<?php echo Product::hasAudio($row->audio, $row->id); ?>">
                     </audio>
                  </div>
               <?php endif; ?>
            </div>
         </div>
      </div>
   </div>
<?php endforeach; ?>