<?php
   /**
    * _contact
    *
    * @package Wojo Framework
    * @author wojoscripts.com
    * @copyright 2023
    * @version 5.50: _contact.tpl.php, v1.00 7/12/2023 10:30 AM Gewa Exp $
    *
    */
   if (!defined('_WOJO')) {
      die('Direct access to this location is not allowed.');
   }
?>
<div class="row big-gutters">
   <div class="columns screen-50 tablet-50 mobile-100 phone-100">
      <h3><?php echo Language::$word->CONTACT_INFO; ?></h3>
      <div class="wojo big space divider"></div>
      <?php echo $this->row->body; ?>
   </div>
   <div class="columns screen-50 tablet-50 mobile-100 phone-100">
      <h3><?php echo Language::$word->CONTACT_WRITE; ?></h3>
      <div class="wojo big space divider"></div>
      <div class="wojo form">
         <form id="wojo_form" name="wojo_form" method="post">
            <div class="wojo block fields">
               <div class="field">
                  <label><?php echo Language::$word->NAME; ?>
                     <i class="icon asterisk"></i>
                  </label>
                  <input type="text" placeholder="<?php echo Language::$word->NAME; ?>" value="<?php if (App::Auth()->is_User()) {
                     echo App::Auth()->name;
                  } ?>" name="name">
               </div>
               <div class="field">
                  <label><?php echo Language::$word->EMAIL; ?>
                     <i class="icon asterisk"></i>
                  </label>
                  <input type="text" placeholder="<?php echo Language::$word->EMAIL; ?>" value="<?php if (App::Auth()->is_User()) {
                     echo App::Auth()->email;
                  } ?>" name="email">
               </div>
               <div class="field">
                  <label><?php echo Language::$word->MESSAGE; ?>
                     <i class="icon asterisk"></i>
                  </label>
                  <textarea class="small" placeholder="<?php echo Language::$word->MESSAGE; ?>" name="notes"></textarea>
               </div>
               <div class="field">
                  <label><?php echo Language::$word->CAPTCHA; ?>
                     <i class="icon asterisk"></i>
                  </label>
                  <div class="wojo labeled input">
                     <input name="captcha" placeholder="<?php echo Language::$word->CAPTCHA; ?>" type="text">
                     <div class="wojo simple label"><?php echo Session::captcha(); ?></div>
                  </div>
               </div>
               <div class="field">
                  <div class="wojo checkbox">
                     <input name="agree" type="checkbox" value="1" id="agree_1">
                     <label for="agree_1">
                        <a href="<?php echo Url::url('/content', $this->core->page_slugs->privacy[0]->page_type); ?>" target="_blank"><?php echo Language::$word->AGREE; ?></a>
                     </label>
                  </div>
               </div>
               <div class="field">
                  <button type="button" data-hide="true" data-action="contact" name="dosubmit" class="wojo primary fluid  button"><?php echo Language::$word->SEND; ?></button>
               </div>
            </div>
            <input type="hidden" name="slug" value="<?php echo $this->segments[1]; ?>">
         </form>
      </div>
   </div>
</div>
