<?php
   /**
    * _packages
    *
    * @package Wojo Framework
    * @author wojoscripts.com
    * @copyright 2023
    * @version 5.50: _packages.tpl.php, v1.00 7/12/2023 10:30 AM Gewa Exp $
    *
    */
   if (!defined('_WOJO')) {
      die('Direct access to this location is not allowed.');
   }
?>
<h2 class="margin-big-bottom"><?php echo $this->row->title; ?></h2>
<?php echo Url::out_url($this->row->body); ?>
<?php if (!App::Auth()->is_User()): ?>
   <p><?php echo str_replace(array('[LOGIN]', '[REGISTER]'), array(' <a href="' . Url::url('/login') . '" class="text-weight-700">' . strtolower(Language::$word->LOGIN) . '</a>', '<a href="' . Url::url('/register') . '" class="text-weight-700">' . strtolower(Language::$word->REGISTER) . '</a>'), Language::$word->FRONT_VIP_ERROR); ?></p>
<?php endif; ?>
<?php if ($this->packages): ?>
   <div class="row grid screen-3 tablet-2 mobile-1 phone-1 gutters">
      <?php foreach ($this->packages as $row): ?>
         <div class="columns">
            <div class="wojo attached segment">
               <?php if ($row->thumb): ?>
                  <img src="<?php echo UPLOADURL; ?>/memberships/<?php echo $row->thumb; ?>" alt="<?php echo $row->title; ?>">
               <?php else: ?>
                  <img src="<?php echo UPLOADURL; ?>/memberships/default.svg" alt="<?php echo $row->title; ?>">
               <?php endif; ?>
               <h4 class="center aligned">
                  <?php echo Utility::formatMoney($row->price); ?>
                  <?php echo $row->title; ?>
               </h4>
               <p class="wojo small text center aligned">
                  <?php echo $row->description; ?>
               </p>
            </div>
         </div>
      <?php endforeach; ?>
   </div>
<?php endif; ?>