<?php
   /**
    * cart
    *
    * @package Wojo Framework
    * @author wojoscripts.com
    * @copyright 2023
    * @version 5.50: cart.tpl.php, v1.00 11/18/2023 12:22 PM Gewa Exp $
    *
    */
   if (!defined('_WOJO')) {
      die('Direct access to this location is not allowed.');
   }
?>
<?php if (!$this->data): ?>
   <div class="center-aligned margin-bottom">
      <p class="wojo small thick caps text"><?php echo Language::$word->FRONT_CART_EMPTY1; ?></p>
      <p class="text-weight-700">
         <a href="<?php echo SITEURL; ?>/"><?php echo Language::$word->FRONT_CONTINUE; ?> ...</a>
      </p>
   </div>
   <img src="<?php echo THEMEURL; ?>/images/banner.jpg" alt="" class="shadow">
   <?php if ($this->special): ?>
      <?php include_once(PLUGINBASE . '/_specials.tpl.php'); ?>
   <?php endif; ?>
<?php else: ?>
   <div class="wojo card">
      <table class="wojo basic responsive table" id="bigCart">
         <thead>
         <tr>
            <th></th>
            <th><?php echo Language::$word->PRD_PRODUCT; ?></th>
            <th><?php echo Language::$word->PRD_PRICE; ?></th>
            <th class="center-align"><?php echo Language::$word->QUANTITY; ?></th>
            <th><?php echo Language::$word->TOTAL; ?></th>
            <th></th>
         </tr>
         </thead>
         <tbody>
         <?php foreach ($this->data as $row): ?>
            <tr id="item_<?php echo $row->pid ?>">
               <td class="auto">
                  <img src="<?php echo Product::hasThumb($row->thumb, $row->pid); ?>" alt="<?php echo $row->title ?>" class="wojo normal image">
               </td>
               <td>
                  <h5>
                     <a href="<?php echo Url::url('/product', $row->slug); ?>"><?php echo $row->title ?></a>
                  </h5>
               </td>
               <td><?php echo Utility::formatMoney($row->total); ?></td>
               <td class="center-align"><?php echo $row->items; ?></td>
               <td>
                  <span class="text-weight-700"><?php echo Utility::formatMoney($row->items * $row->total); ?></span>
               </td>
               <td>
                  <a data-id="<?php echo $row->pid; ?>" class="deleteItem">
                     <i class="icon negative trash"></i>
                  </a>
               </td>
            </tr>
         <?php endforeach; ?>
         </tbody>
      </table>
   </div>
   <div class="wojo form margin-bottom">
      <div class="wojo small action input">
         <input placeholder="<?php echo Language::$word->DC_CODE; ?>" type="text" name="coupon">
         <button type="button" name="discount" class="wojo primary small button">
            <?php echo Language::$word->APPLY; ?>
         </button>
      </div>
   </div>
   <h4 class="right-align"><?php echo Language::$word->FRONT_CART_TOTALS; ?></h4>
   <table class="wojo basic table">
      <tbody>
      <tr>
         <td class="right-align text-weight-700"><?php echo Language::$word->TRX_SUBTOTAL; ?></td>
         <td class="right-align" id="subtotal"><?php echo Utility::formatNumber($this->totals->subtotal); ?></td>
      </tr>
      <tr>
         <td class="right-align text-weight-700"><?php echo Language::$word->DC_DISC; ?></td>
         <td class="right-align" id="discount"><div class="icon-text">
            <i class="icon dash positive alt"></i>
               <?php echo Utility::formatNumber($this->totals->discount); ?></div></td>
      </tr>
      <?php if ($this->core->enable_tax): ?>
         <tr>
            <td class="right-align text-weight-700"><?php echo Language::$word->TAX; ?></td>
            <td class="right-align" id="tax"><div class="icon-text">
               <i class="icon plus negative alt"></i>
               <?php echo Utility::formatNumber($this->totals->tax); ?></div>
            </td>
         </tr>
      <?php endif; ?>
      <tr class="highlight">
         <td class="right-align text-weight-700"><?php echo Language::$word->TOTAL; ?></td>
         <td class="right-align text-weight-700" id="total"><?php echo Utility::formatMoney($this->totals->grand); ?></td>
      </tr>
      </tbody>
   </table>
   <?php if (App::Auth()->is_User()): ?>
      <?php include(THEMEBASE . '/_checkout.tpl.php'); ?>
   <?php else: ?>
      <p class="padding top">
         <i class="icon info sign"></i>
         <?php echo str_replace(array('[LOGIN]', '[REGISTER]'), array(' <a href="' . Url::url('/login') . '" class="text-weight-700">' . strtolower(Language::$word->LOGIN) . '</a>', '<a href="' . Url::url('/register') . '" class="text-weight-700">' . strtolower(Language::$word->REGISTER) . '</a>'), Language::$word->FRONT_CART_ERROR2); ?></p>
   <?php endif; ?>
<?php endif; ?>