<?php
   /**
    * category
    *
    * @package Wojo Framework
    * @author wojoscripts.com
    * @copyright 2023
    * @version 5.50: category.tpl.php, v1.00 7/12/2023 10:30 AM Gewa Exp $
    *
    */
   if (!defined('_WOJO')) {
      die('Direct access to this location is not allowed.');
   }
?>
<?php if ($this->special): ?>
   <div class="wojo cards screen-2 tablet-2 mobile-1">
      <div class="card" id="special3">
         <?php if (isset($this->special[0])): ?>
            <div class="content">
               <div class="row horizontal-gutters">
                  <div class="columns screen-40 mobile-100 phone-100 center-align">
                     <img src="<?php echo Product::hasThumb($this->special[0]->thumb, $this->special[0]->id); ?>" alt="<?php echo $this->special[0]->title ?>" class="wojo large inline responsive image">
                  </div>
                  <div class="columns mobile-100 phone-100">
                     <div class="padding">
                        <p>
                           <span class="wojo transparent label"><?php echo Utility::renderPrice($this->special[0]->is_sale, $this->special[0]->price, $this->special[0]->sprice); ?></span>
                        </p>
                        <h3 class="wojo truncate"><?php echo $this->special[0]->title ?></h3>
                        <p class="text-size-small dimmed-text"><?php echo Validator::sanitize($this->special[0]->body, 'string', 80) ?></p>
                        <p class="margin-top">
                           <a href="<?php echo Url::url('/product', $this->special[0]->slug); ?>" class="wojo small transparent button"><?php echo Language::$word->MOREINFO; ?></a>
                        </p>
                     </div>
                  </div>
               </div>
            </div>
         <?php endif; ?>
      </div>
      <div class="card" id="special2">
         <?php if (isset($this->special[1])): ?>
            <div class="content">
               <div class="row horizontal-gutters">
                  <div class="columns screen-40 mobile-100 phone-100 center-align">
                     <img src="<?php echo Product::hasThumb($this->special[1]->thumb, $this->special[1]->id); ?>" alt="<?php echo $this->special[1]->title ?>" class="wojo large inline responsive image">
                  </div>
                  <div class="columns mobile-100 phone-100">
                     <div class="padding">
                        <p>
                           <span class="wojo transparent label"><?php echo Utility::renderPrice($this->special[1]->is_sale, $this->special[1]->price, $this->special[1]->sprice); ?></span>
                        </p>
                        <h3 class="wojo truncate"><?php echo $this->special[1]->title ?></h3>
                        <p class="text-size-small dimmed-text"><?php echo Validator::sanitize($this->special[1]->body, 'string', 80) ?></p>
                        <p class="margin-top">
                           <a href="<?php echo Url::url('/product', $this->special[1]->slug); ?>" class="wojo small transparent button"><?php echo Language::$word->MOREINFO; ?></a>
                        </p>
                     </div>
                  </div>
               </div>
            </div>
         <?php endif; ?>
      </div>
   </div>
<?php endif; ?>
   <div class="row align-middle gutters phone-hide" id="filter">
      <div class="columns auto">
         <div class="items"><?php echo Language::$word->TOTAL . ': ' . $this->pager->items_total; ?></div>
      </div>
      <div class="columns phone-100">
         <div class="center-align">
            <div class="wojo small divided horizontal list">
               <div class="disabled item text-weight-700">
                  <?php echo Language::$word->SORTING_O; ?>
               </div>
               <a href="<?php echo Url::url(Router::$path); ?>" class="item<?php echo Url::setActive('order', false); ?>">
                  <?php echo Language::$word->RESET; ?>
               </a>
               <a href="<?php echo Url::url(Router::$path, '?order=title|DESC'); ?>"
                  class="item<?php echo Url::setActive('order', 'title'); ?>">
                  <?php echo Language::$word->NAME; ?>
               </a>
               <a href="<?php echo Url::url(Router::$path, '?order=price|DESC'); ?>"
                  class="item<?php echo Url::setActive('order', 'price'); ?>">
                  <?php echo Language::$word->PRD_PRICE; ?>
               </a>
               <a href="<?php echo Url::url(Router::$path, '?order=likes|DESC'); ?>"
                  class="item<?php echo Url::setActive('order', 'likes'); ?>">
                  <?php echo Language::$word->LIKES; ?>
               </a>
               <a href="<?php echo Url::sortItems(Url::url(Router::$path), 'order'); ?>" class="item">
                  <i class="icon caret <?php echo Url::ascDesc('order'); ?> link"></i>
               </a>
            </div>
         </div>
      </div>
      <div class="columns auto">
         <a <?php if (Validator::isGetSet('mode', 'list')) {
            echo 'href="' . Url::url(Router::$path, Url::buildUrl('mode', 'grid')) . '"';
         } ?> class="wojo small primary icon button<?php if (!Validator::isGetSet('mode', 'list')) {
            echo ' passive basic';
         } ?>">
            <i class="icon grid"></i>
         </a>
         <a <?php if (!Validator::isGetSet('mode', 'list')) {
            echo 'href="' . Url::url(Router::$path, Url::buildUrl('mode', 'list')) . '"';
         } ?> class="wojo small primary icon button<?php if (Validator::isGetSet('mode', 'list')) {
            echo ' passive basic';
         } ?>">
            <i class="icon list"></i>
         </a>
      </div>
   </div>
<?php if ($this->featured): ?>
   <?php if (Validator::isGetSet('mode', 'list')): ?>
      <?php include(THEMEBASE . '/_category_list.tpl.php'); ?>
   <?php else: ?>
      <?php include(THEMEBASE . '/_category_grid.tpl.php'); ?>
   <?php endif; ?>
   <?php if ($this->pager->items_total > $this->pager->items_per_page): ?>
      <div class="center-align padding"><?php echo $this->pager->display(); ?></div>
   <?php endif; ?>
<?php endif; ?>