<?php
   /**
    * compare
    *
    * @package Wojo Framework
    * @author wojoscripts.com
    * @copyright 2023
    * @version 5.50: compare.tpl.php, v1.00 7/12/2023 10:30 AM Gewa Exp $
    *
    */
   if (!defined('_WOJO')) {
      die('Direct access to this location is not allowed.');
   }
?>
<?php $bfluid = true; ?>
   <h3><?php echo Language::$word->FRONT_COMPARE; ?></h3>
<?php if (!$this->data): ?>
   <div class="center-align">
      <img src="<?php echo ADMINVIEW; ?>/images/notfound.svg" alt="" class="wojo big inline image">
      <div class="margin-small-top">
         <p class="wojo small icon alert inverted attached compact message">
            <i class="icon exclamation triangle"></i>
            <?php echo Language::$word->FRONT_COMPARE_EMPTY; ?></p>
      </div>
   </div>
<?php else: ?>
   <div class="row grid phone-1 mobile-2 tablet-3 screen-5 small-gutters">
      <?php foreach ($this->data as $i => $row): ?>
         <?php $i++; ?>
         <div class="columns" id="compare_<?php echo $row->id ?>">
            <div class="wojo card">
               <div class="header center-align">
                  <a href="<?php echo Url::url('/product', $row->slug); ?>">
                     <img src="<?php echo Product::hasThumb($row->thumb, $row->id); ?>" alt="<?php echo $row->title ?>" class="wojo image">
                  </a>
                  <h4 class="margin-top">
                     <a href="<?php echo Url::url('/product', $row->slug); ?>"><?php echo $row->title ?></a>
                  </h4>
               </div>
               <div class="content">
                  <div class="text-size-large"><?php echo Utility::renderPrice($row->is_sale, $row->price, $row->sprice, 'negative'); ?></div>
                  <?php include(THEMEBASE . '/snippets/listButton.tpl.php'); ?>
               </div>
               <div class="footer divided">
                  <p class="text-size-small"><?php echo Validator::sanitize($row->body, 'string', 100) ?></p>
                  <div class="center-align">
                     <a data-set='{"option":[{"iaction": "removeCompare", "id":<?php echo $row->id ?>}], "url":"/controller.php", "complete":"remove", "parent":"#compare_<?php echo $row->id ?>"}' class="iaction">
                        <i class="icon negative circular x"></i>
                     </a>
                  </div>
               </div>
            </div>
         </div>
      <?php endforeach; ?>
   </div>
<?php endif; ?>