<?php
   /**
    * dashboard
    *
    * @package Wojo Framework
    * @author wojoscripts.com
    * @copyright 2023
    * @version 5.50: dashboard.tpl.php, v1.00 11/18/2023 12:22 PM Gewa Exp $
    *
    */
   if (!defined('_WOJO')) {
      die('Direct access to this location is not allowed.');
   }
?>
<?php include_once THEMEBASE . '/snippets/dashNav.tpl.php'; ?>
   <h4><?php echo Language::$word->META_M_MYDOWNS; ?></h4>
<?php if ($this->data): ?>
   <table class="wojo responsive table">
      <thead>
      <tr>
         <th>&nbsp;</th>
         <th><?php echo Language::$word->NAME; ?></th>
         <th><?php echo Language::$word->DATE; ?></th>
         <th class="right aligned">&nbsp;</th>
      </tr>
      </thead>
      <?php foreach ($this->data as $row): ?>
         <tr>
            <td class="auto">
               <a href="<?php echo Url::url('/product', $row->slug); ?>">
                  <img src="<?php echo Product::hasThumb($row->thumb, $row->product_id); ?>" alt="" class="wojo small basic image">
               </a>
            </td>
            <td>
               <a href="<?php echo Url::url('/product', $row->slug); ?>"><?php echo $row->title; ?></a>
            </td>
            <td><?php echo Date::doDate('short_date', $row->created); ?></td>
            <td class="auto">
               <a href="<?php echo Url::url('/dashboard/view', Utility::encode($row->id)); ?>" class="wojo small primary inverted icon button">
                  <i class="icon download"></i>
               </a>
               <a data-tooltip="<?php echo Language::$word->INVOICE; ?>" href="<?php echo FRONTVIEW; ?>/controller.php?action=pInvoice&amp;tid=<?php echo $row->txn_id ?>" class="wojo small secondary inverted icon button">
                  <i class="icon files"></i>
               </a>
            </td>
         </tr>
      <?php endforeach; ?>
      <?php unset($row); ?>
   </table>
<?php endif; ?>