<?php
   /**
    * Footer
    *
    * @package Wojo Framework
    * @author wojoscripts.com
    * @copyright 2023
    * @version 5.50: footer.tpl.php, v1.00 11/18/2023 12:22 PM Gewa Exp $
    */
   if (!defined('_WOJO')) {
      die('Direct access to this location is not allowed.');
   }
?>
</div>
<!-- Home page -->
<?php if($this->segments[0] == 'index'):?>
   <?php include_once '_home_page.tpl.php'; ?>
<?php endif;?>
</main>
<!-- Footer -->
<footer>
   <div class="wojo-grid">
      <div class="row align-middle small-gutters">
         <div class="columns auto phone-100">
            <a href="<?php echo SITEURL; ?>/" class="logo"><?php echo ($this->core->logo)? '<img src="' . SITEURL . '/uploads/' . $this->core->logo . '" alt="' . $this->core->company . '">' : $this->core->company; ?></a>
         </div>
         <div class="columns phone-100 right-align">
            <?php if ($this->menus): ?>
               <ul class="wojo horizontal fitted divided list">
                  <?php foreach ($this->menus as $menu): ?>
                     <li class="item">
                        <a class="grey" <?php echo ($menu->content_type == 'web')? 'target="' . $menu->target . '"' : null; ?> href="<?php echo ($menu->content_type == 'web')? Url::out_url($menu->link) : ($menu->page_type == 'home'? SITEURL : Url::url('/content', $menu->slug)); ?>">
                           <strong><?php echo $menu->name; ?></strong>
                        </a>
                     </li>
                  <?php endforeach; ?>
               </ul>
            <?php endif; ?>
         </div>
      </div>
      <div class="divider"></div>
      <div class="row align-middle small-gutters">
         <div class="columns phone-100">
            <p class="wojo small text">Copyright &copy;<?php echo date('Y') . ' ' . $this->core->company; ?> | Powered by DDP v.<?php echo $this->core->wojov; ?></p>
         </div>
         <div class="columns auto phone-100">
            <a class="wojo icon small primary inverted button" href="//<?php echo $this->core->social->facebook; ?>">
               <i class="icon facebook"></i>
            </a>
            <a class="wojo icon small primary inverted button" href="//<?php echo $this->core->social->twitter; ?>">
               <i class="icon twitter"></i>
            </a>
         </div>
      </div>
   </div>
</footer>
<?php Debug::displayInfo(); ?>
<script type="text/javascript" src="<?php echo THEMEURL; ?>/js/master.js"></script>
<script type="text/javascript">
   // <![CDATA[
   <?php if($this->core->ploader):?>
   $(window).on('load', function () {
      $('#preloader').fadeOut(200);
   })
   <?php endif;?>
   $(document).ready(function () {
      $.Master({
         weekstart: <?php echo($this->core->weekstart);?>,
         ampm: "<?php echo !(($this->core->time_format) == 'hh:mm');?>",
         url: "<?php echo FRONTVIEW;?>",
         surl: "<?php echo SITEURL;?>",
         theme: "<?php echo THEMEURL;?>",
         lang: {
            button_text: "<?php echo Language::$word->BROWSE;?>",
            empty_text: "<?php echo Language::$word->NOFILE;?>",
            delBtn: "<?php echo Language::$word->DELETE_REC;?>",
            trsBtn: "<?php echo Language::$word->MTOTRASH;?>",
            restBtn: "<?php echo Language::$word->RFCOMPLETE;?>",
            canBtn: "<?php echo Language::$word->CANCEL;?>",
            popular: "<?php echo Language::$word->FAQ_POPULAR;?>",
         }
      });

      <?php if($this->core->eucookie):?>
      $('body').wCookies({
         title: '&#x1F36A; <?php echo Language::$word->EU_W_COOKIES;?>?',
         message: '<?php echo Language::$word->EU_NOTICE;?>',
         delay: 600,
         expires: 360,
         cookieName: 'WCDP_GDPR',
         link: '<?php echo Url::url('/page', $this->core->page_slugs->privacy[0]->page_type);?>',
         cookieTypes: [
            {
               type: '<?php echo Language::$word->EU_PREFS;?>',
               value: 'preferences',
               description: '<?php echo Language::$word->EU_PREFS_I;?>'
            },
            {
               type: '<?php echo Language::$word->EU_ANALYTICS;?>',
               value: 'analytics',
               description: '<?php echo Language::$word->EU_ANALYTICS_I;?>'
            },
            {
               type: '<?php echo Language::$word->EU_MARKETING;?>',
               value: 'marketing',
               description: '<?php echo Language::$word->EU_MARKETING_I;?>'
            }
         ],
         uncheckBoxes: true,
         acceptBtnLabel: '<?php echo Language::$word->EU_ACCEPT;?>',
         advancedBtnLabel: '<?php echo Language::$word->EU_CUSTOMISE;?>',
         moreInfoLabel: '<?php echo Language::$word->PRIVACY;?>',
         cookieTypesTitle: '<?php echo Language::$word->EU_SELCOOKIES;?>',
         fixedCookieTypeLabel: '<?php echo Language::$word->EU_ESSENTIALS;?>',
         fixedCookieTypeDesc: '<?php echo Language::$word->EU_ESSENTIALS_I;?>'
      });
      <?php endif;?>
   });
   // ]]>
</script>
<?php if ($this->core->analytics): ?>
   <script async src="https://www.googletagmanager.com/gtag/js?id=<?php echo $this->core->analytics; ?>"></script>
   <script>
      <?php if($this->core->analytics):?>
      window.dataLayer = window.dataLayer || [];

      function gtag() {
         dataLayer.push(arguments);
      }

      gtag('js', new Date());
      gtag('config', '<?php echo $this->core->analytics;?>', {
         client_storage: '<?php echo ($this->core->eucookie and Session::cookieinArray('analytics', 'DDP_cookieControlPrefs', true))? 'granted' : 'none';?>',
         ad_storage: '<?php echo ($this->core->eucookie and Session::cookieinArray('analytics', 'DDP_cookieControlPrefs', true))? 'granted' : 'denied';?>',
         analytics_storage: '<?php echo ($this->core->eucookie and Session::cookieinArray('analytics', 'DDP_cookieControlPrefs', true))? 'granted' : 'denied';?>',
      });
      <?php endif;?>
   </script>
<?php endif; ?>
</body></html>