<?php
   /**
    * history
    *
    * @package Wojo Framework
    * @author wojoscripts.com
    * @copyright 2023
    * @version 5.50: history.tpl.php, v1.00 11/18/2023 12:22 PM Gewa Exp $
    *
    */
   if (!defined('_WOJO')) {
      die('Direct access to this location is not allowed.');
   }
?>
<?php include_once(THEMEBASE . '/snippets/dashNav.tpl.php'); ?>
   <h4><?php echo Language::$word->META_M_MHISTORY; ?></h4>
<?php if ($this->data): ?>
   <table class="wojo responsive table">
      <thead>
      <tr>
         <th><?php echo Language::$word->NAME; ?></th>
         <th><?php echo Language::$word->MEM_ACT; ?></th>
         <th><?php echo Language::$word->MEM_EXP; ?></th>
         <th class="center-align"><?php echo Language::$word->MEM_REC1; ?></th>
         <th class="auto"></th>
      </tr>
      </thead>
      <?php foreach ($this->data as $row): ?>
         <tr id="item_<?php echo $row->transaction_id ?>">
            <td>
               <strong><?php echo $row->title; ?></strong>
            </td>
            <td><?php echo Date::doDate('long_date', $row->activated); ?></td>
            <td><?php echo Date::doDate('long_date', $row->expire); ?></td>
            <td class="center-align"><?php echo Utility::isPublished($row->recurring); ?></td>
            <td class="center-align">
               <a data-tooltip="<?php echo Language::$word->INVOICE; ?>" href="<?php echo FRONTVIEW; ?>/controller.php?action=mInvoice&amp;id=<?php echo $row->transaction_id; ?>" class="wojo small primary inverted icon button">
                  <i class="icon files"></i>
               </a>
            </td>
         </tr>
      <?php endforeach; ?>
      <tfoot>
      <tr>
         <td colspan="5"><span class="wojo small basic passive button">
        <?php echo Language::$word->TRX_TOTAMT; ?>
        <?php echo Utility::formatMoney($this->totals); ?>
        </span>
         </td>
      </tr>
      </tfoot>
   </table>
<?php endif; ?>