(function ($) {
   'use strict';
   $.Master = function (settings) {
      const config = {
         weekstart: 0,
         ampm: 0,
         url: '',
         surl: '',
         theme: '',
         lang: {
            button_text: 'Choose file...',
            empty_text: 'No file...',
            monthsFull: '',
            monthsShort: '',
            weeksFull: '',
            weeksShort: '',
            weeksMed: '',
            today: 'Today',
            now: 'Now',
            delBtn: 'Delete Record',
            trsBtn: 'Move to Trash',
            arcBtn: 'Move to Archive',
            uarcBtn: 'Restore From Archive',
            restBtn: 'Restore Item',
            canBtn: 'Cancel',
            clear: 'Clear',
            popular: 'Popular',
            selProject: 'Select Project',
            delMsg1: 'Are you sure you want to delete this record?',
            delMsg2: 'This action cannot be undone!!!',
            delMsg3: 'Trash',
            delMsg5: 'Move [NAME] to the archive?',
            delMsg6: 'Remove [NAME] from the archive?',
            delMsg7: 'Restore [NAME]?',
            delMsg8: 'The item will remain in Trash for 30 days. To remove it permanently, go to Trash and empty it.',
            working: 'working...'
         }
      };

      const $comments = $('#comments');
      const $lf = $('#loginform');
      const $pf = $('#passform');

      if (settings) {
         $.extend(config, settings);
      }

      /* == Categories == */
      $('.wojo.menu').wMenu({
         breakpoint: 959,
         showArrows: true,
         arrow: '<i class="icon plus alt"></i>'
      });

      /* == Vertical Menus == */
      $('ul.vertical-menu').find('ul.menu-submenu').parent().prepend('<i class=\"icon chevron down\"></i>');
      $('ul.vertical-menu .chevron.down').on('click', function () {
         let icon = this;
         $(this).siblings('ul.vertical-menu ul.menu-submenu').slideToggle(200);
         $(icon).toggleClass('vertically flipped');
      });

      /* == Input focus == */
      $(document).on('focusout', '.wojo.input input, .wojo.input textarea', function () {
         $('.wojo.input').removeClass('focus');
      });
      $(document).on('focusin', '.wojo.input input, .wojo.input textarea', function () {
         $(this).closest('.input').addClass('focus');
      });

      /* == Cart Button == */
      $('.cartButton').on('click', function () {
         const $cList = $('#cartList');
         const button = $(this);
         if ($cList.hasClass('hide-all')) {
            $cList.removeClass('hide-all').addClass('scaleIn');
         } else {
            $cList.removeClass('scaleIn').addClass('hide-all');
         }

         if ($cList.children('.list').children().length === 0) {
            button.addClass('loading');
            $.get(config.url + '/controller.php', {
               action: 'smallCart',
               url: ($.url().segment(-1) ? $.url().segment(-1) : 'index'),
            }, function (json) {
               $cList.children('.list').html(json.html);
            }, 'json').done(function () {
               button.removeClass('loading');
            });
         }
      });

      $('audio').audioPlayer();
      /* == Tabs == */
      $('.wojo.tabs').wTabs();

      /* == Progress Bars == */
      $('.wojo.progress').wProgress();

      /* == Number Spinner == */
      $('.wojo.input.number').wNumber();

      /* == Scroll to element == */
      $(document).on('click', '[data-scroll="true"]', function (event) {
         event.preventDefault();
         event.stopPropagation();
         let target = $(this).attr('href');
         $('html,body').animate({
            scrollTop: $(target).offset().top - 30
         }, 1000);
         return false;
      });

      /* == Login == */
      $('#backto').on('click', function () {
         $lf.slideDown();
         $pf.slideUp();
      });
      $('#passreset').on('click', function () {
         $lf.slideUp();
         $pf.slideDown();
      });

      $('#doSubmit').on('click', function () {
         const $btn = $(this);
         $btn.addClass('loading').prop('disabled', true);
         const username = $('input[name=username]').val();
         const password = $('input[name=password]').val();
         $.ajax({
            type: 'post',
            url: config.url + '/controller.php',
            data: {
               'action': 'userLogin',
               'username': username,
               'password': password
            },
            dataType: 'json',
            success: function (json) {
               if (json.type === 'error') {
                  $.wNotice({
                     autoclose: 6000,
                     type: json.type,
                     title: json.title,
                     text: json.message
                  });
               } else {
                  window.location.href = (json.cart > 0) ? config.surl + '/cart/' : config.surl + '/dashboard/';
               }
               $btn.removeClass('loading').prop('disabled', false);
            }
         });
      });

      /* == Pass Reset == */
      $('#dopass').on('click', function () {
         const $btn = $(this);
         $btn.addClass('loading');
         const email = $('input[name=pEmail]').val();
         const fname = $('input[name=fname]').val();
         $.ajax({
            type: 'post',
            url: config.url + '/controller.php',
            data: {
               'action': 'uResetPass',
               'email': email,
               'fname': fname
            },
            dataType: 'json',
            success: function (json) {
               $.wNotice({
                  autoclose: 6000,
                  type: json.type,
                  title: json.title,
                  text: json.message
               });
               if (json.type === 'success') {
                  $btn.prop('disabled', true);
                  $('input[name=pEmail]').val('');
               }
               $btn.removeClass('loading');
            }
         });
      });

      /* == Show/Hide password == */
      $('#showPassword').on('click', function () {
         let $icon = $(this).children();
         $icon.toggleClass('slash');
         let $input = $(this).prev('input');

         if ($input.attr('type') === 'password') {
            $input.attr('type', 'text');
         } else {
            $input.attr('type', 'password');
         }
      });

      /* == Small contact form == */
      $(document).on('click', '.fContact', function () {
         let parent = $(this).closest('.form');
         let name = parent.find('input[name=name]');
         let email = parent.find('input[name=email]');
         let message = parent.find('textarea[name=message]');
         let num = Math.floor(Math.random() * 90000) + 10000;
         parent.addClass('loading');

         $.post(config.url + '/controller.php', {
            action: 'contact',
            slug: 'index',
            captcha: num,
            name: name.val(),
            email: email.val(),
            notes: message.val(),
            front: true,
         }, function (json) {
            if (json.type === 'success') {
               name.val('');
               email.val('');
               message.val('');
            }
            setTimeout(function () {
               parent.removeClass('loading');
            }, 500);
            $.wNotice({
               autoclose: 4000,
               type: json.type,
               title: json.title,
               text: json.message
            });
         }, 'json');
      });

      /* == Wishlist Compare == */
      $(document).on('click', '.wishlist, .compare', function () {
         let $btn = $(this);
         let id = $btn.data('id');
         let type = $btn.hasClass('wishlist') ? 'wishlist' : 'compare';

         switch ($btn.data('layout')) {
            case 'list':
               $btn.children().addClass('primary spinning spinner circles');
               break;

            default:
               $btn.children().addClass('spinning spinner circles');
               break;
         }

         $.post(config.url + '/controller.php', {
            action: 'wcomp',
            type: type,
            id: id,
         }, function (json) {
            if (json.type === 'error') {
               console.log('Invalid ID');
            }
            setTimeout(function () {
               $btn.removeClass('wishlist compare');
               $btn.children().removeClass('inverted spinning spinner circles heart collection ');

               switch ($btn.data('layout')) {
                  case 'list':
                     $btn.children().addClass('primary check');
                     break;

                  default:
                     $btn.children().addClass('check');
                     break;
               }
            }, 500);

         }, 'json');
      });

      /* == Buy membership == */
      $('.mCart').on('click', function () {
         const $mResult = $('#mResult');
         $('#mBlock .segment').removeClass('shadow');
         $(this).closest('.segment').addClass('shadow');
         let id = $(this).data('id');
         let button = $(this);
         button.addClass('loading').prop('disabled', true);
         $.post(config.url + '/controller.php', {
            action: 'membership',
            id: id
         }, function (json) {
            $mResult.html(json.message);
            $('html,body').animate({
               scrollTop: $mResult.offset().top - 40
            }, 500);
            button.removeClass('loading').prop('disabled', false);
         }, 'json');
      });

      /* == Membership gateways == */
      $('#mResult').on('click', '.sGateway', function () {
         const $mg = $('#mResult #gdata');
         $('#mResult .sGateway').removeClass('primary');
         let $this = $(this);
         $(this).addClass('primary loading');
         let id = $(this).data('id');
         $.post(config.url + '/controller.php', {
            action: 'mGateway',
            id: id
         }, function (json) {
            $mg.html(json.message);
            $this.removeClass('loading');
            $('html,body').animate({
               scrollTop: $mg.offset().top - 40
            }, 500);
         }, 'json');
      });

      /* == Language Switcher == */
      $('#dropdown-lMenu').on('click', 'a', function () {
         Cookies.set('LANG_DDP', $(this).data('value'), {
            expires: 120,
            path: '/',
            sameSite: 'lax'
         });
         $('main').transition('scaleOut', {
            duration: 1000,
            complete: function () {
               window.location.href = $.url().attr('source');
            }
         });
         return false;
      });

      /* == Color Switcher == */
      $('#colorPanel').ColorPanel({
         style: '#styler',
         container: 'main',
         colors: {
            '#ffffff': config.theme + '/css/_default.css',
            '#2196F3': config.theme + '/css/colors/_blue.css',
            '#3F51B5': config.theme + '/css/colors/_indigo.css',
            '#00BCD4': config.theme + '/css/colors/_cyan.css',
            '#795548': config.theme + '/css/colors/_brown.css',
            '#E91E63': config.theme + '/css/colors/_pink.css',
            '#607D8B': config.theme + '/css/colors/_grey.css',
            '#009688': config.theme + '/css/colors/_teal.css',
            '#ff9800': config.theme + '/css/colors/_orange.css',
         }
      });

      /* == Add to cart == */
      $(document).on('click', 'a.add', function () {
         let id = $(this).data('id');
         let button = $(this);
         let $in = $('.input.number');
         let qty = $in.children('input').length ? $in.children('input').val() : 1;

         button.addClass('loading');
         $.post(config.url + '/controller.php', {
            action: 'add',
            id: id,
            qty: qty,
         }, function (json) {
            if (json.status === 'success') {
               $('#cartList .list').html(json.html);
               $('#cTotal').text(json.counter);
               button.children().removeClass('cart add').addClass('check');
            }
            setTimeout(function () {
               button.removeClass('loading');
            }, 1200);

            $.wNotice({
               autoclose: 4000,
               duplicates: false,
               type: json.type,
               title: json.title,
               text: json.message
            });

         }, 'json');
      });

      /* == Apply coupon == */
      $('button[name=discount]').on('click', function () {
         let button = $(this);
         let coupon = $('input[name=\'coupon\']').val();
         $(button).addClass('loading').prop('disabled', true);

         $.post(config.url + '/controller.php', {
            action: 'coupon',
            coupon: coupon,
         }, function (json) {
            if (json.type === 'success') {
               $('#subtotal').text(json.subtotal);
               $('#discount').html(json.coupon);
               $('#tax').html(json.tax);
               $('#total').text(json.total);
            }

            setTimeout(function () {
               $(button).removeClass('loading').prop('disabled', false);
            }, 500);
            $.wNotice({
               autoclose: 12000,
               type: json.type,
               title: json.title,
               text: json.message
            });

         }, 'json');
      });

      //delete from cart
      $('#cartList').on('click', 'a.deleteItem', function () {
         let id = $(this).data('id');
         let item = $(this).closest('.item');

         $.post(config.url + '/controller.php', {
            action: 'remove',
            id: id,
         }, function (json) {
            if (json.status === 'success') {
               item.transition('scaleOut', {
                  duration: 400,
                  complete: function () {
                     $('#cartList').html(json.html);
                     $('#cTotal').text(json.counter);
                  }
               });
               if (json.counter < 1 && $.inArray('cart', $.url().segment()) !== -1) {
                  window.location.href = config.surl + '/cart';
               }
            }

         }, 'json');
      });

      //delete from big cart
      $('#bigCart').on('click', 'a.deleteItem', function () {
         let id = $(this).data('id');
         let item = $(this).closest('tr');

         $.post(config.url + '/controller.php', {
            action: 'removeBig',
            id: id,
         }, function (json) {
            if (json.status === 'success') {
               item.transition('scaleOut', {
                  duration: 400,
                  complete: function () {
                     item.remove();
                     $('#cTotal').text(json.count);

                     $('#subtotal').text(json.subtotal);
                     $('#discount').html(json.coupon);
                     $('#tax').html(json.tax);
                     $('#total').text(json.total);
                  }
               });
               if (json.counter < 1) {
                  window.location.href = config.surl + '/cart';
               }
            }
         }, 'json');
      });

      /* == Comments like == */
      $comments.on('click', 'a.down, a.up', function () {
         let type = $(this).attr('class').replace('item ', '');
         let id = $(this).data('id');
         let icon = $(this).children('.icon');
         let score = $(this).children('span');
         let down = $(this).data('down');
         let up = $(this).data('up');

         icon.removeClass('chevron up down').addClass('check').fadeIn(150);
         $(this).removeClass('up down');

         $.post(config.url + '/controller.php', {
            action: 'vote',
            type: type,
            id: id
         }, function (json) {
            if (json.status === 'success') {
               if (json.type === 'down') {
                  score.text(parseInt(down) - 1);
               } else {
                  score.text(parseInt(up) + 1);
               }
            }
         }, 'json');
      });

      //load reply form
      $comments.on('click', 'a.replay', function () {
         $('#replyform, #pError').remove();
         let id = $(this).data('id');
         $.get(config.theme + '/plugins/comments/_replyForm.tpl.php', {
            id: id
         }, function (data) {
            let comment = $('#comment_' + id, '#comments').children('.content');
            comment.append(data);
            $('#replyform').fadeIn(150);
         });
      });

      //comment reply
      $comments.on('click', 'button[name=doReply]', function () {
         let parent_id = $(this).closest('.comment').data('id');
         $(this).addClass('loading').prop('disabled', true);

         let data = {
            id: parent_id,
            parent_id: parent_id,
            counter: parseInt($('#pMore .rcounter').text()),
            product_id: $('input[name=product_id]').val(),
            message: $('textarea[name=replybody]').val(),
            username: $('input[name=replayname]').val(),
            acaptcha: $('input[name=acaptcha]').val(),
            url: $('input[name=url]').val(),
            action: 'reply'
         };
         submitComment(data);
      });

      //new comment
      $(document).on('click', 'button[name=doComment]', function () {
         $(this).addClass('loading').prop('disabled', true);

         let data = {
            id: 1,
            product_id: $('input[name=product_id]').val(),
            parent_id: -1,
            counter: parseInt($('#pMore .rcounter').text()),
            message: $('textarea[name=body]').val(),
            username: $('input[name=name]').val(),
            captcha: $('input[name=captcha]').val(),
            rating: $('input[type=\'radio\'][name=\'star\']:checked').val(),
            url: $('input[name=url]').val(),
            action: 'comment'
         };
         submitComment(data);
      });

      //process comment
      function submitComment(data) {
         $.post(config.url + '/controller.php', data, function (json) {
            if (json.type === 'success') {
               $('#replyform').remove();
               if (json.html) {
                  let $cmid = $('#comment_' + data.id);
                  let $cmd = $('#comments');
                  if (data.action === 'reply') {
                     if ($cmid.children('.comments').length < 1) {
                        $cmid.append('<div class="comments"></div>');
                     }
                     $cmid.children('.comments').append(json.html);
                  } else {
                     if ($cmd.children('.comments').length < 1) {
                        $cmd.prepend('<div class="wojo comments threaded"></div>');
                     }
                     $('.wojo.comments').prepend(json.html);
                     $('html, body').animate({
                        scrollTop: $cmd.offset().top
                     }, 500);
                     $('#combody').val('');
                  }
               }
               $('.rcounter').text(json.counter);
            }
            $.wNotice({
               autoclose: 12000,
               type: json.type,
               title: json.title,
               text: json.message
            });
            $('button[name=doReply], button[name=doComment]').removeClass('loading').prop('disabled', false);
         }, 'json');
      }

      //char counter
      $(document).on('keyup paste', '#combody, #replybody', function () {
         let characters = $(this).attr('data-counter');

         if ($(this).val().length > characters) {
            $(this).val($(this).val().substr(0, characters));
         }
         let id = $(this).attr('id');
         let $cs = $('.' + id + '_counter span');

         let remaining = characters - $(this).val().length;
         $cs.html(remaining);
         if (remaining <= 10) {
            $cs.addClass('negative').removeClass('positive');
         } else {
            $cs.removeClass('negative').addClass('positive');
         }
      });

      //delete comment
      $comments.on('click', 'a.delete', function () {
         let id = $(this).closest('.comment').data('id');
         $.post(config.url + '/controller.php', {
            action: 'deleteComment',
            id: id
         }, function () {
            let comment = $('#comment_' + id);
            $(comment).fadeOut();
         });
      });

      //load gateway
      $('#dGateways').on('change', 'input[name=gateway]', function () {
         let id = $(this).val();
         let card = $('#card_' + $(this).attr('id').replace('gate_', ''));
         const $dc = $('#dCheckout');

         card.addClass('loading');
         $.get(config.url + '/controller.php', {
            action: 'gateway',
            id: id
         }, function (json) {
            $dc.html(json.message);
            card.removeClass('loading');
            $('html,body').animate({
               scrollTop: $dc.offset().top - 40
            }, 500);

         }, 'json');
      });

      /* == Video Player == */
      $('#ytube a').on('click', function (event) {
         event.preventDefault();
         let url = $(this).attr('href');
         let id = url.substring(url.search('=') + 1, url.length);
         const $yt = $('#ytube');
         $yt.addClass('loading');
         setTimeout(function () {
            $yt.html('<iframe width="100%" height="320px" src="https://www.youtube.com/embed/' + id + '?autoplay=1&autohide=1" allowfullscreen></iframe>');
            $yt.removeClass('loading');
         }, 5000);
      });

      /* == Avatar Upload == */
      $('[data-type="image"]').wavatar({
         text: config.lang.selPic,
         validators: {
            maxWidth: 3200,
            maxHeight: 1800
         },
         reject: function (file, errors) {
            if (errors.mimeType) {
               $.wNotice({
                  autoclose: 4000,
                  type: 'error',
                  title: 'ERROR',
                  text: file.name + ' must be an image.'
               });
            }
            if (errors.maxWidth || errors.maxHeight) {
               $.wNotice({
                  autoclose: 4000,
                  type: 'error',
                  title: 'ERROR',
                  text: file.name + ' must be width:3200px, and height:1800px  max.'
               });
            }
         }
      });

      /* == Clear Session Debug Queries == */
      $('#debug-panel').on('click', 'a.clear_session', function () {
         $.post(config.url + '/controller.php', {
            iaction: 'session'
         });
         $(this).css('color', '#222');
      });

      /* == Check All == */
      $('#masterCheckbox').on('click', function () {
         let parent = $(this).data('parent');
         $(parent + ' .checkbox').checkbox('toggle', $(this));
      });


      /* == Master Form == */
      $(document).on('click', 'button[name=dosubmit]', function () {
         let $button = $(this);
         let action = $(this).data('action');
         let $form = $(this).closest('form');
         let asseturl = $(this).data('url');

         function showResponse(json) {
            setTimeout(function () {
               $($button).removeClass('loading').prop('disabled', false);
            }, 500);
            $.wNotice({
               autoclose: 4000,
               type: json.type,
               title: json.title,
               text: json.message
            });
            if (json.type === 'success' && json.redirect) {
               setTimeout(function () {
                  $('main').transition('scaleOut', {
                     duration: 1000,
                     complete: function () {
                        window.location.href = json.redirect;
                     }
                  });
               }, 5000);
            }
         }

         function showLoader() {
            $($button).addClass('loading').prop('disabled', true);
         }

         let options = {
            target: null,
            beforeSubmit: showLoader,
            success: showResponse,
            type: 'post',
            url: asseturl ? config.url + '/' + asseturl + '/controller.php' : config.url + '/controller.php',
            data: {
               action: action
            },
            dataType: 'json'
         };

         $($form).ajaxForm(options).submit();
      });

      // product image viewer
      $('.lightbox').fluidbox();
      $('nav#imageswitch a img').on('click', function () {
         $('.lightbox').fluidbox('destroy');
         let previewImg = $('img#mainimg');
         let previewLink = previewImg.parent();
         previewLink.parent().addClass('loading');


         let img = $(this);
         let link = $(this).parent();
         let imgHref = img.attr('src');
         let imgAlt = img.attr('alt');
         let linkHref = link.attr('href');

         if ($(img).parent().hasClass('active') === false) {
            $('nav#imageswitch a').removeClass('active');
            img.parent().addClass('active');
            $(previewImg).fadeIn(300, function () {
               previewImg.attr('src', imgHref);
               previewImg.attr('alt', imgAlt);
               previewLink.attr('href', linkHref);
               $('.lightbox').fluidbox();
               previewLink.parent().removeClass('loading');
            });
         }
         return false;
      });

      // download error messages
      if ($.url().param('msg')) {
         $.wNotice({
            autoclose: 12000,
            type: json.type,
            title: json.title,
            text: $.url().param('msg')
         });
      }

      // convert logo svg to editable
      $('.logo img').each(function () {
         let $img = $(this);
         let imgID = $img.attr('id');
         let imgClass = $img.attr('class');
         let imgURL = $img.attr('src');

         $.get(imgURL, function (data) {
            let $svg = $(data).find('svg');
            if (typeof imgID !== 'undefined') {
               $svg = $svg.attr('id', imgID);
            }
            if (typeof imgClass !== 'undefined') {
               $svg = $svg.attr('class', imgClass + ' replaced-svg');
            }
            $svg = $svg.removeAttr('xmlns:a');
            $img.replaceWith($svg);
         }, 'xml');

      });

      /* == Add/Edit Modal Actions == */
      $(document).on('click', 'a.action, button.action', function () {
         let dataset = $(this).data('set');
         let $parent = dataset.parent;
         let $this = $(this);
         let actions = '';
         let url = config.url + dataset.url;

         $.get(url, dataset.option[0], function (data) {
            if (dataset.buttons !== false) {
               actions += '' +
                 '<div class="footer">' +
                 '<button type="button" class="wojo small simple button" data="modal:close">' + config.lang.canBtn + '</button>' +
                 '<button type="button" class="wojo small positive button" data="modal:ok">' + dataset.label + '</button>' +
                 '</div>';
            }

            let $wmodal = $('<div class="wojo ' + dataset.modalclass + ' modal"><div class="dialog" role="document"><div class="content">' +
              '' + data + '' +
              '' + actions + '' +
              '</div></div></div>').on($.modal.BEFORE_OPEN, function () {

            }).modal().on('click', '[data="modal:ok"]', function () {
               $(this).addClass('loading').prop('disabled', true);

               function showResponse(json) {
                  setTimeout(function () {
                     $('[data="modal:ok"]', $wmodal).removeClass('loading').prop('disabled', false);
                     if (json.message) {
                        $.wNotice({
                           autoclose: 12000,
                           type: json.type,
                           title: json.title,
                           text: json.message
                        });
                     }
                     if (json.type === 'success') {
                        if (dataset.redirect) {
                           setTimeout(function () {
                              $('main').transition('scaleOut');
                              window.location.href = json.redirect;
                           }, 800);
                        } else {
                           switch (dataset.complete) {
                              case 'replace':
                                 $($parent).html(json.html).transition('fadeIn', {
                                    duration: 600
                                 });
                                 break;
                              case 'replaceWith':
                                 $($this).replaceWith(json.html).transition('fadeIn', {
                                    duration: 600
                                 });
                                 break;
                              case 'append':
                                 $($parent).append(json.html).transition('scaleIn', {
                                    duration: 300
                                 });
                                 break;
                              case 'prepend':
                                 $($parent).prepend(json.html).transition('scaleIn', {
                                    duration: 300
                                 });
                                 break;
                              case 'update':
                                 $($parent).replaceWith(json.html).transition('fadeIn', {
                                    duration: 600
                                 });
                                 break;
                              case 'insert':
                                 if (dataset.mode === 'append') {
                                    $($parent).append(json.html);
                                 }
                                 if (dataset.mode === 'prepend') {
                                    $($parent).prepend(json.html);
                                 }
                                 break;
                              case 'highlite':
                                 $($parent).addClass('highlite');
                                 break;
                              default:
                                 break;
                           }
                           $.modal.close();
                        }
                     }

                  }, 500);
               }

               let options = {
                  target: null,
                  success: showResponse,
                  type: 'post',
                  url: url,
                  data: dataset.option[0],
                  dataType: 'json'
               };
               $('#modal_form').ajaxForm(options).submit();
            });
         });
      });

      /* == Simple Actions == */
      $(document).on('click', '.iaction', function () {
         let dataset = $(this).data('set');
         let $parent = $(dataset.parent);
         $.ajax({
            type: 'POST',
            url: config.url + dataset.url,
            dataType: 'json',
            data: dataset.option[0]
         }).done(function (json) {
            if (json.type === 'success') {
               switch (dataset.complete) {
                  case 'remove':
                     $parent.transition('scaleOut', {
                        duration: 300,
                        complete: function () {
                           $parent.remove();
                        }
                     });

                     break;

                  case 'replace':
                     $parent.html(json.html).transition('fadeIn', {
                        duration: 600
                     });
                     break;

                  case 'prepend':
                     $parent.prepend(json.html).transition('fadeIn', {
                        duration: 600
                     });
                     break;
               }

               if (dataset.redirect) {
                  setTimeout(function () {
                     $('main').transition('scaleOut');
                     window.location.href = dataset.redirect;
                  }, 800);
               }
            }

            if (json.message) {
               $.wNotice({
                  autoclose: 12000,
                  type: json.type,
                  title: json.title,
                  text: json.message
               });
            }

         });
      });
   };
})(jQuery);