<?php
   /**
    * memberships
    *
    * @package Wojo Framework
    * @author wojoscripts.com
    * @copyright 2023
    * @version 5.50: memberships.tpl.php, v1.00 11/18/2023 12:22 PM Gewa Exp $
    *
    */
   if (!defined('_WOJO')) {
      die('Direct access to this location is not allowed.');
   }
?>
<?php include_once(THEMEBASE . '/snippets/dashNav.tpl.php'); ?>
<div class="row gutters">
   <div class="columns">
      <h4><?php echo Language::$word->MEMBERSHIPS; ?></h4>
   </div>
   <div class="columns auto">
      <a href="<?php echo Url::url('/dashboard', 'history'); ?>" class="wojo small primary button">
         <i class="icon time history"></i>
         <?php echo Language::$word->HISTORY; ?></a>
   </div>
</div>
<?php if ($this->data): ?>
   <div id="mBlock" class="row blocks screen-3 tablet-2 mobile-1 phone-1 gutters">
      <?php foreach ($this->data as $row): ?>
         <div class="columns">
            <div id="item_<?php echo $row->id; ?>" class="wojo attached segment<?php echo App::Auth()->membership_id == $row->id? ' active' : null; ?>">
               <?php if ($row->thumb): ?>
                  <img src="<?php echo UPLOADURL; ?>/memberships/<?php echo $row->thumb; ?>" alt="<?php echo $row->title; ?>">
               <?php else: ?>
                  <img src="<?php echo UPLOADURL; ?>/memberships/default.svg" alt="<?php echo $row->title; ?>">
               <?php endif; ?>
               <h4 class="center-align">
                  <?php echo Utility::formatMoney($row->price); ?>
                  <?php echo $row->title; ?></h4>
               <p class="text-size-small"><?php echo Language::$word->MEM_REC1; ?>
                  <?php echo ($row->recurring)? Language::$word->YES : Language::$word->NO; ?></p>
               <p class="text-size-small"><?php echo $row->days; ?>@<?php echo Date::getPeriodReadable($row->period); ?></p>
               <p class="text-size-small"><?php echo $row->description; ?></p>
               <?php if (App::Auth()->membership_id != $row->id): ?>
                  <button type="button" class="wojo primary button mCart" data-id="<?php echo $row->id; ?>"><?php echo ($row->price <> 0)? Language::$word->SELECT : Language::$word->ACTIVATE; ?></button>
               <?php else: ?>
                  <span class="wojo simple disabled button"><?php echo Language::$word->ACTIVE; ?></span>
               <?php endif; ?>
            </div>
         </div>
      <?php endforeach; ?>
   </div>
<?php endif; ?>
<div id="mResult"></div>