<?php
   /**
    * product
    *
    * @package Wojo Framework
    * @author wojoscripts.com
    * @copyright 2023
    * @version 5.50: product.tpl.php, v1.00 11/18/2023 12:22 PM Gewa Exp $
    *
    */
   if (!defined('_WOJO')) {
      die('Direct access to this location is not allowed.');
   }
?>
<div class="row big gutters">
   <div class="columns screen-60 tablet-60 mobile-100 phone-100">
      <h4>
         <a href="<?php echo Url::url('/category', $this->row->cslug); ?>"><?php echo $this->row->name; ?></a>
      </h4>
      <h2><?php echo $this->row->title; ?></h2>
      <?php include(THEMEBASE . '/snippets/ratingStars.tpl.php'); ?>
      <p class="text-size-large text-weight-700"><?php echo Utility::renderPrice($this->row->is_sale, $this->row->price, $this->row->sprice, 'negative'); ?></p>
      <?php echo Validator::sanitize($this->row->body, 'string', 300) ?>
      <div class="margin-top">
         <div class="row gutters align-middle">
            <div class="columns auto">
               <div class="wojo form">
                  <div class="wojo action input number">
                     <input type="text" value="1" data-rule="quantity">
                     <div class="buttons">
                        <button class="wojo small icon simple button" type="button" data-spin="up">
                           <i class="icon caret up"></i>
                        </button>
                        <button class="wojo small icon simple button" type="button" data-spin="down">
                           <i class="icon caret down"></i>
                        </button>
                     </div>
                  </div>
               </div>
            </div>
            <div class="columns">
               <?php include(THEMEBASE . '/snippets/productButton.tpl.php'); ?>
            </div>
            <div class="columns auto phone-100 center-align">
               <a data-tooltip="<?php echo Language::$word->WISHLIST; ?>" data-id="<?php echo $this->row->id ?>" class="wishlist wojo icon small primary circular button">
                  <i class="icon heart"></i>
               </a>
               <a data-tooltip="<?php echo Language::$word->COMPARE; ?>" data-id="<?php echo $this->row->id ?>" class="compare wojo icon small circular primary button">
                  <i class="icon collection"></i>
               </a>
            </div>
         </div>
      </div>
      <div class="share">
         <a href="https://www.facebook.com/sharer/sharer.php?u=<?php echo Url::url(Router::$path); ?>" class="wojo small icon primary button" target="_blank">
            <i class="icon facebook"></i>
         </a>
         <a href="https://twitter.com/home?status=<?php echo Url::url(Router::$path); ?>" class="wojo small icon primary button" target="_blank">
            <i class="icon twitter"></i>
         </a>
         <a href="https://pinterest.com/pin/create/button/?url=<?php echo Url::url(Router::$path); ?>" class="wojo small icon primary button" target="_blank">
            <i class="icon pinterest"></i>
         </a>
      </div>
   </div>
   <div class="columns screen-40 tablet-40 mobile-100 phone-100">
      <div class="wojo basic attached card center-align">
         <a class="lightbox" data-gall="gallery01" href="<?php echo Product::hasImage($this->row->thumb, $this->row->id); ?>">
            <img id="mainimg" src="<?php echo Product::hasThumb($this->row->thumb, $this->row->id); ?>" alt="<?php echo $this->row->title; ?>">
         </a>
      </div>
      <!-- Image Gallery-->
      <?php if ($this->images): ?>
         <nav id="imageswitch" class="wojo images justify-center margin-vertical">
            <a href="<?php echo Product::hasImage($this->row->thumb, $this->row->id); ?>" class="wojo small image">
               <img src="<?php echo Product::hasThumb($this->row->thumb, $this->row->id); ?>" alt="">
            </a>
            <?php foreach ($this->images as $img): ?>
               <a href="<?php echo Product::hasImage($img->name, $this->row->id); ?>" class="wojo small image">
                  <img src="<?php echo Product::hasThumb($img->name, $this->row->id); ?>" alt="">
               </a>
            <?php endforeach; ?>
         </nav>
      <?php endif; ?>
      <!-- Product Audio-->
      <?php if ($this->row->audio): ?>
         <audio preload="auto" controls>
            <source src="<?php echo Product::hasAudio($this->row->audio, $this->row->id); ?>">
         </audio>
      <?php endif; ?>
   </div>
</div>
<div class="wojo fluid relaxed tabs">
   <ul class="nav" id="pMore">
      <li class="active">
         <a data-tab="desc">
            <i class="icon wysiwyg justify left"></i><?php echo Language::$word->DESCRIPTION; ?></a>
      </li>
      <?php if ($this->row->pbody and $this->row->membership_id and Membership::is_valid($this->row->membership_id)): ?>
         <li>
            <a data-tab="vip">
               <i class="icon card list"></i><?php echo Language::$word->VIP; ?></a>
         </li>
      <?php endif; ?>
      <li>
         <a data-tab="info">
            <i class="icon information circle"></i><?php echo Language::$word->FRONT_ADINFO; ?></a>
      </li>
      <?php if ($this->core->enable_comments): ?>
         <li>
            <a data-tab="reviews">
               <i class="icon chat text round"></i><?php echo Language::$word->REVIEWS; ?> (
               <ins class="rcounter"><?php echo $this->row->comments; ?></ins>
               )
            </a>
         </li>
      <?php endif; ?>
   </ul>
   <div class="wojo segment tab">
      <div data-tab="desc" class="item">
         <h5><?php echo Language::$word->DESCRIPTION; ?></h5>
         <?php echo Validator::cleanOut($this->row->body) ?>
      </div>
      <?php if ($this->row->pbody and $this->row->membership_id and Membership::is_valid($this->row->membership_id)): ?>
         <div data-tab="vip" class="item">
            <h4><?php echo Language::$word->VIP; ?></h4>
            <?php echo Validator::cleanOut($this->row->pbody) ?>
         </div>
      <?php endif; ?>
      <div data-tab="info" class="item">
         <h5><?php echo Language::$word->FRONT_ADINFO; ?></h5>
         <div class="row gutters align-middle">
            <div class="columns screen-50 tablet-40 mobile-100 phone-100">
               <div class="wojo relaxed list">
                  <?php echo $this->custom_fields; ?>
               </div>
            </div>
            <?php if ($this->row->youtube): ?>
               <div class="columns screen-50 tablet-60 mobile-100 phone-100">
                  <div id="ytube" class="wojo basic attached card">
                     <a href="<?php echo $this->row->youtube; ?>">
                     </a>
                  </div>
               </div>
            <?php endif; ?>
         </div>
      </div>
      <?php if ($this->core->enable_comments): ?>
         <div data-tab="reviews" class="item">
            <h5>
               <ins class="rcounter"><?php echo $this->row->comments; ?></ins>
               <?php echo Language::$word->REVIEWS . ' ' . strtolower(Language::$word->FOR) . ' ' . $this->row->title; ?></h5>
            <?php include_once PLUGINBASE . '/comments/index.tpl.php';?>
         </div>
      <?php endif; ?>
   </div>
</div>
<?php if ($this->special): ?>
   <?php include_once PLUGINBASE . '/_specials.tpl.php'; ?>
<?php endif; ?>