<?php
   /**
    * profile
    *
    * @package Wojo Framework
    * @author wojoscripts.com
    * @copyright 2023
    * @version 5.50: profile.tpl.php, v1.00 11/18/2023 12:22 PM Gewa Exp $
    *
    */
   if (!defined('_WOJO')) {
      die('Direct access to this location is not allowed.');
   }
?>
<?php include_once(THEMEBASE . '/snippets/dashNav.tpl.php'); ?>
<h4><?php echo Language::$word->ADM_MYACC; ?></h4>
<div class="row justify-center">
   <div class="columns screen-40 tablet-80 mobile-100 phone-100">
      <form method="post" id="wojo_form" name="wojo_form">
         <div class="wojo form">
            <div class="wojo block fields">
               <div class="field">
                  <label><?php echo Language::$word->AVATAR; ?></label>
                  <input type="file" name="avatar" data-type="image" data-exist="<?php echo ($this->row->avatar)? UPLOADURL . '/avatars/' . $this->row->avatar : UPLOADURL . '/avatars/blank.svg'; ?>" accept="image/png, image/jpeg">
               </div>
               <div class="field">
                  <label><?php echo Language::$word->EMAIL; ?>
                     <i class="icon asterisk"></i>
                  </label>
                  <input type="text" placeholder="<?php echo Language::$word->EMAIL; ?>" value="<?php echo $this->row->email; ?>" name="email">
               </div>

               <div class="field">
                  <label><?php echo Language::$word->FNAME; ?>
                     <i class="icon asterisk"></i>
                  </label>
                  <input type="text" placeholder="<?php echo Language::$word->FNAME; ?>" value="<?php echo $this->row->fname; ?>" name="fname">
               </div>

               <div class="field">
                  <label><?php echo Language::$word->LNAME; ?>
                     <i class="icon asterisk"></i>
                  </label>
                  <input type="text" placeholder="<?php echo Language::$word->LNAME; ?>" value="<?php echo $this->row->lname; ?>" name="lname">
               </div>
               <div class="field">
                  <label><?php echo Language::$word->PASSWORD; ?></label>
                  <input type="password" placeholder="<?php echo Language::$word->PASSWORD; ?>" name="password">
               </div>
            </div>
            <?php echo $this->custom_fields; ?>
            <?php if ($this->core->enable_tax): ?>
               <div class="wojo block fields">
                  <div class="field">
                     <label><?php echo Language::$word->ADDRESS; ?>
                        <i class="icon asterisk"></i>
                     </label>
                     <input type="text" placeholder="<?php echo Language::$word->ADDRESS; ?>" value="<?php echo $this->row->address; ?>" name="address">
                  </div>
                  <div class="field">
                     <label><?php echo Language::$word->CITY; ?>
                        <i class="icon asterisk"></i>
                     </label>
                     <input type="text" placeholder="<?php echo Language::$word->CITY; ?>" value="<?php echo $this->row->city; ?>" name="city">
                  </div>
                  <div class="field">
                     <label><?php echo Language::$word->STATE; ?>
                        <i class="icon asterisk"></i>
                     </label>
                     <input type="text" placeholder="<?php echo Language::$word->STATE; ?>" value="<?php echo $this->row->state; ?>" name="state">
                  </div>
                  <div class="field">
                     <label><?php echo Language::$word->COUNTRY; ?>/<?php echo Language::$word->ZIP; ?>
                        <i class="icon asterisk"></i>
                     </label>
                     <div class="wojo action input">
                        <input type="text" placeholder="<?php echo Language::$word->ZIP; ?>" value="<?php echo $this->row->zip; ?>" name="zip">
                        <select name="country">
                           <?php echo Utility::loopOptions($this->countries, 'abbr', 'name', $this->row->country); ?>
                        </select>
                     </div>
                  </div>
               </div>
            <?php endif; ?>
            <div class="wojo block fields">
               <div class="field"><label><?php echo Language::$word->USR_NLETTER; ?></label>
                  <div class="wojo checkbox radio inline fitted">
                     <input name="newsletter" type="radio" value="1" <?php echo Validator::getChecked($this->row->newsletter, 1); ?> id="newsletter_1">
                     <label for="newsletter_1"><?php echo Language::$word->YES; ?></label>
                  </div>
                  <div class="wojo checkbox radio inline fitted">
                     <input name="newsletter" type="radio" value="0" <?php echo Validator::getChecked($this->row->newsletter, 0); ?> id="newsletter_0">
                     <label for="newsletter_0"><?php echo Language::$word->NO; ?></label>
                  </div>
               </div>
               <div class="field">
                  <button class="bottom fluid wojo primary button" data-action="profile" name="dosubmit" type="button"><?php echo Language::$word->USR_UPDATE_A; ?></button>
               </div>
            </div>
         </div>
      </form>
   </div>
</div>