<?php
   /**
    * search
    *
    * @package Wojo Framework
    * @author wojoscripts.com
    * @copyright 2023
    * @version 5.50: search.tpl.php, v1.00 7/12/2023 10:30 AM Gewa Exp $
    *
    */
   if (!defined('_WOJO')) {
      die('Direct access to this location is not allowed.');
   }
?>
   <div class="row align-middle small-gutters phone-hide" id="filter">
      <div class="columns auto">
         <div class="items"><?php echo Language::$word->TOTAL . ': ' . (($this->featured > 0)? count($this->featured) : 0); ?></div>
      </div>
      <div class="columns center-align"><?php echo Language::$word->FRONT_SEARCH_FOR; ?>
         <span class="text-weight-700">[<?php echo $this->keyword; ?>]</span>
      </div>
      <div class="columns auto">
         <a <?php if (Validator::isGetSet('mode', 'list')) {
            echo 'href="' . Url::url(Router::$path, Url::buildUrl('mode', 'grid')) . '"';
         } ?> class="wojo icon primary button<?php if (!Validator::isGetSet('mode', 'list')) {
            echo ' passive basic';
         } ?>">
            <i class="icon grid"></i>
         </a>
      </div>
      <div class="columns auto">
         <a <?php if (!Validator::isGetSet('mode', 'list')) {
            echo 'href="' . Url::url(Router::$path, Url::buildUrl('mode', 'list')) . '"';
         } ?> class="wojo icon primary button<?php if (Validator::isGetSet('mode', 'list')) {
            echo ' passive basic';
         } ?>">
            <i class="icon list"></i>
         </a>
      </div>
   </div>
<?php if (!$this->keyword || strlen($this->keyword = trim($this->keyword)) == 0 || strlen($this->keyword) < 3): ?>
   <?php echo Message::msgSingleInfo(Language::$word->FRONT_SEARCH_EMPTY2); ?>
<?php elseif (!$this->featured): ?>
   <?php echo Message::msgSingleInfo(Language::$word->FRONT_SEARCH_EMPTY . '<span class="text-weight-700"> [' . $this->keyword . '] </span>' . Language::$word->FRONT_SEARCH_EMPTY1); ?>
<?php else: ?>
   <?php if (Validator::isGetSet('mode', 'list')): ?>
      <?php include THEMEBASE . '/_home_list.tpl.php'; ?>
   <?php else: ?>
      <?php include THEMEBASE . '/_home_grid.tpl.php'; ?>
   <?php endif; ?>
<?php endif; ?>