<?php
   /**
    * customFields
    *
    * @package Wojo Framework
    * @author wojoscripts.com
    * @var object $data
    * @copyright 2023
    * @version 5.00: customFields.tpl.php, v1.00 7/12/2023 10:30 AM Gewa Exp $
    *
    */
   if (!defined('_WOJO')) {
      die('Direct access to this location is not allowed.');
   }
   
   $html = '';
   switch ($data['section']):
      case 'profile':
         $html .= '<div class="wojo block fields">';
         foreach ($data['data'] as $i => $row) {
            $tooltip = $row->tooltip? ' <span data-tooltip="' . $row->tooltip . '"><i class="icon question circle"></i></span>' : '';
            $required = $row->required? ' <i class="icon asterisk"></i>' : '';
            
            $html .= '<div class="field">';
            $html .= '<label>' . $row->title . $tooltip . $required . '</label>';
            $html .= '<input name="custom_' . $row->name . '" type="text" placeholder="' . $row->title . '" value="' . ($data['id']? $row->field_value : '') . '">';
            $html .= '</div>';
         }
         $html .= '</div>';
         unset($row);
         break;
      
      case 'product':
         foreach ($data['data'] as $i => $row) {
            if (!empty($row->field_value)) {
               $html .= '<div class="item align-middle">';
               $html .= '<div class="content auto"><span class="text-weight-500">' . $row->title . ':</span></div>';
               $html .= '<div class="content padding-left">' . $row->field_value;
               $html .= '</div>';
               $html .= '</div>';
            }
         }
         unset($row);
         break;
   endswitch;
   echo $html;