<?php
   /**
    * productButton
    *
    * @package Wojo Framework
    * @author wojoscripts.com
    * @copyright 2023
    * @var object $row
    * @version 5.50: productButton.tpl.php, v1.00 11/18/2023 12:23 PM Gewa Exp $
    *
    */
   if (!defined('_WOJO')) {
      die('Direct access to this location is not allowed.');
   }
   
   if ($this->row->type == 'affiliate') {
      echo '<a href="' . $this->row->affiliate . '" target="_blank" class="wojo secondary button"> <i class="icon globe"></i> ' . Language::$word->VISIT . '</a>';
   } else {
      if ($this->row->membership_id == '-1') {
         if ($this->row->price == 0) {
            if ($this->core->allow_free == 'yes') {
               echo '<a data-set=\'{"option":[{"action":"download", "token":"' . Utility::encode($this->row->id) . '"}],"url":"/controller.php", "parent":"#item_' . $this->row->id . '", "buttons": false, "complete":"replace", "modalclass":"medium"}\' class="wojo fluid rounded primary button action"><i class="icon membership"></i> ' . Language::$word->PRD_DOWNFREE . '</a>';
            } else {
               if (App::Auth()->logged_in) {
                  echo '<a data-set=\'{"option":[{"action":"download", "token":"' . Utility::encode($this->row->id) . '"}],"url":"/controller.php", "parent":"#item_' . $this->row->id . '", "buttons": false, "complete":"replace", "modalclass":"medium"}\' class="wojo fluid rounded primary button action"><i class="icon unlock"></i> ' . Language::$word->PRD_DOWNFREE . '</a>';
               } else {
                  echo '<a href="' . Url::url('/login') . '" class="wojo fluid rounded primary button"> <i class="icon lock"> </i>' . Language::$word->LOGIN . '</a>';
               }
            }
         } else {
            echo '<a data-id="' . $this->row->id . '" class="wojo fluid rounded primary button add"><i class="icon basket add"></i> ' . Language::$word->ADD . '</a>';
         }
      } else {
         if (!$this->row->membership_id == '-1' and Membership::is_valid($this->row->membership_id)) {
            echo '<a data-set=\'{"option":[{"action":"download", "token":"' . Utility::encode($this->row->id) . '"}],"url":"/controller.php", "parent":"#item_' . $this->row->id . '", "buttons": false, "complete":"replace", "modalclass":"medium"}\' class="wojo fluid rounded primary button action"><i class="icon membership"></i> ' . Language::$word->DOWNLOAD . '</a>';
         } else {
            echo '<a class="wojo fluid rounded primary button disabled"> <i class="icon bookmark"></i> ' . Language::$word->VIP . '</a>';
         }
      }
   }