<?php
   /**
    * wishlist
    *
    * @package Wojo Framework
    * @author wojoscripts.com
    * @copyright 2023
    * @version 5.50: wishlist.tpl.php, v1.00 7/12/2023 10:30 AM Gewa Exp $
    *
    */
   if (!defined('_WOJO')) {
      die('Direct access to this location is not allowed.');
   }
?>
   <h3><?php echo Language::$word->META_M_WISHLIST; ?></h3>
<?php if (!$this->data): ?>
   <div class="center-align">
      <img src="<?php echo ADMINVIEW; ?>/images/notfound.svg" alt="" class="wojo big inline image">
      <div class="margin-small-top">
         <p class="wojo small icon alert inverted attached compact message">
            <i class="icon exclamation triangle"></i>
            <?php echo Language::$word->FRONT_COMPARE_EMPTY; ?></p>
      </div>
   </div>
<?php else: ?>
   <table class="wojo responsive table">
      <thead>
      <tr>
         <th></th>
         <th></th>
         <th><?php echo Language::$word->NAME; ?></th>
         <th><?php echo Language::$word->PRD_PRICE; ?></th>
         <th></th>
      </tr>
      </thead>
      <tbody>
      <?php foreach ($this->data as $row): ?>
         <tr id="wishlist_<?php echo $row->id ?>">
            <td class="auto">
               <a data-set='{"option":[{"iaction": "removeWishlist", "id":<?php echo $row->id ?>}], "url":"/controller.php", "complete":"remove", "parent":"#wishlist_<?php echo $row->id ?>"}' class="iaction">
                  <i class="icon negative circular x"></i>
               </a>
            </td>
            <td class="auto">
               <img src="<?php echo Product::hasThumb($row->thumb, $row->id); ?>" alt="<?php echo $row->title ?>" class="wojo normal image">
            </td>
            <td>
               <h4>
                  <a href="<?php echo Url::url('/product', $row->slug); ?>"><?php echo $row->title ?></a>
               </h4>
            </td>
            <td>
               <span class="text-weight-700"><?php echo Utility::renderPrice($row->is_sale, $row->price, $row->sprice, 'negative'); ?></span>
            </td>
            <td class="auto"><?php include(THEMEBASE . '/snippets/listButton.tpl.php'); ?></td>
         </tr>
      <?php endforeach; ?>
      </tbody>
   </table>
<?php endif; ?>